/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A filter condition used to include or exclude emails when exporting from or searching an archive.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ArchiveFilterCondition implements SdkPojo, Serializable,
        ToCopyableBuilder<ArchiveFilterCondition.Builder, ArchiveFilterCondition> {
    private static final SdkField<ArchiveBooleanExpression> BOOLEAN_EXPRESSION_FIELD = SdkField
            .<ArchiveBooleanExpression> builder(MarshallingType.SDK_POJO).memberName("BooleanExpression")
            .getter(getter(ArchiveFilterCondition::booleanExpression)).setter(setter(Builder::booleanExpression))
            .constructor(ArchiveBooleanExpression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BooleanExpression").build()).build();

    private static final SdkField<ArchiveStringExpression> STRING_EXPRESSION_FIELD = SdkField
            .<ArchiveStringExpression> builder(MarshallingType.SDK_POJO).memberName("StringExpression")
            .getter(getter(ArchiveFilterCondition::stringExpression)).setter(setter(Builder::stringExpression))
            .constructor(ArchiveStringExpression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringExpression").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOOLEAN_EXPRESSION_FIELD,
            STRING_EXPRESSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ArchiveBooleanExpression booleanExpression;

    private final ArchiveStringExpression stringExpression;

    private final Type type;

    private ArchiveFilterCondition(BuilderImpl builder) {
        this.booleanExpression = builder.booleanExpression;
        this.stringExpression = builder.stringExpression;
        this.type = builder.type;
    }

    /**
     * <p>
     * A boolean expression to evaluate against email attributes.
     * </p>
     * 
     * @return A boolean expression to evaluate against email attributes.
     */
    public final ArchiveBooleanExpression booleanExpression() {
        return booleanExpression;
    }

    /**
     * <p>
     * A string expression to evaluate against email attributes.
     * </p>
     * 
     * @return A string expression to evaluate against email attributes.
     */
    public final ArchiveStringExpression stringExpression() {
        return stringExpression;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(booleanExpression());
        hashCode = 31 * hashCode + Objects.hashCode(stringExpression());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArchiveFilterCondition)) {
            return false;
        }
        ArchiveFilterCondition other = (ArchiveFilterCondition) obj;
        return Objects.equals(booleanExpression(), other.booleanExpression())
                && Objects.equals(stringExpression(), other.stringExpression());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ArchiveFilterCondition").add("BooleanExpression", booleanExpression())
                .add("StringExpression", stringExpression()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BooleanExpression":
            return Optional.ofNullable(clazz.cast(booleanExpression()));
        case "StringExpression":
            return Optional.ofNullable(clazz.cast(stringExpression()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #booleanExpression()} initialized to the given value.
     *
     * <p>
     * A boolean expression to evaluate against email attributes.
     * </p>
     * 
     * @param booleanExpression
     *        A boolean expression to evaluate against email attributes.
     */
    public static ArchiveFilterCondition fromBooleanExpression(ArchiveBooleanExpression booleanExpression) {
        return builder().booleanExpression(booleanExpression).build();
    }

    /**
     * Create an instance of this class with {@link #booleanExpression()} initialized to the given value.
     *
     * <p>
     * A boolean expression to evaluate against email attributes.
     * </p>
     * 
     * @param booleanExpression
     *        A boolean expression to evaluate against email attributes.
     */
    public static ArchiveFilterCondition fromBooleanExpression(Consumer<ArchiveBooleanExpression.Builder> booleanExpression) {
        ArchiveBooleanExpression.Builder builder = ArchiveBooleanExpression.builder();
        booleanExpression.accept(builder);
        return fromBooleanExpression(builder.build());
    }

    /**
     * Create an instance of this class with {@link #stringExpression()} initialized to the given value.
     *
     * <p>
     * A string expression to evaluate against email attributes.
     * </p>
     * 
     * @param stringExpression
     *        A string expression to evaluate against email attributes.
     */
    public static ArchiveFilterCondition fromStringExpression(ArchiveStringExpression stringExpression) {
        return builder().stringExpression(stringExpression).build();
    }

    /**
     * Create an instance of this class with {@link #stringExpression()} initialized to the given value.
     *
     * <p>
     * A string expression to evaluate against email attributes.
     * </p>
     * 
     * @param stringExpression
     *        A string expression to evaluate against email attributes.
     */
    public static ArchiveFilterCondition fromStringExpression(Consumer<ArchiveStringExpression.Builder> stringExpression) {
        ArchiveStringExpression.Builder builder = ArchiveStringExpression.builder();
        stringExpression.accept(builder);
        return fromStringExpression(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BooleanExpression", BOOLEAN_EXPRESSION_FIELD);
        map.put("StringExpression", STRING_EXPRESSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ArchiveFilterCondition, T> g) {
        return obj -> g.apply((ArchiveFilterCondition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ArchiveFilterCondition> {
        /**
         * <p>
         * A boolean expression to evaluate against email attributes.
         * </p>
         * 
         * @param booleanExpression
         *        A boolean expression to evaluate against email attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder booleanExpression(ArchiveBooleanExpression booleanExpression);

        /**
         * <p>
         * A boolean expression to evaluate against email attributes.
         * </p>
         * This is a convenience method that creates an instance of the {@link ArchiveBooleanExpression.Builder}
         * avoiding the need to create one manually via {@link ArchiveBooleanExpression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ArchiveBooleanExpression.Builder#build()} is called immediately
         * and its result is passed to {@link #booleanExpression(ArchiveBooleanExpression)}.
         * 
         * @param booleanExpression
         *        a consumer that will call methods on {@link ArchiveBooleanExpression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #booleanExpression(ArchiveBooleanExpression)
         */
        default Builder booleanExpression(Consumer<ArchiveBooleanExpression.Builder> booleanExpression) {
            return booleanExpression(ArchiveBooleanExpression.builder().applyMutation(booleanExpression).build());
        }

        /**
         * <p>
         * A string expression to evaluate against email attributes.
         * </p>
         * 
         * @param stringExpression
         *        A string expression to evaluate against email attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringExpression(ArchiveStringExpression stringExpression);

        /**
         * <p>
         * A string expression to evaluate against email attributes.
         * </p>
         * This is a convenience method that creates an instance of the {@link ArchiveStringExpression.Builder} avoiding
         * the need to create one manually via {@link ArchiveStringExpression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ArchiveStringExpression.Builder#build()} is called immediately
         * and its result is passed to {@link #stringExpression(ArchiveStringExpression)}.
         * 
         * @param stringExpression
         *        a consumer that will call methods on {@link ArchiveStringExpression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stringExpression(ArchiveStringExpression)
         */
        default Builder stringExpression(Consumer<ArchiveStringExpression.Builder> stringExpression) {
            return stringExpression(ArchiveStringExpression.builder().applyMutation(stringExpression).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ArchiveBooleanExpression booleanExpression;

        private ArchiveStringExpression stringExpression;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ArchiveFilterCondition model) {
            booleanExpression(model.booleanExpression);
            stringExpression(model.stringExpression);
        }

        public final ArchiveBooleanExpression.Builder getBooleanExpression() {
            return booleanExpression != null ? booleanExpression.toBuilder() : null;
        }

        public final void setBooleanExpression(ArchiveBooleanExpression.BuilderImpl booleanExpression) {
            Object oldValue = this.booleanExpression;
            this.booleanExpression = booleanExpression != null ? booleanExpression.build() : null;
            handleUnionValueChange(Type.BOOLEAN_EXPRESSION, oldValue, this.booleanExpression);
        }

        @Override
        public final Builder booleanExpression(ArchiveBooleanExpression booleanExpression) {
            Object oldValue = this.booleanExpression;
            this.booleanExpression = booleanExpression;
            handleUnionValueChange(Type.BOOLEAN_EXPRESSION, oldValue, this.booleanExpression);
            return this;
        }

        public final ArchiveStringExpression.Builder getStringExpression() {
            return stringExpression != null ? stringExpression.toBuilder() : null;
        }

        public final void setStringExpression(ArchiveStringExpression.BuilderImpl stringExpression) {
            Object oldValue = this.stringExpression;
            this.stringExpression = stringExpression != null ? stringExpression.build() : null;
            handleUnionValueChange(Type.STRING_EXPRESSION, oldValue, this.stringExpression);
        }

        @Override
        public final Builder stringExpression(ArchiveStringExpression stringExpression) {
            Object oldValue = this.stringExpression;
            this.stringExpression = stringExpression;
            handleUnionValueChange(Type.STRING_EXPRESSION, oldValue, this.stringExpression);
            return this;
        }

        @Override
        public ArchiveFilterCondition build() {
            return new ArchiveFilterCondition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ArchiveFilterCondition#type()
     */
    public enum Type {
        BOOLEAN_EXPRESSION,

        STRING_EXPRESSION,

        UNKNOWN_TO_SDK_VERSION
    }
}
