/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A set of filter conditions to include and/or exclude emails.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ArchiveFilters implements SdkPojo, Serializable, ToCopyableBuilder<ArchiveFilters.Builder, ArchiveFilters> {
    private static final SdkField<List<ArchiveFilterCondition>> INCLUDE_FIELD = SdkField
            .<List<ArchiveFilterCondition>> builder(MarshallingType.LIST)
            .memberName("Include")
            .getter(getter(ArchiveFilters::include))
            .setter(setter(Builder::include))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Include").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ArchiveFilterCondition> builder(MarshallingType.SDK_POJO)
                                            .constructor(ArchiveFilterCondition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ArchiveFilterCondition>> UNLESS_FIELD = SdkField
            .<List<ArchiveFilterCondition>> builder(MarshallingType.LIST)
            .memberName("Unless")
            .getter(getter(ArchiveFilters::unless))
            .setter(setter(Builder::unless))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unless").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ArchiveFilterCondition> builder(MarshallingType.SDK_POJO)
                                            .constructor(ArchiveFilterCondition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INCLUDE_FIELD, UNLESS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<ArchiveFilterCondition> include;

    private final List<ArchiveFilterCondition> unless;

    private ArchiveFilters(BuilderImpl builder) {
        this.include = builder.include;
        this.unless = builder.unless;
    }

    /**
     * For responses, this returns true if the service returned a value for the Include property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasInclude() {
        return include != null && !(include instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The filter conditions for emails to include.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInclude} method.
     * </p>
     * 
     * @return The filter conditions for emails to include.
     */
    public final List<ArchiveFilterCondition> include() {
        return include;
    }

    /**
     * For responses, this returns true if the service returned a value for the Unless property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasUnless() {
        return unless != null && !(unless instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The filter conditions for emails to exclude.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUnless} method.
     * </p>
     * 
     * @return The filter conditions for emails to exclude.
     */
    public final List<ArchiveFilterCondition> unless() {
        return unless;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasInclude() ? include() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUnless() ? unless() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArchiveFilters)) {
            return false;
        }
        ArchiveFilters other = (ArchiveFilters) obj;
        return hasInclude() == other.hasInclude() && Objects.equals(include(), other.include())
                && hasUnless() == other.hasUnless() && Objects.equals(unless(), other.unless());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ArchiveFilters").add("Include", hasInclude() ? include() : null)
                .add("Unless", hasUnless() ? unless() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Include":
            return Optional.ofNullable(clazz.cast(include()));
        case "Unless":
            return Optional.ofNullable(clazz.cast(unless()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Include", INCLUDE_FIELD);
        map.put("Unless", UNLESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ArchiveFilters, T> g) {
        return obj -> g.apply((ArchiveFilters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ArchiveFilters> {
        /**
         * <p>
         * The filter conditions for emails to include.
         * </p>
         * 
         * @param include
         *        The filter conditions for emails to include.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder include(Collection<ArchiveFilterCondition> include);

        /**
         * <p>
         * The filter conditions for emails to include.
         * </p>
         * 
         * @param include
         *        The filter conditions for emails to include.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder include(ArchiveFilterCondition... include);

        /**
         * <p>
         * The filter conditions for emails to include.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mailmanager.model.ArchiveFilterCondition.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.mailmanager.model.ArchiveFilterCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mailmanager.model.ArchiveFilterCondition.Builder#build()} is called
         * immediately and its result is passed to {@link #include(List<ArchiveFilterCondition>)}.
         * 
         * @param include
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mailmanager.model.ArchiveFilterCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #include(java.util.Collection<ArchiveFilterCondition>)
         */
        Builder include(Consumer<ArchiveFilterCondition.Builder>... include);

        /**
         * <p>
         * The filter conditions for emails to exclude.
         * </p>
         * 
         * @param unless
         *        The filter conditions for emails to exclude.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unless(Collection<ArchiveFilterCondition> unless);

        /**
         * <p>
         * The filter conditions for emails to exclude.
         * </p>
         * 
         * @param unless
         *        The filter conditions for emails to exclude.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unless(ArchiveFilterCondition... unless);

        /**
         * <p>
         * The filter conditions for emails to exclude.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mailmanager.model.ArchiveFilterCondition.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.mailmanager.model.ArchiveFilterCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mailmanager.model.ArchiveFilterCondition.Builder#build()} is called
         * immediately and its result is passed to {@link #unless(List<ArchiveFilterCondition>)}.
         * 
         * @param unless
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mailmanager.model.ArchiveFilterCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unless(java.util.Collection<ArchiveFilterCondition>)
         */
        Builder unless(Consumer<ArchiveFilterCondition.Builder>... unless);
    }

    static final class BuilderImpl implements Builder {
        private List<ArchiveFilterCondition> include = DefaultSdkAutoConstructList.getInstance();

        private List<ArchiveFilterCondition> unless = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ArchiveFilters model) {
            include(model.include);
            unless(model.unless);
        }

        public final List<ArchiveFilterCondition.Builder> getInclude() {
            List<ArchiveFilterCondition.Builder> result = ArchiveFilterConditionsCopier.copyToBuilder(this.include);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInclude(Collection<ArchiveFilterCondition.BuilderImpl> include) {
            this.include = ArchiveFilterConditionsCopier.copyFromBuilder(include);
        }

        @Override
        public final Builder include(Collection<ArchiveFilterCondition> include) {
            this.include = ArchiveFilterConditionsCopier.copy(include);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder include(ArchiveFilterCondition... include) {
            include(Arrays.asList(include));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder include(Consumer<ArchiveFilterCondition.Builder>... include) {
            include(Stream.of(include).map(c -> ArchiveFilterCondition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ArchiveFilterCondition.Builder> getUnless() {
            List<ArchiveFilterCondition.Builder> result = ArchiveFilterConditionsCopier.copyToBuilder(this.unless);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnless(Collection<ArchiveFilterCondition.BuilderImpl> unless) {
            this.unless = ArchiveFilterConditionsCopier.copyFromBuilder(unless);
        }

        @Override
        public final Builder unless(Collection<ArchiveFilterCondition> unless) {
            this.unless = ArchiveFilterConditionsCopier.copy(unless);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unless(ArchiveFilterCondition... unless) {
            unless(Arrays.asList(unless));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unless(Consumer<ArchiveFilterCondition.Builder>... unless) {
            unless(Stream.of(unless).map(c -> ArchiveFilterCondition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ArchiveFilters build() {
            return new ArchiveFilters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
