/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The retention policy for an email archive that specifies how long emails are kept before being automatically deleted.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ArchiveRetention implements SdkPojo, Serializable,
        ToCopyableBuilder<ArchiveRetention.Builder, ArchiveRetention> {
    private static final SdkField<String> RETENTION_PERIOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RetentionPeriod").getter(getter(ArchiveRetention::retentionPeriodAsString))
            .setter(setter(Builder::retentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionPeriod").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RETENTION_PERIOD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String retentionPeriod;

    private final Type type;

    private ArchiveRetention(BuilderImpl builder) {
        this.retentionPeriod = builder.retentionPeriod;
        this.type = builder.type;
    }

    /**
     * <p>
     * The enum value sets the period for retaining emails in an archive.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #retentionPeriod}
     * will return {@link RetentionPeriod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #retentionPeriodAsString}.
     * </p>
     * 
     * @return The enum value sets the period for retaining emails in an archive.
     * @see RetentionPeriod
     */
    public final RetentionPeriod retentionPeriod() {
        return RetentionPeriod.fromValue(retentionPeriod);
    }

    /**
     * <p>
     * The enum value sets the period for retaining emails in an archive.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #retentionPeriod}
     * will return {@link RetentionPeriod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #retentionPeriodAsString}.
     * </p>
     * 
     * @return The enum value sets the period for retaining emails in an archive.
     * @see RetentionPeriod
     */
    public final String retentionPeriodAsString() {
        return retentionPeriod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(retentionPeriodAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArchiveRetention)) {
            return false;
        }
        ArchiveRetention other = (ArchiveRetention) obj;
        return Objects.equals(retentionPeriodAsString(), other.retentionPeriodAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ArchiveRetention").add("RetentionPeriod", retentionPeriodAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RetentionPeriod":
            return Optional.ofNullable(clazz.cast(retentionPeriodAsString()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #retentionPeriodAsString()} initialized to the given value.
     *
     * <p>
     * The enum value sets the period for retaining emails in an archive.
     * </p>
     * 
     * @param retentionPeriod
     *        The enum value sets the period for retaining emails in an archive.
     * @see RetentionPeriod
     */
    public static ArchiveRetention fromRetentionPeriod(String retentionPeriod) {
        return builder().retentionPeriod(retentionPeriod).build();
    }

    /**
     * Create an instance of this class with {@link #retentionPeriodAsString()} initialized to the given value.
     *
     * <p>
     * The enum value sets the period for retaining emails in an archive.
     * </p>
     * 
     * @param retentionPeriod
     *        The enum value sets the period for retaining emails in an archive.
     * @see RetentionPeriod
     */
    public static ArchiveRetention fromRetentionPeriod(RetentionPeriod retentionPeriod) {
        return builder().retentionPeriod(retentionPeriod).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RetentionPeriod", RETENTION_PERIOD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ArchiveRetention, T> g) {
        return obj -> g.apply((ArchiveRetention) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ArchiveRetention> {
        /**
         * <p>
         * The enum value sets the period for retaining emails in an archive.
         * </p>
         * 
         * @param retentionPeriod
         *        The enum value sets the period for retaining emails in an archive.
         * @see RetentionPeriod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetentionPeriod
         */
        Builder retentionPeriod(String retentionPeriod);

        /**
         * <p>
         * The enum value sets the period for retaining emails in an archive.
         * </p>
         * 
         * @param retentionPeriod
         *        The enum value sets the period for retaining emails in an archive.
         * @see RetentionPeriod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetentionPeriod
         */
        Builder retentionPeriod(RetentionPeriod retentionPeriod);
    }

    static final class BuilderImpl implements Builder {
        private String retentionPeriod;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ArchiveRetention model) {
            retentionPeriod(model.retentionPeriod);
        }

        public final String getRetentionPeriod() {
            return retentionPeriod;
        }

        public final void setRetentionPeriod(String retentionPeriod) {
            Object oldValue = this.retentionPeriod;
            this.retentionPeriod = retentionPeriod;
            handleUnionValueChange(Type.RETENTION_PERIOD, oldValue, this.retentionPeriod);
        }

        @Override
        public final Builder retentionPeriod(String retentionPeriod) {
            Object oldValue = this.retentionPeriod;
            this.retentionPeriod = retentionPeriod;
            handleUnionValueChange(Type.RETENTION_PERIOD, oldValue, this.retentionPeriod);
            return this;
        }

        @Override
        public final Builder retentionPeriod(RetentionPeriod retentionPeriod) {
            this.retentionPeriod(retentionPeriod == null ? null : retentionPeriod.toString());
            return this;
        }

        @Override
        public ArchiveRetention build() {
            return new ArchiveRetention(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ArchiveRetention#type()
     */
    public enum Type {
        RETENTION_PERIOD,

        UNKNOWN_TO_SDK_VERSION
    }
}
