/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateIngressPointRequest extends MailManagerRequest implements
        ToCopyableBuilder<CreateIngressPointRequest.Builder, CreateIngressPointRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateIngressPointRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<IngressPointConfiguration> INGRESS_POINT_CONFIGURATION_FIELD = SdkField
            .<IngressPointConfiguration> builder(MarshallingType.SDK_POJO).memberName("IngressPointConfiguration")
            .getter(getter(CreateIngressPointRequest::ingressPointConfiguration))
            .setter(setter(Builder::ingressPointConfiguration)).constructor(IngressPointConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngressPointConfiguration").build())
            .build();

    private static final SdkField<String> INGRESS_POINT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IngressPointName").getter(getter(CreateIngressPointRequest::ingressPointName))
            .setter(setter(Builder::ingressPointName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngressPointName").build()).build();

    private static final SdkField<String> RULE_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleSetId").getter(getter(CreateIngressPointRequest::ruleSetId)).setter(setter(Builder::ruleSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleSetId").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateIngressPointRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TRAFFIC_POLICY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrafficPolicyId").getter(getter(CreateIngressPointRequest::trafficPolicyId))
            .setter(setter(Builder::trafficPolicyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficPolicyId").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(CreateIngressPointRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            INGRESS_POINT_CONFIGURATION_FIELD, INGRESS_POINT_NAME_FIELD, RULE_SET_ID_FIELD, TAGS_FIELD, TRAFFIC_POLICY_ID_FIELD,
            TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final IngressPointConfiguration ingressPointConfiguration;

    private final String ingressPointName;

    private final String ruleSetId;

    private final List<Tag> tags;

    private final String trafficPolicyId;

    private final String type;

    private CreateIngressPointRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.ingressPointConfiguration = builder.ingressPointConfiguration;
        this.ingressPointName = builder.ingressPointName;
        this.ruleSetId = builder.ruleSetId;
        this.tags = builder.tags;
        this.trafficPolicyId = builder.trafficPolicyId;
        this.type = builder.type;
    }

    /**
     * <p>
     * A unique token that Amazon SES uses to recognize subsequent retries of the same request.
     * </p>
     * 
     * @return A unique token that Amazon SES uses to recognize subsequent retries of the same request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * If you choose an Authenticated ingress endpoint, you must configure either an SMTP password or a secret ARN.
     * </p>
     * 
     * @return If you choose an Authenticated ingress endpoint, you must configure either an SMTP password or a secret
     *         ARN.
     */
    public final IngressPointConfiguration ingressPointConfiguration() {
        return ingressPointConfiguration;
    }

    /**
     * <p>
     * A user friendly name for an ingress endpoint resource.
     * </p>
     * 
     * @return A user friendly name for an ingress endpoint resource.
     */
    public final String ingressPointName() {
        return ingressPointName;
    }

    /**
     * <p>
     * The identifier of an existing rule set that you attach to an ingress endpoint resource.
     * </p>
     * 
     * @return The identifier of an existing rule set that you attach to an ingress endpoint resource.
     */
    public final String ruleSetId() {
        return ruleSetId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for the resource. For example, { "tags": {"key1":"value1",
     * "key2":"value2"} }.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for the resource. For example, { "tags":
     *         {"key1":"value1", "key2":"value2"} }.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The identifier of an existing traffic policy that you attach to an ingress endpoint resource.
     * </p>
     * 
     * @return The identifier of an existing traffic policy that you attach to an ingress endpoint resource.
     */
    public final String trafficPolicyId() {
        return trafficPolicyId;
    }

    /**
     * <p>
     * The type of the ingress endpoint to create.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link IngressPointType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the ingress endpoint to create.
     * @see IngressPointType
     */
    public final IngressPointType type() {
        return IngressPointType.fromValue(type);
    }

    /**
     * <p>
     * The type of the ingress endpoint to create.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link IngressPointType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the ingress endpoint to create.
     * @see IngressPointType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(ingressPointConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(ingressPointName());
        hashCode = 31 * hashCode + Objects.hashCode(ruleSetId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(trafficPolicyId());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIngressPointRequest)) {
            return false;
        }
        CreateIngressPointRequest other = (CreateIngressPointRequest) obj;
        return Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(ingressPointConfiguration(), other.ingressPointConfiguration())
                && Objects.equals(ingressPointName(), other.ingressPointName()) && Objects.equals(ruleSetId(), other.ruleSetId())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(trafficPolicyId(), other.trafficPolicyId())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateIngressPointRequest").add("ClientToken", clientToken())
                .add("IngressPointConfiguration", ingressPointConfiguration()).add("IngressPointName", ingressPointName())
                .add("RuleSetId", ruleSetId()).add("Tags", hasTags() ? tags() : null).add("TrafficPolicyId", trafficPolicyId())
                .add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "IngressPointConfiguration":
            return Optional.ofNullable(clazz.cast(ingressPointConfiguration()));
        case "IngressPointName":
            return Optional.ofNullable(clazz.cast(ingressPointName()));
        case "RuleSetId":
            return Optional.ofNullable(clazz.cast(ruleSetId()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "TrafficPolicyId":
            return Optional.ofNullable(clazz.cast(trafficPolicyId()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("IngressPointConfiguration", INGRESS_POINT_CONFIGURATION_FIELD);
        map.put("IngressPointName", INGRESS_POINT_NAME_FIELD);
        map.put("RuleSetId", RULE_SET_ID_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("TrafficPolicyId", TRAFFIC_POLICY_ID_FIELD);
        map.put("Type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateIngressPointRequest, T> g) {
        return obj -> g.apply((CreateIngressPointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MailManagerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateIngressPointRequest> {
        /**
         * <p>
         * A unique token that Amazon SES uses to recognize subsequent retries of the same request.
         * </p>
         * 
         * @param clientToken
         *        A unique token that Amazon SES uses to recognize subsequent retries of the same request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * If you choose an Authenticated ingress endpoint, you must configure either an SMTP password or a secret ARN.
         * </p>
         * 
         * @param ingressPointConfiguration
         *        If you choose an Authenticated ingress endpoint, you must configure either an SMTP password or a
         *        secret ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingressPointConfiguration(IngressPointConfiguration ingressPointConfiguration);

        /**
         * <p>
         * If you choose an Authenticated ingress endpoint, you must configure either an SMTP password or a secret ARN.
         * </p>
         * This is a convenience method that creates an instance of the {@link IngressPointConfiguration.Builder}
         * avoiding the need to create one manually via {@link IngressPointConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IngressPointConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #ingressPointConfiguration(IngressPointConfiguration)}.
         * 
         * @param ingressPointConfiguration
         *        a consumer that will call methods on {@link IngressPointConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ingressPointConfiguration(IngressPointConfiguration)
         */
        default Builder ingressPointConfiguration(Consumer<IngressPointConfiguration.Builder> ingressPointConfiguration) {
            return ingressPointConfiguration(IngressPointConfiguration.builder().applyMutation(ingressPointConfiguration).build());
        }

        /**
         * <p>
         * A user friendly name for an ingress endpoint resource.
         * </p>
         * 
         * @param ingressPointName
         *        A user friendly name for an ingress endpoint resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingressPointName(String ingressPointName);

        /**
         * <p>
         * The identifier of an existing rule set that you attach to an ingress endpoint resource.
         * </p>
         * 
         * @param ruleSetId
         *        The identifier of an existing rule set that you attach to an ingress endpoint resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleSetId(String ruleSetId);

        /**
         * <p>
         * The tags used to organize, track, or control access for the resource. For example, { "tags":
         * {"key1":"value1", "key2":"value2"} }.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for the resource. For example, { "tags":
         *        {"key1":"value1", "key2":"value2"} }.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags used to organize, track, or control access for the resource. For example, { "tags":
         * {"key1":"value1", "key2":"value2"} }.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for the resource. For example, { "tags":
         *        {"key1":"value1", "key2":"value2"} }.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags used to organize, track, or control access for the resource. For example, { "tags":
         * {"key1":"value1", "key2":"value2"} }.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mailmanager.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.mailmanager.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mailmanager.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mailmanager.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The identifier of an existing traffic policy that you attach to an ingress endpoint resource.
         * </p>
         * 
         * @param trafficPolicyId
         *        The identifier of an existing traffic policy that you attach to an ingress endpoint resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicyId(String trafficPolicyId);

        /**
         * <p>
         * The type of the ingress endpoint to create.
         * </p>
         * 
         * @param type
         *        The type of the ingress endpoint to create.
         * @see IngressPointType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngressPointType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the ingress endpoint to create.
         * </p>
         * 
         * @param type
         *        The type of the ingress endpoint to create.
         * @see IngressPointType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngressPointType
         */
        Builder type(IngressPointType type);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MailManagerRequest.BuilderImpl implements Builder {
        private String clientToken;

        private IngressPointConfiguration ingressPointConfiguration;

        private String ingressPointName;

        private String ruleSetId;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String trafficPolicyId;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIngressPointRequest model) {
            super(model);
            clientToken(model.clientToken);
            ingressPointConfiguration(model.ingressPointConfiguration);
            ingressPointName(model.ingressPointName);
            ruleSetId(model.ruleSetId);
            tags(model.tags);
            trafficPolicyId(model.trafficPolicyId);
            type(model.type);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final IngressPointConfiguration.Builder getIngressPointConfiguration() {
            return ingressPointConfiguration != null ? ingressPointConfiguration.toBuilder() : null;
        }

        public final void setIngressPointConfiguration(IngressPointConfiguration.BuilderImpl ingressPointConfiguration) {
            this.ingressPointConfiguration = ingressPointConfiguration != null ? ingressPointConfiguration.build() : null;
        }

        @Override
        public final Builder ingressPointConfiguration(IngressPointConfiguration ingressPointConfiguration) {
            this.ingressPointConfiguration = ingressPointConfiguration;
            return this;
        }

        public final String getIngressPointName() {
            return ingressPointName;
        }

        public final void setIngressPointName(String ingressPointName) {
            this.ingressPointName = ingressPointName;
        }

        @Override
        public final Builder ingressPointName(String ingressPointName) {
            this.ingressPointName = ingressPointName;
            return this;
        }

        public final String getRuleSetId() {
            return ruleSetId;
        }

        public final void setRuleSetId(String ruleSetId) {
            this.ruleSetId = ruleSetId;
        }

        @Override
        public final Builder ruleSetId(String ruleSetId) {
            this.ruleSetId = ruleSetId;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTrafficPolicyId() {
            return trafficPolicyId;
        }

        public final void setTrafficPolicyId(String trafficPolicyId) {
            this.trafficPolicyId = trafficPolicyId;
        }

        @Override
        public final Builder trafficPolicyId(String trafficPolicyId) {
            this.trafficPolicyId = trafficPolicyId;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(IngressPointType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateIngressPointRequest build() {
            return new CreateIngressPointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
