/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The action to deliver incoming emails to an Amazon Q Business application for indexing.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeliverToQBusinessAction implements SdkPojo, Serializable,
        ToCopyableBuilder<DeliverToQBusinessAction.Builder, DeliverToQBusinessAction> {
    private static final SdkField<String> ACTION_FAILURE_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActionFailurePolicy").getter(getter(DeliverToQBusinessAction::actionFailurePolicyAsString))
            .setter(setter(Builder::actionFailurePolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionFailurePolicy").build())
            .build();

    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationId").getter(getter(DeliverToQBusinessAction::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()).build();

    private static final SdkField<String> INDEX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexId").getter(getter(DeliverToQBusinessAction::indexId)).setter(setter(Builder::indexId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexId").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(DeliverToQBusinessAction::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FAILURE_POLICY_FIELD,
            APPLICATION_ID_FIELD, INDEX_ID_FIELD, ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String actionFailurePolicy;

    private final String applicationId;

    private final String indexId;

    private final String roleArn;

    private DeliverToQBusinessAction(BuilderImpl builder) {
        this.actionFailurePolicy = builder.actionFailurePolicy;
        this.applicationId = builder.applicationId;
        this.indexId = builder.indexId;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * A policy that states what to do in the case of failure. The action will fail if there are configuration errors.
     * For example, the specified application has been deleted or the role lacks necessary permissions to call the
     * qbusiness:BatchPutDocument API.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #actionFailurePolicy} will return {@link ActionFailurePolicy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #actionFailurePolicyAsString}.
     * </p>
     * 
     * @return A policy that states what to do in the case of failure. The action will fail if there are configuration
     *         errors. For example, the specified application has been deleted or the role lacks necessary permissions
     *         to call the qbusiness:BatchPutDocument API.
     * @see ActionFailurePolicy
     */
    public final ActionFailurePolicy actionFailurePolicy() {
        return ActionFailurePolicy.fromValue(actionFailurePolicy);
    }

    /**
     * <p>
     * A policy that states what to do in the case of failure. The action will fail if there are configuration errors.
     * For example, the specified application has been deleted or the role lacks necessary permissions to call the
     * qbusiness:BatchPutDocument API.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #actionFailurePolicy} will return {@link ActionFailurePolicy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #actionFailurePolicyAsString}.
     * </p>
     * 
     * @return A policy that states what to do in the case of failure. The action will fail if there are configuration
     *         errors. For example, the specified application has been deleted or the role lacks necessary permissions
     *         to call the qbusiness:BatchPutDocument API.
     * @see ActionFailurePolicy
     */
    public final String actionFailurePolicyAsString() {
        return actionFailurePolicy;
    }

    /**
     * <p>
     * The unique identifier of the Amazon Q Business application instance where the email content will be delivered.
     * </p>
     * 
     * @return The unique identifier of the Amazon Q Business application instance where the email content will be
     *         delivered.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The identifier of the knowledge base index within the Amazon Q Business application where the email content will
     * be stored and indexed.
     * </p>
     * 
     * @return The identifier of the knowledge base index within the Amazon Q Business application where the email
     *         content will be stored and indexed.
     */
    public final String indexId() {
        return indexId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM Role to use while delivering to Amazon Q Business. This role must have
     * access to the qbusiness:BatchPutDocument API for the given application and index.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM Role to use while delivering to Amazon Q Business. This role
     *         must have access to the qbusiness:BatchPutDocument API for the given application and index.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionFailurePolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(indexId());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeliverToQBusinessAction)) {
            return false;
        }
        DeliverToQBusinessAction other = (DeliverToQBusinessAction) obj;
        return Objects.equals(actionFailurePolicyAsString(), other.actionFailurePolicyAsString())
                && Objects.equals(applicationId(), other.applicationId()) && Objects.equals(indexId(), other.indexId())
                && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeliverToQBusinessAction").add("ActionFailurePolicy", actionFailurePolicyAsString())
                .add("ApplicationId", applicationId()).add("IndexId", indexId()).add("RoleArn", roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActionFailurePolicy":
            return Optional.ofNullable(clazz.cast(actionFailurePolicyAsString()));
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "IndexId":
            return Optional.ofNullable(clazz.cast(indexId()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ActionFailurePolicy", ACTION_FAILURE_POLICY_FIELD);
        map.put("ApplicationId", APPLICATION_ID_FIELD);
        map.put("IndexId", INDEX_ID_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeliverToQBusinessAction, T> g) {
        return obj -> g.apply((DeliverToQBusinessAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeliverToQBusinessAction> {
        /**
         * <p>
         * A policy that states what to do in the case of failure. The action will fail if there are configuration
         * errors. For example, the specified application has been deleted or the role lacks necessary permissions to
         * call the qbusiness:BatchPutDocument API.
         * </p>
         * 
         * @param actionFailurePolicy
         *        A policy that states what to do in the case of failure. The action will fail if there are
         *        configuration errors. For example, the specified application has been deleted or the role lacks
         *        necessary permissions to call the qbusiness:BatchPutDocument API.
         * @see ActionFailurePolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionFailurePolicy
         */
        Builder actionFailurePolicy(String actionFailurePolicy);

        /**
         * <p>
         * A policy that states what to do in the case of failure. The action will fail if there are configuration
         * errors. For example, the specified application has been deleted or the role lacks necessary permissions to
         * call the qbusiness:BatchPutDocument API.
         * </p>
         * 
         * @param actionFailurePolicy
         *        A policy that states what to do in the case of failure. The action will fail if there are
         *        configuration errors. For example, the specified application has been deleted or the role lacks
         *        necessary permissions to call the qbusiness:BatchPutDocument API.
         * @see ActionFailurePolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionFailurePolicy
         */
        Builder actionFailurePolicy(ActionFailurePolicy actionFailurePolicy);

        /**
         * <p>
         * The unique identifier of the Amazon Q Business application instance where the email content will be
         * delivered.
         * </p>
         * 
         * @param applicationId
         *        The unique identifier of the Amazon Q Business application instance where the email content will be
         *        delivered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The identifier of the knowledge base index within the Amazon Q Business application where the email content
         * will be stored and indexed.
         * </p>
         * 
         * @param indexId
         *        The identifier of the knowledge base index within the Amazon Q Business application where the email
         *        content will be stored and indexed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexId(String indexId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM Role to use while delivering to Amazon Q Business. This role must
         * have access to the qbusiness:BatchPutDocument API for the given application and index.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM Role to use while delivering to Amazon Q Business. This role
         *        must have access to the qbusiness:BatchPutDocument API for the given application and index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);
    }

    static final class BuilderImpl implements Builder {
        private String actionFailurePolicy;

        private String applicationId;

        private String indexId;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeliverToQBusinessAction model) {
            actionFailurePolicy(model.actionFailurePolicy);
            applicationId(model.applicationId);
            indexId(model.indexId);
            roleArn(model.roleArn);
        }

        public final String getActionFailurePolicy() {
            return actionFailurePolicy;
        }

        public final void setActionFailurePolicy(String actionFailurePolicy) {
            this.actionFailurePolicy = actionFailurePolicy;
        }

        @Override
        public final Builder actionFailurePolicy(String actionFailurePolicy) {
            this.actionFailurePolicy = actionFailurePolicy;
            return this;
        }

        @Override
        public final Builder actionFailurePolicy(ActionFailurePolicy actionFailurePolicy) {
            this.actionFailurePolicy(actionFailurePolicy == null ? null : actionFailurePolicy.toString());
            return this;
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getIndexId() {
            return indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public DeliverToQBusinessAction build() {
            return new DeliverToQBusinessAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
