/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The SMTP envelope information of the email.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Envelope implements SdkPojo, Serializable, ToCopyableBuilder<Envelope.Builder, Envelope> {
    private static final SdkField<String> FROM_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("From")
            .getter(getter(Envelope::from)).setter(setter(Builder::from))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("From").build()).build();

    private static final SdkField<String> HELO_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Helo")
            .getter(getter(Envelope::helo)).setter(setter(Builder::helo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Helo").build()).build();

    private static final SdkField<List<String>> TO_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("To")
            .getter(getter(Envelope::to))
            .setter(setter(Builder::to))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("To").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FROM_FIELD, HELO_FIELD,
            TO_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String from;

    private final String helo;

    private final List<String> to;

    private Envelope(BuilderImpl builder) {
        this.from = builder.from;
        this.helo = builder.helo;
        this.to = builder.to;
    }

    /**
     * <p>
     * The RCPT FROM given by the host from which the email was received.
     * </p>
     * 
     * @return The RCPT FROM given by the host from which the email was received.
     */
    public final String from() {
        return from;
    }

    /**
     * <p>
     * The HELO used by the host from which the email was received.
     * </p>
     * 
     * @return The HELO used by the host from which the email was received.
     */
    public final String helo() {
        return helo;
    }

    /**
     * For responses, this returns true if the service returned a value for the To property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTo() {
        return to != null && !(to instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * All SMTP TO entries given by the host from which the email was received.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTo} method.
     * </p>
     * 
     * @return All SMTP TO entries given by the host from which the email was received.
     */
    public final List<String> to() {
        return to;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(from());
        hashCode = 31 * hashCode + Objects.hashCode(helo());
        hashCode = 31 * hashCode + Objects.hashCode(hasTo() ? to() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Envelope)) {
            return false;
        }
        Envelope other = (Envelope) obj;
        return Objects.equals(from(), other.from()) && Objects.equals(helo(), other.helo()) && hasTo() == other.hasTo()
                && Objects.equals(to(), other.to());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Envelope").add("From", from()).add("Helo", helo()).add("To", hasTo() ? to() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "From":
            return Optional.ofNullable(clazz.cast(from()));
        case "Helo":
            return Optional.ofNullable(clazz.cast(helo()));
        case "To":
            return Optional.ofNullable(clazz.cast(to()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("From", FROM_FIELD);
        map.put("Helo", HELO_FIELD);
        map.put("To", TO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Envelope, T> g) {
        return obj -> g.apply((Envelope) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Envelope> {
        /**
         * <p>
         * The RCPT FROM given by the host from which the email was received.
         * </p>
         * 
         * @param from
         *        The RCPT FROM given by the host from which the email was received.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder from(String from);

        /**
         * <p>
         * The HELO used by the host from which the email was received.
         * </p>
         * 
         * @param helo
         *        The HELO used by the host from which the email was received.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder helo(String helo);

        /**
         * <p>
         * All SMTP TO entries given by the host from which the email was received.
         * </p>
         * 
         * @param to
         *        All SMTP TO entries given by the host from which the email was received.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder to(Collection<String> to);

        /**
         * <p>
         * All SMTP TO entries given by the host from which the email was received.
         * </p>
         * 
         * @param to
         *        All SMTP TO entries given by the host from which the email was received.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder to(String... to);
    }

    static final class BuilderImpl implements Builder {
        private String from;

        private String helo;

        private List<String> to = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Envelope model) {
            from(model.from);
            helo(model.helo);
            to(model.to);
        }

        public final String getFrom() {
            return from;
        }

        public final void setFrom(String from) {
            this.from = from;
        }

        @Override
        public final Builder from(String from) {
            this.from = from;
            return this;
        }

        public final String getHelo() {
            return helo;
        }

        public final void setHelo(String helo) {
            this.helo = helo;
        }

        @Override
        public final Builder helo(String helo) {
            this.helo = helo;
            return this;
        }

        public final Collection<String> getTo() {
            if (to instanceof SdkAutoConstructList) {
                return null;
            }
            return to;
        }

        public final void setTo(Collection<String> to) {
            this.to = StringListCopier.copy(to);
        }

        @Override
        public final Builder to(Collection<String> to) {
            this.to = StringListCopier.copy(to);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder to(String... to) {
            to(Arrays.asList(to));
            return this;
        }

        @Override
        public Envelope build() {
            return new Envelope(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
