/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The destination configuration for delivering exported email data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportDestinationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ExportDestinationConfiguration.Builder, ExportDestinationConfiguration> {
    private static final SdkField<S3ExportDestinationConfiguration> S3_FIELD = SdkField
            .<S3ExportDestinationConfiguration> builder(MarshallingType.SDK_POJO).memberName("S3")
            .getter(getter(ExportDestinationConfiguration::s3)).setter(setter(Builder::s3))
            .constructor(S3ExportDestinationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final S3ExportDestinationConfiguration s3;

    private final Type type;

    private ExportDestinationConfiguration(BuilderImpl builder) {
        this.s3 = builder.s3;
        this.type = builder.type;
    }

    /**
     * <p>
     * Configuration for delivering to an Amazon S3 bucket.
     * </p>
     * 
     * @return Configuration for delivering to an Amazon S3 bucket.
     */
    public final S3ExportDestinationConfiguration s3() {
        return s3;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportDestinationConfiguration)) {
            return false;
        }
        ExportDestinationConfiguration other = (ExportDestinationConfiguration) obj;
        return Objects.equals(s3(), other.s3());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExportDestinationConfiguration").add("S3", s3()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3":
            return Optional.ofNullable(clazz.cast(s3()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #s3()} initialized to the given value.
     *
     * <p>
     * Configuration for delivering to an Amazon S3 bucket.
     * </p>
     * 
     * @param s3
     *        Configuration for delivering to an Amazon S3 bucket.
     */
    public static ExportDestinationConfiguration fromS3(S3ExportDestinationConfiguration s3) {
        return builder().s3(s3).build();
    }

    /**
     * Create an instance of this class with {@link #s3()} initialized to the given value.
     *
     * <p>
     * Configuration for delivering to an Amazon S3 bucket.
     * </p>
     * 
     * @param s3
     *        Configuration for delivering to an Amazon S3 bucket.
     */
    public static ExportDestinationConfiguration fromS3(Consumer<S3ExportDestinationConfiguration.Builder> s3) {
        S3ExportDestinationConfiguration.Builder builder = S3ExportDestinationConfiguration.builder();
        s3.accept(builder);
        return fromS3(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("S3", S3_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExportDestinationConfiguration, T> g) {
        return obj -> g.apply((ExportDestinationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExportDestinationConfiguration> {
        /**
         * <p>
         * Configuration for delivering to an Amazon S3 bucket.
         * </p>
         * 
         * @param s3
         *        Configuration for delivering to an Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3(S3ExportDestinationConfiguration s3);

        /**
         * <p>
         * Configuration for delivering to an Amazon S3 bucket.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3ExportDestinationConfiguration.Builder}
         * avoiding the need to create one manually via {@link S3ExportDestinationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3ExportDestinationConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #s3(S3ExportDestinationConfiguration)}.
         * 
         * @param s3
         *        a consumer that will call methods on {@link S3ExportDestinationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3(S3ExportDestinationConfiguration)
         */
        default Builder s3(Consumer<S3ExportDestinationConfiguration.Builder> s3) {
            return s3(S3ExportDestinationConfiguration.builder().applyMutation(s3).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private S3ExportDestinationConfiguration s3;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ExportDestinationConfiguration model) {
            s3(model.s3);
        }

        public final S3ExportDestinationConfiguration.Builder getS3() {
            return s3 != null ? s3.toBuilder() : null;
        }

        public final void setS3(S3ExportDestinationConfiguration.BuilderImpl s3) {
            Object oldValue = this.s3;
            this.s3 = s3 != null ? s3.build() : null;
            handleUnionValueChange(Type.S3, oldValue, this.s3);
        }

        @Override
        public final Builder s3(S3ExportDestinationConfiguration s3) {
            Object oldValue = this.s3;
            this.s3 = s3;
            handleUnionValueChange(Type.S3, oldValue, this.s3);
            return this;
        }

        @Override
        public ExportDestinationConfiguration build() {
            return new ExportDestinationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ExportDestinationConfiguration#type()
     */
    public enum Type {
        S3,

        UNKNOWN_TO_SDK_VERSION
    }
}
