/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response containing the textual content of the requested archived email message.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetArchiveMessageContentResponse extends MailManagerResponse implements
        ToCopyableBuilder<GetArchiveMessageContentResponse.Builder, GetArchiveMessageContentResponse> {
    private static final SdkField<MessageBody> BODY_FIELD = SdkField.<MessageBody> builder(MarshallingType.SDK_POJO)
            .memberName("Body").getter(getter(GetArchiveMessageContentResponse::body)).setter(setter(Builder::body))
            .constructor(MessageBody::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Body").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BODY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final MessageBody body;

    private GetArchiveMessageContentResponse(BuilderImpl builder) {
        super(builder);
        this.body = builder.body;
    }

    /**
     * <p>
     * The textual body content of the email message.
     * </p>
     * 
     * @return The textual body content of the email message.
     */
    public final MessageBody body() {
        return body;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(body());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetArchiveMessageContentResponse)) {
            return false;
        }
        GetArchiveMessageContentResponse other = (GetArchiveMessageContentResponse) obj;
        return Objects.equals(body(), other.body());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetArchiveMessageContentResponse").add("Body", body()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Body":
            return Optional.ofNullable(clazz.cast(body()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Body", BODY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetArchiveMessageContentResponse, T> g) {
        return obj -> g.apply((GetArchiveMessageContentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MailManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetArchiveMessageContentResponse> {
        /**
         * <p>
         * The textual body content of the email message.
         * </p>
         * 
         * @param body
         *        The textual body content of the email message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder body(MessageBody body);

        /**
         * <p>
         * The textual body content of the email message.
         * </p>
         * This is a convenience method that creates an instance of the {@link MessageBody.Builder} avoiding the need to
         * create one manually via {@link MessageBody#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MessageBody.Builder#build()} is called immediately and its result
         * is passed to {@link #body(MessageBody)}.
         * 
         * @param body
         *        a consumer that will call methods on {@link MessageBody.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #body(MessageBody)
         */
        default Builder body(Consumer<MessageBody.Builder> body) {
            return body(MessageBody.builder().applyMutation(body).build());
        }
    }

    static final class BuilderImpl extends MailManagerResponse.BuilderImpl implements Builder {
        private MessageBody body;

        private BuilderImpl() {
        }

        private BuilderImpl(GetArchiveMessageContentResponse model) {
            super(model);
            body(model.body);
        }

        public final MessageBody.Builder getBody() {
            return body != null ? body.toBuilder() : null;
        }

        public final void setBody(MessageBody.BuilderImpl body) {
            this.body = body != null ? body.build() : null;
        }

        @Override
        public final Builder body(MessageBody body) {
            this.body = body;
            return this;
        }

        @Override
        public GetArchiveMessageContentResponse build() {
            return new GetArchiveMessageContentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
