/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetIngressPointResponse extends MailManagerResponse implements
        ToCopyableBuilder<GetIngressPointResponse.Builder, GetIngressPointResponse> {
    private static final SdkField<String> A_RECORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ARecord").getter(getter(GetIngressPointResponse::aRecord)).setter(setter(Builder::aRecord))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARecord").build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp").getter(getter(GetIngressPointResponse::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()).build();

    private static final SdkField<String> INGRESS_POINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IngressPointArn").getter(getter(GetIngressPointResponse::ingressPointArn))
            .setter(setter(Builder::ingressPointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngressPointArn").build()).build();

    private static final SdkField<IngressPointAuthConfiguration> INGRESS_POINT_AUTH_CONFIGURATION_FIELD = SdkField
            .<IngressPointAuthConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("IngressPointAuthConfiguration")
            .getter(getter(GetIngressPointResponse::ingressPointAuthConfiguration))
            .setter(setter(Builder::ingressPointAuthConfiguration))
            .constructor(IngressPointAuthConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngressPointAuthConfiguration")
                    .build()).build();

    private static final SdkField<String> INGRESS_POINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IngressPointId").getter(getter(GetIngressPointResponse::ingressPointId))
            .setter(setter(Builder::ingressPointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngressPointId").build()).build();

    private static final SdkField<String> INGRESS_POINT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IngressPointName").getter(getter(GetIngressPointResponse::ingressPointName))
            .setter(setter(Builder::ingressPointName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngressPointName").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTimestamp").getter(getter(GetIngressPointResponse::lastUpdatedTimestamp))
            .setter(setter(Builder::lastUpdatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTimestamp").build())
            .build();

    private static final SdkField<String> RULE_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleSetId").getter(getter(GetIngressPointResponse::ruleSetId)).setter(setter(Builder::ruleSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleSetId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GetIngressPointResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> TRAFFIC_POLICY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrafficPolicyId").getter(getter(GetIngressPointResponse::trafficPolicyId))
            .setter(setter(Builder::trafficPolicyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficPolicyId").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(GetIngressPointResponse::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(A_RECORD_FIELD,
            CREATED_TIMESTAMP_FIELD, INGRESS_POINT_ARN_FIELD, INGRESS_POINT_AUTH_CONFIGURATION_FIELD, INGRESS_POINT_ID_FIELD,
            INGRESS_POINT_NAME_FIELD, LAST_UPDATED_TIMESTAMP_FIELD, RULE_SET_ID_FIELD, STATUS_FIELD, TRAFFIC_POLICY_ID_FIELD,
            TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String aRecord;

    private final Instant createdTimestamp;

    private final String ingressPointArn;

    private final IngressPointAuthConfiguration ingressPointAuthConfiguration;

    private final String ingressPointId;

    private final String ingressPointName;

    private final Instant lastUpdatedTimestamp;

    private final String ruleSetId;

    private final String status;

    private final String trafficPolicyId;

    private final String type;

    private GetIngressPointResponse(BuilderImpl builder) {
        super(builder);
        this.aRecord = builder.aRecord;
        this.createdTimestamp = builder.createdTimestamp;
        this.ingressPointArn = builder.ingressPointArn;
        this.ingressPointAuthConfiguration = builder.ingressPointAuthConfiguration;
        this.ingressPointId = builder.ingressPointId;
        this.ingressPointName = builder.ingressPointName;
        this.lastUpdatedTimestamp = builder.lastUpdatedTimestamp;
        this.ruleSetId = builder.ruleSetId;
        this.status = builder.status;
        this.trafficPolicyId = builder.trafficPolicyId;
        this.type = builder.type;
    }

    /**
     * <p>
     * The DNS A Record that identifies your ingress endpoint. Configure your DNS Mail Exchange (MX) record with this
     * value to route emails to Mail Manager.
     * </p>
     * 
     * @return The DNS A Record that identifies your ingress endpoint. Configure your DNS Mail Exchange (MX) record with
     *         this value to route emails to Mail Manager.
     */
    public final String aRecord() {
        return aRecord;
    }

    /**
     * <p>
     * The timestamp of when the ingress endpoint was created.
     * </p>
     * 
     * @return The timestamp of when the ingress endpoint was created.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the ingress endpoint resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the ingress endpoint resource.
     */
    public final String ingressPointArn() {
        return ingressPointArn;
    }

    /**
     * <p>
     * The authentication configuration of the ingress endpoint resource.
     * </p>
     * 
     * @return The authentication configuration of the ingress endpoint resource.
     */
    public final IngressPointAuthConfiguration ingressPointAuthConfiguration() {
        return ingressPointAuthConfiguration;
    }

    /**
     * <p>
     * The identifier of an ingress endpoint resource.
     * </p>
     * 
     * @return The identifier of an ingress endpoint resource.
     */
    public final String ingressPointId() {
        return ingressPointId;
    }

    /**
     * <p>
     * A user friendly name for the ingress endpoint.
     * </p>
     * 
     * @return A user friendly name for the ingress endpoint.
     */
    public final String ingressPointName() {
        return ingressPointName;
    }

    /**
     * <p>
     * The timestamp of when the ingress endpoint was last updated.
     * </p>
     * 
     * @return The timestamp of when the ingress endpoint was last updated.
     */
    public final Instant lastUpdatedTimestamp() {
        return lastUpdatedTimestamp;
    }

    /**
     * <p>
     * The identifier of a rule set resource associated with the ingress endpoint.
     * </p>
     * 
     * @return The identifier of a rule set resource associated with the ingress endpoint.
     */
    public final String ruleSetId() {
        return ruleSetId;
    }

    /**
     * <p>
     * The status of the ingress endpoint resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link IngressPointStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the ingress endpoint resource.
     * @see IngressPointStatus
     */
    public final IngressPointStatus status() {
        return IngressPointStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the ingress endpoint resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link IngressPointStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the ingress endpoint resource.
     * @see IngressPointStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The identifier of the traffic policy resource associated with the ingress endpoint.
     * </p>
     * 
     * @return The identifier of the traffic policy resource associated with the ingress endpoint.
     */
    public final String trafficPolicyId() {
        return trafficPolicyId;
    }

    /**
     * <p>
     * The type of ingress endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link IngressPointType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of ingress endpoint.
     * @see IngressPointType
     */
    public final IngressPointType type() {
        return IngressPointType.fromValue(type);
    }

    /**
     * <p>
     * The type of ingress endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link IngressPointType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of ingress endpoint.
     * @see IngressPointType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(aRecord());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(ingressPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(ingressPointAuthConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(ingressPointId());
        hashCode = 31 * hashCode + Objects.hashCode(ingressPointName());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(ruleSetId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(trafficPolicyId());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIngressPointResponse)) {
            return false;
        }
        GetIngressPointResponse other = (GetIngressPointResponse) obj;
        return Objects.equals(aRecord(), other.aRecord()) && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(ingressPointArn(), other.ingressPointArn())
                && Objects.equals(ingressPointAuthConfiguration(), other.ingressPointAuthConfiguration())
                && Objects.equals(ingressPointId(), other.ingressPointId())
                && Objects.equals(ingressPointName(), other.ingressPointName())
                && Objects.equals(lastUpdatedTimestamp(), other.lastUpdatedTimestamp())
                && Objects.equals(ruleSetId(), other.ruleSetId()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(trafficPolicyId(), other.trafficPolicyId())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetIngressPointResponse").add("ARecord", aRecord()).add("CreatedTimestamp", createdTimestamp())
                .add("IngressPointArn", ingressPointArn()).add("IngressPointAuthConfiguration", ingressPointAuthConfiguration())
                .add("IngressPointId", ingressPointId()).add("IngressPointName", ingressPointName())
                .add("LastUpdatedTimestamp", lastUpdatedTimestamp()).add("RuleSetId", ruleSetId())
                .add("Status", statusAsString()).add("TrafficPolicyId", trafficPolicyId()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ARecord":
            return Optional.ofNullable(clazz.cast(aRecord()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "IngressPointArn":
            return Optional.ofNullable(clazz.cast(ingressPointArn()));
        case "IngressPointAuthConfiguration":
            return Optional.ofNullable(clazz.cast(ingressPointAuthConfiguration()));
        case "IngressPointId":
            return Optional.ofNullable(clazz.cast(ingressPointId()));
        case "IngressPointName":
            return Optional.ofNullable(clazz.cast(ingressPointName()));
        case "LastUpdatedTimestamp":
            return Optional.ofNullable(clazz.cast(lastUpdatedTimestamp()));
        case "RuleSetId":
            return Optional.ofNullable(clazz.cast(ruleSetId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "TrafficPolicyId":
            return Optional.ofNullable(clazz.cast(trafficPolicyId()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ARecord", A_RECORD_FIELD);
        map.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
        map.put("IngressPointArn", INGRESS_POINT_ARN_FIELD);
        map.put("IngressPointAuthConfiguration", INGRESS_POINT_AUTH_CONFIGURATION_FIELD);
        map.put("IngressPointId", INGRESS_POINT_ID_FIELD);
        map.put("IngressPointName", INGRESS_POINT_NAME_FIELD);
        map.put("LastUpdatedTimestamp", LAST_UPDATED_TIMESTAMP_FIELD);
        map.put("RuleSetId", RULE_SET_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("TrafficPolicyId", TRAFFIC_POLICY_ID_FIELD);
        map.put("Type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetIngressPointResponse, T> g) {
        return obj -> g.apply((GetIngressPointResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MailManagerResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetIngressPointResponse> {
        /**
         * <p>
         * The DNS A Record that identifies your ingress endpoint. Configure your DNS Mail Exchange (MX) record with
         * this value to route emails to Mail Manager.
         * </p>
         * 
         * @param aRecord
         *        The DNS A Record that identifies your ingress endpoint. Configure your DNS Mail Exchange (MX) record
         *        with this value to route emails to Mail Manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aRecord(String aRecord);

        /**
         * <p>
         * The timestamp of when the ingress endpoint was created.
         * </p>
         * 
         * @param createdTimestamp
         *        The timestamp of when the ingress endpoint was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the ingress endpoint resource.
         * </p>
         * 
         * @param ingressPointArn
         *        The Amazon Resource Name (ARN) of the ingress endpoint resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingressPointArn(String ingressPointArn);

        /**
         * <p>
         * The authentication configuration of the ingress endpoint resource.
         * </p>
         * 
         * @param ingressPointAuthConfiguration
         *        The authentication configuration of the ingress endpoint resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingressPointAuthConfiguration(IngressPointAuthConfiguration ingressPointAuthConfiguration);

        /**
         * <p>
         * The authentication configuration of the ingress endpoint resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link IngressPointAuthConfiguration.Builder}
         * avoiding the need to create one manually via {@link IngressPointAuthConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IngressPointAuthConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #ingressPointAuthConfiguration(IngressPointAuthConfiguration)}.
         * 
         * @param ingressPointAuthConfiguration
         *        a consumer that will call methods on {@link IngressPointAuthConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ingressPointAuthConfiguration(IngressPointAuthConfiguration)
         */
        default Builder ingressPointAuthConfiguration(
                Consumer<IngressPointAuthConfiguration.Builder> ingressPointAuthConfiguration) {
            return ingressPointAuthConfiguration(IngressPointAuthConfiguration.builder()
                    .applyMutation(ingressPointAuthConfiguration).build());
        }

        /**
         * <p>
         * The identifier of an ingress endpoint resource.
         * </p>
         * 
         * @param ingressPointId
         *        The identifier of an ingress endpoint resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingressPointId(String ingressPointId);

        /**
         * <p>
         * A user friendly name for the ingress endpoint.
         * </p>
         * 
         * @param ingressPointName
         *        A user friendly name for the ingress endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingressPointName(String ingressPointName);

        /**
         * <p>
         * The timestamp of when the ingress endpoint was last updated.
         * </p>
         * 
         * @param lastUpdatedTimestamp
         *        The timestamp of when the ingress endpoint was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp);

        /**
         * <p>
         * The identifier of a rule set resource associated with the ingress endpoint.
         * </p>
         * 
         * @param ruleSetId
         *        The identifier of a rule set resource associated with the ingress endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleSetId(String ruleSetId);

        /**
         * <p>
         * The status of the ingress endpoint resource.
         * </p>
         * 
         * @param status
         *        The status of the ingress endpoint resource.
         * @see IngressPointStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngressPointStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the ingress endpoint resource.
         * </p>
         * 
         * @param status
         *        The status of the ingress endpoint resource.
         * @see IngressPointStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngressPointStatus
         */
        Builder status(IngressPointStatus status);

        /**
         * <p>
         * The identifier of the traffic policy resource associated with the ingress endpoint.
         * </p>
         * 
         * @param trafficPolicyId
         *        The identifier of the traffic policy resource associated with the ingress endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicyId(String trafficPolicyId);

        /**
         * <p>
         * The type of ingress endpoint.
         * </p>
         * 
         * @param type
         *        The type of ingress endpoint.
         * @see IngressPointType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngressPointType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of ingress endpoint.
         * </p>
         * 
         * @param type
         *        The type of ingress endpoint.
         * @see IngressPointType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngressPointType
         */
        Builder type(IngressPointType type);
    }

    static final class BuilderImpl extends MailManagerResponse.BuilderImpl implements Builder {
        private String aRecord;

        private Instant createdTimestamp;

        private String ingressPointArn;

        private IngressPointAuthConfiguration ingressPointAuthConfiguration;

        private String ingressPointId;

        private String ingressPointName;

        private Instant lastUpdatedTimestamp;

        private String ruleSetId;

        private String status;

        private String trafficPolicyId;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIngressPointResponse model) {
            super(model);
            aRecord(model.aRecord);
            createdTimestamp(model.createdTimestamp);
            ingressPointArn(model.ingressPointArn);
            ingressPointAuthConfiguration(model.ingressPointAuthConfiguration);
            ingressPointId(model.ingressPointId);
            ingressPointName(model.ingressPointName);
            lastUpdatedTimestamp(model.lastUpdatedTimestamp);
            ruleSetId(model.ruleSetId);
            status(model.status);
            trafficPolicyId(model.trafficPolicyId);
            type(model.type);
        }

        public final String getARecord() {
            return aRecord;
        }

        public final void setARecord(String aRecord) {
            this.aRecord = aRecord;
        }

        @Override
        public final Builder aRecord(String aRecord) {
            this.aRecord = aRecord;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final String getIngressPointArn() {
            return ingressPointArn;
        }

        public final void setIngressPointArn(String ingressPointArn) {
            this.ingressPointArn = ingressPointArn;
        }

        @Override
        public final Builder ingressPointArn(String ingressPointArn) {
            this.ingressPointArn = ingressPointArn;
            return this;
        }

        public final IngressPointAuthConfiguration.Builder getIngressPointAuthConfiguration() {
            return ingressPointAuthConfiguration != null ? ingressPointAuthConfiguration.toBuilder() : null;
        }

        public final void setIngressPointAuthConfiguration(IngressPointAuthConfiguration.BuilderImpl ingressPointAuthConfiguration) {
            this.ingressPointAuthConfiguration = ingressPointAuthConfiguration != null ? ingressPointAuthConfiguration.build()
                    : null;
        }

        @Override
        public final Builder ingressPointAuthConfiguration(IngressPointAuthConfiguration ingressPointAuthConfiguration) {
            this.ingressPointAuthConfiguration = ingressPointAuthConfiguration;
            return this;
        }

        public final String getIngressPointId() {
            return ingressPointId;
        }

        public final void setIngressPointId(String ingressPointId) {
            this.ingressPointId = ingressPointId;
        }

        @Override
        public final Builder ingressPointId(String ingressPointId) {
            this.ingressPointId = ingressPointId;
            return this;
        }

        public final String getIngressPointName() {
            return ingressPointName;
        }

        public final void setIngressPointName(String ingressPointName) {
            this.ingressPointName = ingressPointName;
        }

        @Override
        public final Builder ingressPointName(String ingressPointName) {
            this.ingressPointName = ingressPointName;
            return this;
        }

        public final Instant getLastUpdatedTimestamp() {
            return lastUpdatedTimestamp;
        }

        public final void setLastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        }

        @Override
        public final Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
            return this;
        }

        public final String getRuleSetId() {
            return ruleSetId;
        }

        public final void setRuleSetId(String ruleSetId) {
            this.ruleSetId = ruleSetId;
        }

        @Override
        public final Builder ruleSetId(String ruleSetId) {
            this.ruleSetId = ruleSetId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(IngressPointStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getTrafficPolicyId() {
            return trafficPolicyId;
        }

        public final void setTrafficPolicyId(String trafficPolicyId) {
            this.trafficPolicyId = trafficPolicyId;
        }

        @Override
        public final Builder trafficPolicyId(String trafficPolicyId) {
            this.trafficPolicyId = trafficPolicyId;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(IngressPointType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public GetIngressPointResponse build() {
            return new GetIngressPointResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
