/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Add On ARN and its returned value that is evaluated in a policy statement's conditional expression to either deny
 * or block the incoming email.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IngressAnalysis implements SdkPojo, Serializable, ToCopyableBuilder<IngressAnalysis.Builder, IngressAnalysis> {
    private static final SdkField<String> ANALYZER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Analyzer").getter(getter(IngressAnalysis::analyzer)).setter(setter(Builder::analyzer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Analyzer").build()).build();

    private static final SdkField<String> RESULT_FIELD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResultField").getter(getter(IngressAnalysis::resultField)).setter(setter(Builder::resultField))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultField").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYZER_FIELD,
            RESULT_FIELD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String analyzer;

    private final String resultField;

    private IngressAnalysis(BuilderImpl builder) {
        this.analyzer = builder.analyzer;
        this.resultField = builder.resultField;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an Add On.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an Add On.
     */
    public final String analyzer() {
        return analyzer;
    }

    /**
     * <p>
     * The returned value from an Add On.
     * </p>
     * 
     * @return The returned value from an Add On.
     */
    public final String resultField() {
        return resultField;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(analyzer());
        hashCode = 31 * hashCode + Objects.hashCode(resultField());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IngressAnalysis)) {
            return false;
        }
        IngressAnalysis other = (IngressAnalysis) obj;
        return Objects.equals(analyzer(), other.analyzer()) && Objects.equals(resultField(), other.resultField());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IngressAnalysis").add("Analyzer", analyzer()).add("ResultField", resultField()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Analyzer":
            return Optional.ofNullable(clazz.cast(analyzer()));
        case "ResultField":
            return Optional.ofNullable(clazz.cast(resultField()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Analyzer", ANALYZER_FIELD);
        map.put("ResultField", RESULT_FIELD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IngressAnalysis, T> g) {
        return obj -> g.apply((IngressAnalysis) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IngressAnalysis> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of an Add On.
         * </p>
         * 
         * @param analyzer
         *        The Amazon Resource Name (ARN) of an Add On.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analyzer(String analyzer);

        /**
         * <p>
         * The returned value from an Add On.
         * </p>
         * 
         * @param resultField
         *        The returned value from an Add On.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultField(String resultField);
    }

    static final class BuilderImpl implements Builder {
        private String analyzer;

        private String resultField;

        private BuilderImpl() {
        }

        private BuilderImpl(IngressAnalysis model) {
            analyzer(model.analyzer);
            resultField(model.resultField);
        }

        public final String getAnalyzer() {
            return analyzer;
        }

        public final void setAnalyzer(String analyzer) {
            this.analyzer = analyzer;
        }

        @Override
        public final Builder analyzer(String analyzer) {
            this.analyzer = analyzer;
            return this;
        }

        public final String getResultField() {
            return resultField;
        }

        public final void setResultField(String resultField) {
            this.resultField = resultField;
        }

        @Override
        public final Builder resultField(String resultField) {
            this.resultField = resultField;
            return this;
        }

        @Override
        public IngressAnalysis build() {
            return new IngressAnalysis(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
