/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure for a string based condition matching on the incoming mail.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IngressStringExpression implements SdkPojo, Serializable,
        ToCopyableBuilder<IngressStringExpression.Builder, IngressStringExpression> {
    private static final SdkField<IngressStringToEvaluate> EVALUATE_FIELD = SdkField
            .<IngressStringToEvaluate> builder(MarshallingType.SDK_POJO).memberName("Evaluate")
            .getter(getter(IngressStringExpression::evaluate)).setter(setter(Builder::evaluate))
            .constructor(IngressStringToEvaluate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Evaluate").build()).build();

    private static final SdkField<String> OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Operator").getter(getter(IngressStringExpression::operatorAsString)).setter(setter(Builder::operator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operator").build()).build();

    private static final SdkField<List<String>> VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Values")
            .getter(getter(IngressStringExpression::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVALUATE_FIELD,
            OPERATOR_FIELD, VALUES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final IngressStringToEvaluate evaluate;

    private final String operator;

    private final List<String> values;

    private IngressStringExpression(BuilderImpl builder) {
        this.evaluate = builder.evaluate;
        this.operator = builder.operator;
        this.values = builder.values;
    }

    /**
     * <p>
     * The left hand side argument of a string condition expression.
     * </p>
     * 
     * @return The left hand side argument of a string condition expression.
     */
    public final IngressStringToEvaluate evaluate() {
        return evaluate;
    }

    /**
     * <p>
     * The matching operator for a string condition expression.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link IngressStringOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #operatorAsString}.
     * </p>
     * 
     * @return The matching operator for a string condition expression.
     * @see IngressStringOperator
     */
    public final IngressStringOperator operator() {
        return IngressStringOperator.fromValue(operator);
    }

    /**
     * <p>
     * The matching operator for a string condition expression.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link IngressStringOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #operatorAsString}.
     * </p>
     * 
     * @return The matching operator for a string condition expression.
     * @see IngressStringOperator
     */
    public final String operatorAsString() {
        return operator;
    }

    /**
     * For responses, this returns true if the service returned a value for the Values property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The right hand side argument of a string condition expression.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValues} method.
     * </p>
     * 
     * @return The right hand side argument of a string condition expression.
     */
    public final List<String> values() {
        return values;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(evaluate());
        hashCode = 31 * hashCode + Objects.hashCode(operatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasValues() ? values() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IngressStringExpression)) {
            return false;
        }
        IngressStringExpression other = (IngressStringExpression) obj;
        return Objects.equals(evaluate(), other.evaluate()) && Objects.equals(operatorAsString(), other.operatorAsString())
                && hasValues() == other.hasValues() && Objects.equals(values(), other.values());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IngressStringExpression").add("Evaluate", evaluate()).add("Operator", operatorAsString())
                .add("Values", hasValues() ? values() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Evaluate":
            return Optional.ofNullable(clazz.cast(evaluate()));
        case "Operator":
            return Optional.ofNullable(clazz.cast(operatorAsString()));
        case "Values":
            return Optional.ofNullable(clazz.cast(values()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Evaluate", EVALUATE_FIELD);
        map.put("Operator", OPERATOR_FIELD);
        map.put("Values", VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IngressStringExpression, T> g) {
        return obj -> g.apply((IngressStringExpression) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IngressStringExpression> {
        /**
         * <p>
         * The left hand side argument of a string condition expression.
         * </p>
         * 
         * @param evaluate
         *        The left hand side argument of a string condition expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluate(IngressStringToEvaluate evaluate);

        /**
         * <p>
         * The left hand side argument of a string condition expression.
         * </p>
         * This is a convenience method that creates an instance of the {@link IngressStringToEvaluate.Builder} avoiding
         * the need to create one manually via {@link IngressStringToEvaluate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IngressStringToEvaluate.Builder#build()} is called immediately
         * and its result is passed to {@link #evaluate(IngressStringToEvaluate)}.
         * 
         * @param evaluate
         *        a consumer that will call methods on {@link IngressStringToEvaluate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #evaluate(IngressStringToEvaluate)
         */
        default Builder evaluate(Consumer<IngressStringToEvaluate.Builder> evaluate) {
            return evaluate(IngressStringToEvaluate.builder().applyMutation(evaluate).build());
        }

        /**
         * <p>
         * The matching operator for a string condition expression.
         * </p>
         * 
         * @param operator
         *        The matching operator for a string condition expression.
         * @see IngressStringOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngressStringOperator
         */
        Builder operator(String operator);

        /**
         * <p>
         * The matching operator for a string condition expression.
         * </p>
         * 
         * @param operator
         *        The matching operator for a string condition expression.
         * @see IngressStringOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngressStringOperator
         */
        Builder operator(IngressStringOperator operator);

        /**
         * <p>
         * The right hand side argument of a string condition expression.
         * </p>
         * 
         * @param values
         *        The right hand side argument of a string condition expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<String> values);

        /**
         * <p>
         * The right hand side argument of a string condition expression.
         * </p>
         * 
         * @param values
         *        The right hand side argument of a string condition expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(String... values);
    }

    static final class BuilderImpl implements Builder {
        private IngressStringToEvaluate evaluate;

        private String operator;

        private List<String> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IngressStringExpression model) {
            evaluate(model.evaluate);
            operator(model.operator);
            values(model.values);
        }

        public final IngressStringToEvaluate.Builder getEvaluate() {
            return evaluate != null ? evaluate.toBuilder() : null;
        }

        public final void setEvaluate(IngressStringToEvaluate.BuilderImpl evaluate) {
            this.evaluate = evaluate != null ? evaluate.build() : null;
        }

        @Override
        public final Builder evaluate(IngressStringToEvaluate evaluate) {
            this.evaluate = evaluate;
            return this;
        }

        public final String getOperator() {
            return operator;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public final Builder operator(IngressStringOperator operator) {
            this.operator(operator == null ? null : operator.toString());
            return this;
        }

        public final Collection<String> getValues() {
            if (values instanceof SdkAutoConstructList) {
                return null;
            }
            return values;
        }

        public final void setValues(Collection<String> values) {
            this.values = StringListCopier.copy(values);
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = StringListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String... values) {
            values(Arrays.asList(values));
            return this;
        }

        @Override
        public IngressStringExpression build() {
            return new IngressStringExpression(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
