/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTrafficPoliciesResponse extends MailManagerResponse implements
        ToCopyableBuilder<ListTrafficPoliciesResponse.Builder, ListTrafficPoliciesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListTrafficPoliciesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<TrafficPolicy>> TRAFFIC_POLICIES_FIELD = SdkField
            .<List<TrafficPolicy>> builder(MarshallingType.LIST)
            .memberName("TrafficPolicies")
            .getter(getter(ListTrafficPoliciesResponse::trafficPolicies))
            .setter(setter(Builder::trafficPolicies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficPolicies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TrafficPolicy> builder(MarshallingType.SDK_POJO)
                                            .constructor(TrafficPolicy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            TRAFFIC_POLICIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<TrafficPolicy> trafficPolicies;

    private ListTrafficPoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.trafficPolicies = builder.trafficPolicies;
    }

    /**
     * <p>
     * If NextToken is returned, there are more results available. The value of NextToken is a unique pagination token
     * for each page. Make the call again using the returned token to retrieve the next page.
     * </p>
     * 
     * @return If NextToken is returned, there are more results available. The value of NextToken is a unique pagination
     *         token for each page. Make the call again using the returned token to retrieve the next page.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the TrafficPolicies property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTrafficPolicies() {
        return trafficPolicies != null && !(trafficPolicies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of traffic policies.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTrafficPolicies} method.
     * </p>
     * 
     * @return The list of traffic policies.
     */
    public final List<TrafficPolicy> trafficPolicies() {
        return trafficPolicies;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTrafficPolicies() ? trafficPolicies() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrafficPoliciesResponse)) {
            return false;
        }
        ListTrafficPoliciesResponse other = (ListTrafficPoliciesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasTrafficPolicies() == other.hasTrafficPolicies()
                && Objects.equals(trafficPolicies(), other.trafficPolicies());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTrafficPoliciesResponse").add("NextToken", nextToken())
                .add("TrafficPolicies", hasTrafficPolicies() ? trafficPolicies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "TrafficPolicies":
            return Optional.ofNullable(clazz.cast(trafficPolicies()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("TrafficPolicies", TRAFFIC_POLICIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTrafficPoliciesResponse, T> g) {
        return obj -> g.apply((ListTrafficPoliciesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MailManagerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListTrafficPoliciesResponse> {
        /**
         * <p>
         * If NextToken is returned, there are more results available. The value of NextToken is a unique pagination
         * token for each page. Make the call again using the returned token to retrieve the next page.
         * </p>
         * 
         * @param nextToken
         *        If NextToken is returned, there are more results available. The value of NextToken is a unique
         *        pagination token for each page. Make the call again using the returned token to retrieve the next
         *        page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The list of traffic policies.
         * </p>
         * 
         * @param trafficPolicies
         *        The list of traffic policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicies(Collection<TrafficPolicy> trafficPolicies);

        /**
         * <p>
         * The list of traffic policies.
         * </p>
         * 
         * @param trafficPolicies
         *        The list of traffic policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicies(TrafficPolicy... trafficPolicies);

        /**
         * <p>
         * The list of traffic policies.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mailmanager.model.TrafficPolicy.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.mailmanager.model.TrafficPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mailmanager.model.TrafficPolicy.Builder#build()} is called immediately
         * and its result is passed to {@link #trafficPolicies(List<TrafficPolicy>)}.
         * 
         * @param trafficPolicies
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mailmanager.model.TrafficPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trafficPolicies(java.util.Collection<TrafficPolicy>)
         */
        Builder trafficPolicies(Consumer<TrafficPolicy.Builder>... trafficPolicies);
    }

    static final class BuilderImpl extends MailManagerResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<TrafficPolicy> trafficPolicies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrafficPoliciesResponse model) {
            super(model);
            nextToken(model.nextToken);
            trafficPolicies(model.trafficPolicies);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<TrafficPolicy.Builder> getTrafficPolicies() {
            List<TrafficPolicy.Builder> result = TrafficPolicyListCopier.copyToBuilder(this.trafficPolicies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTrafficPolicies(Collection<TrafficPolicy.BuilderImpl> trafficPolicies) {
            this.trafficPolicies = TrafficPolicyListCopier.copyFromBuilder(trafficPolicies);
        }

        @Override
        public final Builder trafficPolicies(Collection<TrafficPolicy> trafficPolicies) {
            this.trafficPolicies = TrafficPolicyListCopier.copy(trafficPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trafficPolicies(TrafficPolicy... trafficPolicies) {
            trafficPolicies(Arrays.asList(trafficPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trafficPolicies(Consumer<TrafficPolicy.Builder>... trafficPolicies) {
            trafficPolicies(Stream.of(trafficPolicies).map(c -> TrafficPolicy.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListTrafficPoliciesResponse build() {
            return new ListTrafficPoliciesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
