/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A boolean expression to be used in a rule condition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleBooleanExpression implements SdkPojo, Serializable,
        ToCopyableBuilder<RuleBooleanExpression.Builder, RuleBooleanExpression> {
    private static final SdkField<RuleBooleanToEvaluate> EVALUATE_FIELD = SdkField
            .<RuleBooleanToEvaluate> builder(MarshallingType.SDK_POJO).memberName("Evaluate")
            .getter(getter(RuleBooleanExpression::evaluate)).setter(setter(Builder::evaluate))
            .constructor(RuleBooleanToEvaluate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Evaluate").build()).build();

    private static final SdkField<String> OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Operator").getter(getter(RuleBooleanExpression::operatorAsString)).setter(setter(Builder::operator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operator").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(EVALUATE_FIELD, OPERATOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RuleBooleanToEvaluate evaluate;

    private final String operator;

    private RuleBooleanExpression(BuilderImpl builder) {
        this.evaluate = builder.evaluate;
        this.operator = builder.operator;
    }

    /**
     * <p>
     * The operand on which to perform a boolean condition operation.
     * </p>
     * 
     * @return The operand on which to perform a boolean condition operation.
     */
    public final RuleBooleanToEvaluate evaluate() {
        return evaluate;
    }

    /**
     * <p>
     * The matching operator for a boolean condition expression.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link RuleBooleanOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #operatorAsString}.
     * </p>
     * 
     * @return The matching operator for a boolean condition expression.
     * @see RuleBooleanOperator
     */
    public final RuleBooleanOperator operator() {
        return RuleBooleanOperator.fromValue(operator);
    }

    /**
     * <p>
     * The matching operator for a boolean condition expression.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link RuleBooleanOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #operatorAsString}.
     * </p>
     * 
     * @return The matching operator for a boolean condition expression.
     * @see RuleBooleanOperator
     */
    public final String operatorAsString() {
        return operator;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(evaluate());
        hashCode = 31 * hashCode + Objects.hashCode(operatorAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleBooleanExpression)) {
            return false;
        }
        RuleBooleanExpression other = (RuleBooleanExpression) obj;
        return Objects.equals(evaluate(), other.evaluate()) && Objects.equals(operatorAsString(), other.operatorAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleBooleanExpression").add("Evaluate", evaluate()).add("Operator", operatorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Evaluate":
            return Optional.ofNullable(clazz.cast(evaluate()));
        case "Operator":
            return Optional.ofNullable(clazz.cast(operatorAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Evaluate", EVALUATE_FIELD);
        map.put("Operator", OPERATOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuleBooleanExpression, T> g) {
        return obj -> g.apply((RuleBooleanExpression) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleBooleanExpression> {
        /**
         * <p>
         * The operand on which to perform a boolean condition operation.
         * </p>
         * 
         * @param evaluate
         *        The operand on which to perform a boolean condition operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluate(RuleBooleanToEvaluate evaluate);

        /**
         * <p>
         * The operand on which to perform a boolean condition operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link RuleBooleanToEvaluate.Builder} avoiding
         * the need to create one manually via {@link RuleBooleanToEvaluate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuleBooleanToEvaluate.Builder#build()} is called immediately and
         * its result is passed to {@link #evaluate(RuleBooleanToEvaluate)}.
         * 
         * @param evaluate
         *        a consumer that will call methods on {@link RuleBooleanToEvaluate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #evaluate(RuleBooleanToEvaluate)
         */
        default Builder evaluate(Consumer<RuleBooleanToEvaluate.Builder> evaluate) {
            return evaluate(RuleBooleanToEvaluate.builder().applyMutation(evaluate).build());
        }

        /**
         * <p>
         * The matching operator for a boolean condition expression.
         * </p>
         * 
         * @param operator
         *        The matching operator for a boolean condition expression.
         * @see RuleBooleanOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleBooleanOperator
         */
        Builder operator(String operator);

        /**
         * <p>
         * The matching operator for a boolean condition expression.
         * </p>
         * 
         * @param operator
         *        The matching operator for a boolean condition expression.
         * @see RuleBooleanOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleBooleanOperator
         */
        Builder operator(RuleBooleanOperator operator);
    }

    static final class BuilderImpl implements Builder {
        private RuleBooleanToEvaluate evaluate;

        private String operator;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleBooleanExpression model) {
            evaluate(model.evaluate);
            operator(model.operator);
        }

        public final RuleBooleanToEvaluate.Builder getEvaluate() {
            return evaluate != null ? evaluate.toBuilder() : null;
        }

        public final void setEvaluate(RuleBooleanToEvaluate.BuilderImpl evaluate) {
            this.evaluate = evaluate != null ? evaluate.build() : null;
        }

        @Override
        public final Builder evaluate(RuleBooleanToEvaluate evaluate) {
            this.evaluate = evaluate;
            return this;
        }

        public final String getOperator() {
            return operator;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public final Builder operator(RuleBooleanOperator operator) {
            this.operator(operator == null ? null : operator.toString());
            return this;
        }

        @Override
        public RuleBooleanExpression build() {
            return new RuleBooleanExpression(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
