/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The conditional expression used to evaluate an email for determining if a rule action should be taken.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleCondition implements SdkPojo, Serializable, ToCopyableBuilder<RuleCondition.Builder, RuleCondition> {
    private static final SdkField<RuleBooleanExpression> BOOLEAN_EXPRESSION_FIELD = SdkField
            .<RuleBooleanExpression> builder(MarshallingType.SDK_POJO).memberName("BooleanExpression")
            .getter(getter(RuleCondition::booleanExpression)).setter(setter(Builder::booleanExpression))
            .constructor(RuleBooleanExpression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BooleanExpression").build()).build();

    private static final SdkField<RuleDmarcExpression> DMARC_EXPRESSION_FIELD = SdkField
            .<RuleDmarcExpression> builder(MarshallingType.SDK_POJO).memberName("DmarcExpression")
            .getter(getter(RuleCondition::dmarcExpression)).setter(setter(Builder::dmarcExpression))
            .constructor(RuleDmarcExpression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DmarcExpression").build()).build();

    private static final SdkField<RuleIpExpression> IP_EXPRESSION_FIELD = SdkField
            .<RuleIpExpression> builder(MarshallingType.SDK_POJO).memberName("IpExpression")
            .getter(getter(RuleCondition::ipExpression)).setter(setter(Builder::ipExpression))
            .constructor(RuleIpExpression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpExpression").build()).build();

    private static final SdkField<RuleNumberExpression> NUMBER_EXPRESSION_FIELD = SdkField
            .<RuleNumberExpression> builder(MarshallingType.SDK_POJO).memberName("NumberExpression")
            .getter(getter(RuleCondition::numberExpression)).setter(setter(Builder::numberExpression))
            .constructor(RuleNumberExpression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberExpression").build()).build();

    private static final SdkField<RuleStringExpression> STRING_EXPRESSION_FIELD = SdkField
            .<RuleStringExpression> builder(MarshallingType.SDK_POJO).memberName("StringExpression")
            .getter(getter(RuleCondition::stringExpression)).setter(setter(Builder::stringExpression))
            .constructor(RuleStringExpression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringExpression").build()).build();

    private static final SdkField<RuleVerdictExpression> VERDICT_EXPRESSION_FIELD = SdkField
            .<RuleVerdictExpression> builder(MarshallingType.SDK_POJO).memberName("VerdictExpression")
            .getter(getter(RuleCondition::verdictExpression)).setter(setter(Builder::verdictExpression))
            .constructor(RuleVerdictExpression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerdictExpression").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOOLEAN_EXPRESSION_FIELD,
            DMARC_EXPRESSION_FIELD, IP_EXPRESSION_FIELD, NUMBER_EXPRESSION_FIELD, STRING_EXPRESSION_FIELD,
            VERDICT_EXPRESSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RuleBooleanExpression booleanExpression;

    private final RuleDmarcExpression dmarcExpression;

    private final RuleIpExpression ipExpression;

    private final RuleNumberExpression numberExpression;

    private final RuleStringExpression stringExpression;

    private final RuleVerdictExpression verdictExpression;

    private final Type type;

    private RuleCondition(BuilderImpl builder) {
        this.booleanExpression = builder.booleanExpression;
        this.dmarcExpression = builder.dmarcExpression;
        this.ipExpression = builder.ipExpression;
        this.numberExpression = builder.numberExpression;
        this.stringExpression = builder.stringExpression;
        this.verdictExpression = builder.verdictExpression;
        this.type = builder.type;
    }

    /**
     * <p>
     * The condition applies to a boolean expression passed in this field.
     * </p>
     * 
     * @return The condition applies to a boolean expression passed in this field.
     */
    public final RuleBooleanExpression booleanExpression() {
        return booleanExpression;
    }

    /**
     * <p>
     * The condition applies to a DMARC policy expression passed in this field.
     * </p>
     * 
     * @return The condition applies to a DMARC policy expression passed in this field.
     */
    public final RuleDmarcExpression dmarcExpression() {
        return dmarcExpression;
    }

    /**
     * <p>
     * The condition applies to an IP address expression passed in this field.
     * </p>
     * 
     * @return The condition applies to an IP address expression passed in this field.
     */
    public final RuleIpExpression ipExpression() {
        return ipExpression;
    }

    /**
     * <p>
     * The condition applies to a number expression passed in this field.
     * </p>
     * 
     * @return The condition applies to a number expression passed in this field.
     */
    public final RuleNumberExpression numberExpression() {
        return numberExpression;
    }

    /**
     * <p>
     * The condition applies to a string expression passed in this field.
     * </p>
     * 
     * @return The condition applies to a string expression passed in this field.
     */
    public final RuleStringExpression stringExpression() {
        return stringExpression;
    }

    /**
     * <p>
     * The condition applies to a verdict expression passed in this field.
     * </p>
     * 
     * @return The condition applies to a verdict expression passed in this field.
     */
    public final RuleVerdictExpression verdictExpression() {
        return verdictExpression;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(booleanExpression());
        hashCode = 31 * hashCode + Objects.hashCode(dmarcExpression());
        hashCode = 31 * hashCode + Objects.hashCode(ipExpression());
        hashCode = 31 * hashCode + Objects.hashCode(numberExpression());
        hashCode = 31 * hashCode + Objects.hashCode(stringExpression());
        hashCode = 31 * hashCode + Objects.hashCode(verdictExpression());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleCondition)) {
            return false;
        }
        RuleCondition other = (RuleCondition) obj;
        return Objects.equals(booleanExpression(), other.booleanExpression())
                && Objects.equals(dmarcExpression(), other.dmarcExpression())
                && Objects.equals(ipExpression(), other.ipExpression())
                && Objects.equals(numberExpression(), other.numberExpression())
                && Objects.equals(stringExpression(), other.stringExpression())
                && Objects.equals(verdictExpression(), other.verdictExpression());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleCondition").add("BooleanExpression", booleanExpression())
                .add("DmarcExpression", dmarcExpression()).add("IpExpression", ipExpression())
                .add("NumberExpression", numberExpression()).add("StringExpression", stringExpression())
                .add("VerdictExpression", verdictExpression()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BooleanExpression":
            return Optional.ofNullable(clazz.cast(booleanExpression()));
        case "DmarcExpression":
            return Optional.ofNullable(clazz.cast(dmarcExpression()));
        case "IpExpression":
            return Optional.ofNullable(clazz.cast(ipExpression()));
        case "NumberExpression":
            return Optional.ofNullable(clazz.cast(numberExpression()));
        case "StringExpression":
            return Optional.ofNullable(clazz.cast(stringExpression()));
        case "VerdictExpression":
            return Optional.ofNullable(clazz.cast(verdictExpression()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #booleanExpression()} initialized to the given value.
     *
     * <p>
     * The condition applies to a boolean expression passed in this field.
     * </p>
     * 
     * @param booleanExpression
     *        The condition applies to a boolean expression passed in this field.
     */
    public static RuleCondition fromBooleanExpression(RuleBooleanExpression booleanExpression) {
        return builder().booleanExpression(booleanExpression).build();
    }

    /**
     * Create an instance of this class with {@link #booleanExpression()} initialized to the given value.
     *
     * <p>
     * The condition applies to a boolean expression passed in this field.
     * </p>
     * 
     * @param booleanExpression
     *        The condition applies to a boolean expression passed in this field.
     */
    public static RuleCondition fromBooleanExpression(Consumer<RuleBooleanExpression.Builder> booleanExpression) {
        RuleBooleanExpression.Builder builder = RuleBooleanExpression.builder();
        booleanExpression.accept(builder);
        return fromBooleanExpression(builder.build());
    }

    /**
     * Create an instance of this class with {@link #dmarcExpression()} initialized to the given value.
     *
     * <p>
     * The condition applies to a DMARC policy expression passed in this field.
     * </p>
     * 
     * @param dmarcExpression
     *        The condition applies to a DMARC policy expression passed in this field.
     */
    public static RuleCondition fromDmarcExpression(RuleDmarcExpression dmarcExpression) {
        return builder().dmarcExpression(dmarcExpression).build();
    }

    /**
     * Create an instance of this class with {@link #dmarcExpression()} initialized to the given value.
     *
     * <p>
     * The condition applies to a DMARC policy expression passed in this field.
     * </p>
     * 
     * @param dmarcExpression
     *        The condition applies to a DMARC policy expression passed in this field.
     */
    public static RuleCondition fromDmarcExpression(Consumer<RuleDmarcExpression.Builder> dmarcExpression) {
        RuleDmarcExpression.Builder builder = RuleDmarcExpression.builder();
        dmarcExpression.accept(builder);
        return fromDmarcExpression(builder.build());
    }

    /**
     * Create an instance of this class with {@link #ipExpression()} initialized to the given value.
     *
     * <p>
     * The condition applies to an IP address expression passed in this field.
     * </p>
     * 
     * @param ipExpression
     *        The condition applies to an IP address expression passed in this field.
     */
    public static RuleCondition fromIpExpression(RuleIpExpression ipExpression) {
        return builder().ipExpression(ipExpression).build();
    }

    /**
     * Create an instance of this class with {@link #ipExpression()} initialized to the given value.
     *
     * <p>
     * The condition applies to an IP address expression passed in this field.
     * </p>
     * 
     * @param ipExpression
     *        The condition applies to an IP address expression passed in this field.
     */
    public static RuleCondition fromIpExpression(Consumer<RuleIpExpression.Builder> ipExpression) {
        RuleIpExpression.Builder builder = RuleIpExpression.builder();
        ipExpression.accept(builder);
        return fromIpExpression(builder.build());
    }

    /**
     * Create an instance of this class with {@link #numberExpression()} initialized to the given value.
     *
     * <p>
     * The condition applies to a number expression passed in this field.
     * </p>
     * 
     * @param numberExpression
     *        The condition applies to a number expression passed in this field.
     */
    public static RuleCondition fromNumberExpression(RuleNumberExpression numberExpression) {
        return builder().numberExpression(numberExpression).build();
    }

    /**
     * Create an instance of this class with {@link #numberExpression()} initialized to the given value.
     *
     * <p>
     * The condition applies to a number expression passed in this field.
     * </p>
     * 
     * @param numberExpression
     *        The condition applies to a number expression passed in this field.
     */
    public static RuleCondition fromNumberExpression(Consumer<RuleNumberExpression.Builder> numberExpression) {
        RuleNumberExpression.Builder builder = RuleNumberExpression.builder();
        numberExpression.accept(builder);
        return fromNumberExpression(builder.build());
    }

    /**
     * Create an instance of this class with {@link #stringExpression()} initialized to the given value.
     *
     * <p>
     * The condition applies to a string expression passed in this field.
     * </p>
     * 
     * @param stringExpression
     *        The condition applies to a string expression passed in this field.
     */
    public static RuleCondition fromStringExpression(RuleStringExpression stringExpression) {
        return builder().stringExpression(stringExpression).build();
    }

    /**
     * Create an instance of this class with {@link #stringExpression()} initialized to the given value.
     *
     * <p>
     * The condition applies to a string expression passed in this field.
     * </p>
     * 
     * @param stringExpression
     *        The condition applies to a string expression passed in this field.
     */
    public static RuleCondition fromStringExpression(Consumer<RuleStringExpression.Builder> stringExpression) {
        RuleStringExpression.Builder builder = RuleStringExpression.builder();
        stringExpression.accept(builder);
        return fromStringExpression(builder.build());
    }

    /**
     * Create an instance of this class with {@link #verdictExpression()} initialized to the given value.
     *
     * <p>
     * The condition applies to a verdict expression passed in this field.
     * </p>
     * 
     * @param verdictExpression
     *        The condition applies to a verdict expression passed in this field.
     */
    public static RuleCondition fromVerdictExpression(RuleVerdictExpression verdictExpression) {
        return builder().verdictExpression(verdictExpression).build();
    }

    /**
     * Create an instance of this class with {@link #verdictExpression()} initialized to the given value.
     *
     * <p>
     * The condition applies to a verdict expression passed in this field.
     * </p>
     * 
     * @param verdictExpression
     *        The condition applies to a verdict expression passed in this field.
     */
    public static RuleCondition fromVerdictExpression(Consumer<RuleVerdictExpression.Builder> verdictExpression) {
        RuleVerdictExpression.Builder builder = RuleVerdictExpression.builder();
        verdictExpression.accept(builder);
        return fromVerdictExpression(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BooleanExpression", BOOLEAN_EXPRESSION_FIELD);
        map.put("DmarcExpression", DMARC_EXPRESSION_FIELD);
        map.put("IpExpression", IP_EXPRESSION_FIELD);
        map.put("NumberExpression", NUMBER_EXPRESSION_FIELD);
        map.put("StringExpression", STRING_EXPRESSION_FIELD);
        map.put("VerdictExpression", VERDICT_EXPRESSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuleCondition, T> g) {
        return obj -> g.apply((RuleCondition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleCondition> {
        /**
         * <p>
         * The condition applies to a boolean expression passed in this field.
         * </p>
         * 
         * @param booleanExpression
         *        The condition applies to a boolean expression passed in this field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder booleanExpression(RuleBooleanExpression booleanExpression);

        /**
         * <p>
         * The condition applies to a boolean expression passed in this field.
         * </p>
         * This is a convenience method that creates an instance of the {@link RuleBooleanExpression.Builder} avoiding
         * the need to create one manually via {@link RuleBooleanExpression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuleBooleanExpression.Builder#build()} is called immediately and
         * its result is passed to {@link #booleanExpression(RuleBooleanExpression)}.
         * 
         * @param booleanExpression
         *        a consumer that will call methods on {@link RuleBooleanExpression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #booleanExpression(RuleBooleanExpression)
         */
        default Builder booleanExpression(Consumer<RuleBooleanExpression.Builder> booleanExpression) {
            return booleanExpression(RuleBooleanExpression.builder().applyMutation(booleanExpression).build());
        }

        /**
         * <p>
         * The condition applies to a DMARC policy expression passed in this field.
         * </p>
         * 
         * @param dmarcExpression
         *        The condition applies to a DMARC policy expression passed in this field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dmarcExpression(RuleDmarcExpression dmarcExpression);

        /**
         * <p>
         * The condition applies to a DMARC policy expression passed in this field.
         * </p>
         * This is a convenience method that creates an instance of the {@link RuleDmarcExpression.Builder} avoiding the
         * need to create one manually via {@link RuleDmarcExpression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuleDmarcExpression.Builder#build()} is called immediately and
         * its result is passed to {@link #dmarcExpression(RuleDmarcExpression)}.
         * 
         * @param dmarcExpression
         *        a consumer that will call methods on {@link RuleDmarcExpression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dmarcExpression(RuleDmarcExpression)
         */
        default Builder dmarcExpression(Consumer<RuleDmarcExpression.Builder> dmarcExpression) {
            return dmarcExpression(RuleDmarcExpression.builder().applyMutation(dmarcExpression).build());
        }

        /**
         * <p>
         * The condition applies to an IP address expression passed in this field.
         * </p>
         * 
         * @param ipExpression
         *        The condition applies to an IP address expression passed in this field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipExpression(RuleIpExpression ipExpression);

        /**
         * <p>
         * The condition applies to an IP address expression passed in this field.
         * </p>
         * This is a convenience method that creates an instance of the {@link RuleIpExpression.Builder} avoiding the
         * need to create one manually via {@link RuleIpExpression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuleIpExpression.Builder#build()} is called immediately and its
         * result is passed to {@link #ipExpression(RuleIpExpression)}.
         * 
         * @param ipExpression
         *        a consumer that will call methods on {@link RuleIpExpression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipExpression(RuleIpExpression)
         */
        default Builder ipExpression(Consumer<RuleIpExpression.Builder> ipExpression) {
            return ipExpression(RuleIpExpression.builder().applyMutation(ipExpression).build());
        }

        /**
         * <p>
         * The condition applies to a number expression passed in this field.
         * </p>
         * 
         * @param numberExpression
         *        The condition applies to a number expression passed in this field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberExpression(RuleNumberExpression numberExpression);

        /**
         * <p>
         * The condition applies to a number expression passed in this field.
         * </p>
         * This is a convenience method that creates an instance of the {@link RuleNumberExpression.Builder} avoiding
         * the need to create one manually via {@link RuleNumberExpression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuleNumberExpression.Builder#build()} is called immediately and
         * its result is passed to {@link #numberExpression(RuleNumberExpression)}.
         * 
         * @param numberExpression
         *        a consumer that will call methods on {@link RuleNumberExpression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #numberExpression(RuleNumberExpression)
         */
        default Builder numberExpression(Consumer<RuleNumberExpression.Builder> numberExpression) {
            return numberExpression(RuleNumberExpression.builder().applyMutation(numberExpression).build());
        }

        /**
         * <p>
         * The condition applies to a string expression passed in this field.
         * </p>
         * 
         * @param stringExpression
         *        The condition applies to a string expression passed in this field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringExpression(RuleStringExpression stringExpression);

        /**
         * <p>
         * The condition applies to a string expression passed in this field.
         * </p>
         * This is a convenience method that creates an instance of the {@link RuleStringExpression.Builder} avoiding
         * the need to create one manually via {@link RuleStringExpression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuleStringExpression.Builder#build()} is called immediately and
         * its result is passed to {@link #stringExpression(RuleStringExpression)}.
         * 
         * @param stringExpression
         *        a consumer that will call methods on {@link RuleStringExpression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stringExpression(RuleStringExpression)
         */
        default Builder stringExpression(Consumer<RuleStringExpression.Builder> stringExpression) {
            return stringExpression(RuleStringExpression.builder().applyMutation(stringExpression).build());
        }

        /**
         * <p>
         * The condition applies to a verdict expression passed in this field.
         * </p>
         * 
         * @param verdictExpression
         *        The condition applies to a verdict expression passed in this field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verdictExpression(RuleVerdictExpression verdictExpression);

        /**
         * <p>
         * The condition applies to a verdict expression passed in this field.
         * </p>
         * This is a convenience method that creates an instance of the {@link RuleVerdictExpression.Builder} avoiding
         * the need to create one manually via {@link RuleVerdictExpression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuleVerdictExpression.Builder#build()} is called immediately and
         * its result is passed to {@link #verdictExpression(RuleVerdictExpression)}.
         * 
         * @param verdictExpression
         *        a consumer that will call methods on {@link RuleVerdictExpression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #verdictExpression(RuleVerdictExpression)
         */
        default Builder verdictExpression(Consumer<RuleVerdictExpression.Builder> verdictExpression) {
            return verdictExpression(RuleVerdictExpression.builder().applyMutation(verdictExpression).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RuleBooleanExpression booleanExpression;

        private RuleDmarcExpression dmarcExpression;

        private RuleIpExpression ipExpression;

        private RuleNumberExpression numberExpression;

        private RuleStringExpression stringExpression;

        private RuleVerdictExpression verdictExpression;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RuleCondition model) {
            booleanExpression(model.booleanExpression);
            dmarcExpression(model.dmarcExpression);
            ipExpression(model.ipExpression);
            numberExpression(model.numberExpression);
            stringExpression(model.stringExpression);
            verdictExpression(model.verdictExpression);
        }

        public final RuleBooleanExpression.Builder getBooleanExpression() {
            return booleanExpression != null ? booleanExpression.toBuilder() : null;
        }

        public final void setBooleanExpression(RuleBooleanExpression.BuilderImpl booleanExpression) {
            Object oldValue = this.booleanExpression;
            this.booleanExpression = booleanExpression != null ? booleanExpression.build() : null;
            handleUnionValueChange(Type.BOOLEAN_EXPRESSION, oldValue, this.booleanExpression);
        }

        @Override
        public final Builder booleanExpression(RuleBooleanExpression booleanExpression) {
            Object oldValue = this.booleanExpression;
            this.booleanExpression = booleanExpression;
            handleUnionValueChange(Type.BOOLEAN_EXPRESSION, oldValue, this.booleanExpression);
            return this;
        }

        public final RuleDmarcExpression.Builder getDmarcExpression() {
            return dmarcExpression != null ? dmarcExpression.toBuilder() : null;
        }

        public final void setDmarcExpression(RuleDmarcExpression.BuilderImpl dmarcExpression) {
            Object oldValue = this.dmarcExpression;
            this.dmarcExpression = dmarcExpression != null ? dmarcExpression.build() : null;
            handleUnionValueChange(Type.DMARC_EXPRESSION, oldValue, this.dmarcExpression);
        }

        @Override
        public final Builder dmarcExpression(RuleDmarcExpression dmarcExpression) {
            Object oldValue = this.dmarcExpression;
            this.dmarcExpression = dmarcExpression;
            handleUnionValueChange(Type.DMARC_EXPRESSION, oldValue, this.dmarcExpression);
            return this;
        }

        public final RuleIpExpression.Builder getIpExpression() {
            return ipExpression != null ? ipExpression.toBuilder() : null;
        }

        public final void setIpExpression(RuleIpExpression.BuilderImpl ipExpression) {
            Object oldValue = this.ipExpression;
            this.ipExpression = ipExpression != null ? ipExpression.build() : null;
            handleUnionValueChange(Type.IP_EXPRESSION, oldValue, this.ipExpression);
        }

        @Override
        public final Builder ipExpression(RuleIpExpression ipExpression) {
            Object oldValue = this.ipExpression;
            this.ipExpression = ipExpression;
            handleUnionValueChange(Type.IP_EXPRESSION, oldValue, this.ipExpression);
            return this;
        }

        public final RuleNumberExpression.Builder getNumberExpression() {
            return numberExpression != null ? numberExpression.toBuilder() : null;
        }

        public final void setNumberExpression(RuleNumberExpression.BuilderImpl numberExpression) {
            Object oldValue = this.numberExpression;
            this.numberExpression = numberExpression != null ? numberExpression.build() : null;
            handleUnionValueChange(Type.NUMBER_EXPRESSION, oldValue, this.numberExpression);
        }

        @Override
        public final Builder numberExpression(RuleNumberExpression numberExpression) {
            Object oldValue = this.numberExpression;
            this.numberExpression = numberExpression;
            handleUnionValueChange(Type.NUMBER_EXPRESSION, oldValue, this.numberExpression);
            return this;
        }

        public final RuleStringExpression.Builder getStringExpression() {
            return stringExpression != null ? stringExpression.toBuilder() : null;
        }

        public final void setStringExpression(RuleStringExpression.BuilderImpl stringExpression) {
            Object oldValue = this.stringExpression;
            this.stringExpression = stringExpression != null ? stringExpression.build() : null;
            handleUnionValueChange(Type.STRING_EXPRESSION, oldValue, this.stringExpression);
        }

        @Override
        public final Builder stringExpression(RuleStringExpression stringExpression) {
            Object oldValue = this.stringExpression;
            this.stringExpression = stringExpression;
            handleUnionValueChange(Type.STRING_EXPRESSION, oldValue, this.stringExpression);
            return this;
        }

        public final RuleVerdictExpression.Builder getVerdictExpression() {
            return verdictExpression != null ? verdictExpression.toBuilder() : null;
        }

        public final void setVerdictExpression(RuleVerdictExpression.BuilderImpl verdictExpression) {
            Object oldValue = this.verdictExpression;
            this.verdictExpression = verdictExpression != null ? verdictExpression.build() : null;
            handleUnionValueChange(Type.VERDICT_EXPRESSION, oldValue, this.verdictExpression);
        }

        @Override
        public final Builder verdictExpression(RuleVerdictExpression verdictExpression) {
            Object oldValue = this.verdictExpression;
            this.verdictExpression = verdictExpression;
            handleUnionValueChange(Type.VERDICT_EXPRESSION, oldValue, this.verdictExpression);
            return this;
        }

        @Override
        public RuleCondition build() {
            return new RuleCondition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see RuleCondition#type()
     */
    public enum Type {
        BOOLEAN_EXPRESSION,

        DMARC_EXPRESSION,

        IP_EXPRESSION,

        NUMBER_EXPRESSION,

        STRING_EXPRESSION,

        VERDICT_EXPRESSION,

        UNKNOWN_TO_SDK_VERSION
    }
}
