/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A number expression to match numeric conditions with integers from the incoming email.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleNumberExpression implements SdkPojo, Serializable,
        ToCopyableBuilder<RuleNumberExpression.Builder, RuleNumberExpression> {
    private static final SdkField<RuleNumberToEvaluate> EVALUATE_FIELD = SdkField
            .<RuleNumberToEvaluate> builder(MarshallingType.SDK_POJO).memberName("Evaluate")
            .getter(getter(RuleNumberExpression::evaluate)).setter(setter(Builder::evaluate))
            .constructor(RuleNumberToEvaluate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Evaluate").build()).build();

    private static final SdkField<String> OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Operator").getter(getter(RuleNumberExpression::operatorAsString)).setter(setter(Builder::operator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operator").build()).build();

    private static final SdkField<Double> VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Value")
            .getter(getter(RuleNumberExpression::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVALUATE_FIELD,
            OPERATOR_FIELD, VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RuleNumberToEvaluate evaluate;

    private final String operator;

    private final Double value;

    private RuleNumberExpression(BuilderImpl builder) {
        this.evaluate = builder.evaluate;
        this.operator = builder.operator;
        this.value = builder.value;
    }

    /**
     * <p>
     * The number to evaluate in a numeric condition expression.
     * </p>
     * 
     * @return The number to evaluate in a numeric condition expression.
     */
    public final RuleNumberToEvaluate evaluate() {
        return evaluate;
    }

    /**
     * <p>
     * The operator for a numeric condition expression.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link RuleNumberOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #operatorAsString}.
     * </p>
     * 
     * @return The operator for a numeric condition expression.
     * @see RuleNumberOperator
     */
    public final RuleNumberOperator operator() {
        return RuleNumberOperator.fromValue(operator);
    }

    /**
     * <p>
     * The operator for a numeric condition expression.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link RuleNumberOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #operatorAsString}.
     * </p>
     * 
     * @return The operator for a numeric condition expression.
     * @see RuleNumberOperator
     */
    public final String operatorAsString() {
        return operator;
    }

    /**
     * <p>
     * The value to evaluate in a numeric condition expression.
     * </p>
     * 
     * @return The value to evaluate in a numeric condition expression.
     */
    public final Double value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(evaluate());
        hashCode = 31 * hashCode + Objects.hashCode(operatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleNumberExpression)) {
            return false;
        }
        RuleNumberExpression other = (RuleNumberExpression) obj;
        return Objects.equals(evaluate(), other.evaluate()) && Objects.equals(operatorAsString(), other.operatorAsString())
                && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleNumberExpression").add("Evaluate", evaluate()).add("Operator", operatorAsString())
                .add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Evaluate":
            return Optional.ofNullable(clazz.cast(evaluate()));
        case "Operator":
            return Optional.ofNullable(clazz.cast(operatorAsString()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Evaluate", EVALUATE_FIELD);
        map.put("Operator", OPERATOR_FIELD);
        map.put("Value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuleNumberExpression, T> g) {
        return obj -> g.apply((RuleNumberExpression) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleNumberExpression> {
        /**
         * <p>
         * The number to evaluate in a numeric condition expression.
         * </p>
         * 
         * @param evaluate
         *        The number to evaluate in a numeric condition expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluate(RuleNumberToEvaluate evaluate);

        /**
         * <p>
         * The number to evaluate in a numeric condition expression.
         * </p>
         * This is a convenience method that creates an instance of the {@link RuleNumberToEvaluate.Builder} avoiding
         * the need to create one manually via {@link RuleNumberToEvaluate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuleNumberToEvaluate.Builder#build()} is called immediately and
         * its result is passed to {@link #evaluate(RuleNumberToEvaluate)}.
         * 
         * @param evaluate
         *        a consumer that will call methods on {@link RuleNumberToEvaluate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #evaluate(RuleNumberToEvaluate)
         */
        default Builder evaluate(Consumer<RuleNumberToEvaluate.Builder> evaluate) {
            return evaluate(RuleNumberToEvaluate.builder().applyMutation(evaluate).build());
        }

        /**
         * <p>
         * The operator for a numeric condition expression.
         * </p>
         * 
         * @param operator
         *        The operator for a numeric condition expression.
         * @see RuleNumberOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleNumberOperator
         */
        Builder operator(String operator);

        /**
         * <p>
         * The operator for a numeric condition expression.
         * </p>
         * 
         * @param operator
         *        The operator for a numeric condition expression.
         * @see RuleNumberOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleNumberOperator
         */
        Builder operator(RuleNumberOperator operator);

        /**
         * <p>
         * The value to evaluate in a numeric condition expression.
         * </p>
         * 
         * @param value
         *        The value to evaluate in a numeric condition expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Double value);
    }

    static final class BuilderImpl implements Builder {
        private RuleNumberToEvaluate evaluate;

        private String operator;

        private Double value;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleNumberExpression model) {
            evaluate(model.evaluate);
            operator(model.operator);
            value(model.value);
        }

        public final RuleNumberToEvaluate.Builder getEvaluate() {
            return evaluate != null ? evaluate.toBuilder() : null;
        }

        public final void setEvaluate(RuleNumberToEvaluate.BuilderImpl evaluate) {
            this.evaluate = evaluate != null ? evaluate.build() : null;
        }

        @Override
        public final Builder evaluate(RuleNumberToEvaluate evaluate) {
            this.evaluate = evaluate;
            return this;
        }

        public final String getOperator() {
            return operator;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public final Builder operator(RuleNumberOperator operator) {
            this.operator(operator == null ? null : operator.toString());
            return this;
        }

        public final Double getValue() {
            return value;
        }

        public final void setValue(Double value) {
            this.value = value;
        }

        @Override
        public final Builder value(Double value) {
            this.value = value;
            return this;
        }

        @Override
        public RuleNumberExpression build() {
            return new RuleNumberExpression(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
