/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Writes the MIME content of the email to an S3 bucket.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3Action implements SdkPojo, Serializable, ToCopyableBuilder<S3Action.Builder, S3Action> {
    private static final SdkField<String> ACTION_FAILURE_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActionFailurePolicy").getter(getter(S3Action::actionFailurePolicyAsString))
            .setter(setter(Builder::actionFailurePolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionFailurePolicy").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(S3Action::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> S3_BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3Bucket").getter(getter(S3Action::s3Bucket)).setter(setter(Builder::s3Bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Bucket").build()).build();

    private static final SdkField<String> S3_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3Prefix").getter(getter(S3Action::s3Prefix)).setter(setter(Builder::s3Prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Prefix").build()).build();

    private static final SdkField<String> S3_SSE_KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3SseKmsKeyId").getter(getter(S3Action::s3SseKmsKeyId)).setter(setter(Builder::s3SseKmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3SseKmsKeyId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FAILURE_POLICY_FIELD,
            ROLE_ARN_FIELD, S3_BUCKET_FIELD, S3_PREFIX_FIELD, S3_SSE_KMS_KEY_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String actionFailurePolicy;

    private final String roleArn;

    private final String s3Bucket;

    private final String s3Prefix;

    private final String s3SseKmsKeyId;

    private S3Action(BuilderImpl builder) {
        this.actionFailurePolicy = builder.actionFailurePolicy;
        this.roleArn = builder.roleArn;
        this.s3Bucket = builder.s3Bucket;
        this.s3Prefix = builder.s3Prefix;
        this.s3SseKmsKeyId = builder.s3SseKmsKeyId;
    }

    /**
     * <p>
     * A policy that states what to do in the case of failure. The action will fail if there are configuration errors.
     * For example, the specified the bucket has been deleted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #actionFailurePolicy} will return {@link ActionFailurePolicy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #actionFailurePolicyAsString}.
     * </p>
     * 
     * @return A policy that states what to do in the case of failure. The action will fail if there are configuration
     *         errors. For example, the specified the bucket has been deleted.
     * @see ActionFailurePolicy
     */
    public final ActionFailurePolicy actionFailurePolicy() {
        return ActionFailurePolicy.fromValue(actionFailurePolicy);
    }

    /**
     * <p>
     * A policy that states what to do in the case of failure. The action will fail if there are configuration errors.
     * For example, the specified the bucket has been deleted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #actionFailurePolicy} will return {@link ActionFailurePolicy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #actionFailurePolicyAsString}.
     * </p>
     * 
     * @return A policy that states what to do in the case of failure. The action will fail if there are configuration
     *         errors. For example, the specified the bucket has been deleted.
     * @see ActionFailurePolicy
     */
    public final String actionFailurePolicyAsString() {
        return actionFailurePolicy;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM Role to use while writing to S3. This role must have access to the
     * s3:PutObject, kms:Encrypt, and kms:GenerateDataKey APIs for the given bucket.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM Role to use while writing to S3. This role must have access to
     *         the s3:PutObject, kms:Encrypt, and kms:GenerateDataKey APIs for the given bucket.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The bucket name of the S3 bucket to write to.
     * </p>
     * 
     * @return The bucket name of the S3 bucket to write to.
     */
    public final String s3Bucket() {
        return s3Bucket;
    }

    /**
     * <p>
     * The S3 prefix to use for the write to the s3 bucket.
     * </p>
     * 
     * @return The S3 prefix to use for the write to the s3 bucket.
     */
    public final String s3Prefix() {
        return s3Prefix;
    }

    /**
     * <p>
     * The KMS Key ID to use to encrypt the message in S3.
     * </p>
     * 
     * @return The KMS Key ID to use to encrypt the message in S3.
     */
    public final String s3SseKmsKeyId() {
        return s3SseKmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionFailurePolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(s3Prefix());
        hashCode = 31 * hashCode + Objects.hashCode(s3SseKmsKeyId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Action)) {
            return false;
        }
        S3Action other = (S3Action) obj;
        return Objects.equals(actionFailurePolicyAsString(), other.actionFailurePolicyAsString())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(s3Bucket(), other.s3Bucket())
                && Objects.equals(s3Prefix(), other.s3Prefix()) && Objects.equals(s3SseKmsKeyId(), other.s3SseKmsKeyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3Action").add("ActionFailurePolicy", actionFailurePolicyAsString()).add("RoleArn", roleArn())
                .add("S3Bucket", s3Bucket()).add("S3Prefix", s3Prefix()).add("S3SseKmsKeyId", s3SseKmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActionFailurePolicy":
            return Optional.ofNullable(clazz.cast(actionFailurePolicyAsString()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "S3Bucket":
            return Optional.ofNullable(clazz.cast(s3Bucket()));
        case "S3Prefix":
            return Optional.ofNullable(clazz.cast(s3Prefix()));
        case "S3SseKmsKeyId":
            return Optional.ofNullable(clazz.cast(s3SseKmsKeyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ActionFailurePolicy", ACTION_FAILURE_POLICY_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("S3Bucket", S3_BUCKET_FIELD);
        map.put("S3Prefix", S3_PREFIX_FIELD);
        map.put("S3SseKmsKeyId", S3_SSE_KMS_KEY_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3Action, T> g) {
        return obj -> g.apply((S3Action) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3Action> {
        /**
         * <p>
         * A policy that states what to do in the case of failure. The action will fail if there are configuration
         * errors. For example, the specified the bucket has been deleted.
         * </p>
         * 
         * @param actionFailurePolicy
         *        A policy that states what to do in the case of failure. The action will fail if there are
         *        configuration errors. For example, the specified the bucket has been deleted.
         * @see ActionFailurePolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionFailurePolicy
         */
        Builder actionFailurePolicy(String actionFailurePolicy);

        /**
         * <p>
         * A policy that states what to do in the case of failure. The action will fail if there are configuration
         * errors. For example, the specified the bucket has been deleted.
         * </p>
         * 
         * @param actionFailurePolicy
         *        A policy that states what to do in the case of failure. The action will fail if there are
         *        configuration errors. For example, the specified the bucket has been deleted.
         * @see ActionFailurePolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionFailurePolicy
         */
        Builder actionFailurePolicy(ActionFailurePolicy actionFailurePolicy);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM Role to use while writing to S3. This role must have access to the
         * s3:PutObject, kms:Encrypt, and kms:GenerateDataKey APIs for the given bucket.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM Role to use while writing to S3. This role must have access
         *        to the s3:PutObject, kms:Encrypt, and kms:GenerateDataKey APIs for the given bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The bucket name of the S3 bucket to write to.
         * </p>
         * 
         * @param s3Bucket
         *        The bucket name of the S3 bucket to write to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Bucket(String s3Bucket);

        /**
         * <p>
         * The S3 prefix to use for the write to the s3 bucket.
         * </p>
         * 
         * @param s3Prefix
         *        The S3 prefix to use for the write to the s3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Prefix(String s3Prefix);

        /**
         * <p>
         * The KMS Key ID to use to encrypt the message in S3.
         * </p>
         * 
         * @param s3SseKmsKeyId
         *        The KMS Key ID to use to encrypt the message in S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3SseKmsKeyId(String s3SseKmsKeyId);
    }

    static final class BuilderImpl implements Builder {
        private String actionFailurePolicy;

        private String roleArn;

        private String s3Bucket;

        private String s3Prefix;

        private String s3SseKmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Action model) {
            actionFailurePolicy(model.actionFailurePolicy);
            roleArn(model.roleArn);
            s3Bucket(model.s3Bucket);
            s3Prefix(model.s3Prefix);
            s3SseKmsKeyId(model.s3SseKmsKeyId);
        }

        public final String getActionFailurePolicy() {
            return actionFailurePolicy;
        }

        public final void setActionFailurePolicy(String actionFailurePolicy) {
            this.actionFailurePolicy = actionFailurePolicy;
        }

        @Override
        public final Builder actionFailurePolicy(String actionFailurePolicy) {
            this.actionFailurePolicy = actionFailurePolicy;
            return this;
        }

        @Override
        public final Builder actionFailurePolicy(ActionFailurePolicy actionFailurePolicy) {
            this.actionFailurePolicy(actionFailurePolicy == null ? null : actionFailurePolicy.toString());
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getS3Bucket() {
            return s3Bucket;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final String getS3Prefix() {
            return s3Prefix;
        }

        public final void setS3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
        }

        @Override
        public final Builder s3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
            return this;
        }

        public final String getS3SseKmsKeyId() {
            return s3SseKmsKeyId;
        }

        public final void setS3SseKmsKeyId(String s3SseKmsKeyId) {
            this.s3SseKmsKeyId = s3SseKmsKeyId;
        }

        @Override
        public final Builder s3SseKmsKeyId(String s3SseKmsKeyId) {
            this.s3SseKmsKeyId = s3SseKmsKeyId;
            return this;
        }

        @Override
        public S3Action build() {
            return new S3Action(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
