/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateIngressPointRequest extends MailManagerRequest implements
        ToCopyableBuilder<UpdateIngressPointRequest.Builder, UpdateIngressPointRequest> {
    private static final SdkField<IngressPointConfiguration> INGRESS_POINT_CONFIGURATION_FIELD = SdkField
            .<IngressPointConfiguration> builder(MarshallingType.SDK_POJO).memberName("IngressPointConfiguration")
            .getter(getter(UpdateIngressPointRequest::ingressPointConfiguration))
            .setter(setter(Builder::ingressPointConfiguration)).constructor(IngressPointConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngressPointConfiguration").build())
            .build();

    private static final SdkField<String> INGRESS_POINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IngressPointId").getter(getter(UpdateIngressPointRequest::ingressPointId))
            .setter(setter(Builder::ingressPointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngressPointId").build()).build();

    private static final SdkField<String> INGRESS_POINT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IngressPointName").getter(getter(UpdateIngressPointRequest::ingressPointName))
            .setter(setter(Builder::ingressPointName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngressPointName").build()).build();

    private static final SdkField<String> RULE_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleSetId").getter(getter(UpdateIngressPointRequest::ruleSetId)).setter(setter(Builder::ruleSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleSetId").build()).build();

    private static final SdkField<String> STATUS_TO_UPDATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusToUpdate").getter(getter(UpdateIngressPointRequest::statusToUpdateAsString))
            .setter(setter(Builder::statusToUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusToUpdate").build()).build();

    private static final SdkField<String> TRAFFIC_POLICY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrafficPolicyId").getter(getter(UpdateIngressPointRequest::trafficPolicyId))
            .setter(setter(Builder::trafficPolicyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficPolicyId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            INGRESS_POINT_CONFIGURATION_FIELD, INGRESS_POINT_ID_FIELD, INGRESS_POINT_NAME_FIELD, RULE_SET_ID_FIELD,
            STATUS_TO_UPDATE_FIELD, TRAFFIC_POLICY_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final IngressPointConfiguration ingressPointConfiguration;

    private final String ingressPointId;

    private final String ingressPointName;

    private final String ruleSetId;

    private final String statusToUpdate;

    private final String trafficPolicyId;

    private UpdateIngressPointRequest(BuilderImpl builder) {
        super(builder);
        this.ingressPointConfiguration = builder.ingressPointConfiguration;
        this.ingressPointId = builder.ingressPointId;
        this.ingressPointName = builder.ingressPointName;
        this.ruleSetId = builder.ruleSetId;
        this.statusToUpdate = builder.statusToUpdate;
        this.trafficPolicyId = builder.trafficPolicyId;
    }

    /**
     * <p>
     * If you choose an Authenticated ingress endpoint, you must configure either an SMTP password or a secret ARN.
     * </p>
     * 
     * @return If you choose an Authenticated ingress endpoint, you must configure either an SMTP password or a secret
     *         ARN.
     */
    public final IngressPointConfiguration ingressPointConfiguration() {
        return ingressPointConfiguration;
    }

    /**
     * <p>
     * The identifier for the ingress endpoint you want to update.
     * </p>
     * 
     * @return The identifier for the ingress endpoint you want to update.
     */
    public final String ingressPointId() {
        return ingressPointId;
    }

    /**
     * <p>
     * A user friendly name for the ingress endpoint resource.
     * </p>
     * 
     * @return A user friendly name for the ingress endpoint resource.
     */
    public final String ingressPointName() {
        return ingressPointName;
    }

    /**
     * <p>
     * The identifier of an existing rule set that you attach to an ingress endpoint resource.
     * </p>
     * 
     * @return The identifier of an existing rule set that you attach to an ingress endpoint resource.
     */
    public final String ruleSetId() {
        return ruleSetId;
    }

    /**
     * <p>
     * The update status of an ingress endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusToUpdate}
     * will return {@link IngressPointStatusToUpdate#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusToUpdateAsString}.
     * </p>
     * 
     * @return The update status of an ingress endpoint.
     * @see IngressPointStatusToUpdate
     */
    public final IngressPointStatusToUpdate statusToUpdate() {
        return IngressPointStatusToUpdate.fromValue(statusToUpdate);
    }

    /**
     * <p>
     * The update status of an ingress endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusToUpdate}
     * will return {@link IngressPointStatusToUpdate#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusToUpdateAsString}.
     * </p>
     * 
     * @return The update status of an ingress endpoint.
     * @see IngressPointStatusToUpdate
     */
    public final String statusToUpdateAsString() {
        return statusToUpdate;
    }

    /**
     * <p>
     * The identifier of an existing traffic policy that you attach to an ingress endpoint resource.
     * </p>
     * 
     * @return The identifier of an existing traffic policy that you attach to an ingress endpoint resource.
     */
    public final String trafficPolicyId() {
        return trafficPolicyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ingressPointConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(ingressPointId());
        hashCode = 31 * hashCode + Objects.hashCode(ingressPointName());
        hashCode = 31 * hashCode + Objects.hashCode(ruleSetId());
        hashCode = 31 * hashCode + Objects.hashCode(statusToUpdateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(trafficPolicyId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIngressPointRequest)) {
            return false;
        }
        UpdateIngressPointRequest other = (UpdateIngressPointRequest) obj;
        return Objects.equals(ingressPointConfiguration(), other.ingressPointConfiguration())
                && Objects.equals(ingressPointId(), other.ingressPointId())
                && Objects.equals(ingressPointName(), other.ingressPointName()) && Objects.equals(ruleSetId(), other.ruleSetId())
                && Objects.equals(statusToUpdateAsString(), other.statusToUpdateAsString())
                && Objects.equals(trafficPolicyId(), other.trafficPolicyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateIngressPointRequest").add("IngressPointConfiguration", ingressPointConfiguration())
                .add("IngressPointId", ingressPointId()).add("IngressPointName", ingressPointName())
                .add("RuleSetId", ruleSetId()).add("StatusToUpdate", statusToUpdateAsString())
                .add("TrafficPolicyId", trafficPolicyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IngressPointConfiguration":
            return Optional.ofNullable(clazz.cast(ingressPointConfiguration()));
        case "IngressPointId":
            return Optional.ofNullable(clazz.cast(ingressPointId()));
        case "IngressPointName":
            return Optional.ofNullable(clazz.cast(ingressPointName()));
        case "RuleSetId":
            return Optional.ofNullable(clazz.cast(ruleSetId()));
        case "StatusToUpdate":
            return Optional.ofNullable(clazz.cast(statusToUpdateAsString()));
        case "TrafficPolicyId":
            return Optional.ofNullable(clazz.cast(trafficPolicyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IngressPointConfiguration", INGRESS_POINT_CONFIGURATION_FIELD);
        map.put("IngressPointId", INGRESS_POINT_ID_FIELD);
        map.put("IngressPointName", INGRESS_POINT_NAME_FIELD);
        map.put("RuleSetId", RULE_SET_ID_FIELD);
        map.put("StatusToUpdate", STATUS_TO_UPDATE_FIELD);
        map.put("TrafficPolicyId", TRAFFIC_POLICY_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateIngressPointRequest, T> g) {
        return obj -> g.apply((UpdateIngressPointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MailManagerRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateIngressPointRequest> {
        /**
         * <p>
         * If you choose an Authenticated ingress endpoint, you must configure either an SMTP password or a secret ARN.
         * </p>
         * 
         * @param ingressPointConfiguration
         *        If you choose an Authenticated ingress endpoint, you must configure either an SMTP password or a
         *        secret ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingressPointConfiguration(IngressPointConfiguration ingressPointConfiguration);

        /**
         * <p>
         * If you choose an Authenticated ingress endpoint, you must configure either an SMTP password or a secret ARN.
         * </p>
         * This is a convenience method that creates an instance of the {@link IngressPointConfiguration.Builder}
         * avoiding the need to create one manually via {@link IngressPointConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IngressPointConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #ingressPointConfiguration(IngressPointConfiguration)}.
         * 
         * @param ingressPointConfiguration
         *        a consumer that will call methods on {@link IngressPointConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ingressPointConfiguration(IngressPointConfiguration)
         */
        default Builder ingressPointConfiguration(Consumer<IngressPointConfiguration.Builder> ingressPointConfiguration) {
            return ingressPointConfiguration(IngressPointConfiguration.builder().applyMutation(ingressPointConfiguration).build());
        }

        /**
         * <p>
         * The identifier for the ingress endpoint you want to update.
         * </p>
         * 
         * @param ingressPointId
         *        The identifier for the ingress endpoint you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingressPointId(String ingressPointId);

        /**
         * <p>
         * A user friendly name for the ingress endpoint resource.
         * </p>
         * 
         * @param ingressPointName
         *        A user friendly name for the ingress endpoint resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingressPointName(String ingressPointName);

        /**
         * <p>
         * The identifier of an existing rule set that you attach to an ingress endpoint resource.
         * </p>
         * 
         * @param ruleSetId
         *        The identifier of an existing rule set that you attach to an ingress endpoint resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleSetId(String ruleSetId);

        /**
         * <p>
         * The update status of an ingress endpoint.
         * </p>
         * 
         * @param statusToUpdate
         *        The update status of an ingress endpoint.
         * @see IngressPointStatusToUpdate
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngressPointStatusToUpdate
         */
        Builder statusToUpdate(String statusToUpdate);

        /**
         * <p>
         * The update status of an ingress endpoint.
         * </p>
         * 
         * @param statusToUpdate
         *        The update status of an ingress endpoint.
         * @see IngressPointStatusToUpdate
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngressPointStatusToUpdate
         */
        Builder statusToUpdate(IngressPointStatusToUpdate statusToUpdate);

        /**
         * <p>
         * The identifier of an existing traffic policy that you attach to an ingress endpoint resource.
         * </p>
         * 
         * @param trafficPolicyId
         *        The identifier of an existing traffic policy that you attach to an ingress endpoint resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicyId(String trafficPolicyId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MailManagerRequest.BuilderImpl implements Builder {
        private IngressPointConfiguration ingressPointConfiguration;

        private String ingressPointId;

        private String ingressPointName;

        private String ruleSetId;

        private String statusToUpdate;

        private String trafficPolicyId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIngressPointRequest model) {
            super(model);
            ingressPointConfiguration(model.ingressPointConfiguration);
            ingressPointId(model.ingressPointId);
            ingressPointName(model.ingressPointName);
            ruleSetId(model.ruleSetId);
            statusToUpdate(model.statusToUpdate);
            trafficPolicyId(model.trafficPolicyId);
        }

        public final IngressPointConfiguration.Builder getIngressPointConfiguration() {
            return ingressPointConfiguration != null ? ingressPointConfiguration.toBuilder() : null;
        }

        public final void setIngressPointConfiguration(IngressPointConfiguration.BuilderImpl ingressPointConfiguration) {
            this.ingressPointConfiguration = ingressPointConfiguration != null ? ingressPointConfiguration.build() : null;
        }

        @Override
        public final Builder ingressPointConfiguration(IngressPointConfiguration ingressPointConfiguration) {
            this.ingressPointConfiguration = ingressPointConfiguration;
            return this;
        }

        public final String getIngressPointId() {
            return ingressPointId;
        }

        public final void setIngressPointId(String ingressPointId) {
            this.ingressPointId = ingressPointId;
        }

        @Override
        public final Builder ingressPointId(String ingressPointId) {
            this.ingressPointId = ingressPointId;
            return this;
        }

        public final String getIngressPointName() {
            return ingressPointName;
        }

        public final void setIngressPointName(String ingressPointName) {
            this.ingressPointName = ingressPointName;
        }

        @Override
        public final Builder ingressPointName(String ingressPointName) {
            this.ingressPointName = ingressPointName;
            return this;
        }

        public final String getRuleSetId() {
            return ruleSetId;
        }

        public final void setRuleSetId(String ruleSetId) {
            this.ruleSetId = ruleSetId;
        }

        @Override
        public final Builder ruleSetId(String ruleSetId) {
            this.ruleSetId = ruleSetId;
            return this;
        }

        public final String getStatusToUpdate() {
            return statusToUpdate;
        }

        public final void setStatusToUpdate(String statusToUpdate) {
            this.statusToUpdate = statusToUpdate;
        }

        @Override
        public final Builder statusToUpdate(String statusToUpdate) {
            this.statusToUpdate = statusToUpdate;
            return this;
        }

        @Override
        public final Builder statusToUpdate(IngressPointStatusToUpdate statusToUpdate) {
            this.statusToUpdate(statusToUpdate == null ? null : statusToUpdate.toString());
            return this;
        }

        public final String getTrafficPolicyId() {
            return trafficPolicyId;
        }

        public final void setTrafficPolicyId(String trafficPolicyId) {
            this.trafficPolicyId = trafficPolicyId;
        }

        @Override
        public final Builder trafficPolicyId(String trafficPolicyId) {
            this.trafficPolicyId = trafficPolicyId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateIngressPointRequest build() {
            return new UpdateIngressPointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
