/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.mailmanager.model.CreateAddonInstanceRequest;
import software.amazon.awssdk.services.mailmanager.model.CreateAddonInstanceResponse;
import software.amazon.awssdk.services.mailmanager.model.CreateAddonSubscriptionRequest;
import software.amazon.awssdk.services.mailmanager.model.CreateAddonSubscriptionResponse;
import software.amazon.awssdk.services.mailmanager.model.CreateAddressListImportJobRequest;
import software.amazon.awssdk.services.mailmanager.model.CreateAddressListImportJobResponse;
import software.amazon.awssdk.services.mailmanager.model.CreateAddressListRequest;
import software.amazon.awssdk.services.mailmanager.model.CreateAddressListResponse;
import software.amazon.awssdk.services.mailmanager.model.CreateArchiveRequest;
import software.amazon.awssdk.services.mailmanager.model.CreateArchiveResponse;
import software.amazon.awssdk.services.mailmanager.model.CreateIngressPointRequest;
import software.amazon.awssdk.services.mailmanager.model.CreateIngressPointResponse;
import software.amazon.awssdk.services.mailmanager.model.CreateRelayRequest;
import software.amazon.awssdk.services.mailmanager.model.CreateRelayResponse;
import software.amazon.awssdk.services.mailmanager.model.CreateRuleSetRequest;
import software.amazon.awssdk.services.mailmanager.model.CreateRuleSetResponse;
import software.amazon.awssdk.services.mailmanager.model.CreateTrafficPolicyRequest;
import software.amazon.awssdk.services.mailmanager.model.CreateTrafficPolicyResponse;
import software.amazon.awssdk.services.mailmanager.model.DeleteAddonInstanceRequest;
import software.amazon.awssdk.services.mailmanager.model.DeleteAddonInstanceResponse;
import software.amazon.awssdk.services.mailmanager.model.DeleteAddonSubscriptionRequest;
import software.amazon.awssdk.services.mailmanager.model.DeleteAddonSubscriptionResponse;
import software.amazon.awssdk.services.mailmanager.model.DeleteAddressListRequest;
import software.amazon.awssdk.services.mailmanager.model.DeleteAddressListResponse;
import software.amazon.awssdk.services.mailmanager.model.DeleteArchiveRequest;
import software.amazon.awssdk.services.mailmanager.model.DeleteArchiveResponse;
import software.amazon.awssdk.services.mailmanager.model.DeleteIngressPointRequest;
import software.amazon.awssdk.services.mailmanager.model.DeleteIngressPointResponse;
import software.amazon.awssdk.services.mailmanager.model.DeleteRelayRequest;
import software.amazon.awssdk.services.mailmanager.model.DeleteRelayResponse;
import software.amazon.awssdk.services.mailmanager.model.DeleteRuleSetRequest;
import software.amazon.awssdk.services.mailmanager.model.DeleteRuleSetResponse;
import software.amazon.awssdk.services.mailmanager.model.DeleteTrafficPolicyRequest;
import software.amazon.awssdk.services.mailmanager.model.DeleteTrafficPolicyResponse;
import software.amazon.awssdk.services.mailmanager.model.DeregisterMemberFromAddressListRequest;
import software.amazon.awssdk.services.mailmanager.model.DeregisterMemberFromAddressListResponse;
import software.amazon.awssdk.services.mailmanager.model.GetAddonInstanceRequest;
import software.amazon.awssdk.services.mailmanager.model.GetAddonInstanceResponse;
import software.amazon.awssdk.services.mailmanager.model.GetAddonSubscriptionRequest;
import software.amazon.awssdk.services.mailmanager.model.GetAddonSubscriptionResponse;
import software.amazon.awssdk.services.mailmanager.model.GetAddressListImportJobRequest;
import software.amazon.awssdk.services.mailmanager.model.GetAddressListImportJobResponse;
import software.amazon.awssdk.services.mailmanager.model.GetAddressListRequest;
import software.amazon.awssdk.services.mailmanager.model.GetAddressListResponse;
import software.amazon.awssdk.services.mailmanager.model.GetArchiveExportRequest;
import software.amazon.awssdk.services.mailmanager.model.GetArchiveExportResponse;
import software.amazon.awssdk.services.mailmanager.model.GetArchiveMessageContentRequest;
import software.amazon.awssdk.services.mailmanager.model.GetArchiveMessageContentResponse;
import software.amazon.awssdk.services.mailmanager.model.GetArchiveMessageRequest;
import software.amazon.awssdk.services.mailmanager.model.GetArchiveMessageResponse;
import software.amazon.awssdk.services.mailmanager.model.GetArchiveRequest;
import software.amazon.awssdk.services.mailmanager.model.GetArchiveResponse;
import software.amazon.awssdk.services.mailmanager.model.GetArchiveSearchRequest;
import software.amazon.awssdk.services.mailmanager.model.GetArchiveSearchResponse;
import software.amazon.awssdk.services.mailmanager.model.GetArchiveSearchResultsRequest;
import software.amazon.awssdk.services.mailmanager.model.GetArchiveSearchResultsResponse;
import software.amazon.awssdk.services.mailmanager.model.GetIngressPointRequest;
import software.amazon.awssdk.services.mailmanager.model.GetIngressPointResponse;
import software.amazon.awssdk.services.mailmanager.model.GetMemberOfAddressListRequest;
import software.amazon.awssdk.services.mailmanager.model.GetMemberOfAddressListResponse;
import software.amazon.awssdk.services.mailmanager.model.GetRelayRequest;
import software.amazon.awssdk.services.mailmanager.model.GetRelayResponse;
import software.amazon.awssdk.services.mailmanager.model.GetRuleSetRequest;
import software.amazon.awssdk.services.mailmanager.model.GetRuleSetResponse;
import software.amazon.awssdk.services.mailmanager.model.GetTrafficPolicyRequest;
import software.amazon.awssdk.services.mailmanager.model.GetTrafficPolicyResponse;
import software.amazon.awssdk.services.mailmanager.model.ListAddonInstancesRequest;
import software.amazon.awssdk.services.mailmanager.model.ListAddonInstancesResponse;
import software.amazon.awssdk.services.mailmanager.model.ListAddonSubscriptionsRequest;
import software.amazon.awssdk.services.mailmanager.model.ListAddonSubscriptionsResponse;
import software.amazon.awssdk.services.mailmanager.model.ListAddressListImportJobsRequest;
import software.amazon.awssdk.services.mailmanager.model.ListAddressListImportJobsResponse;
import software.amazon.awssdk.services.mailmanager.model.ListAddressListsRequest;
import software.amazon.awssdk.services.mailmanager.model.ListAddressListsResponse;
import software.amazon.awssdk.services.mailmanager.model.ListArchiveExportsRequest;
import software.amazon.awssdk.services.mailmanager.model.ListArchiveExportsResponse;
import software.amazon.awssdk.services.mailmanager.model.ListArchiveSearchesRequest;
import software.amazon.awssdk.services.mailmanager.model.ListArchiveSearchesResponse;
import software.amazon.awssdk.services.mailmanager.model.ListArchivesRequest;
import software.amazon.awssdk.services.mailmanager.model.ListArchivesResponse;
import software.amazon.awssdk.services.mailmanager.model.ListIngressPointsRequest;
import software.amazon.awssdk.services.mailmanager.model.ListIngressPointsResponse;
import software.amazon.awssdk.services.mailmanager.model.ListMembersOfAddressListRequest;
import software.amazon.awssdk.services.mailmanager.model.ListMembersOfAddressListResponse;
import software.amazon.awssdk.services.mailmanager.model.ListRelaysRequest;
import software.amazon.awssdk.services.mailmanager.model.ListRelaysResponse;
import software.amazon.awssdk.services.mailmanager.model.ListRuleSetsRequest;
import software.amazon.awssdk.services.mailmanager.model.ListRuleSetsResponse;
import software.amazon.awssdk.services.mailmanager.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.mailmanager.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.mailmanager.model.ListTrafficPoliciesRequest;
import software.amazon.awssdk.services.mailmanager.model.ListTrafficPoliciesResponse;
import software.amazon.awssdk.services.mailmanager.model.RegisterMemberToAddressListRequest;
import software.amazon.awssdk.services.mailmanager.model.RegisterMemberToAddressListResponse;
import software.amazon.awssdk.services.mailmanager.model.StartAddressListImportJobRequest;
import software.amazon.awssdk.services.mailmanager.model.StartAddressListImportJobResponse;
import software.amazon.awssdk.services.mailmanager.model.StartArchiveExportRequest;
import software.amazon.awssdk.services.mailmanager.model.StartArchiveExportResponse;
import software.amazon.awssdk.services.mailmanager.model.StartArchiveSearchRequest;
import software.amazon.awssdk.services.mailmanager.model.StartArchiveSearchResponse;
import software.amazon.awssdk.services.mailmanager.model.StopAddressListImportJobRequest;
import software.amazon.awssdk.services.mailmanager.model.StopAddressListImportJobResponse;
import software.amazon.awssdk.services.mailmanager.model.StopArchiveExportRequest;
import software.amazon.awssdk.services.mailmanager.model.StopArchiveExportResponse;
import software.amazon.awssdk.services.mailmanager.model.StopArchiveSearchRequest;
import software.amazon.awssdk.services.mailmanager.model.StopArchiveSearchResponse;
import software.amazon.awssdk.services.mailmanager.model.TagResourceRequest;
import software.amazon.awssdk.services.mailmanager.model.TagResourceResponse;
import software.amazon.awssdk.services.mailmanager.model.UntagResourceRequest;
import software.amazon.awssdk.services.mailmanager.model.UntagResourceResponse;
import software.amazon.awssdk.services.mailmanager.model.UpdateArchiveRequest;
import software.amazon.awssdk.services.mailmanager.model.UpdateArchiveResponse;
import software.amazon.awssdk.services.mailmanager.model.UpdateIngressPointRequest;
import software.amazon.awssdk.services.mailmanager.model.UpdateIngressPointResponse;
import software.amazon.awssdk.services.mailmanager.model.UpdateRelayRequest;
import software.amazon.awssdk.services.mailmanager.model.UpdateRelayResponse;
import software.amazon.awssdk.services.mailmanager.model.UpdateRuleSetRequest;
import software.amazon.awssdk.services.mailmanager.model.UpdateRuleSetResponse;
import software.amazon.awssdk.services.mailmanager.model.UpdateTrafficPolicyRequest;
import software.amazon.awssdk.services.mailmanager.model.UpdateTrafficPolicyResponse;
import software.amazon.awssdk.services.mailmanager.paginators.ListAddonInstancesPublisher;
import software.amazon.awssdk.services.mailmanager.paginators.ListAddonSubscriptionsPublisher;
import software.amazon.awssdk.services.mailmanager.paginators.ListAddressListImportJobsPublisher;
import software.amazon.awssdk.services.mailmanager.paginators.ListAddressListsPublisher;
import software.amazon.awssdk.services.mailmanager.paginators.ListArchiveExportsPublisher;
import software.amazon.awssdk.services.mailmanager.paginators.ListArchiveSearchesPublisher;
import software.amazon.awssdk.services.mailmanager.paginators.ListArchivesPublisher;
import software.amazon.awssdk.services.mailmanager.paginators.ListIngressPointsPublisher;
import software.amazon.awssdk.services.mailmanager.paginators.ListMembersOfAddressListPublisher;
import software.amazon.awssdk.services.mailmanager.paginators.ListRelaysPublisher;
import software.amazon.awssdk.services.mailmanager.paginators.ListRuleSetsPublisher;
import software.amazon.awssdk.services.mailmanager.paginators.ListTrafficPoliciesPublisher;

/**
 * Service client for accessing MailManager asynchronously. This can be created using the static {@link #builder()}
 * method.The asynchronous client performs non-blocking I/O when configured with any {@code SdkAsyncHttpClient}
 * supported in the SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in
 * some cases such as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * <p>
 * <fullname>Amazon SES Mail Manager API</fullname>
 * <p>
 * The Amazon SES Mail Manager API contains operations and data types that comprise the Mail Manager feature of <a
 * href="http://aws.amazon.com/ses">Amazon Simple Email Service (SES)</a>.
 * </p>
 * <p>
 * Mail Manager is a set of Amazon SES email gateway features designed to help you strengthen your organization's email
 * infrastructure, simplify email workflow management, and streamline email compliance control. To learn more, see the
 * <a href="https://docs.aws.amazon.com/ses/latest/dg/eb.html">Mail Manager chapter</a> in the <i>Amazon SES Developer
 * Guide</i>.
 * </p>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface MailManagerAsyncClient extends AwsClient {
    String SERVICE_NAME = "ses";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "mail-manager";

    /**
     * <p>
     * Creates an Add On instance for the subscription indicated in the request. The resulting Amazon Resource Name
     * (ARN) can be used in a conditional statement for a rule set or traffic policy.
     * </p>
     *
     * @param createAddonInstanceRequest
     * @return A Java Future containing the result of the CreateAddonInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>ServiceQuotaExceededException Occurs when an operation exceeds a predefined service quota or limit.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.CreateAddonInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/CreateAddonInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAddonInstanceResponse> createAddonInstance(
            CreateAddonInstanceRequest createAddonInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Add On instance for the subscription indicated in the request. The resulting Amazon Resource Name
     * (ARN) can be used in a conditional statement for a rule set or traffic policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAddonInstanceRequest.Builder} avoiding the
     * need to create one manually via {@link CreateAddonInstanceRequest#builder()}
     * </p>
     *
     * @param createAddonInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.CreateAddonInstanceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateAddonInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>ServiceQuotaExceededException Occurs when an operation exceeds a predefined service quota or limit.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.CreateAddonInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/CreateAddonInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAddonInstanceResponse> createAddonInstance(
            Consumer<CreateAddonInstanceRequest.Builder> createAddonInstanceRequest) {
        return createAddonInstance(CreateAddonInstanceRequest.builder().applyMutation(createAddonInstanceRequest).build());
    }

    /**
     * <p>
     * Creates a subscription for an Add On representing the acceptance of its terms of use and additional pricing. The
     * subscription can then be used to create an instance for use in rule sets or traffic policies.
     * </p>
     *
     * @param createAddonSubscriptionRequest
     * @return A Java Future containing the result of the CreateAddonSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>ServiceQuotaExceededException Occurs when an operation exceeds a predefined service quota or limit.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.CreateAddonSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/CreateAddonSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAddonSubscriptionResponse> createAddonSubscription(
            CreateAddonSubscriptionRequest createAddonSubscriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a subscription for an Add On representing the acceptance of its terms of use and additional pricing. The
     * subscription can then be used to create an instance for use in rule sets or traffic policies.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAddonSubscriptionRequest.Builder} avoiding
     * the need to create one manually via {@link CreateAddonSubscriptionRequest#builder()}
     * </p>
     *
     * @param createAddonSubscriptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.CreateAddonSubscriptionRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateAddonSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>ServiceQuotaExceededException Occurs when an operation exceeds a predefined service quota or limit.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.CreateAddonSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/CreateAddonSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAddonSubscriptionResponse> createAddonSubscription(
            Consumer<CreateAddonSubscriptionRequest.Builder> createAddonSubscriptionRequest) {
        return createAddonSubscription(CreateAddonSubscriptionRequest.builder().applyMutation(createAddonSubscriptionRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new address list.
     * </p>
     *
     * @param createAddressListRequest
     * @return A Java Future containing the result of the CreateAddressList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ServiceQuotaExceededException Occurs when an operation exceeds a predefined service quota or limit.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.CreateAddressList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/CreateAddressList" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateAddressListResponse> createAddressList(CreateAddressListRequest createAddressListRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new address list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAddressListRequest.Builder} avoiding the need
     * to create one manually via {@link CreateAddressListRequest#builder()}
     * </p>
     *
     * @param createAddressListRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.CreateAddressListRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateAddressList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ServiceQuotaExceededException Occurs when an operation exceeds a predefined service quota or limit.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.CreateAddressList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/CreateAddressList" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateAddressListResponse> createAddressList(
            Consumer<CreateAddressListRequest.Builder> createAddressListRequest) {
        return createAddressList(CreateAddressListRequest.builder().applyMutation(createAddressListRequest).build());
    }

    /**
     * <p>
     * Creates an import job for an address list.
     * </p>
     *
     * @param createAddressListImportJobRequest
     * @return A Java Future containing the result of the CreateAddressListImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.CreateAddressListImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/CreateAddressListImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAddressListImportJobResponse> createAddressListImportJob(
            CreateAddressListImportJobRequest createAddressListImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an import job for an address list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAddressListImportJobRequest.Builder} avoiding
     * the need to create one manually via {@link CreateAddressListImportJobRequest#builder()}
     * </p>
     *
     * @param createAddressListImportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.CreateAddressListImportJobRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateAddressListImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.CreateAddressListImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/CreateAddressListImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAddressListImportJobResponse> createAddressListImportJob(
            Consumer<CreateAddressListImportJobRequest.Builder> createAddressListImportJobRequest) {
        return createAddressListImportJob(CreateAddressListImportJobRequest.builder()
                .applyMutation(createAddressListImportJobRequest).build());
    }

    /**
     * <p>
     * Creates a new email archive resource for storing and retaining emails.
     * </p>
     *
     * @param createArchiveRequest
     *        The request to create a new email archive.
     * @return A Java Future containing the result of the CreateArchive operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ServiceQuotaExceededException Occurs when an operation exceeds a predefined service quota or limit.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.CreateArchive
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/CreateArchive" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateArchiveResponse> createArchive(CreateArchiveRequest createArchiveRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new email archive resource for storing and retaining emails.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateArchiveRequest.Builder} avoiding the need to
     * create one manually via {@link CreateArchiveRequest#builder()}
     * </p>
     *
     * @param createArchiveRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.CreateArchiveRequest.Builder} to create a
     *        request. The request to create a new email archive.
     * @return A Java Future containing the result of the CreateArchive operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ServiceQuotaExceededException Occurs when an operation exceeds a predefined service quota or limit.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.CreateArchive
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/CreateArchive" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateArchiveResponse> createArchive(Consumer<CreateArchiveRequest.Builder> createArchiveRequest) {
        return createArchive(CreateArchiveRequest.builder().applyMutation(createArchiveRequest).build());
    }

    /**
     * <p>
     * Provision a new ingress endpoint resource.
     * </p>
     *
     * @param createIngressPointRequest
     * @return A Java Future containing the result of the CreateIngressPoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>ServiceQuotaExceededException Occurs when an operation exceeds a predefined service quota or limit.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.CreateIngressPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/CreateIngressPoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateIngressPointResponse> createIngressPoint(CreateIngressPointRequest createIngressPointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provision a new ingress endpoint resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIngressPointRequest.Builder} avoiding the
     * need to create one manually via {@link CreateIngressPointRequest#builder()}
     * </p>
     *
     * @param createIngressPointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.CreateIngressPointRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateIngressPoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>ServiceQuotaExceededException Occurs when an operation exceeds a predefined service quota or limit.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.CreateIngressPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/CreateIngressPoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateIngressPointResponse> createIngressPoint(
            Consumer<CreateIngressPointRequest.Builder> createIngressPointRequest) {
        return createIngressPoint(CreateIngressPointRequest.builder().applyMutation(createIngressPointRequest).build());
    }

    /**
     * <p>
     * Creates a relay resource which can be used in rules to relay incoming emails to defined relay destinations.
     * </p>
     *
     * @param createRelayRequest
     * @return A Java Future containing the result of the CreateRelay operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>ServiceQuotaExceededException Occurs when an operation exceeds a predefined service quota or limit.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.CreateRelay
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/CreateRelay" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateRelayResponse> createRelay(CreateRelayRequest createRelayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a relay resource which can be used in rules to relay incoming emails to defined relay destinations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRelayRequest.Builder} avoiding the need to
     * create one manually via {@link CreateRelayRequest#builder()}
     * </p>
     *
     * @param createRelayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.CreateRelayRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateRelay operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>ServiceQuotaExceededException Occurs when an operation exceeds a predefined service quota or limit.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.CreateRelay
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/CreateRelay" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateRelayResponse> createRelay(Consumer<CreateRelayRequest.Builder> createRelayRequest) {
        return createRelay(CreateRelayRequest.builder().applyMutation(createRelayRequest).build());
    }

    /**
     * <p>
     * Provision a new rule set.
     * </p>
     *
     * @param createRuleSetRequest
     * @return A Java Future containing the result of the CreateRuleSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>ServiceQuotaExceededException Occurs when an operation exceeds a predefined service quota or limit.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.CreateRuleSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/CreateRuleSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateRuleSetResponse> createRuleSet(CreateRuleSetRequest createRuleSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provision a new rule set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRuleSetRequest.Builder} avoiding the need to
     * create one manually via {@link CreateRuleSetRequest#builder()}
     * </p>
     *
     * @param createRuleSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.CreateRuleSetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateRuleSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>ServiceQuotaExceededException Occurs when an operation exceeds a predefined service quota or limit.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.CreateRuleSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/CreateRuleSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateRuleSetResponse> createRuleSet(Consumer<CreateRuleSetRequest.Builder> createRuleSetRequest) {
        return createRuleSet(CreateRuleSetRequest.builder().applyMutation(createRuleSetRequest).build());
    }

    /**
     * <p>
     * Provision a new traffic policy resource.
     * </p>
     *
     * @param createTrafficPolicyRequest
     * @return A Java Future containing the result of the CreateTrafficPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>ServiceQuotaExceededException Occurs when an operation exceeds a predefined service quota or limit.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.CreateTrafficPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/CreateTrafficPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTrafficPolicyResponse> createTrafficPolicy(
            CreateTrafficPolicyRequest createTrafficPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provision a new traffic policy resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTrafficPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link CreateTrafficPolicyRequest#builder()}
     * </p>
     *
     * @param createTrafficPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.CreateTrafficPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateTrafficPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>ServiceQuotaExceededException Occurs when an operation exceeds a predefined service quota or limit.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.CreateTrafficPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/CreateTrafficPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTrafficPolicyResponse> createTrafficPolicy(
            Consumer<CreateTrafficPolicyRequest.Builder> createTrafficPolicyRequest) {
        return createTrafficPolicy(CreateTrafficPolicyRequest.builder().applyMutation(createTrafficPolicyRequest).build());
    }

    /**
     * <p>
     * Deletes an Add On instance.
     * </p>
     *
     * @param deleteAddonInstanceRequest
     * @return A Java Future containing the result of the DeleteAddonInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.DeleteAddonInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/DeleteAddonInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAddonInstanceResponse> deleteAddonInstance(
            DeleteAddonInstanceRequest deleteAddonInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Add On instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAddonInstanceRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteAddonInstanceRequest#builder()}
     * </p>
     *
     * @param deleteAddonInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.DeleteAddonInstanceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteAddonInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.DeleteAddonInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/DeleteAddonInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAddonInstanceResponse> deleteAddonInstance(
            Consumer<DeleteAddonInstanceRequest.Builder> deleteAddonInstanceRequest) {
        return deleteAddonInstance(DeleteAddonInstanceRequest.builder().applyMutation(deleteAddonInstanceRequest).build());
    }

    /**
     * <p>
     * Deletes an Add On subscription.
     * </p>
     *
     * @param deleteAddonSubscriptionRequest
     * @return A Java Future containing the result of the DeleteAddonSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.DeleteAddonSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/DeleteAddonSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAddonSubscriptionResponse> deleteAddonSubscription(
            DeleteAddonSubscriptionRequest deleteAddonSubscriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Add On subscription.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAddonSubscriptionRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteAddonSubscriptionRequest#builder()}
     * </p>
     *
     * @param deleteAddonSubscriptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.DeleteAddonSubscriptionRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteAddonSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.DeleteAddonSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/DeleteAddonSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAddonSubscriptionResponse> deleteAddonSubscription(
            Consumer<DeleteAddonSubscriptionRequest.Builder> deleteAddonSubscriptionRequest) {
        return deleteAddonSubscription(DeleteAddonSubscriptionRequest.builder().applyMutation(deleteAddonSubscriptionRequest)
                .build());
    }

    /**
     * <p>
     * Deletes an address list.
     * </p>
     *
     * @param deleteAddressListRequest
     * @return A Java Future containing the result of the DeleteAddressList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.DeleteAddressList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/DeleteAddressList" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteAddressListResponse> deleteAddressList(DeleteAddressListRequest deleteAddressListRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an address list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAddressListRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteAddressListRequest#builder()}
     * </p>
     *
     * @param deleteAddressListRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.DeleteAddressListRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteAddressList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.DeleteAddressList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/DeleteAddressList" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteAddressListResponse> deleteAddressList(
            Consumer<DeleteAddressListRequest.Builder> deleteAddressListRequest) {
        return deleteAddressList(DeleteAddressListRequest.builder().applyMutation(deleteAddressListRequest).build());
    }

    /**
     * <p>
     * Initiates deletion of an email archive. This changes the archive state to pending deletion. In this state, no new
     * emails can be added, and existing archived emails become inaccessible (search, export, download). The archive and
     * all of its contents will be permanently deleted 30 days after entering the pending deletion state, regardless of
     * the configured retention period.
     * </p>
     *
     * @param deleteArchiveRequest
     *        The request to initiate deletion of an email archive.
     * @return A Java Future containing the result of the DeleteArchive operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.DeleteArchive
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/DeleteArchive" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteArchiveResponse> deleteArchive(DeleteArchiveRequest deleteArchiveRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Initiates deletion of an email archive. This changes the archive state to pending deletion. In this state, no new
     * emails can be added, and existing archived emails become inaccessible (search, export, download). The archive and
     * all of its contents will be permanently deleted 30 days after entering the pending deletion state, regardless of
     * the configured retention period.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteArchiveRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteArchiveRequest#builder()}
     * </p>
     *
     * @param deleteArchiveRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.DeleteArchiveRequest.Builder} to create a
     *        request. The request to initiate deletion of an email archive.
     * @return A Java Future containing the result of the DeleteArchive operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.DeleteArchive
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/DeleteArchive" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteArchiveResponse> deleteArchive(Consumer<DeleteArchiveRequest.Builder> deleteArchiveRequest) {
        return deleteArchive(DeleteArchiveRequest.builder().applyMutation(deleteArchiveRequest).build());
    }

    /**
     * <p>
     * Delete an ingress endpoint resource.
     * </p>
     *
     * @param deleteIngressPointRequest
     * @return A Java Future containing the result of the DeleteIngressPoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.DeleteIngressPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/DeleteIngressPoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteIngressPointResponse> deleteIngressPoint(DeleteIngressPointRequest deleteIngressPointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete an ingress endpoint resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIngressPointRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteIngressPointRequest#builder()}
     * </p>
     *
     * @param deleteIngressPointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.DeleteIngressPointRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteIngressPoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.DeleteIngressPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/DeleteIngressPoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteIngressPointResponse> deleteIngressPoint(
            Consumer<DeleteIngressPointRequest.Builder> deleteIngressPointRequest) {
        return deleteIngressPoint(DeleteIngressPointRequest.builder().applyMutation(deleteIngressPointRequest).build());
    }

    /**
     * <p>
     * Deletes an existing relay resource.
     * </p>
     *
     * @param deleteRelayRequest
     * @return A Java Future containing the result of the DeleteRelay operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.DeleteRelay
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/DeleteRelay" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteRelayResponse> deleteRelay(DeleteRelayRequest deleteRelayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing relay resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRelayRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteRelayRequest#builder()}
     * </p>
     *
     * @param deleteRelayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.DeleteRelayRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteRelay operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.DeleteRelay
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/DeleteRelay" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteRelayResponse> deleteRelay(Consumer<DeleteRelayRequest.Builder> deleteRelayRequest) {
        return deleteRelay(DeleteRelayRequest.builder().applyMutation(deleteRelayRequest).build());
    }

    /**
     * <p>
     * Delete a rule set.
     * </p>
     *
     * @param deleteRuleSetRequest
     * @return A Java Future containing the result of the DeleteRuleSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.DeleteRuleSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/DeleteRuleSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteRuleSetResponse> deleteRuleSet(DeleteRuleSetRequest deleteRuleSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a rule set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRuleSetRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteRuleSetRequest#builder()}
     * </p>
     *
     * @param deleteRuleSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.DeleteRuleSetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteRuleSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.DeleteRuleSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/DeleteRuleSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteRuleSetResponse> deleteRuleSet(Consumer<DeleteRuleSetRequest.Builder> deleteRuleSetRequest) {
        return deleteRuleSet(DeleteRuleSetRequest.builder().applyMutation(deleteRuleSetRequest).build());
    }

    /**
     * <p>
     * Delete a traffic policy resource.
     * </p>
     *
     * @param deleteTrafficPolicyRequest
     * @return A Java Future containing the result of the DeleteTrafficPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.DeleteTrafficPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/DeleteTrafficPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTrafficPolicyResponse> deleteTrafficPolicy(
            DeleteTrafficPolicyRequest deleteTrafficPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a traffic policy resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTrafficPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteTrafficPolicyRequest#builder()}
     * </p>
     *
     * @param deleteTrafficPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.DeleteTrafficPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteTrafficPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.DeleteTrafficPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/DeleteTrafficPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTrafficPolicyResponse> deleteTrafficPolicy(
            Consumer<DeleteTrafficPolicyRequest.Builder> deleteTrafficPolicyRequest) {
        return deleteTrafficPolicy(DeleteTrafficPolicyRequest.builder().applyMutation(deleteTrafficPolicyRequest).build());
    }

    /**
     * <p>
     * Removes a member from an address list.
     * </p>
     *
     * @param deregisterMemberFromAddressListRequest
     * @return A Java Future containing the result of the DeregisterMemberFromAddressList operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.DeregisterMemberFromAddressList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/DeregisterMemberFromAddressList"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterMemberFromAddressListResponse> deregisterMemberFromAddressList(
            DeregisterMemberFromAddressListRequest deregisterMemberFromAddressListRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a member from an address list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterMemberFromAddressListRequest.Builder}
     * avoiding the need to create one manually via {@link DeregisterMemberFromAddressListRequest#builder()}
     * </p>
     *
     * @param deregisterMemberFromAddressListRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.DeregisterMemberFromAddressListRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeregisterMemberFromAddressList operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.DeregisterMemberFromAddressList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/DeregisterMemberFromAddressList"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterMemberFromAddressListResponse> deregisterMemberFromAddressList(
            Consumer<DeregisterMemberFromAddressListRequest.Builder> deregisterMemberFromAddressListRequest) {
        return deregisterMemberFromAddressList(DeregisterMemberFromAddressListRequest.builder()
                .applyMutation(deregisterMemberFromAddressListRequest).build());
    }

    /**
     * <p>
     * Gets detailed information about an Add On instance.
     * </p>
     *
     * @param getAddonInstanceRequest
     * @return A Java Future containing the result of the GetAddonInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.GetAddonInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetAddonInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetAddonInstanceResponse> getAddonInstance(GetAddonInstanceRequest getAddonInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets detailed information about an Add On instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAddonInstanceRequest.Builder} avoiding the need
     * to create one manually via {@link GetAddonInstanceRequest#builder()}
     * </p>
     *
     * @param getAddonInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.GetAddonInstanceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetAddonInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.GetAddonInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetAddonInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetAddonInstanceResponse> getAddonInstance(
            Consumer<GetAddonInstanceRequest.Builder> getAddonInstanceRequest) {
        return getAddonInstance(GetAddonInstanceRequest.builder().applyMutation(getAddonInstanceRequest).build());
    }

    /**
     * <p>
     * Gets detailed information about an Add On subscription.
     * </p>
     *
     * @param getAddonSubscriptionRequest
     * @return A Java Future containing the result of the GetAddonSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.GetAddonSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetAddonSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAddonSubscriptionResponse> getAddonSubscription(
            GetAddonSubscriptionRequest getAddonSubscriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets detailed information about an Add On subscription.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAddonSubscriptionRequest.Builder} avoiding the
     * need to create one manually via {@link GetAddonSubscriptionRequest#builder()}
     * </p>
     *
     * @param getAddonSubscriptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.GetAddonSubscriptionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetAddonSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.GetAddonSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetAddonSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAddonSubscriptionResponse> getAddonSubscription(
            Consumer<GetAddonSubscriptionRequest.Builder> getAddonSubscriptionRequest) {
        return getAddonSubscription(GetAddonSubscriptionRequest.builder().applyMutation(getAddonSubscriptionRequest).build());
    }

    /**
     * <p>
     * Fetch attributes of an address list.
     * </p>
     *
     * @param getAddressListRequest
     * @return A Java Future containing the result of the GetAddressList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.GetAddressList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetAddressList" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetAddressListResponse> getAddressList(GetAddressListRequest getAddressListRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Fetch attributes of an address list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAddressListRequest.Builder} avoiding the need to
     * create one manually via {@link GetAddressListRequest#builder()}
     * </p>
     *
     * @param getAddressListRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.GetAddressListRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetAddressList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.GetAddressList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetAddressList" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetAddressListResponse> getAddressList(Consumer<GetAddressListRequest.Builder> getAddressListRequest) {
        return getAddressList(GetAddressListRequest.builder().applyMutation(getAddressListRequest).build());
    }

    /**
     * <p>
     * Fetch attributes of an import job.
     * </p>
     *
     * @param getAddressListImportJobRequest
     * @return A Java Future containing the result of the GetAddressListImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.GetAddressListImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetAddressListImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAddressListImportJobResponse> getAddressListImportJob(
            GetAddressListImportJobRequest getAddressListImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Fetch attributes of an import job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAddressListImportJobRequest.Builder} avoiding
     * the need to create one manually via {@link GetAddressListImportJobRequest#builder()}
     * </p>
     *
     * @param getAddressListImportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.GetAddressListImportJobRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetAddressListImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.GetAddressListImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetAddressListImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAddressListImportJobResponse> getAddressListImportJob(
            Consumer<GetAddressListImportJobRequest.Builder> getAddressListImportJobRequest) {
        return getAddressListImportJob(GetAddressListImportJobRequest.builder().applyMutation(getAddressListImportJobRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the full details and current state of a specified email archive.
     * </p>
     *
     * @param getArchiveRequest
     *        The request to retrieve details of an email archive.
     * @return A Java Future containing the result of the GetArchive operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.GetArchive
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetArchive" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetArchiveResponse> getArchive(GetArchiveRequest getArchiveRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the full details and current state of a specified email archive.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetArchiveRequest.Builder} avoiding the need to
     * create one manually via {@link GetArchiveRequest#builder()}
     * </p>
     *
     * @param getArchiveRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.GetArchiveRequest.Builder} to create a request.
     *        The request to retrieve details of an email archive.
     * @return A Java Future containing the result of the GetArchive operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.GetArchive
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetArchive" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetArchiveResponse> getArchive(Consumer<GetArchiveRequest.Builder> getArchiveRequest) {
        return getArchive(GetArchiveRequest.builder().applyMutation(getArchiveRequest).build());
    }

    /**
     * <p>
     * Retrieves the details and current status of a specific email archive export job.
     * </p>
     *
     * @param getArchiveExportRequest
     *        The request to retrieve details of a specific archive export job.
     * @return A Java Future containing the result of the GetArchiveExport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.GetArchiveExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetArchiveExport" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetArchiveExportResponse> getArchiveExport(GetArchiveExportRequest getArchiveExportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the details and current status of a specific email archive export job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetArchiveExportRequest.Builder} avoiding the need
     * to create one manually via {@link GetArchiveExportRequest#builder()}
     * </p>
     *
     * @param getArchiveExportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.GetArchiveExportRequest.Builder} to create a
     *        request. The request to retrieve details of a specific archive export job.
     * @return A Java Future containing the result of the GetArchiveExport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.GetArchiveExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetArchiveExport" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetArchiveExportResponse> getArchiveExport(
            Consumer<GetArchiveExportRequest.Builder> getArchiveExportRequest) {
        return getArchiveExport(GetArchiveExportRequest.builder().applyMutation(getArchiveExportRequest).build());
    }

    /**
     * <p>
     * Returns a pre-signed URL that provides temporary download access to the specific email message stored in the
     * archive.
     * </p>
     *
     * @param getArchiveMessageRequest
     *        The request to get details of a specific email message stored in an archive.
     * @return A Java Future containing the result of the GetArchiveMessage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.GetArchiveMessage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetArchiveMessage" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetArchiveMessageResponse> getArchiveMessage(GetArchiveMessageRequest getArchiveMessageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a pre-signed URL that provides temporary download access to the specific email message stored in the
     * archive.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetArchiveMessageRequest.Builder} avoiding the need
     * to create one manually via {@link GetArchiveMessageRequest#builder()}
     * </p>
     *
     * @param getArchiveMessageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.GetArchiveMessageRequest.Builder} to create a
     *        request. The request to get details of a specific email message stored in an archive.
     * @return A Java Future containing the result of the GetArchiveMessage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.GetArchiveMessage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetArchiveMessage" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetArchiveMessageResponse> getArchiveMessage(
            Consumer<GetArchiveMessageRequest.Builder> getArchiveMessageRequest) {
        return getArchiveMessage(GetArchiveMessageRequest.builder().applyMutation(getArchiveMessageRequest).build());
    }

    /**
     * <p>
     * Returns the textual content of a specific email message stored in the archive. Attachments are not included.
     * </p>
     *
     * @param getArchiveMessageContentRequest
     *        The request to get the textual content of a specific email message stored in an archive.
     * @return A Java Future containing the result of the GetArchiveMessageContent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.GetArchiveMessageContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetArchiveMessageContent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetArchiveMessageContentResponse> getArchiveMessageContent(
            GetArchiveMessageContentRequest getArchiveMessageContentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the textual content of a specific email message stored in the archive. Attachments are not included.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetArchiveMessageContentRequest.Builder} avoiding
     * the need to create one manually via {@link GetArchiveMessageContentRequest#builder()}
     * </p>
     *
     * @param getArchiveMessageContentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.GetArchiveMessageContentRequest.Builder} to
     *        create a request. The request to get the textual content of a specific email message stored in an archive.
     * @return A Java Future containing the result of the GetArchiveMessageContent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.GetArchiveMessageContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetArchiveMessageContent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetArchiveMessageContentResponse> getArchiveMessageContent(
            Consumer<GetArchiveMessageContentRequest.Builder> getArchiveMessageContentRequest) {
        return getArchiveMessageContent(GetArchiveMessageContentRequest.builder().applyMutation(getArchiveMessageContentRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the details and current status of a specific email archive search job.
     * </p>
     *
     * @param getArchiveSearchRequest
     *        The request to retrieve details of a specific archive search job.
     * @return A Java Future containing the result of the GetArchiveSearch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.GetArchiveSearch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetArchiveSearch" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetArchiveSearchResponse> getArchiveSearch(GetArchiveSearchRequest getArchiveSearchRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the details and current status of a specific email archive search job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetArchiveSearchRequest.Builder} avoiding the need
     * to create one manually via {@link GetArchiveSearchRequest#builder()}
     * </p>
     *
     * @param getArchiveSearchRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.GetArchiveSearchRequest.Builder} to create a
     *        request. The request to retrieve details of a specific archive search job.
     * @return A Java Future containing the result of the GetArchiveSearch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.GetArchiveSearch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetArchiveSearch" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetArchiveSearchResponse> getArchiveSearch(
            Consumer<GetArchiveSearchRequest.Builder> getArchiveSearchRequest) {
        return getArchiveSearch(GetArchiveSearchRequest.builder().applyMutation(getArchiveSearchRequest).build());
    }

    /**
     * <p>
     * Returns the results of a completed email archive search job.
     * </p>
     *
     * @param getArchiveSearchResultsRequest
     *        The request to retrieve results from a completed archive search job.
     * @return A Java Future containing the result of the GetArchiveSearchResults operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.GetArchiveSearchResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetArchiveSearchResults"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetArchiveSearchResultsResponse> getArchiveSearchResults(
            GetArchiveSearchResultsRequest getArchiveSearchResultsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the results of a completed email archive search job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetArchiveSearchResultsRequest.Builder} avoiding
     * the need to create one manually via {@link GetArchiveSearchResultsRequest#builder()}
     * </p>
     *
     * @param getArchiveSearchResultsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.GetArchiveSearchResultsRequest.Builder} to create
     *        a request. The request to retrieve results from a completed archive search job.
     * @return A Java Future containing the result of the GetArchiveSearchResults operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.GetArchiveSearchResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetArchiveSearchResults"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetArchiveSearchResultsResponse> getArchiveSearchResults(
            Consumer<GetArchiveSearchResultsRequest.Builder> getArchiveSearchResultsRequest) {
        return getArchiveSearchResults(GetArchiveSearchResultsRequest.builder().applyMutation(getArchiveSearchResultsRequest)
                .build());
    }

    /**
     * <p>
     * Fetch ingress endpoint resource attributes.
     * </p>
     *
     * @param getIngressPointRequest
     * @return A Java Future containing the result of the GetIngressPoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.GetIngressPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetIngressPoint" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetIngressPointResponse> getIngressPoint(GetIngressPointRequest getIngressPointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Fetch ingress endpoint resource attributes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIngressPointRequest.Builder} avoiding the need
     * to create one manually via {@link GetIngressPointRequest#builder()}
     * </p>
     *
     * @param getIngressPointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.GetIngressPointRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetIngressPoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.GetIngressPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetIngressPoint" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetIngressPointResponse> getIngressPoint(
            Consumer<GetIngressPointRequest.Builder> getIngressPointRequest) {
        return getIngressPoint(GetIngressPointRequest.builder().applyMutation(getIngressPointRequest).build());
    }

    /**
     * <p>
     * Fetch attributes of a member in an address list.
     * </p>
     *
     * @param getMemberOfAddressListRequest
     * @return A Java Future containing the result of the GetMemberOfAddressList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.GetMemberOfAddressList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetMemberOfAddressList"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMemberOfAddressListResponse> getMemberOfAddressList(
            GetMemberOfAddressListRequest getMemberOfAddressListRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Fetch attributes of a member in an address list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMemberOfAddressListRequest.Builder} avoiding the
     * need to create one manually via {@link GetMemberOfAddressListRequest#builder()}
     * </p>
     *
     * @param getMemberOfAddressListRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.GetMemberOfAddressListRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetMemberOfAddressList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.GetMemberOfAddressList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetMemberOfAddressList"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMemberOfAddressListResponse> getMemberOfAddressList(
            Consumer<GetMemberOfAddressListRequest.Builder> getMemberOfAddressListRequest) {
        return getMemberOfAddressList(GetMemberOfAddressListRequest.builder().applyMutation(getMemberOfAddressListRequest)
                .build());
    }

    /**
     * <p>
     * Fetch the relay resource and it's attributes.
     * </p>
     *
     * @param getRelayRequest
     * @return A Java Future containing the result of the GetRelay operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.GetRelay
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetRelay" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRelayResponse> getRelay(GetRelayRequest getRelayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Fetch the relay resource and it's attributes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRelayRequest.Builder} avoiding the need to
     * create one manually via {@link GetRelayRequest#builder()}
     * </p>
     *
     * @param getRelayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.GetRelayRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetRelay operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.GetRelay
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetRelay" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRelayResponse> getRelay(Consumer<GetRelayRequest.Builder> getRelayRequest) {
        return getRelay(GetRelayRequest.builder().applyMutation(getRelayRequest).build());
    }

    /**
     * <p>
     * Fetch attributes of a rule set.
     * </p>
     *
     * @param getRuleSetRequest
     * @return A Java Future containing the result of the GetRuleSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.GetRuleSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetRuleSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRuleSetResponse> getRuleSet(GetRuleSetRequest getRuleSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Fetch attributes of a rule set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRuleSetRequest.Builder} avoiding the need to
     * create one manually via {@link GetRuleSetRequest#builder()}
     * </p>
     *
     * @param getRuleSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.GetRuleSetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetRuleSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.GetRuleSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetRuleSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRuleSetResponse> getRuleSet(Consumer<GetRuleSetRequest.Builder> getRuleSetRequest) {
        return getRuleSet(GetRuleSetRequest.builder().applyMutation(getRuleSetRequest).build());
    }

    /**
     * <p>
     * Fetch attributes of a traffic policy resource.
     * </p>
     *
     * @param getTrafficPolicyRequest
     * @return A Java Future containing the result of the GetTrafficPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.GetTrafficPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetTrafficPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetTrafficPolicyResponse> getTrafficPolicy(GetTrafficPolicyRequest getTrafficPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Fetch attributes of a traffic policy resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTrafficPolicyRequest.Builder} avoiding the need
     * to create one manually via {@link GetTrafficPolicyRequest#builder()}
     * </p>
     *
     * @param getTrafficPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.GetTrafficPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetTrafficPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.GetTrafficPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetTrafficPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetTrafficPolicyResponse> getTrafficPolicy(
            Consumer<GetTrafficPolicyRequest.Builder> getTrafficPolicyRequest) {
        return getTrafficPolicy(GetTrafficPolicyRequest.builder().applyMutation(getTrafficPolicyRequest).build());
    }

    /**
     * <p>
     * Lists all Add On instances in your account.
     * </p>
     *
     * @param listAddonInstancesRequest
     * @return A Java Future containing the result of the ListAddonInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.ListAddonInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListAddonInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAddonInstancesResponse> listAddonInstances(ListAddonInstancesRequest listAddonInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all Add On instances in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAddonInstancesRequest.Builder} avoiding the
     * need to create one manually via {@link ListAddonInstancesRequest#builder()}
     * </p>
     *
     * @param listAddonInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.ListAddonInstancesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListAddonInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.ListAddonInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListAddonInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAddonInstancesResponse> listAddonInstances(
            Consumer<ListAddonInstancesRequest.Builder> listAddonInstancesRequest) {
        return listAddonInstances(ListAddonInstancesRequest.builder().applyMutation(listAddonInstancesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAddonInstances(software.amazon.awssdk.services.mailmanager.model.ListAddonInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListAddonInstancesPublisher publisher = client.listAddonInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListAddonInstancesPublisher publisher = client.listAddonInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mailmanager.model.ListAddonInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mailmanager.model.ListAddonInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAddonInstances(software.amazon.awssdk.services.mailmanager.model.ListAddonInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAddonInstancesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.ListAddonInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListAddonInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAddonInstancesPublisher listAddonInstancesPaginator(ListAddonInstancesRequest listAddonInstancesRequest) {
        return new ListAddonInstancesPublisher(this, listAddonInstancesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAddonInstances(software.amazon.awssdk.services.mailmanager.model.ListAddonInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListAddonInstancesPublisher publisher = client.listAddonInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListAddonInstancesPublisher publisher = client.listAddonInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mailmanager.model.ListAddonInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mailmanager.model.ListAddonInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAddonInstances(software.amazon.awssdk.services.mailmanager.model.ListAddonInstancesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAddonInstancesRequest.Builder} avoiding the
     * need to create one manually via {@link ListAddonInstancesRequest#builder()}
     * </p>
     *
     * @param listAddonInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.ListAddonInstancesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.ListAddonInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListAddonInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAddonInstancesPublisher listAddonInstancesPaginator(
            Consumer<ListAddonInstancesRequest.Builder> listAddonInstancesRequest) {
        return listAddonInstancesPaginator(ListAddonInstancesRequest.builder().applyMutation(listAddonInstancesRequest).build());
    }

    /**
     * <p>
     * Lists all Add On subscriptions in your account.
     * </p>
     *
     * @param listAddonSubscriptionsRequest
     * @return A Java Future containing the result of the ListAddonSubscriptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.ListAddonSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListAddonSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAddonSubscriptionsResponse> listAddonSubscriptions(
            ListAddonSubscriptionsRequest listAddonSubscriptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all Add On subscriptions in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAddonSubscriptionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAddonSubscriptionsRequest#builder()}
     * </p>
     *
     * @param listAddonSubscriptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.ListAddonSubscriptionsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListAddonSubscriptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.ListAddonSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListAddonSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAddonSubscriptionsResponse> listAddonSubscriptions(
            Consumer<ListAddonSubscriptionsRequest.Builder> listAddonSubscriptionsRequest) {
        return listAddonSubscriptions(ListAddonSubscriptionsRequest.builder().applyMutation(listAddonSubscriptionsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAddonSubscriptions(software.amazon.awssdk.services.mailmanager.model.ListAddonSubscriptionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListAddonSubscriptionsPublisher publisher = client.listAddonSubscriptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListAddonSubscriptionsPublisher publisher = client.listAddonSubscriptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mailmanager.model.ListAddonSubscriptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mailmanager.model.ListAddonSubscriptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAddonSubscriptions(software.amazon.awssdk.services.mailmanager.model.ListAddonSubscriptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAddonSubscriptionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.ListAddonSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListAddonSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAddonSubscriptionsPublisher listAddonSubscriptionsPaginator(
            ListAddonSubscriptionsRequest listAddonSubscriptionsRequest) {
        return new ListAddonSubscriptionsPublisher(this, listAddonSubscriptionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAddonSubscriptions(software.amazon.awssdk.services.mailmanager.model.ListAddonSubscriptionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListAddonSubscriptionsPublisher publisher = client.listAddonSubscriptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListAddonSubscriptionsPublisher publisher = client.listAddonSubscriptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mailmanager.model.ListAddonSubscriptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mailmanager.model.ListAddonSubscriptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAddonSubscriptions(software.amazon.awssdk.services.mailmanager.model.ListAddonSubscriptionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAddonSubscriptionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAddonSubscriptionsRequest#builder()}
     * </p>
     *
     * @param listAddonSubscriptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.ListAddonSubscriptionsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.ListAddonSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListAddonSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAddonSubscriptionsPublisher listAddonSubscriptionsPaginator(
            Consumer<ListAddonSubscriptionsRequest.Builder> listAddonSubscriptionsRequest) {
        return listAddonSubscriptionsPaginator(ListAddonSubscriptionsRequest.builder()
                .applyMutation(listAddonSubscriptionsRequest).build());
    }

    /**
     * <p>
     * Lists jobs for an address list.
     * </p>
     *
     * @param listAddressListImportJobsRequest
     * @return A Java Future containing the result of the ListAddressListImportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.ListAddressListImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListAddressListImportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAddressListImportJobsResponse> listAddressListImportJobs(
            ListAddressListImportJobsRequest listAddressListImportJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists jobs for an address list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAddressListImportJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListAddressListImportJobsRequest#builder()}
     * </p>
     *
     * @param listAddressListImportJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.ListAddressListImportJobsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListAddressListImportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.ListAddressListImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListAddressListImportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAddressListImportJobsResponse> listAddressListImportJobs(
            Consumer<ListAddressListImportJobsRequest.Builder> listAddressListImportJobsRequest) {
        return listAddressListImportJobs(ListAddressListImportJobsRequest.builder()
                .applyMutation(listAddressListImportJobsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAddressListImportJobs(software.amazon.awssdk.services.mailmanager.model.ListAddressListImportJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListAddressListImportJobsPublisher publisher = client.listAddressListImportJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListAddressListImportJobsPublisher publisher = client.listAddressListImportJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mailmanager.model.ListAddressListImportJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mailmanager.model.ListAddressListImportJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAddressListImportJobs(software.amazon.awssdk.services.mailmanager.model.ListAddressListImportJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAddressListImportJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.ListAddressListImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListAddressListImportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAddressListImportJobsPublisher listAddressListImportJobsPaginator(
            ListAddressListImportJobsRequest listAddressListImportJobsRequest) {
        return new ListAddressListImportJobsPublisher(this, listAddressListImportJobsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAddressListImportJobs(software.amazon.awssdk.services.mailmanager.model.ListAddressListImportJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListAddressListImportJobsPublisher publisher = client.listAddressListImportJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListAddressListImportJobsPublisher publisher = client.listAddressListImportJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mailmanager.model.ListAddressListImportJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mailmanager.model.ListAddressListImportJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAddressListImportJobs(software.amazon.awssdk.services.mailmanager.model.ListAddressListImportJobsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAddressListImportJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListAddressListImportJobsRequest#builder()}
     * </p>
     *
     * @param listAddressListImportJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.ListAddressListImportJobsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.ListAddressListImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListAddressListImportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAddressListImportJobsPublisher listAddressListImportJobsPaginator(
            Consumer<ListAddressListImportJobsRequest.Builder> listAddressListImportJobsRequest) {
        return listAddressListImportJobsPaginator(ListAddressListImportJobsRequest.builder()
                .applyMutation(listAddressListImportJobsRequest).build());
    }

    /**
     * <p>
     * Lists address lists for this account.
     * </p>
     *
     * @param listAddressListsRequest
     * @return A Java Future containing the result of the ListAddressLists operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.ListAddressLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListAddressLists" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListAddressListsResponse> listAddressLists(ListAddressListsRequest listAddressListsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists address lists for this account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAddressListsRequest.Builder} avoiding the need
     * to create one manually via {@link ListAddressListsRequest#builder()}
     * </p>
     *
     * @param listAddressListsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.ListAddressListsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListAddressLists operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.ListAddressLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListAddressLists" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListAddressListsResponse> listAddressLists(
            Consumer<ListAddressListsRequest.Builder> listAddressListsRequest) {
        return listAddressLists(ListAddressListsRequest.builder().applyMutation(listAddressListsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAddressLists(software.amazon.awssdk.services.mailmanager.model.ListAddressListsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListAddressListsPublisher publisher = client.listAddressListsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListAddressListsPublisher publisher = client.listAddressListsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mailmanager.model.ListAddressListsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mailmanager.model.ListAddressListsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAddressLists(software.amazon.awssdk.services.mailmanager.model.ListAddressListsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAddressListsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.ListAddressLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListAddressLists" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAddressListsPublisher listAddressListsPaginator(ListAddressListsRequest listAddressListsRequest) {
        return new ListAddressListsPublisher(this, listAddressListsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAddressLists(software.amazon.awssdk.services.mailmanager.model.ListAddressListsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListAddressListsPublisher publisher = client.listAddressListsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListAddressListsPublisher publisher = client.listAddressListsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mailmanager.model.ListAddressListsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mailmanager.model.ListAddressListsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAddressLists(software.amazon.awssdk.services.mailmanager.model.ListAddressListsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAddressListsRequest.Builder} avoiding the need
     * to create one manually via {@link ListAddressListsRequest#builder()}
     * </p>
     *
     * @param listAddressListsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.ListAddressListsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.ListAddressLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListAddressLists" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAddressListsPublisher listAddressListsPaginator(Consumer<ListAddressListsRequest.Builder> listAddressListsRequest) {
        return listAddressListsPaginator(ListAddressListsRequest.builder().applyMutation(listAddressListsRequest).build());
    }

    /**
     * <p>
     * Returns a list of email archive export jobs.
     * </p>
     *
     * @param listArchiveExportsRequest
     *        The request to list archive export jobs in your account.
     * @return A Java Future containing the result of the ListArchiveExports operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.ListArchiveExports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListArchiveExports"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListArchiveExportsResponse> listArchiveExports(ListArchiveExportsRequest listArchiveExportsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of email archive export jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListArchiveExportsRequest.Builder} avoiding the
     * need to create one manually via {@link ListArchiveExportsRequest#builder()}
     * </p>
     *
     * @param listArchiveExportsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.ListArchiveExportsRequest.Builder} to create a
     *        request. The request to list archive export jobs in your account.
     * @return A Java Future containing the result of the ListArchiveExports operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.ListArchiveExports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListArchiveExports"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListArchiveExportsResponse> listArchiveExports(
            Consumer<ListArchiveExportsRequest.Builder> listArchiveExportsRequest) {
        return listArchiveExports(ListArchiveExportsRequest.builder().applyMutation(listArchiveExportsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listArchiveExports(software.amazon.awssdk.services.mailmanager.model.ListArchiveExportsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListArchiveExportsPublisher publisher = client.listArchiveExportsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListArchiveExportsPublisher publisher = client.listArchiveExportsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mailmanager.model.ListArchiveExportsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mailmanager.model.ListArchiveExportsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listArchiveExports(software.amazon.awssdk.services.mailmanager.model.ListArchiveExportsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listArchiveExportsRequest
     *        The request to list archive export jobs in your account.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.ListArchiveExports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListArchiveExports"
     *      target="_top">AWS API Documentation</a>
     */
    default ListArchiveExportsPublisher listArchiveExportsPaginator(ListArchiveExportsRequest listArchiveExportsRequest) {
        return new ListArchiveExportsPublisher(this, listArchiveExportsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listArchiveExports(software.amazon.awssdk.services.mailmanager.model.ListArchiveExportsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListArchiveExportsPublisher publisher = client.listArchiveExportsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListArchiveExportsPublisher publisher = client.listArchiveExportsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mailmanager.model.ListArchiveExportsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mailmanager.model.ListArchiveExportsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listArchiveExports(software.amazon.awssdk.services.mailmanager.model.ListArchiveExportsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListArchiveExportsRequest.Builder} avoiding the
     * need to create one manually via {@link ListArchiveExportsRequest#builder()}
     * </p>
     *
     * @param listArchiveExportsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.ListArchiveExportsRequest.Builder} to create a
     *        request. The request to list archive export jobs in your account.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.ListArchiveExports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListArchiveExports"
     *      target="_top">AWS API Documentation</a>
     */
    default ListArchiveExportsPublisher listArchiveExportsPaginator(
            Consumer<ListArchiveExportsRequest.Builder> listArchiveExportsRequest) {
        return listArchiveExportsPaginator(ListArchiveExportsRequest.builder().applyMutation(listArchiveExportsRequest).build());
    }

    /**
     * <p>
     * Returns a list of email archive search jobs.
     * </p>
     *
     * @param listArchiveSearchesRequest
     *        The request to list archive search jobs in your account.
     * @return A Java Future containing the result of the ListArchiveSearches operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.ListArchiveSearches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListArchiveSearches"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListArchiveSearchesResponse> listArchiveSearches(
            ListArchiveSearchesRequest listArchiveSearchesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of email archive search jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListArchiveSearchesRequest.Builder} avoiding the
     * need to create one manually via {@link ListArchiveSearchesRequest#builder()}
     * </p>
     *
     * @param listArchiveSearchesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.ListArchiveSearchesRequest.Builder} to create a
     *        request. The request to list archive search jobs in your account.
     * @return A Java Future containing the result of the ListArchiveSearches operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.ListArchiveSearches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListArchiveSearches"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListArchiveSearchesResponse> listArchiveSearches(
            Consumer<ListArchiveSearchesRequest.Builder> listArchiveSearchesRequest) {
        return listArchiveSearches(ListArchiveSearchesRequest.builder().applyMutation(listArchiveSearchesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listArchiveSearches(software.amazon.awssdk.services.mailmanager.model.ListArchiveSearchesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListArchiveSearchesPublisher publisher = client.listArchiveSearchesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListArchiveSearchesPublisher publisher = client.listArchiveSearchesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mailmanager.model.ListArchiveSearchesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mailmanager.model.ListArchiveSearchesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listArchiveSearches(software.amazon.awssdk.services.mailmanager.model.ListArchiveSearchesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listArchiveSearchesRequest
     *        The request to list archive search jobs in your account.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.ListArchiveSearches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListArchiveSearches"
     *      target="_top">AWS API Documentation</a>
     */
    default ListArchiveSearchesPublisher listArchiveSearchesPaginator(ListArchiveSearchesRequest listArchiveSearchesRequest) {
        return new ListArchiveSearchesPublisher(this, listArchiveSearchesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listArchiveSearches(software.amazon.awssdk.services.mailmanager.model.ListArchiveSearchesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListArchiveSearchesPublisher publisher = client.listArchiveSearchesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListArchiveSearchesPublisher publisher = client.listArchiveSearchesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mailmanager.model.ListArchiveSearchesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mailmanager.model.ListArchiveSearchesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listArchiveSearches(software.amazon.awssdk.services.mailmanager.model.ListArchiveSearchesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListArchiveSearchesRequest.Builder} avoiding the
     * need to create one manually via {@link ListArchiveSearchesRequest#builder()}
     * </p>
     *
     * @param listArchiveSearchesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.ListArchiveSearchesRequest.Builder} to create a
     *        request. The request to list archive search jobs in your account.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.ListArchiveSearches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListArchiveSearches"
     *      target="_top">AWS API Documentation</a>
     */
    default ListArchiveSearchesPublisher listArchiveSearchesPaginator(
            Consumer<ListArchiveSearchesRequest.Builder> listArchiveSearchesRequest) {
        return listArchiveSearchesPaginator(ListArchiveSearchesRequest.builder().applyMutation(listArchiveSearchesRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of all email archives in your account.
     * </p>
     *
     * @param listArchivesRequest
     *        The request to list email archives in your account.
     * @return A Java Future containing the result of the ListArchives operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.ListArchives
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListArchives" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListArchivesResponse> listArchives(ListArchivesRequest listArchivesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all email archives in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListArchivesRequest.Builder} avoiding the need to
     * create one manually via {@link ListArchivesRequest#builder()}
     * </p>
     *
     * @param listArchivesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.ListArchivesRequest.Builder} to create a request.
     *        The request to list email archives in your account.
     * @return A Java Future containing the result of the ListArchives operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.ListArchives
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListArchives" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListArchivesResponse> listArchives(Consumer<ListArchivesRequest.Builder> listArchivesRequest) {
        return listArchives(ListArchivesRequest.builder().applyMutation(listArchivesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listArchives(software.amazon.awssdk.services.mailmanager.model.ListArchivesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListArchivesPublisher publisher = client.listArchivesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListArchivesPublisher publisher = client.listArchivesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mailmanager.model.ListArchivesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mailmanager.model.ListArchivesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listArchives(software.amazon.awssdk.services.mailmanager.model.ListArchivesRequest)} operation.</b>
     * </p>
     *
     * @param listArchivesRequest
     *        The request to list email archives in your account.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.ListArchives
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListArchives" target="_top">AWS API
     *      Documentation</a>
     */
    default ListArchivesPublisher listArchivesPaginator(ListArchivesRequest listArchivesRequest) {
        return new ListArchivesPublisher(this, listArchivesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listArchives(software.amazon.awssdk.services.mailmanager.model.ListArchivesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListArchivesPublisher publisher = client.listArchivesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListArchivesPublisher publisher = client.listArchivesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mailmanager.model.ListArchivesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mailmanager.model.ListArchivesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listArchives(software.amazon.awssdk.services.mailmanager.model.ListArchivesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListArchivesRequest.Builder} avoiding the need to
     * create one manually via {@link ListArchivesRequest#builder()}
     * </p>
     *
     * @param listArchivesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.ListArchivesRequest.Builder} to create a request.
     *        The request to list email archives in your account.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.ListArchives
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListArchives" target="_top">AWS API
     *      Documentation</a>
     */
    default ListArchivesPublisher listArchivesPaginator(Consumer<ListArchivesRequest.Builder> listArchivesRequest) {
        return listArchivesPaginator(ListArchivesRequest.builder().applyMutation(listArchivesRequest).build());
    }

    /**
     * <p>
     * List all ingress endpoint resources.
     * </p>
     *
     * @param listIngressPointsRequest
     * @return A Java Future containing the result of the ListIngressPoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.ListIngressPoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListIngressPoints" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListIngressPointsResponse> listIngressPoints(ListIngressPointsRequest listIngressPointsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all ingress endpoint resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIngressPointsRequest.Builder} avoiding the need
     * to create one manually via {@link ListIngressPointsRequest#builder()}
     * </p>
     *
     * @param listIngressPointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.ListIngressPointsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListIngressPoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.ListIngressPoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListIngressPoints" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListIngressPointsResponse> listIngressPoints(
            Consumer<ListIngressPointsRequest.Builder> listIngressPointsRequest) {
        return listIngressPoints(ListIngressPointsRequest.builder().applyMutation(listIngressPointsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listIngressPoints(software.amazon.awssdk.services.mailmanager.model.ListIngressPointsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListIngressPointsPublisher publisher = client.listIngressPointsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListIngressPointsPublisher publisher = client.listIngressPointsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mailmanager.model.ListIngressPointsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mailmanager.model.ListIngressPointsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIngressPoints(software.amazon.awssdk.services.mailmanager.model.ListIngressPointsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listIngressPointsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.ListIngressPoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListIngressPoints" target="_top">AWS
     *      API Documentation</a>
     */
    default ListIngressPointsPublisher listIngressPointsPaginator(ListIngressPointsRequest listIngressPointsRequest) {
        return new ListIngressPointsPublisher(this, listIngressPointsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listIngressPoints(software.amazon.awssdk.services.mailmanager.model.ListIngressPointsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListIngressPointsPublisher publisher = client.listIngressPointsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListIngressPointsPublisher publisher = client.listIngressPointsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mailmanager.model.ListIngressPointsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mailmanager.model.ListIngressPointsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIngressPoints(software.amazon.awssdk.services.mailmanager.model.ListIngressPointsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIngressPointsRequest.Builder} avoiding the need
     * to create one manually via {@link ListIngressPointsRequest#builder()}
     * </p>
     *
     * @param listIngressPointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.ListIngressPointsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.ListIngressPoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListIngressPoints" target="_top">AWS
     *      API Documentation</a>
     */
    default ListIngressPointsPublisher listIngressPointsPaginator(
            Consumer<ListIngressPointsRequest.Builder> listIngressPointsRequest) {
        return listIngressPointsPaginator(ListIngressPointsRequest.builder().applyMutation(listIngressPointsRequest).build());
    }

    /**
     * <p>
     * Lists members of an address list.
     * </p>
     *
     * @param listMembersOfAddressListRequest
     * @return A Java Future containing the result of the ListMembersOfAddressList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.ListMembersOfAddressList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListMembersOfAddressList"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMembersOfAddressListResponse> listMembersOfAddressList(
            ListMembersOfAddressListRequest listMembersOfAddressListRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists members of an address list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMembersOfAddressListRequest.Builder} avoiding
     * the need to create one manually via {@link ListMembersOfAddressListRequest#builder()}
     * </p>
     *
     * @param listMembersOfAddressListRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.ListMembersOfAddressListRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListMembersOfAddressList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.ListMembersOfAddressList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListMembersOfAddressList"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMembersOfAddressListResponse> listMembersOfAddressList(
            Consumer<ListMembersOfAddressListRequest.Builder> listMembersOfAddressListRequest) {
        return listMembersOfAddressList(ListMembersOfAddressListRequest.builder().applyMutation(listMembersOfAddressListRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMembersOfAddressList(software.amazon.awssdk.services.mailmanager.model.ListMembersOfAddressListRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListMembersOfAddressListPublisher publisher = client.listMembersOfAddressListPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListMembersOfAddressListPublisher publisher = client.listMembersOfAddressListPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mailmanager.model.ListMembersOfAddressListResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mailmanager.model.ListMembersOfAddressListResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMembersOfAddressList(software.amazon.awssdk.services.mailmanager.model.ListMembersOfAddressListRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMembersOfAddressListRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.ListMembersOfAddressList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListMembersOfAddressList"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMembersOfAddressListPublisher listMembersOfAddressListPaginator(
            ListMembersOfAddressListRequest listMembersOfAddressListRequest) {
        return new ListMembersOfAddressListPublisher(this, listMembersOfAddressListRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMembersOfAddressList(software.amazon.awssdk.services.mailmanager.model.ListMembersOfAddressListRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListMembersOfAddressListPublisher publisher = client.listMembersOfAddressListPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListMembersOfAddressListPublisher publisher = client.listMembersOfAddressListPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mailmanager.model.ListMembersOfAddressListResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mailmanager.model.ListMembersOfAddressListResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMembersOfAddressList(software.amazon.awssdk.services.mailmanager.model.ListMembersOfAddressListRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMembersOfAddressListRequest.Builder} avoiding
     * the need to create one manually via {@link ListMembersOfAddressListRequest#builder()}
     * </p>
     *
     * @param listMembersOfAddressListRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.ListMembersOfAddressListRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.ListMembersOfAddressList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListMembersOfAddressList"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMembersOfAddressListPublisher listMembersOfAddressListPaginator(
            Consumer<ListMembersOfAddressListRequest.Builder> listMembersOfAddressListRequest) {
        return listMembersOfAddressListPaginator(ListMembersOfAddressListRequest.builder()
                .applyMutation(listMembersOfAddressListRequest).build());
    }

    /**
     * <p>
     * Lists all the existing relay resources.
     * </p>
     *
     * @param listRelaysRequest
     * @return A Java Future containing the result of the ListRelays operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.ListRelays
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListRelays" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRelaysResponse> listRelays(ListRelaysRequest listRelaysRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the existing relay resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRelaysRequest.Builder} avoiding the need to
     * create one manually via {@link ListRelaysRequest#builder()}
     * </p>
     *
     * @param listRelaysRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.ListRelaysRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListRelays operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.ListRelays
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListRelays" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRelaysResponse> listRelays(Consumer<ListRelaysRequest.Builder> listRelaysRequest) {
        return listRelays(ListRelaysRequest.builder().applyMutation(listRelaysRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listRelays(software.amazon.awssdk.services.mailmanager.model.ListRelaysRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListRelaysPublisher publisher = client.listRelaysPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListRelaysPublisher publisher = client.listRelaysPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mailmanager.model.ListRelaysResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mailmanager.model.ListRelaysResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRelays(software.amazon.awssdk.services.mailmanager.model.ListRelaysRequest)} operation.</b>
     * </p>
     *
     * @param listRelaysRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.ListRelays
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListRelays" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRelaysPublisher listRelaysPaginator(ListRelaysRequest listRelaysRequest) {
        return new ListRelaysPublisher(this, listRelaysRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listRelays(software.amazon.awssdk.services.mailmanager.model.ListRelaysRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListRelaysPublisher publisher = client.listRelaysPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListRelaysPublisher publisher = client.listRelaysPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mailmanager.model.ListRelaysResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mailmanager.model.ListRelaysResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRelays(software.amazon.awssdk.services.mailmanager.model.ListRelaysRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRelaysRequest.Builder} avoiding the need to
     * create one manually via {@link ListRelaysRequest#builder()}
     * </p>
     *
     * @param listRelaysRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.ListRelaysRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.ListRelays
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListRelays" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRelaysPublisher listRelaysPaginator(Consumer<ListRelaysRequest.Builder> listRelaysRequest) {
        return listRelaysPaginator(ListRelaysRequest.builder().applyMutation(listRelaysRequest).build());
    }

    /**
     * <p>
     * List rule sets for this account.
     * </p>
     *
     * @param listRuleSetsRequest
     * @return A Java Future containing the result of the ListRuleSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.ListRuleSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListRuleSets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRuleSetsResponse> listRuleSets(ListRuleSetsRequest listRuleSetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List rule sets for this account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRuleSetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListRuleSetsRequest#builder()}
     * </p>
     *
     * @param listRuleSetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.ListRuleSetsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListRuleSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.ListRuleSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListRuleSets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRuleSetsResponse> listRuleSets(Consumer<ListRuleSetsRequest.Builder> listRuleSetsRequest) {
        return listRuleSets(ListRuleSetsRequest.builder().applyMutation(listRuleSetsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listRuleSets(software.amazon.awssdk.services.mailmanager.model.ListRuleSetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListRuleSetsPublisher publisher = client.listRuleSetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListRuleSetsPublisher publisher = client.listRuleSetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mailmanager.model.ListRuleSetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mailmanager.model.ListRuleSetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRuleSets(software.amazon.awssdk.services.mailmanager.model.ListRuleSetsRequest)} operation.</b>
     * </p>
     *
     * @param listRuleSetsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.ListRuleSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListRuleSets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRuleSetsPublisher listRuleSetsPaginator(ListRuleSetsRequest listRuleSetsRequest) {
        return new ListRuleSetsPublisher(this, listRuleSetsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listRuleSets(software.amazon.awssdk.services.mailmanager.model.ListRuleSetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListRuleSetsPublisher publisher = client.listRuleSetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListRuleSetsPublisher publisher = client.listRuleSetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mailmanager.model.ListRuleSetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mailmanager.model.ListRuleSetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRuleSets(software.amazon.awssdk.services.mailmanager.model.ListRuleSetsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRuleSetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListRuleSetsRequest#builder()}
     * </p>
     *
     * @param listRuleSetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.ListRuleSetsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.ListRuleSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListRuleSets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRuleSetsPublisher listRuleSetsPaginator(Consumer<ListRuleSetsRequest.Builder> listRuleSetsRequest) {
        return listRuleSetsPaginator(ListRuleSetsRequest.builder().applyMutation(listRuleSetsRequest).build());
    }

    /**
     * <p>
     * Retrieves the list of tags (keys and values) assigned to the resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the list of tags (keys and values) assigned to the resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * List traffic policy resources.
     * </p>
     *
     * @param listTrafficPoliciesRequest
     * @return A Java Future containing the result of the ListTrafficPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.ListTrafficPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListTrafficPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTrafficPoliciesResponse> listTrafficPolicies(
            ListTrafficPoliciesRequest listTrafficPoliciesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List traffic policy resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTrafficPoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link ListTrafficPoliciesRequest#builder()}
     * </p>
     *
     * @param listTrafficPoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.ListTrafficPoliciesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTrafficPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.ListTrafficPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListTrafficPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTrafficPoliciesResponse> listTrafficPolicies(
            Consumer<ListTrafficPoliciesRequest.Builder> listTrafficPoliciesRequest) {
        return listTrafficPolicies(ListTrafficPoliciesRequest.builder().applyMutation(listTrafficPoliciesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTrafficPolicies(software.amazon.awssdk.services.mailmanager.model.ListTrafficPoliciesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListTrafficPoliciesPublisher publisher = client.listTrafficPoliciesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListTrafficPoliciesPublisher publisher = client.listTrafficPoliciesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mailmanager.model.ListTrafficPoliciesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mailmanager.model.ListTrafficPoliciesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTrafficPolicies(software.amazon.awssdk.services.mailmanager.model.ListTrafficPoliciesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTrafficPoliciesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.ListTrafficPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListTrafficPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTrafficPoliciesPublisher listTrafficPoliciesPaginator(ListTrafficPoliciesRequest listTrafficPoliciesRequest) {
        return new ListTrafficPoliciesPublisher(this, listTrafficPoliciesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTrafficPolicies(software.amazon.awssdk.services.mailmanager.model.ListTrafficPoliciesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListTrafficPoliciesPublisher publisher = client.listTrafficPoliciesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListTrafficPoliciesPublisher publisher = client.listTrafficPoliciesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mailmanager.model.ListTrafficPoliciesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mailmanager.model.ListTrafficPoliciesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTrafficPolicies(software.amazon.awssdk.services.mailmanager.model.ListTrafficPoliciesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTrafficPoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link ListTrafficPoliciesRequest#builder()}
     * </p>
     *
     * @param listTrafficPoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.ListTrafficPoliciesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.ListTrafficPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListTrafficPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTrafficPoliciesPublisher listTrafficPoliciesPaginator(
            Consumer<ListTrafficPoliciesRequest.Builder> listTrafficPoliciesRequest) {
        return listTrafficPoliciesPaginator(ListTrafficPoliciesRequest.builder().applyMutation(listTrafficPoliciesRequest)
                .build());
    }

    /**
     * <p>
     * Adds a member to an address list.
     * </p>
     *
     * @param registerMemberToAddressListRequest
     * @return A Java Future containing the result of the RegisterMemberToAddressList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ServiceQuotaExceededException Occurs when an operation exceeds a predefined service quota or limit.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.RegisterMemberToAddressList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/RegisterMemberToAddressList"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RegisterMemberToAddressListResponse> registerMemberToAddressList(
            RegisterMemberToAddressListRequest registerMemberToAddressListRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a member to an address list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterMemberToAddressListRequest.Builder}
     * avoiding the need to create one manually via {@link RegisterMemberToAddressListRequest#builder()}
     * </p>
     *
     * @param registerMemberToAddressListRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.RegisterMemberToAddressListRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the RegisterMemberToAddressList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ServiceQuotaExceededException Occurs when an operation exceeds a predefined service quota or limit.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.RegisterMemberToAddressList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/RegisterMemberToAddressList"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RegisterMemberToAddressListResponse> registerMemberToAddressList(
            Consumer<RegisterMemberToAddressListRequest.Builder> registerMemberToAddressListRequest) {
        return registerMemberToAddressList(RegisterMemberToAddressListRequest.builder()
                .applyMutation(registerMemberToAddressListRequest).build());
    }

    /**
     * <p>
     * Starts an import job for an address list.
     * </p>
     *
     * @param startAddressListImportJobRequest
     * @return A Java Future containing the result of the StartAddressListImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ServiceQuotaExceededException Occurs when an operation exceeds a predefined service quota or limit.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.StartAddressListImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/StartAddressListImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartAddressListImportJobResponse> startAddressListImportJob(
            StartAddressListImportJobRequest startAddressListImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an import job for an address list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartAddressListImportJobRequest.Builder} avoiding
     * the need to create one manually via {@link StartAddressListImportJobRequest#builder()}
     * </p>
     *
     * @param startAddressListImportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.StartAddressListImportJobRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the StartAddressListImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ServiceQuotaExceededException Occurs when an operation exceeds a predefined service quota or limit.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.StartAddressListImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/StartAddressListImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartAddressListImportJobResponse> startAddressListImportJob(
            Consumer<StartAddressListImportJobRequest.Builder> startAddressListImportJobRequest) {
        return startAddressListImportJob(StartAddressListImportJobRequest.builder()
                .applyMutation(startAddressListImportJobRequest).build());
    }

    /**
     * <p>
     * Initiates an export of emails from the specified archive.
     * </p>
     *
     * @param startArchiveExportRequest
     *        The request to initiate an export of emails from an archive.
     * @return A Java Future containing the result of the StartArchiveExport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ServiceQuotaExceededException Occurs when an operation exceeds a predefined service quota or limit.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.StartArchiveExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/StartArchiveExport"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartArchiveExportResponse> startArchiveExport(StartArchiveExportRequest startArchiveExportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Initiates an export of emails from the specified archive.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartArchiveExportRequest.Builder} avoiding the
     * need to create one manually via {@link StartArchiveExportRequest#builder()}
     * </p>
     *
     * @param startArchiveExportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.StartArchiveExportRequest.Builder} to create a
     *        request. The request to initiate an export of emails from an archive.
     * @return A Java Future containing the result of the StartArchiveExport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ServiceQuotaExceededException Occurs when an operation exceeds a predefined service quota or limit.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.StartArchiveExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/StartArchiveExport"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartArchiveExportResponse> startArchiveExport(
            Consumer<StartArchiveExportRequest.Builder> startArchiveExportRequest) {
        return startArchiveExport(StartArchiveExportRequest.builder().applyMutation(startArchiveExportRequest).build());
    }

    /**
     * <p>
     * Initiates a search across emails in the specified archive.
     * </p>
     *
     * @param startArchiveSearchRequest
     *        The request to initiate a search across emails in an archive.
     * @return A Java Future containing the result of the StartArchiveSearch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ServiceQuotaExceededException Occurs when an operation exceeds a predefined service quota or limit.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.StartArchiveSearch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/StartArchiveSearch"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartArchiveSearchResponse> startArchiveSearch(StartArchiveSearchRequest startArchiveSearchRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Initiates a search across emails in the specified archive.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartArchiveSearchRequest.Builder} avoiding the
     * need to create one manually via {@link StartArchiveSearchRequest#builder()}
     * </p>
     *
     * @param startArchiveSearchRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.StartArchiveSearchRequest.Builder} to create a
     *        request. The request to initiate a search across emails in an archive.
     * @return A Java Future containing the result of the StartArchiveSearch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ServiceQuotaExceededException Occurs when an operation exceeds a predefined service quota or limit.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.StartArchiveSearch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/StartArchiveSearch"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartArchiveSearchResponse> startArchiveSearch(
            Consumer<StartArchiveSearchRequest.Builder> startArchiveSearchRequest) {
        return startArchiveSearch(StartArchiveSearchRequest.builder().applyMutation(startArchiveSearchRequest).build());
    }

    /**
     * <p>
     * Stops an ongoing import job for an address list.
     * </p>
     *
     * @param stopAddressListImportJobRequest
     * @return A Java Future containing the result of the StopAddressListImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.StopAddressListImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/StopAddressListImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopAddressListImportJobResponse> stopAddressListImportJob(
            StopAddressListImportJobRequest stopAddressListImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops an ongoing import job for an address list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopAddressListImportJobRequest.Builder} avoiding
     * the need to create one manually via {@link StopAddressListImportJobRequest#builder()}
     * </p>
     *
     * @param stopAddressListImportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.StopAddressListImportJobRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the StopAddressListImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.StopAddressListImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/StopAddressListImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopAddressListImportJobResponse> stopAddressListImportJob(
            Consumer<StopAddressListImportJobRequest.Builder> stopAddressListImportJobRequest) {
        return stopAddressListImportJob(StopAddressListImportJobRequest.builder().applyMutation(stopAddressListImportJobRequest)
                .build());
    }

    /**
     * <p>
     * Stops an in-progress export of emails from an archive.
     * </p>
     *
     * @param stopArchiveExportRequest
     *        The request to stop an in-progress archive export job.
     * @return A Java Future containing the result of the StopArchiveExport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.StopArchiveExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/StopArchiveExport" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StopArchiveExportResponse> stopArchiveExport(StopArchiveExportRequest stopArchiveExportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops an in-progress export of emails from an archive.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopArchiveExportRequest.Builder} avoiding the need
     * to create one manually via {@link StopArchiveExportRequest#builder()}
     * </p>
     *
     * @param stopArchiveExportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.StopArchiveExportRequest.Builder} to create a
     *        request. The request to stop an in-progress archive export job.
     * @return A Java Future containing the result of the StopArchiveExport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.StopArchiveExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/StopArchiveExport" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StopArchiveExportResponse> stopArchiveExport(
            Consumer<StopArchiveExportRequest.Builder> stopArchiveExportRequest) {
        return stopArchiveExport(StopArchiveExportRequest.builder().applyMutation(stopArchiveExportRequest).build());
    }

    /**
     * <p>
     * Stops an in-progress archive search job.
     * </p>
     *
     * @param stopArchiveSearchRequest
     *        The request to stop an in-progress archive search job.
     * @return A Java Future containing the result of the StopArchiveSearch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.StopArchiveSearch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/StopArchiveSearch" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StopArchiveSearchResponse> stopArchiveSearch(StopArchiveSearchRequest stopArchiveSearchRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops an in-progress archive search job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopArchiveSearchRequest.Builder} avoiding the need
     * to create one manually via {@link StopArchiveSearchRequest#builder()}
     * </p>
     *
     * @param stopArchiveSearchRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.StopArchiveSearchRequest.Builder} to create a
     *        request. The request to stop an in-progress archive search job.
     * @return A Java Future containing the result of the StopArchiveSearch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.StopArchiveSearch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/StopArchiveSearch" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StopArchiveSearchResponse> stopArchiveSearch(
            Consumer<StopArchiveSearchRequest.Builder> stopArchiveSearchRequest) {
        return stopArchiveSearch(StopArchiveSearchRequest.builder().applyMutation(stopArchiveSearchRequest).build());
    }

    /**
     * <p>
     * Adds one or more tags (keys and values) to a specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>ServiceQuotaExceededException Occurs when an operation exceeds a predefined service quota or limit.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds one or more tags (keys and values) to a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>ServiceQuotaExceededException Occurs when an operation exceeds a predefined service quota or limit.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Remove one or more tags (keys and values) from a specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Remove one or more tags (keys and values) from a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the attributes of an existing email archive.
     * </p>
     *
     * @param updateArchiveRequest
     *        The request to update properties of an existing email archive.
     * @return A Java Future containing the result of the UpdateArchive operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ServiceQuotaExceededException Occurs when an operation exceeds a predefined service quota or limit.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.UpdateArchive
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/UpdateArchive" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateArchiveResponse> updateArchive(UpdateArchiveRequest updateArchiveRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the attributes of an existing email archive.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateArchiveRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateArchiveRequest#builder()}
     * </p>
     *
     * @param updateArchiveRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.UpdateArchiveRequest.Builder} to create a
     *        request. The request to update properties of an existing email archive.
     * @return A Java Future containing the result of the UpdateArchive operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>AccessDeniedException Occurs when a user is denied access to a specific resource or action.</li>
     *         <li>ServiceQuotaExceededException Occurs when an operation exceeds a predefined service quota or limit.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>ThrottlingException Occurs when a service's request rate limit is exceeded, resulting in throttling
     *         of further requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.UpdateArchive
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/UpdateArchive" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateArchiveResponse> updateArchive(Consumer<UpdateArchiveRequest.Builder> updateArchiveRequest) {
        return updateArchive(UpdateArchiveRequest.builder().applyMutation(updateArchiveRequest).build());
    }

    /**
     * <p>
     * Update attributes of a provisioned ingress endpoint resource.
     * </p>
     *
     * @param updateIngressPointRequest
     * @return A Java Future containing the result of the UpdateIngressPoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.UpdateIngressPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/UpdateIngressPoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateIngressPointResponse> updateIngressPoint(UpdateIngressPointRequest updateIngressPointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update attributes of a provisioned ingress endpoint resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateIngressPointRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateIngressPointRequest#builder()}
     * </p>
     *
     * @param updateIngressPointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.UpdateIngressPointRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateIngressPoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.UpdateIngressPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/UpdateIngressPoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateIngressPointResponse> updateIngressPoint(
            Consumer<UpdateIngressPointRequest.Builder> updateIngressPointRequest) {
        return updateIngressPoint(UpdateIngressPointRequest.builder().applyMutation(updateIngressPointRequest).build());
    }

    /**
     * <p>
     * Updates the attributes of an existing relay resource.
     * </p>
     *
     * @param updateRelayRequest
     * @return A Java Future containing the result of the UpdateRelay operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.UpdateRelay
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/UpdateRelay" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateRelayResponse> updateRelay(UpdateRelayRequest updateRelayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the attributes of an existing relay resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRelayRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateRelayRequest#builder()}
     * </p>
     *
     * @param updateRelayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.UpdateRelayRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateRelay operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.UpdateRelay
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/UpdateRelay" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateRelayResponse> updateRelay(Consumer<UpdateRelayRequest.Builder> updateRelayRequest) {
        return updateRelay(UpdateRelayRequest.builder().applyMutation(updateRelayRequest).build());
    }

    /**
     * <p>
     * Update attributes of an already provisioned rule set.
     * </p>
     *
     * @param updateRuleSetRequest
     * @return A Java Future containing the result of the UpdateRuleSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.UpdateRuleSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/UpdateRuleSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateRuleSetResponse> updateRuleSet(UpdateRuleSetRequest updateRuleSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update attributes of an already provisioned rule set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRuleSetRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateRuleSetRequest#builder()}
     * </p>
     *
     * @param updateRuleSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.UpdateRuleSetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateRuleSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.UpdateRuleSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/UpdateRuleSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateRuleSetResponse> updateRuleSet(Consumer<UpdateRuleSetRequest.Builder> updateRuleSetRequest) {
        return updateRuleSet(UpdateRuleSetRequest.builder().applyMutation(updateRuleSetRequest).build());
    }

    /**
     * <p>
     * Update attributes of an already provisioned traffic policy resource.
     * </p>
     *
     * @param updateTrafficPolicyRequest
     * @return A Java Future containing the result of the UpdateTrafficPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.UpdateTrafficPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/UpdateTrafficPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateTrafficPolicyResponse> updateTrafficPolicy(
            UpdateTrafficPolicyRequest updateTrafficPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update attributes of an already provisioned traffic policy resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTrafficPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateTrafficPolicyRequest#builder()}
     * </p>
     *
     * @param updateTrafficPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.UpdateTrafficPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateTrafficPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request validation has failed. For details, see the accompanying error
     *         message.</li>
     *         <li>ConflictException The request configuration has conflicts. For details, see the accompanying error
     *         message.</li>
     *         <li>ResourceNotFoundException Occurs when a requested resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MailManagerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MailManagerAsyncClient.UpdateTrafficPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/UpdateTrafficPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateTrafficPolicyResponse> updateTrafficPolicy(
            Consumer<UpdateTrafficPolicyRequest.Builder> updateTrafficPolicyRequest) {
        return updateTrafficPolicy(UpdateTrafficPolicyRequest.builder().applyMutation(updateTrafficPolicyRequest).build());
    }

    @Override
    default MailManagerServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link MailManagerAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static MailManagerAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link MailManagerAsyncClient}.
     */
    static MailManagerAsyncClientBuilder builder() {
        return new DefaultMailManagerAsyncClientBuilder();
    }
}
