/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Filtering options for ListMembersOfAddressList operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddressFilter implements SdkPojo, Serializable, ToCopyableBuilder<AddressFilter.Builder, AddressFilter> {
    private static final SdkField<String> ADDRESS_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AddressPrefix").getter(getter(AddressFilter::addressPrefix)).setter(setter(Builder::addressPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressPrefix").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDRESS_PREFIX_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String addressPrefix;

    private AddressFilter(BuilderImpl builder) {
        this.addressPrefix = builder.addressPrefix;
    }

    /**
     * <p>
     * Filter to limit the results to addresses having the provided prefix.
     * </p>
     * 
     * @return Filter to limit the results to addresses having the provided prefix.
     */
    public final String addressPrefix() {
        return addressPrefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(addressPrefix());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddressFilter)) {
            return false;
        }
        AddressFilter other = (AddressFilter) obj;
        return Objects.equals(addressPrefix(), other.addressPrefix());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AddressFilter")
                .add("AddressPrefix", addressPrefix() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AddressPrefix":
            return Optional.ofNullable(clazz.cast(addressPrefix()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AddressPrefix", ADDRESS_PREFIX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AddressFilter, T> g) {
        return obj -> g.apply((AddressFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AddressFilter> {
        /**
         * <p>
         * Filter to limit the results to addresses having the provided prefix.
         * </p>
         * 
         * @param addressPrefix
         *        Filter to limit the results to addresses having the provided prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressPrefix(String addressPrefix);
    }

    static final class BuilderImpl implements Builder {
        private String addressPrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(AddressFilter model) {
            addressPrefix(model.addressPrefix);
        }

        public final String getAddressPrefix() {
            return addressPrefix;
        }

        public final void setAddressPrefix(String addressPrefix) {
            this.addressPrefix = addressPrefix;
        }

        @Override
        public final Builder addressPrefix(String addressPrefix) {
            this.addressPrefix = addressPrefix;
            return this;
        }

        @Override
        public AddressFilter build() {
            return new AddressFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
