/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An address list contains a list of emails and domains that are used in MailManager Ingress endpoints and Rules for
 * email management.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddressList implements SdkPojo, Serializable, ToCopyableBuilder<AddressList.Builder, AddressList> {
    private static final SdkField<String> ADDRESS_LIST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AddressListId").getter(getter(AddressList::addressListId)).setter(setter(Builder::addressListId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressListId").build()).build();

    private static final SdkField<String> ADDRESS_LIST_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AddressListArn").getter(getter(AddressList::addressListArn)).setter(setter(Builder::addressListArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressListArn").build()).build();

    private static final SdkField<String> ADDRESS_LIST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AddressListName").getter(getter(AddressList::addressListName)).setter(setter(Builder::addressListName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressListName").build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp").getter(getter(AddressList::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTimestamp").getter(getter(AddressList::lastUpdatedTimestamp))
            .setter(setter(Builder::lastUpdatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTimestamp").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDRESS_LIST_ID_FIELD,
            ADDRESS_LIST_ARN_FIELD, ADDRESS_LIST_NAME_FIELD, CREATED_TIMESTAMP_FIELD, LAST_UPDATED_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String addressListId;

    private final String addressListArn;

    private final String addressListName;

    private final Instant createdTimestamp;

    private final Instant lastUpdatedTimestamp;

    private AddressList(BuilderImpl builder) {
        this.addressListId = builder.addressListId;
        this.addressListArn = builder.addressListArn;
        this.addressListName = builder.addressListName;
        this.createdTimestamp = builder.createdTimestamp;
        this.lastUpdatedTimestamp = builder.lastUpdatedTimestamp;
    }

    /**
     * <p>
     * The identifier of the address list.
     * </p>
     * 
     * @return The identifier of the address list.
     */
    public final String addressListId() {
        return addressListId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the address list.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the address list.
     */
    public final String addressListArn() {
        return addressListArn;
    }

    /**
     * <p>
     * The user-friendly name of the address list.
     * </p>
     * 
     * @return The user-friendly name of the address list.
     */
    public final String addressListName() {
        return addressListName;
    }

    /**
     * <p>
     * The timestamp of when the address list was created.
     * </p>
     * 
     * @return The timestamp of when the address list was created.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * The timestamp of when the address list was last updated.
     * </p>
     * 
     * @return The timestamp of when the address list was last updated.
     */
    public final Instant lastUpdatedTimestamp() {
        return lastUpdatedTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(addressListId());
        hashCode = 31 * hashCode + Objects.hashCode(addressListArn());
        hashCode = 31 * hashCode + Objects.hashCode(addressListName());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddressList)) {
            return false;
        }
        AddressList other = (AddressList) obj;
        return Objects.equals(addressListId(), other.addressListId()) && Objects.equals(addressListArn(), other.addressListArn())
                && Objects.equals(addressListName(), other.addressListName())
                && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(lastUpdatedTimestamp(), other.lastUpdatedTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AddressList").add("AddressListId", addressListId()).add("AddressListArn", addressListArn())
                .add("AddressListName", addressListName()).add("CreatedTimestamp", createdTimestamp())
                .add("LastUpdatedTimestamp", lastUpdatedTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AddressListId":
            return Optional.ofNullable(clazz.cast(addressListId()));
        case "AddressListArn":
            return Optional.ofNullable(clazz.cast(addressListArn()));
        case "AddressListName":
            return Optional.ofNullable(clazz.cast(addressListName()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "LastUpdatedTimestamp":
            return Optional.ofNullable(clazz.cast(lastUpdatedTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AddressListId", ADDRESS_LIST_ID_FIELD);
        map.put("AddressListArn", ADDRESS_LIST_ARN_FIELD);
        map.put("AddressListName", ADDRESS_LIST_NAME_FIELD);
        map.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
        map.put("LastUpdatedTimestamp", LAST_UPDATED_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AddressList, T> g) {
        return obj -> g.apply((AddressList) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AddressList> {
        /**
         * <p>
         * The identifier of the address list.
         * </p>
         * 
         * @param addressListId
         *        The identifier of the address list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressListId(String addressListId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the address list.
         * </p>
         * 
         * @param addressListArn
         *        The Amazon Resource Name (ARN) of the address list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressListArn(String addressListArn);

        /**
         * <p>
         * The user-friendly name of the address list.
         * </p>
         * 
         * @param addressListName
         *        The user-friendly name of the address list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressListName(String addressListName);

        /**
         * <p>
         * The timestamp of when the address list was created.
         * </p>
         * 
         * @param createdTimestamp
         *        The timestamp of when the address list was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * The timestamp of when the address list was last updated.
         * </p>
         * 
         * @param lastUpdatedTimestamp
         *        The timestamp of when the address list was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String addressListId;

        private String addressListArn;

        private String addressListName;

        private Instant createdTimestamp;

        private Instant lastUpdatedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(AddressList model) {
            addressListId(model.addressListId);
            addressListArn(model.addressListArn);
            addressListName(model.addressListName);
            createdTimestamp(model.createdTimestamp);
            lastUpdatedTimestamp(model.lastUpdatedTimestamp);
        }

        public final String getAddressListId() {
            return addressListId;
        }

        public final void setAddressListId(String addressListId) {
            this.addressListId = addressListId;
        }

        @Override
        public final Builder addressListId(String addressListId) {
            this.addressListId = addressListId;
            return this;
        }

        public final String getAddressListArn() {
            return addressListArn;
        }

        public final void setAddressListArn(String addressListArn) {
            this.addressListArn = addressListArn;
        }

        @Override
        public final Builder addressListArn(String addressListArn) {
            this.addressListArn = addressListArn;
            return this;
        }

        public final String getAddressListName() {
            return addressListName;
        }

        public final void setAddressListName(String addressListName) {
            this.addressListName = addressListName;
        }

        @Override
        public final Builder addressListName(String addressListName) {
            this.addressListName = addressListName;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getLastUpdatedTimestamp() {
            return lastUpdatedTimestamp;
        }

        public final void setLastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        }

        @Override
        public final Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
            return this;
        }

        @Override
        public AddressList build() {
            return new AddressList(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
