/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A boolean expression to evaluate email attribute values.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ArchiveBooleanExpression implements SdkPojo, Serializable,
        ToCopyableBuilder<ArchiveBooleanExpression.Builder, ArchiveBooleanExpression> {
    private static final SdkField<ArchiveBooleanToEvaluate> EVALUATE_FIELD = SdkField
            .<ArchiveBooleanToEvaluate> builder(MarshallingType.SDK_POJO).memberName("Evaluate")
            .getter(getter(ArchiveBooleanExpression::evaluate)).setter(setter(Builder::evaluate))
            .constructor(ArchiveBooleanToEvaluate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Evaluate").build()).build();

    private static final SdkField<String> OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Operator").getter(getter(ArchiveBooleanExpression::operatorAsString)).setter(setter(Builder::operator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operator").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(EVALUATE_FIELD, OPERATOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ArchiveBooleanToEvaluate evaluate;

    private final String operator;

    private ArchiveBooleanExpression(BuilderImpl builder) {
        this.evaluate = builder.evaluate;
        this.operator = builder.operator;
    }

    /**
     * <p>
     * The email attribute value to evaluate.
     * </p>
     * 
     * @return The email attribute value to evaluate.
     */
    public final ArchiveBooleanToEvaluate evaluate() {
        return evaluate;
    }

    /**
     * <p>
     * The boolean operator to use for evaluation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link ArchiveBooleanOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #operatorAsString}.
     * </p>
     * 
     * @return The boolean operator to use for evaluation.
     * @see ArchiveBooleanOperator
     */
    public final ArchiveBooleanOperator operator() {
        return ArchiveBooleanOperator.fromValue(operator);
    }

    /**
     * <p>
     * The boolean operator to use for evaluation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link ArchiveBooleanOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #operatorAsString}.
     * </p>
     * 
     * @return The boolean operator to use for evaluation.
     * @see ArchiveBooleanOperator
     */
    public final String operatorAsString() {
        return operator;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(evaluate());
        hashCode = 31 * hashCode + Objects.hashCode(operatorAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArchiveBooleanExpression)) {
            return false;
        }
        ArchiveBooleanExpression other = (ArchiveBooleanExpression) obj;
        return Objects.equals(evaluate(), other.evaluate()) && Objects.equals(operatorAsString(), other.operatorAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ArchiveBooleanExpression").add("Evaluate", evaluate()).add("Operator", operatorAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Evaluate":
            return Optional.ofNullable(clazz.cast(evaluate()));
        case "Operator":
            return Optional.ofNullable(clazz.cast(operatorAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Evaluate", EVALUATE_FIELD);
        map.put("Operator", OPERATOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ArchiveBooleanExpression, T> g) {
        return obj -> g.apply((ArchiveBooleanExpression) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ArchiveBooleanExpression> {
        /**
         * <p>
         * The email attribute value to evaluate.
         * </p>
         * 
         * @param evaluate
         *        The email attribute value to evaluate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluate(ArchiveBooleanToEvaluate evaluate);

        /**
         * <p>
         * The email attribute value to evaluate.
         * </p>
         * This is a convenience method that creates an instance of the {@link ArchiveBooleanToEvaluate.Builder}
         * avoiding the need to create one manually via {@link ArchiveBooleanToEvaluate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ArchiveBooleanToEvaluate.Builder#build()} is called immediately
         * and its result is passed to {@link #evaluate(ArchiveBooleanToEvaluate)}.
         * 
         * @param evaluate
         *        a consumer that will call methods on {@link ArchiveBooleanToEvaluate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #evaluate(ArchiveBooleanToEvaluate)
         */
        default Builder evaluate(Consumer<ArchiveBooleanToEvaluate.Builder> evaluate) {
            return evaluate(ArchiveBooleanToEvaluate.builder().applyMutation(evaluate).build());
        }

        /**
         * <p>
         * The boolean operator to use for evaluation.
         * </p>
         * 
         * @param operator
         *        The boolean operator to use for evaluation.
         * @see ArchiveBooleanOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArchiveBooleanOperator
         */
        Builder operator(String operator);

        /**
         * <p>
         * The boolean operator to use for evaluation.
         * </p>
         * 
         * @param operator
         *        The boolean operator to use for evaluation.
         * @see ArchiveBooleanOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArchiveBooleanOperator
         */
        Builder operator(ArchiveBooleanOperator operator);
    }

    static final class BuilderImpl implements Builder {
        private ArchiveBooleanToEvaluate evaluate;

        private String operator;

        private BuilderImpl() {
        }

        private BuilderImpl(ArchiveBooleanExpression model) {
            evaluate(model.evaluate);
            operator(model.operator);
        }

        public final ArchiveBooleanToEvaluate.Builder getEvaluate() {
            return evaluate != null ? evaluate.toBuilder() : null;
        }

        public final void setEvaluate(ArchiveBooleanToEvaluate.BuilderImpl evaluate) {
            this.evaluate = evaluate != null ? evaluate.build() : null;
        }

        @Override
        public final Builder evaluate(ArchiveBooleanToEvaluate evaluate) {
            this.evaluate = evaluate;
            return this;
        }

        public final String getOperator() {
            return operator;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public final Builder operator(ArchiveBooleanOperator operator) {
            this.operator(operator == null ? null : operator.toString());
            return this;
        }

        @Override
        public ArchiveBooleanExpression build() {
            return new ArchiveBooleanExpression(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
