/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request to get details of a specific email message stored in an archive.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetArchiveMessageRequest extends MailManagerRequest implements
        ToCopyableBuilder<GetArchiveMessageRequest.Builder, GetArchiveMessageRequest> {
    private static final SdkField<String> ARCHIVED_MESSAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ArchivedMessageId").getter(getter(GetArchiveMessageRequest::archivedMessageId))
            .setter(setter(Builder::archivedMessageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchivedMessageId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARCHIVED_MESSAGE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String archivedMessageId;

    private GetArchiveMessageRequest(BuilderImpl builder) {
        super(builder);
        this.archivedMessageId = builder.archivedMessageId;
    }

    /**
     * <p>
     * The unique identifier of the archived email message.
     * </p>
     * 
     * @return The unique identifier of the archived email message.
     */
    public final String archivedMessageId() {
        return archivedMessageId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(archivedMessageId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetArchiveMessageRequest)) {
            return false;
        }
        GetArchiveMessageRequest other = (GetArchiveMessageRequest) obj;
        return Objects.equals(archivedMessageId(), other.archivedMessageId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetArchiveMessageRequest").add("ArchivedMessageId", archivedMessageId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ArchivedMessageId":
            return Optional.ofNullable(clazz.cast(archivedMessageId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ArchivedMessageId", ARCHIVED_MESSAGE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetArchiveMessageRequest, T> g) {
        return obj -> g.apply((GetArchiveMessageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MailManagerRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetArchiveMessageRequest> {
        /**
         * <p>
         * The unique identifier of the archived email message.
         * </p>
         * 
         * @param archivedMessageId
         *        The unique identifier of the archived email message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder archivedMessageId(String archivedMessageId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MailManagerRequest.BuilderImpl implements Builder {
        private String archivedMessageId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetArchiveMessageRequest model) {
            super(model);
            archivedMessageId(model.archivedMessageId);
        }

        public final String getArchivedMessageId() {
            return archivedMessageId;
        }

        public final void setArchivedMessageId(String archivedMessageId) {
            this.archivedMessageId = archivedMessageId;
        }

        @Override
        public final Builder archivedMessageId(String archivedMessageId) {
            this.archivedMessageId = archivedMessageId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetArchiveMessageRequest build() {
            return new GetArchiveMessageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
