/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure of an ingress endpoint resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IngressPoint implements SdkPojo, Serializable, ToCopyableBuilder<IngressPoint.Builder, IngressPoint> {
    private static final SdkField<String> INGRESS_POINT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IngressPointName").getter(getter(IngressPoint::ingressPointName))
            .setter(setter(Builder::ingressPointName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngressPointName").build()).build();

    private static final SdkField<String> INGRESS_POINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IngressPointId").getter(getter(IngressPoint::ingressPointId)).setter(setter(Builder::ingressPointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngressPointId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(IngressPoint::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(IngressPoint::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> A_RECORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ARecord").getter(getter(IngressPoint::aRecord)).setter(setter(Builder::aRecord))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARecord").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INGRESS_POINT_NAME_FIELD,
            INGRESS_POINT_ID_FIELD, STATUS_FIELD, TYPE_FIELD, A_RECORD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String ingressPointName;

    private final String ingressPointId;

    private final String status;

    private final String type;

    private final String aRecord;

    private IngressPoint(BuilderImpl builder) {
        this.ingressPointName = builder.ingressPointName;
        this.ingressPointId = builder.ingressPointId;
        this.status = builder.status;
        this.type = builder.type;
        this.aRecord = builder.aRecord;
    }

    /**
     * <p>
     * A user friendly name for the ingress endpoint resource.
     * </p>
     * 
     * @return A user friendly name for the ingress endpoint resource.
     */
    public final String ingressPointName() {
        return ingressPointName;
    }

    /**
     * <p>
     * The identifier of the ingress endpoint resource.
     * </p>
     * 
     * @return The identifier of the ingress endpoint resource.
     */
    public final String ingressPointId() {
        return ingressPointId;
    }

    /**
     * <p>
     * The status of the ingress endpoint resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link IngressPointStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the ingress endpoint resource.
     * @see IngressPointStatus
     */
    public final IngressPointStatus status() {
        return IngressPointStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the ingress endpoint resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link IngressPointStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the ingress endpoint resource.
     * @see IngressPointStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The type of ingress endpoint resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link IngressPointType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of ingress endpoint resource.
     * @see IngressPointType
     */
    public final IngressPointType type() {
        return IngressPointType.fromValue(type);
    }

    /**
     * <p>
     * The type of ingress endpoint resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link IngressPointType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of ingress endpoint resource.
     * @see IngressPointType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The DNS A Record that identifies your ingress endpoint. Configure your DNS Mail Exchange (MX) record with this
     * value to route emails to Mail Manager.
     * </p>
     * 
     * @return The DNS A Record that identifies your ingress endpoint. Configure your DNS Mail Exchange (MX) record with
     *         this value to route emails to Mail Manager.
     */
    public final String aRecord() {
        return aRecord;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ingressPointName());
        hashCode = 31 * hashCode + Objects.hashCode(ingressPointId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(aRecord());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IngressPoint)) {
            return false;
        }
        IngressPoint other = (IngressPoint) obj;
        return Objects.equals(ingressPointName(), other.ingressPointName())
                && Objects.equals(ingressPointId(), other.ingressPointId())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(aRecord(), other.aRecord());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IngressPoint").add("IngressPointName", ingressPointName())
                .add("IngressPointId", ingressPointId()).add("Status", statusAsString()).add("Type", typeAsString())
                .add("ARecord", aRecord()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IngressPointName":
            return Optional.ofNullable(clazz.cast(ingressPointName()));
        case "IngressPointId":
            return Optional.ofNullable(clazz.cast(ingressPointId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "ARecord":
            return Optional.ofNullable(clazz.cast(aRecord()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IngressPointName", INGRESS_POINT_NAME_FIELD);
        map.put("IngressPointId", INGRESS_POINT_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("ARecord", A_RECORD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IngressPoint, T> g) {
        return obj -> g.apply((IngressPoint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IngressPoint> {
        /**
         * <p>
         * A user friendly name for the ingress endpoint resource.
         * </p>
         * 
         * @param ingressPointName
         *        A user friendly name for the ingress endpoint resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingressPointName(String ingressPointName);

        /**
         * <p>
         * The identifier of the ingress endpoint resource.
         * </p>
         * 
         * @param ingressPointId
         *        The identifier of the ingress endpoint resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingressPointId(String ingressPointId);

        /**
         * <p>
         * The status of the ingress endpoint resource.
         * </p>
         * 
         * @param status
         *        The status of the ingress endpoint resource.
         * @see IngressPointStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngressPointStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the ingress endpoint resource.
         * </p>
         * 
         * @param status
         *        The status of the ingress endpoint resource.
         * @see IngressPointStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngressPointStatus
         */
        Builder status(IngressPointStatus status);

        /**
         * <p>
         * The type of ingress endpoint resource.
         * </p>
         * 
         * @param type
         *        The type of ingress endpoint resource.
         * @see IngressPointType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngressPointType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of ingress endpoint resource.
         * </p>
         * 
         * @param type
         *        The type of ingress endpoint resource.
         * @see IngressPointType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngressPointType
         */
        Builder type(IngressPointType type);

        /**
         * <p>
         * The DNS A Record that identifies your ingress endpoint. Configure your DNS Mail Exchange (MX) record with
         * this value to route emails to Mail Manager.
         * </p>
         * 
         * @param aRecord
         *        The DNS A Record that identifies your ingress endpoint. Configure your DNS Mail Exchange (MX) record
         *        with this value to route emails to Mail Manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aRecord(String aRecord);
    }

    static final class BuilderImpl implements Builder {
        private String ingressPointName;

        private String ingressPointId;

        private String status;

        private String type;

        private String aRecord;

        private BuilderImpl() {
        }

        private BuilderImpl(IngressPoint model) {
            ingressPointName(model.ingressPointName);
            ingressPointId(model.ingressPointId);
            status(model.status);
            type(model.type);
            aRecord(model.aRecord);
        }

        public final String getIngressPointName() {
            return ingressPointName;
        }

        public final void setIngressPointName(String ingressPointName) {
            this.ingressPointName = ingressPointName;
        }

        @Override
        public final Builder ingressPointName(String ingressPointName) {
            this.ingressPointName = ingressPointName;
            return this;
        }

        public final String getIngressPointId() {
            return ingressPointId;
        }

        public final void setIngressPointId(String ingressPointId) {
            this.ingressPointId = ingressPointId;
        }

        @Override
        public final Builder ingressPointId(String ingressPointId) {
            this.ingressPointId = ingressPointId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(IngressPointStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(IngressPointType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getARecord() {
            return aRecord;
        }

        public final void setARecord(String aRecord) {
            this.aRecord = aRecord;
        }

        @Override
        public final Builder aRecord(String aRecord) {
            this.aRecord = aRecord;
            return this;
        }

        @Override
        public IngressPoint build() {
            return new IngressPoint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
