/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The authentication configuration for the ingress endpoint resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IngressPointAuthConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<IngressPointAuthConfiguration.Builder, IngressPointAuthConfiguration> {
    private static final SdkField<IngressPointPasswordConfiguration> INGRESS_POINT_PASSWORD_CONFIGURATION_FIELD = SdkField
            .<IngressPointPasswordConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("IngressPointPasswordConfiguration")
            .getter(getter(IngressPointAuthConfiguration::ingressPointPasswordConfiguration))
            .setter(setter(Builder::ingressPointPasswordConfiguration))
            .constructor(IngressPointPasswordConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngressPointPasswordConfiguration")
                    .build()).build();

    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretArn").getter(getter(IngressPointAuthConfiguration::secretArn)).setter(setter(Builder::secretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            INGRESS_POINT_PASSWORD_CONFIGURATION_FIELD, SECRET_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final IngressPointPasswordConfiguration ingressPointPasswordConfiguration;

    private final String secretArn;

    private IngressPointAuthConfiguration(BuilderImpl builder) {
        this.ingressPointPasswordConfiguration = builder.ingressPointPasswordConfiguration;
        this.secretArn = builder.secretArn;
    }

    /**
     * <p>
     * The ingress endpoint password configuration for the ingress endpoint resource.
     * </p>
     * 
     * @return The ingress endpoint password configuration for the ingress endpoint resource.
     */
    public final IngressPointPasswordConfiguration ingressPointPasswordConfiguration() {
        return ingressPointPasswordConfiguration;
    }

    /**
     * <p>
     * The ingress endpoint SecretsManager::Secret ARN configuration for the ingress endpoint resource.
     * </p>
     * 
     * @return The ingress endpoint SecretsManager::Secret ARN configuration for the ingress endpoint resource.
     */
    public final String secretArn() {
        return secretArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ingressPointPasswordConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(secretArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IngressPointAuthConfiguration)) {
            return false;
        }
        IngressPointAuthConfiguration other = (IngressPointAuthConfiguration) obj;
        return Objects.equals(ingressPointPasswordConfiguration(), other.ingressPointPasswordConfiguration())
                && Objects.equals(secretArn(), other.secretArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IngressPointAuthConfiguration")
                .add("IngressPointPasswordConfiguration", ingressPointPasswordConfiguration()).add("SecretArn", secretArn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IngressPointPasswordConfiguration":
            return Optional.ofNullable(clazz.cast(ingressPointPasswordConfiguration()));
        case "SecretArn":
            return Optional.ofNullable(clazz.cast(secretArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IngressPointPasswordConfiguration", INGRESS_POINT_PASSWORD_CONFIGURATION_FIELD);
        map.put("SecretArn", SECRET_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IngressPointAuthConfiguration, T> g) {
        return obj -> g.apply((IngressPointAuthConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IngressPointAuthConfiguration> {
        /**
         * <p>
         * The ingress endpoint password configuration for the ingress endpoint resource.
         * </p>
         * 
         * @param ingressPointPasswordConfiguration
         *        The ingress endpoint password configuration for the ingress endpoint resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingressPointPasswordConfiguration(IngressPointPasswordConfiguration ingressPointPasswordConfiguration);

        /**
         * <p>
         * The ingress endpoint password configuration for the ingress endpoint resource.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link IngressPointPasswordConfiguration.Builder} avoiding the need to create one manually via
         * {@link IngressPointPasswordConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IngressPointPasswordConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #ingressPointPasswordConfiguration(IngressPointPasswordConfiguration)}.
         * 
         * @param ingressPointPasswordConfiguration
         *        a consumer that will call methods on {@link IngressPointPasswordConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ingressPointPasswordConfiguration(IngressPointPasswordConfiguration)
         */
        default Builder ingressPointPasswordConfiguration(
                Consumer<IngressPointPasswordConfiguration.Builder> ingressPointPasswordConfiguration) {
            return ingressPointPasswordConfiguration(IngressPointPasswordConfiguration.builder()
                    .applyMutation(ingressPointPasswordConfiguration).build());
        }

        /**
         * <p>
         * The ingress endpoint SecretsManager::Secret ARN configuration for the ingress endpoint resource.
         * </p>
         * 
         * @param secretArn
         *        The ingress endpoint SecretsManager::Secret ARN configuration for the ingress endpoint resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretArn(String secretArn);
    }

    static final class BuilderImpl implements Builder {
        private IngressPointPasswordConfiguration ingressPointPasswordConfiguration;

        private String secretArn;

        private BuilderImpl() {
        }

        private BuilderImpl(IngressPointAuthConfiguration model) {
            ingressPointPasswordConfiguration(model.ingressPointPasswordConfiguration);
            secretArn(model.secretArn);
        }

        public final IngressPointPasswordConfiguration.Builder getIngressPointPasswordConfiguration() {
            return ingressPointPasswordConfiguration != null ? ingressPointPasswordConfiguration.toBuilder() : null;
        }

        public final void setIngressPointPasswordConfiguration(
                IngressPointPasswordConfiguration.BuilderImpl ingressPointPasswordConfiguration) {
            this.ingressPointPasswordConfiguration = ingressPointPasswordConfiguration != null ? ingressPointPasswordConfiguration
                    .build() : null;
        }

        @Override
        public final Builder ingressPointPasswordConfiguration(IngressPointPasswordConfiguration ingressPointPasswordConfiguration) {
            this.ingressPointPasswordConfiguration = ingressPointPasswordConfiguration;
            return this;
        }

        public final String getSecretArn() {
            return secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        @Override
        public IngressPointAuthConfiguration build() {
            return new IngressPointAuthConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
