/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAddressListsResponse extends MailManagerResponse implements
        ToCopyableBuilder<ListAddressListsResponse.Builder, ListAddressListsResponse> {
    private static final SdkField<List<AddressList>> ADDRESS_LISTS_FIELD = SdkField
            .<List<AddressList>> builder(MarshallingType.LIST)
            .memberName("AddressLists")
            .getter(getter(ListAddressListsResponse::addressLists))
            .setter(setter(Builder::addressLists))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressLists").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AddressList> builder(MarshallingType.SDK_POJO)
                                            .constructor(AddressList::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAddressListsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDRESS_LISTS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<AddressList> addressLists;

    private final String nextToken;

    private ListAddressListsResponse(BuilderImpl builder) {
        super(builder);
        this.addressLists = builder.addressLists;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AddressLists property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAddressLists() {
        return addressLists != null && !(addressLists instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of address lists.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddressLists} method.
     * </p>
     * 
     * @return The list of address lists.
     */
    public final List<AddressList> addressLists() {
        return addressLists;
    }

    /**
     * <p>
     * If NextToken is returned, there are more results available. The value of NextToken is a unique pagination token
     * for each page. Make the call again using the returned token to retrieve the next page.
     * </p>
     * 
     * @return If NextToken is returned, there are more results available. The value of NextToken is a unique pagination
     *         token for each page. Make the call again using the returned token to retrieve the next page.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAddressLists() ? addressLists() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAddressListsResponse)) {
            return false;
        }
        ListAddressListsResponse other = (ListAddressListsResponse) obj;
        return hasAddressLists() == other.hasAddressLists() && Objects.equals(addressLists(), other.addressLists())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAddressListsResponse").add("AddressLists", hasAddressLists() ? addressLists() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AddressLists":
            return Optional.ofNullable(clazz.cast(addressLists()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AddressLists", ADDRESS_LISTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAddressListsResponse, T> g) {
        return obj -> g.apply((ListAddressListsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MailManagerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAddressListsResponse> {
        /**
         * <p>
         * The list of address lists.
         * </p>
         * 
         * @param addressLists
         *        The list of address lists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressLists(Collection<AddressList> addressLists);

        /**
         * <p>
         * The list of address lists.
         * </p>
         * 
         * @param addressLists
         *        The list of address lists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressLists(AddressList... addressLists);

        /**
         * <p>
         * The list of address lists.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mailmanager.model.AddressList.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.mailmanager.model.AddressList#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mailmanager.model.AddressList.Builder#build()} is called immediately
         * and its result is passed to {@link #addressLists(List<AddressList>)}.
         * 
         * @param addressLists
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mailmanager.model.AddressList.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addressLists(java.util.Collection<AddressList>)
         */
        Builder addressLists(Consumer<AddressList.Builder>... addressLists);

        /**
         * <p>
         * If NextToken is returned, there are more results available. The value of NextToken is a unique pagination
         * token for each page. Make the call again using the returned token to retrieve the next page.
         * </p>
         * 
         * @param nextToken
         *        If NextToken is returned, there are more results available. The value of NextToken is a unique
         *        pagination token for each page. Make the call again using the returned token to retrieve the next
         *        page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends MailManagerResponse.BuilderImpl implements Builder {
        private List<AddressList> addressLists = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAddressListsResponse model) {
            super(model);
            addressLists(model.addressLists);
            nextToken(model.nextToken);
        }

        public final List<AddressList.Builder> getAddressLists() {
            List<AddressList.Builder> result = AddressListsCopier.copyToBuilder(this.addressLists);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddressLists(Collection<AddressList.BuilderImpl> addressLists) {
            this.addressLists = AddressListsCopier.copyFromBuilder(addressLists);
        }

        @Override
        public final Builder addressLists(Collection<AddressList> addressLists) {
            this.addressLists = AddressListsCopier.copy(addressLists);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addressLists(AddressList... addressLists) {
            addressLists(Arrays.asList(addressLists));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addressLists(Consumer<AddressList.Builder>... addressLists) {
            addressLists(Stream.of(addressLists).map(c -> AddressList.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAddressListsResponse build() {
            return new ListAddressListsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
