/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The relay resource that can be used as a rule to relay receiving emails to the destination relay server.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Relay implements SdkPojo, Serializable, ToCopyableBuilder<Relay.Builder, Relay> {
    private static final SdkField<String> RELAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RelayId").getter(getter(Relay::relayId)).setter(setter(Builder::relayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelayId").build()).build();

    private static final SdkField<String> RELAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RelayName").getter(getter(Relay::relayName)).setter(setter(Builder::relayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelayName").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTimestamp").getter(getter(Relay::lastModifiedTimestamp))
            .setter(setter(Builder::lastModifiedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTimestamp").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RELAY_ID_FIELD,
            RELAY_NAME_FIELD, LAST_MODIFIED_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String relayId;

    private final String relayName;

    private final Instant lastModifiedTimestamp;

    private Relay(BuilderImpl builder) {
        this.relayId = builder.relayId;
        this.relayName = builder.relayName;
        this.lastModifiedTimestamp = builder.lastModifiedTimestamp;
    }

    /**
     * <p>
     * The unique relay identifier.
     * </p>
     * 
     * @return The unique relay identifier.
     */
    public final String relayId() {
        return relayId;
    }

    /**
     * <p>
     * The unique relay name.
     * </p>
     * 
     * @return The unique relay name.
     */
    public final String relayName() {
        return relayName;
    }

    /**
     * <p>
     * The timestamp of when the relay was last modified.
     * </p>
     * 
     * @return The timestamp of when the relay was last modified.
     */
    public final Instant lastModifiedTimestamp() {
        return lastModifiedTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(relayId());
        hashCode = 31 * hashCode + Objects.hashCode(relayName());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Relay)) {
            return false;
        }
        Relay other = (Relay) obj;
        return Objects.equals(relayId(), other.relayId()) && Objects.equals(relayName(), other.relayName())
                && Objects.equals(lastModifiedTimestamp(), other.lastModifiedTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Relay").add("RelayId", relayId()).add("RelayName", relayName())
                .add("LastModifiedTimestamp", lastModifiedTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RelayId":
            return Optional.ofNullable(clazz.cast(relayId()));
        case "RelayName":
            return Optional.ofNullable(clazz.cast(relayName()));
        case "LastModifiedTimestamp":
            return Optional.ofNullable(clazz.cast(lastModifiedTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RelayId", RELAY_ID_FIELD);
        map.put("RelayName", RELAY_NAME_FIELD);
        map.put("LastModifiedTimestamp", LAST_MODIFIED_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Relay, T> g) {
        return obj -> g.apply((Relay) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Relay> {
        /**
         * <p>
         * The unique relay identifier.
         * </p>
         * 
         * @param relayId
         *        The unique relay identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relayId(String relayId);

        /**
         * <p>
         * The unique relay name.
         * </p>
         * 
         * @param relayName
         *        The unique relay name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relayName(String relayName);

        /**
         * <p>
         * The timestamp of when the relay was last modified.
         * </p>
         * 
         * @param lastModifiedTimestamp
         *        The timestamp of when the relay was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTimestamp(Instant lastModifiedTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String relayId;

        private String relayName;

        private Instant lastModifiedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(Relay model) {
            relayId(model.relayId);
            relayName(model.relayName);
            lastModifiedTimestamp(model.lastModifiedTimestamp);
        }

        public final String getRelayId() {
            return relayId;
        }

        public final void setRelayId(String relayId) {
            this.relayId = relayId;
        }

        @Override
        public final Builder relayId(String relayId) {
            this.relayId = relayId;
            return this;
        }

        public final String getRelayName() {
            return relayName;
        }

        public final void setRelayName(String relayName) {
            this.relayName = relayName;
        }

        @Override
        public final Builder relayName(String relayName) {
            this.relayName = relayName;
            return this;
        }

        public final Instant getLastModifiedTimestamp() {
            return lastModifiedTimestamp;
        }

        public final void setLastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
        }

        @Override
        public final Builder lastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
            return this;
        }

        @Override
        public Relay build() {
            return new Relay(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
