/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A DMARC policy expression. The condition matches if the given DMARC policy matches that of the incoming email.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleDmarcExpression implements SdkPojo, Serializable,
        ToCopyableBuilder<RuleDmarcExpression.Builder, RuleDmarcExpression> {
    private static final SdkField<String> OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Operator").getter(getter(RuleDmarcExpression::operatorAsString)).setter(setter(Builder::operator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operator").build()).build();

    private static final SdkField<List<String>> VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Values")
            .getter(getter(RuleDmarcExpression::valuesAsStrings))
            .setter(setter(Builder::valuesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATOR_FIELD, VALUES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String operator;

    private final List<String> values;

    private RuleDmarcExpression(BuilderImpl builder) {
        this.operator = builder.operator;
        this.values = builder.values;
    }

    /**
     * <p>
     * The operator to apply to the DMARC policy of the incoming email.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link RuleDmarcOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #operatorAsString}.
     * </p>
     * 
     * @return The operator to apply to the DMARC policy of the incoming email.
     * @see RuleDmarcOperator
     */
    public final RuleDmarcOperator operator() {
        return RuleDmarcOperator.fromValue(operator);
    }

    /**
     * <p>
     * The operator to apply to the DMARC policy of the incoming email.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link RuleDmarcOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #operatorAsString}.
     * </p>
     * 
     * @return The operator to apply to the DMARC policy of the incoming email.
     * @see RuleDmarcOperator
     */
    public final String operatorAsString() {
        return operator;
    }

    /**
     * <p>
     * The values to use for the given DMARC policy operator. For the operator EQUALS, if multiple values are given,
     * they are evaluated as an OR. That is, if any of the given values match, the condition is deemed to match. For the
     * operator NOT_EQUALS, if multiple values are given, they are evaluated as an AND. That is, only if the email's
     * DMARC policy is not equal to any of the given values, then the condition is deemed to match.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValues} method.
     * </p>
     * 
     * @return The values to use for the given DMARC policy operator. For the operator EQUALS, if multiple values are
     *         given, they are evaluated as an OR. That is, if any of the given values match, the condition is deemed to
     *         match. For the operator NOT_EQUALS, if multiple values are given, they are evaluated as an AND. That is,
     *         only if the email's DMARC policy is not equal to any of the given values, then the condition is deemed to
     *         match.
     */
    public final List<RuleDmarcPolicy> values() {
        return RuleDmarcValueListCopier.copyStringToEnum(values);
    }

    /**
     * For responses, this returns true if the service returned a value for the Values property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The values to use for the given DMARC policy operator. For the operator EQUALS, if multiple values are given,
     * they are evaluated as an OR. That is, if any of the given values match, the condition is deemed to match. For the
     * operator NOT_EQUALS, if multiple values are given, they are evaluated as an AND. That is, only if the email's
     * DMARC policy is not equal to any of the given values, then the condition is deemed to match.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValues} method.
     * </p>
     * 
     * @return The values to use for the given DMARC policy operator. For the operator EQUALS, if multiple values are
     *         given, they are evaluated as an OR. That is, if any of the given values match, the condition is deemed to
     *         match. For the operator NOT_EQUALS, if multiple values are given, they are evaluated as an AND. That is,
     *         only if the email's DMARC policy is not equal to any of the given values, then the condition is deemed to
     *         match.
     */
    public final List<String> valuesAsStrings() {
        return values;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(operatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasValues() ? valuesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleDmarcExpression)) {
            return false;
        }
        RuleDmarcExpression other = (RuleDmarcExpression) obj;
        return Objects.equals(operatorAsString(), other.operatorAsString()) && hasValues() == other.hasValues()
                && Objects.equals(valuesAsStrings(), other.valuesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleDmarcExpression").add("Operator", operatorAsString())
                .add("Values", hasValues() ? valuesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Operator":
            return Optional.ofNullable(clazz.cast(operatorAsString()));
        case "Values":
            return Optional.ofNullable(clazz.cast(valuesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Operator", OPERATOR_FIELD);
        map.put("Values", VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuleDmarcExpression, T> g) {
        return obj -> g.apply((RuleDmarcExpression) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleDmarcExpression> {
        /**
         * <p>
         * The operator to apply to the DMARC policy of the incoming email.
         * </p>
         * 
         * @param operator
         *        The operator to apply to the DMARC policy of the incoming email.
         * @see RuleDmarcOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleDmarcOperator
         */
        Builder operator(String operator);

        /**
         * <p>
         * The operator to apply to the DMARC policy of the incoming email.
         * </p>
         * 
         * @param operator
         *        The operator to apply to the DMARC policy of the incoming email.
         * @see RuleDmarcOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleDmarcOperator
         */
        Builder operator(RuleDmarcOperator operator);

        /**
         * <p>
         * The values to use for the given DMARC policy operator. For the operator EQUALS, if multiple values are given,
         * they are evaluated as an OR. That is, if any of the given values match, the condition is deemed to match. For
         * the operator NOT_EQUALS, if multiple values are given, they are evaluated as an AND. That is, only if the
         * email's DMARC policy is not equal to any of the given values, then the condition is deemed to match.
         * </p>
         * 
         * @param values
         *        The values to use for the given DMARC policy operator. For the operator EQUALS, if multiple values are
         *        given, they are evaluated as an OR. That is, if any of the given values match, the condition is deemed
         *        to match. For the operator NOT_EQUALS, if multiple values are given, they are evaluated as an AND.
         *        That is, only if the email's DMARC policy is not equal to any of the given values, then the condition
         *        is deemed to match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valuesWithStrings(Collection<String> values);

        /**
         * <p>
         * The values to use for the given DMARC policy operator. For the operator EQUALS, if multiple values are given,
         * they are evaluated as an OR. That is, if any of the given values match, the condition is deemed to match. For
         * the operator NOT_EQUALS, if multiple values are given, they are evaluated as an AND. That is, only if the
         * email's DMARC policy is not equal to any of the given values, then the condition is deemed to match.
         * </p>
         * 
         * @param values
         *        The values to use for the given DMARC policy operator. For the operator EQUALS, if multiple values are
         *        given, they are evaluated as an OR. That is, if any of the given values match, the condition is deemed
         *        to match. For the operator NOT_EQUALS, if multiple values are given, they are evaluated as an AND.
         *        That is, only if the email's DMARC policy is not equal to any of the given values, then the condition
         *        is deemed to match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valuesWithStrings(String... values);

        /**
         * <p>
         * The values to use for the given DMARC policy operator. For the operator EQUALS, if multiple values are given,
         * they are evaluated as an OR. That is, if any of the given values match, the condition is deemed to match. For
         * the operator NOT_EQUALS, if multiple values are given, they are evaluated as an AND. That is, only if the
         * email's DMARC policy is not equal to any of the given values, then the condition is deemed to match.
         * </p>
         * 
         * @param values
         *        The values to use for the given DMARC policy operator. For the operator EQUALS, if multiple values are
         *        given, they are evaluated as an OR. That is, if any of the given values match, the condition is deemed
         *        to match. For the operator NOT_EQUALS, if multiple values are given, they are evaluated as an AND.
         *        That is, only if the email's DMARC policy is not equal to any of the given values, then the condition
         *        is deemed to match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<RuleDmarcPolicy> values);

        /**
         * <p>
         * The values to use for the given DMARC policy operator. For the operator EQUALS, if multiple values are given,
         * they are evaluated as an OR. That is, if any of the given values match, the condition is deemed to match. For
         * the operator NOT_EQUALS, if multiple values are given, they are evaluated as an AND. That is, only if the
         * email's DMARC policy is not equal to any of the given values, then the condition is deemed to match.
         * </p>
         * 
         * @param values
         *        The values to use for the given DMARC policy operator. For the operator EQUALS, if multiple values are
         *        given, they are evaluated as an OR. That is, if any of the given values match, the condition is deemed
         *        to match. For the operator NOT_EQUALS, if multiple values are given, they are evaluated as an AND.
         *        That is, only if the email's DMARC policy is not equal to any of the given values, then the condition
         *        is deemed to match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(RuleDmarcPolicy... values);
    }

    static final class BuilderImpl implements Builder {
        private String operator;

        private List<String> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RuleDmarcExpression model) {
            operator(model.operator);
            valuesWithStrings(model.values);
        }

        public final String getOperator() {
            return operator;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public final Builder operator(RuleDmarcOperator operator) {
            this.operator(operator == null ? null : operator.toString());
            return this;
        }

        public final Collection<String> getValues() {
            if (values instanceof SdkAutoConstructList) {
                return null;
            }
            return values;
        }

        public final void setValues(Collection<String> values) {
            this.values = RuleDmarcValueListCopier.copy(values);
        }

        @Override
        public final Builder valuesWithStrings(Collection<String> values) {
            this.values = RuleDmarcValueListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder valuesWithStrings(String... values) {
            valuesWithStrings(Arrays.asList(values));
            return this;
        }

        @Override
        public final Builder values(Collection<RuleDmarcPolicy> values) {
            this.values = RuleDmarcValueListCopier.copyEnumToString(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(RuleDmarcPolicy... values) {
            values(Arrays.asList(values));
            return this;
        }

        @Override
        public RuleDmarcExpression build() {
            return new RuleDmarcExpression(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
