/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure type for a boolean condition that provides the address lists and address list attribute to evaluate.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleIsInAddressList implements SdkPojo, Serializable,
        ToCopyableBuilder<RuleIsInAddressList.Builder, RuleIsInAddressList> {
    private static final SdkField<String> ATTRIBUTE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Attribute").getter(getter(RuleIsInAddressList::attributeAsString)).setter(setter(Builder::attribute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attribute").build()).build();

    private static final SdkField<List<String>> ADDRESS_LISTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AddressLists")
            .getter(getter(RuleIsInAddressList::addressLists))
            .setter(setter(Builder::addressLists))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressLists").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_FIELD,
            ADDRESS_LISTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String attribute;

    private final List<String> addressLists;

    private RuleIsInAddressList(BuilderImpl builder) {
        this.attribute = builder.attribute;
        this.addressLists = builder.addressLists;
    }

    /**
     * <p>
     * The email attribute that needs to be evaluated against the address list.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attribute} will
     * return {@link RuleAddressListEmailAttribute#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #attributeAsString}.
     * </p>
     * 
     * @return The email attribute that needs to be evaluated against the address list.
     * @see RuleAddressListEmailAttribute
     */
    public final RuleAddressListEmailAttribute attribute() {
        return RuleAddressListEmailAttribute.fromValue(attribute);
    }

    /**
     * <p>
     * The email attribute that needs to be evaluated against the address list.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attribute} will
     * return {@link RuleAddressListEmailAttribute#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #attributeAsString}.
     * </p>
     * 
     * @return The email attribute that needs to be evaluated against the address list.
     * @see RuleAddressListEmailAttribute
     */
    public final String attributeAsString() {
        return attribute;
    }

    /**
     * For responses, this returns true if the service returned a value for the AddressLists property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAddressLists() {
        return addressLists != null && !(addressLists instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The address lists that will be used for evaluation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddressLists} method.
     * </p>
     * 
     * @return The address lists that will be used for evaluation.
     */
    public final List<String> addressLists() {
        return addressLists;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAddressLists() ? addressLists() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleIsInAddressList)) {
            return false;
        }
        RuleIsInAddressList other = (RuleIsInAddressList) obj;
        return Objects.equals(attributeAsString(), other.attributeAsString()) && hasAddressLists() == other.hasAddressLists()
                && Objects.equals(addressLists(), other.addressLists());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleIsInAddressList").add("Attribute", attributeAsString())
                .add("AddressLists", hasAddressLists() ? addressLists() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attribute":
            return Optional.ofNullable(clazz.cast(attributeAsString()));
        case "AddressLists":
            return Optional.ofNullable(clazz.cast(addressLists()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Attribute", ATTRIBUTE_FIELD);
        map.put("AddressLists", ADDRESS_LISTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuleIsInAddressList, T> g) {
        return obj -> g.apply((RuleIsInAddressList) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleIsInAddressList> {
        /**
         * <p>
         * The email attribute that needs to be evaluated against the address list.
         * </p>
         * 
         * @param attribute
         *        The email attribute that needs to be evaluated against the address list.
         * @see RuleAddressListEmailAttribute
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleAddressListEmailAttribute
         */
        Builder attribute(String attribute);

        /**
         * <p>
         * The email attribute that needs to be evaluated against the address list.
         * </p>
         * 
         * @param attribute
         *        The email attribute that needs to be evaluated against the address list.
         * @see RuleAddressListEmailAttribute
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleAddressListEmailAttribute
         */
        Builder attribute(RuleAddressListEmailAttribute attribute);

        /**
         * <p>
         * The address lists that will be used for evaluation.
         * </p>
         * 
         * @param addressLists
         *        The address lists that will be used for evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressLists(Collection<String> addressLists);

        /**
         * <p>
         * The address lists that will be used for evaluation.
         * </p>
         * 
         * @param addressLists
         *        The address lists that will be used for evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressLists(String... addressLists);
    }

    static final class BuilderImpl implements Builder {
        private String attribute;

        private List<String> addressLists = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RuleIsInAddressList model) {
            attribute(model.attribute);
            addressLists(model.addressLists);
        }

        public final String getAttribute() {
            return attribute;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public final Builder attribute(RuleAddressListEmailAttribute attribute) {
            this.attribute(attribute == null ? null : attribute.toString());
            return this;
        }

        public final Collection<String> getAddressLists() {
            if (addressLists instanceof SdkAutoConstructList) {
                return null;
            }
            return addressLists;
        }

        public final void setAddressLists(Collection<String> addressLists) {
            this.addressLists = RuleAddressListArnListCopier.copy(addressLists);
        }

        @Override
        public final Builder addressLists(Collection<String> addressLists) {
            this.addressLists = RuleAddressListArnListCopier.copy(addressLists);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addressLists(String... addressLists) {
            addressLists(Arrays.asList(addressLists));
            return this;
        }

        @Override
        public RuleIsInAddressList build() {
            return new RuleIsInAddressList(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
