/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary details of an archive search job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchSummary implements SdkPojo, Serializable, ToCopyableBuilder<SearchSummary.Builder, SearchSummary> {
    private static final SdkField<String> SEARCH_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SearchId").getter(getter(SearchSummary::searchId)).setter(setter(Builder::searchId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchId").build()).build();

    private static final SdkField<SearchStatus> STATUS_FIELD = SdkField.<SearchStatus> builder(MarshallingType.SDK_POJO)
            .memberName("Status").getter(getter(SearchSummary::status)).setter(setter(Builder::status))
            .constructor(SearchStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(SEARCH_ID_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String searchId;

    private final SearchStatus status;

    private SearchSummary(BuilderImpl builder) {
        this.searchId = builder.searchId;
        this.status = builder.status;
    }

    /**
     * <p>
     * The unique identifier of the search job.
     * </p>
     * 
     * @return The unique identifier of the search job.
     */
    public final String searchId() {
        return searchId;
    }

    /**
     * <p>
     * The current status of the search job.
     * </p>
     * 
     * @return The current status of the search job.
     */
    public final SearchStatus status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(searchId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchSummary)) {
            return false;
        }
        SearchSummary other = (SearchSummary) obj;
        return Objects.equals(searchId(), other.searchId()) && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchSummary").add("SearchId", searchId()).add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SearchId":
            return Optional.ofNullable(clazz.cast(searchId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SearchId", SEARCH_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchSummary, T> g) {
        return obj -> g.apply((SearchSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SearchSummary> {
        /**
         * <p>
         * The unique identifier of the search job.
         * </p>
         * 
         * @param searchId
         *        The unique identifier of the search job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchId(String searchId);

        /**
         * <p>
         * The current status of the search job.
         * </p>
         * 
         * @param status
         *        The current status of the search job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(SearchStatus status);

        /**
         * <p>
         * The current status of the search job.
         * </p>
         * This is a convenience method that creates an instance of the {@link SearchStatus.Builder} avoiding the need
         * to create one manually via {@link SearchStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SearchStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #status(SearchStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link SearchStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(SearchStatus)
         */
        default Builder status(Consumer<SearchStatus.Builder> status) {
            return status(SearchStatus.builder().applyMutation(status).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String searchId;

        private SearchStatus status;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchSummary model) {
            searchId(model.searchId);
            status(model.status);
        }

        public final String getSearchId() {
            return searchId;
        }

        public final void setSearchId(String searchId) {
            this.searchId = searchId;
        }

        @Override
        public final Builder searchId(String searchId) {
            this.searchId = searchId;
            return this;
        }

        public final SearchStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(SearchStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(SearchStatus status) {
            this.status = status;
            return this;
        }

        @Override
        public SearchSummary build() {
            return new SearchSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
