/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.mailmanager.model.AccessDeniedException;
import software.amazon.awssdk.services.mailmanager.model.ConflictException;
import software.amazon.awssdk.services.mailmanager.model.CreateAddonInstanceRequest;
import software.amazon.awssdk.services.mailmanager.model.CreateAddonInstanceResponse;
import software.amazon.awssdk.services.mailmanager.model.CreateAddonSubscriptionRequest;
import software.amazon.awssdk.services.mailmanager.model.CreateAddonSubscriptionResponse;
import software.amazon.awssdk.services.mailmanager.model.CreateAddressListImportJobRequest;
import software.amazon.awssdk.services.mailmanager.model.CreateAddressListImportJobResponse;
import software.amazon.awssdk.services.mailmanager.model.CreateAddressListRequest;
import software.amazon.awssdk.services.mailmanager.model.CreateAddressListResponse;
import software.amazon.awssdk.services.mailmanager.model.CreateArchiveRequest;
import software.amazon.awssdk.services.mailmanager.model.CreateArchiveResponse;
import software.amazon.awssdk.services.mailmanager.model.CreateIngressPointRequest;
import software.amazon.awssdk.services.mailmanager.model.CreateIngressPointResponse;
import software.amazon.awssdk.services.mailmanager.model.CreateRelayRequest;
import software.amazon.awssdk.services.mailmanager.model.CreateRelayResponse;
import software.amazon.awssdk.services.mailmanager.model.CreateRuleSetRequest;
import software.amazon.awssdk.services.mailmanager.model.CreateRuleSetResponse;
import software.amazon.awssdk.services.mailmanager.model.CreateTrafficPolicyRequest;
import software.amazon.awssdk.services.mailmanager.model.CreateTrafficPolicyResponse;
import software.amazon.awssdk.services.mailmanager.model.DeleteAddonInstanceRequest;
import software.amazon.awssdk.services.mailmanager.model.DeleteAddonInstanceResponse;
import software.amazon.awssdk.services.mailmanager.model.DeleteAddonSubscriptionRequest;
import software.amazon.awssdk.services.mailmanager.model.DeleteAddonSubscriptionResponse;
import software.amazon.awssdk.services.mailmanager.model.DeleteAddressListRequest;
import software.amazon.awssdk.services.mailmanager.model.DeleteAddressListResponse;
import software.amazon.awssdk.services.mailmanager.model.DeleteArchiveRequest;
import software.amazon.awssdk.services.mailmanager.model.DeleteArchiveResponse;
import software.amazon.awssdk.services.mailmanager.model.DeleteIngressPointRequest;
import software.amazon.awssdk.services.mailmanager.model.DeleteIngressPointResponse;
import software.amazon.awssdk.services.mailmanager.model.DeleteRelayRequest;
import software.amazon.awssdk.services.mailmanager.model.DeleteRelayResponse;
import software.amazon.awssdk.services.mailmanager.model.DeleteRuleSetRequest;
import software.amazon.awssdk.services.mailmanager.model.DeleteRuleSetResponse;
import software.amazon.awssdk.services.mailmanager.model.DeleteTrafficPolicyRequest;
import software.amazon.awssdk.services.mailmanager.model.DeleteTrafficPolicyResponse;
import software.amazon.awssdk.services.mailmanager.model.DeregisterMemberFromAddressListRequest;
import software.amazon.awssdk.services.mailmanager.model.DeregisterMemberFromAddressListResponse;
import software.amazon.awssdk.services.mailmanager.model.GetAddonInstanceRequest;
import software.amazon.awssdk.services.mailmanager.model.GetAddonInstanceResponse;
import software.amazon.awssdk.services.mailmanager.model.GetAddonSubscriptionRequest;
import software.amazon.awssdk.services.mailmanager.model.GetAddonSubscriptionResponse;
import software.amazon.awssdk.services.mailmanager.model.GetAddressListImportJobRequest;
import software.amazon.awssdk.services.mailmanager.model.GetAddressListImportJobResponse;
import software.amazon.awssdk.services.mailmanager.model.GetAddressListRequest;
import software.amazon.awssdk.services.mailmanager.model.GetAddressListResponse;
import software.amazon.awssdk.services.mailmanager.model.GetArchiveExportRequest;
import software.amazon.awssdk.services.mailmanager.model.GetArchiveExportResponse;
import software.amazon.awssdk.services.mailmanager.model.GetArchiveMessageContentRequest;
import software.amazon.awssdk.services.mailmanager.model.GetArchiveMessageContentResponse;
import software.amazon.awssdk.services.mailmanager.model.GetArchiveMessageRequest;
import software.amazon.awssdk.services.mailmanager.model.GetArchiveMessageResponse;
import software.amazon.awssdk.services.mailmanager.model.GetArchiveRequest;
import software.amazon.awssdk.services.mailmanager.model.GetArchiveResponse;
import software.amazon.awssdk.services.mailmanager.model.GetArchiveSearchRequest;
import software.amazon.awssdk.services.mailmanager.model.GetArchiveSearchResponse;
import software.amazon.awssdk.services.mailmanager.model.GetArchiveSearchResultsRequest;
import software.amazon.awssdk.services.mailmanager.model.GetArchiveSearchResultsResponse;
import software.amazon.awssdk.services.mailmanager.model.GetIngressPointRequest;
import software.amazon.awssdk.services.mailmanager.model.GetIngressPointResponse;
import software.amazon.awssdk.services.mailmanager.model.GetMemberOfAddressListRequest;
import software.amazon.awssdk.services.mailmanager.model.GetMemberOfAddressListResponse;
import software.amazon.awssdk.services.mailmanager.model.GetRelayRequest;
import software.amazon.awssdk.services.mailmanager.model.GetRelayResponse;
import software.amazon.awssdk.services.mailmanager.model.GetRuleSetRequest;
import software.amazon.awssdk.services.mailmanager.model.GetRuleSetResponse;
import software.amazon.awssdk.services.mailmanager.model.GetTrafficPolicyRequest;
import software.amazon.awssdk.services.mailmanager.model.GetTrafficPolicyResponse;
import software.amazon.awssdk.services.mailmanager.model.ListAddonInstancesRequest;
import software.amazon.awssdk.services.mailmanager.model.ListAddonInstancesResponse;
import software.amazon.awssdk.services.mailmanager.model.ListAddonSubscriptionsRequest;
import software.amazon.awssdk.services.mailmanager.model.ListAddonSubscriptionsResponse;
import software.amazon.awssdk.services.mailmanager.model.ListAddressListImportJobsRequest;
import software.amazon.awssdk.services.mailmanager.model.ListAddressListImportJobsResponse;
import software.amazon.awssdk.services.mailmanager.model.ListAddressListsRequest;
import software.amazon.awssdk.services.mailmanager.model.ListAddressListsResponse;
import software.amazon.awssdk.services.mailmanager.model.ListArchiveExportsRequest;
import software.amazon.awssdk.services.mailmanager.model.ListArchiveExportsResponse;
import software.amazon.awssdk.services.mailmanager.model.ListArchiveSearchesRequest;
import software.amazon.awssdk.services.mailmanager.model.ListArchiveSearchesResponse;
import software.amazon.awssdk.services.mailmanager.model.ListArchivesRequest;
import software.amazon.awssdk.services.mailmanager.model.ListArchivesResponse;
import software.amazon.awssdk.services.mailmanager.model.ListIngressPointsRequest;
import software.amazon.awssdk.services.mailmanager.model.ListIngressPointsResponse;
import software.amazon.awssdk.services.mailmanager.model.ListMembersOfAddressListRequest;
import software.amazon.awssdk.services.mailmanager.model.ListMembersOfAddressListResponse;
import software.amazon.awssdk.services.mailmanager.model.ListRelaysRequest;
import software.amazon.awssdk.services.mailmanager.model.ListRelaysResponse;
import software.amazon.awssdk.services.mailmanager.model.ListRuleSetsRequest;
import software.amazon.awssdk.services.mailmanager.model.ListRuleSetsResponse;
import software.amazon.awssdk.services.mailmanager.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.mailmanager.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.mailmanager.model.ListTrafficPoliciesRequest;
import software.amazon.awssdk.services.mailmanager.model.ListTrafficPoliciesResponse;
import software.amazon.awssdk.services.mailmanager.model.MailManagerException;
import software.amazon.awssdk.services.mailmanager.model.RegisterMemberToAddressListRequest;
import software.amazon.awssdk.services.mailmanager.model.RegisterMemberToAddressListResponse;
import software.amazon.awssdk.services.mailmanager.model.ResourceNotFoundException;
import software.amazon.awssdk.services.mailmanager.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.mailmanager.model.StartAddressListImportJobRequest;
import software.amazon.awssdk.services.mailmanager.model.StartAddressListImportJobResponse;
import software.amazon.awssdk.services.mailmanager.model.StartArchiveExportRequest;
import software.amazon.awssdk.services.mailmanager.model.StartArchiveExportResponse;
import software.amazon.awssdk.services.mailmanager.model.StartArchiveSearchRequest;
import software.amazon.awssdk.services.mailmanager.model.StartArchiveSearchResponse;
import software.amazon.awssdk.services.mailmanager.model.StopAddressListImportJobRequest;
import software.amazon.awssdk.services.mailmanager.model.StopAddressListImportJobResponse;
import software.amazon.awssdk.services.mailmanager.model.StopArchiveExportRequest;
import software.amazon.awssdk.services.mailmanager.model.StopArchiveExportResponse;
import software.amazon.awssdk.services.mailmanager.model.StopArchiveSearchRequest;
import software.amazon.awssdk.services.mailmanager.model.StopArchiveSearchResponse;
import software.amazon.awssdk.services.mailmanager.model.TagResourceRequest;
import software.amazon.awssdk.services.mailmanager.model.TagResourceResponse;
import software.amazon.awssdk.services.mailmanager.model.ThrottlingException;
import software.amazon.awssdk.services.mailmanager.model.UntagResourceRequest;
import software.amazon.awssdk.services.mailmanager.model.UntagResourceResponse;
import software.amazon.awssdk.services.mailmanager.model.UpdateArchiveRequest;
import software.amazon.awssdk.services.mailmanager.model.UpdateArchiveResponse;
import software.amazon.awssdk.services.mailmanager.model.UpdateIngressPointRequest;
import software.amazon.awssdk.services.mailmanager.model.UpdateIngressPointResponse;
import software.amazon.awssdk.services.mailmanager.model.UpdateRelayRequest;
import software.amazon.awssdk.services.mailmanager.model.UpdateRelayResponse;
import software.amazon.awssdk.services.mailmanager.model.UpdateRuleSetRequest;
import software.amazon.awssdk.services.mailmanager.model.UpdateRuleSetResponse;
import software.amazon.awssdk.services.mailmanager.model.UpdateTrafficPolicyRequest;
import software.amazon.awssdk.services.mailmanager.model.UpdateTrafficPolicyResponse;
import software.amazon.awssdk.services.mailmanager.model.ValidationException;
import software.amazon.awssdk.services.mailmanager.paginators.ListAddonInstancesIterable;
import software.amazon.awssdk.services.mailmanager.paginators.ListAddonSubscriptionsIterable;
import software.amazon.awssdk.services.mailmanager.paginators.ListAddressListImportJobsIterable;
import software.amazon.awssdk.services.mailmanager.paginators.ListAddressListsIterable;
import software.amazon.awssdk.services.mailmanager.paginators.ListArchiveExportsIterable;
import software.amazon.awssdk.services.mailmanager.paginators.ListArchiveSearchesIterable;
import software.amazon.awssdk.services.mailmanager.paginators.ListArchivesIterable;
import software.amazon.awssdk.services.mailmanager.paginators.ListIngressPointsIterable;
import software.amazon.awssdk.services.mailmanager.paginators.ListMembersOfAddressListIterable;
import software.amazon.awssdk.services.mailmanager.paginators.ListRelaysIterable;
import software.amazon.awssdk.services.mailmanager.paginators.ListRuleSetsIterable;
import software.amazon.awssdk.services.mailmanager.paginators.ListTrafficPoliciesIterable;

/**
 * Service client for accessing MailManager. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * <fullname>Amazon SES Mail Manager API</fullname>
 * <p>
 * The Amazon SES Mail Manager API contains operations and data types that comprise the Mail Manager feature of <a
 * href="http://aws.amazon.com/ses">Amazon Simple Email Service (SES)</a>.
 * </p>
 * <p>
 * Mail Manager is a set of Amazon SES email gateway features designed to help you strengthen your organization's email
 * infrastructure, simplify email workflow management, and streamline email compliance control. To learn more, see the
 * <a href="https://docs.aws.amazon.com/ses/latest/dg/eb.html">Mail Manager chapter</a> in the <i>Amazon SES Developer
 * Guide</i>.
 * </p>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface MailManagerClient extends AwsClient {
    String SERVICE_NAME = "ses";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "mail-manager";

    /**
     * <p>
     * Creates an Add On instance for the subscription indicated in the request. The resulting Amazon Resource Name
     * (ARN) can be used in a conditional statement for a rule set or traffic policy.
     * </p>
     *
     * @param createAddonInstanceRequest
     * @return Result of the CreateAddonInstance operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws ServiceQuotaExceededException
     *         Occurs when an operation exceeds a predefined service quota or limit.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.CreateAddonInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/CreateAddonInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAddonInstanceResponse createAddonInstance(CreateAddonInstanceRequest createAddonInstanceRequest)
            throws ValidationException, ServiceQuotaExceededException, ConflictException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, MailManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Add On instance for the subscription indicated in the request. The resulting Amazon Resource Name
     * (ARN) can be used in a conditional statement for a rule set or traffic policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAddonInstanceRequest.Builder} avoiding the
     * need to create one manually via {@link CreateAddonInstanceRequest#builder()}
     * </p>
     *
     * @param createAddonInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.CreateAddonInstanceRequest.Builder} to create a
     *        request.
     * @return Result of the CreateAddonInstance operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws ServiceQuotaExceededException
     *         Occurs when an operation exceeds a predefined service quota or limit.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.CreateAddonInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/CreateAddonInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAddonInstanceResponse createAddonInstance(
            Consumer<CreateAddonInstanceRequest.Builder> createAddonInstanceRequest) throws ValidationException,
            ServiceQuotaExceededException, ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            MailManagerException {
        return createAddonInstance(CreateAddonInstanceRequest.builder().applyMutation(createAddonInstanceRequest).build());
    }

    /**
     * <p>
     * Creates a subscription for an Add On representing the acceptance of its terms of use and additional pricing. The
     * subscription can then be used to create an instance for use in rule sets or traffic policies.
     * </p>
     *
     * @param createAddonSubscriptionRequest
     * @return Result of the CreateAddonSubscription operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws ServiceQuotaExceededException
     *         Occurs when an operation exceeds a predefined service quota or limit.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.CreateAddonSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/CreateAddonSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAddonSubscriptionResponse createAddonSubscription(CreateAddonSubscriptionRequest createAddonSubscriptionRequest)
            throws ValidationException, ServiceQuotaExceededException, ConflictException, AwsServiceException,
            SdkClientException, MailManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a subscription for an Add On representing the acceptance of its terms of use and additional pricing. The
     * subscription can then be used to create an instance for use in rule sets or traffic policies.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAddonSubscriptionRequest.Builder} avoiding
     * the need to create one manually via {@link CreateAddonSubscriptionRequest#builder()}
     * </p>
     *
     * @param createAddonSubscriptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.CreateAddonSubscriptionRequest.Builder} to create
     *        a request.
     * @return Result of the CreateAddonSubscription operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws ServiceQuotaExceededException
     *         Occurs when an operation exceeds a predefined service quota or limit.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.CreateAddonSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/CreateAddonSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAddonSubscriptionResponse createAddonSubscription(
            Consumer<CreateAddonSubscriptionRequest.Builder> createAddonSubscriptionRequest) throws ValidationException,
            ServiceQuotaExceededException, ConflictException, AwsServiceException, SdkClientException, MailManagerException {
        return createAddonSubscription(CreateAddonSubscriptionRequest.builder().applyMutation(createAddonSubscriptionRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new address list.
     * </p>
     *
     * @param createAddressListRequest
     * @return Result of the CreateAddressList operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ServiceQuotaExceededException
     *         Occurs when an operation exceeds a predefined service quota or limit.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.CreateAddressList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/CreateAddressList" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateAddressListResponse createAddressList(CreateAddressListRequest createAddressListRequest)
            throws ValidationException, AccessDeniedException, ServiceQuotaExceededException, ConflictException,
            ThrottlingException, AwsServiceException, SdkClientException, MailManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new address list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAddressListRequest.Builder} avoiding the need
     * to create one manually via {@link CreateAddressListRequest#builder()}
     * </p>
     *
     * @param createAddressListRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.CreateAddressListRequest.Builder} to create a
     *        request.
     * @return Result of the CreateAddressList operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ServiceQuotaExceededException
     *         Occurs when an operation exceeds a predefined service quota or limit.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.CreateAddressList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/CreateAddressList" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateAddressListResponse createAddressList(Consumer<CreateAddressListRequest.Builder> createAddressListRequest)
            throws ValidationException, AccessDeniedException, ServiceQuotaExceededException, ConflictException,
            ThrottlingException, AwsServiceException, SdkClientException, MailManagerException {
        return createAddressList(CreateAddressListRequest.builder().applyMutation(createAddressListRequest).build());
    }

    /**
     * <p>
     * Creates an import job for an address list.
     * </p>
     *
     * @param createAddressListImportJobRequest
     * @return Result of the CreateAddressListImportJob operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.CreateAddressListImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/CreateAddressListImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAddressListImportJobResponse createAddressListImportJob(
            CreateAddressListImportJobRequest createAddressListImportJobRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            MailManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an import job for an address list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAddressListImportJobRequest.Builder} avoiding
     * the need to create one manually via {@link CreateAddressListImportJobRequest#builder()}
     * </p>
     *
     * @param createAddressListImportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.CreateAddressListImportJobRequest.Builder} to
     *        create a request.
     * @return Result of the CreateAddressListImportJob operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.CreateAddressListImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/CreateAddressListImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAddressListImportJobResponse createAddressListImportJob(
            Consumer<CreateAddressListImportJobRequest.Builder> createAddressListImportJobRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            MailManagerException {
        return createAddressListImportJob(CreateAddressListImportJobRequest.builder()
                .applyMutation(createAddressListImportJobRequest).build());
    }

    /**
     * <p>
     * Creates a new email archive resource for storing and retaining emails.
     * </p>
     *
     * @param createArchiveRequest
     *        The request to create a new email archive.
     * @return Result of the CreateArchive operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ServiceQuotaExceededException
     *         Occurs when an operation exceeds a predefined service quota or limit.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.CreateArchive
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/CreateArchive" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateArchiveResponse createArchive(CreateArchiveRequest createArchiveRequest) throws ValidationException,
            AccessDeniedException, ServiceQuotaExceededException, ConflictException, ThrottlingException, AwsServiceException,
            SdkClientException, MailManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new email archive resource for storing and retaining emails.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateArchiveRequest.Builder} avoiding the need to
     * create one manually via {@link CreateArchiveRequest#builder()}
     * </p>
     *
     * @param createArchiveRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.CreateArchiveRequest.Builder} to create a
     *        request. The request to create a new email archive.
     * @return Result of the CreateArchive operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ServiceQuotaExceededException
     *         Occurs when an operation exceeds a predefined service quota or limit.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.CreateArchive
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/CreateArchive" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateArchiveResponse createArchive(Consumer<CreateArchiveRequest.Builder> createArchiveRequest)
            throws ValidationException, AccessDeniedException, ServiceQuotaExceededException, ConflictException,
            ThrottlingException, AwsServiceException, SdkClientException, MailManagerException {
        return createArchive(CreateArchiveRequest.builder().applyMutation(createArchiveRequest).build());
    }

    /**
     * <p>
     * Provision a new ingress endpoint resource.
     * </p>
     *
     * @param createIngressPointRequest
     * @return Result of the CreateIngressPoint operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws ServiceQuotaExceededException
     *         Occurs when an operation exceeds a predefined service quota or limit.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.CreateIngressPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/CreateIngressPoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateIngressPointResponse createIngressPoint(CreateIngressPointRequest createIngressPointRequest)
            throws ValidationException, ServiceQuotaExceededException, ConflictException, AwsServiceException,
            SdkClientException, MailManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provision a new ingress endpoint resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIngressPointRequest.Builder} avoiding the
     * need to create one manually via {@link CreateIngressPointRequest#builder()}
     * </p>
     *
     * @param createIngressPointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.CreateIngressPointRequest.Builder} to create a
     *        request.
     * @return Result of the CreateIngressPoint operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws ServiceQuotaExceededException
     *         Occurs when an operation exceeds a predefined service quota or limit.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.CreateIngressPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/CreateIngressPoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateIngressPointResponse createIngressPoint(Consumer<CreateIngressPointRequest.Builder> createIngressPointRequest)
            throws ValidationException, ServiceQuotaExceededException, ConflictException, AwsServiceException,
            SdkClientException, MailManagerException {
        return createIngressPoint(CreateIngressPointRequest.builder().applyMutation(createIngressPointRequest).build());
    }

    /**
     * <p>
     * Creates a relay resource which can be used in rules to relay incoming emails to defined relay destinations.
     * </p>
     *
     * @param createRelayRequest
     * @return Result of the CreateRelay operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws ServiceQuotaExceededException
     *         Occurs when an operation exceeds a predefined service quota or limit.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.CreateRelay
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/CreateRelay" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateRelayResponse createRelay(CreateRelayRequest createRelayRequest) throws ValidationException,
            ServiceQuotaExceededException, ConflictException, AwsServiceException, SdkClientException, MailManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a relay resource which can be used in rules to relay incoming emails to defined relay destinations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRelayRequest.Builder} avoiding the need to
     * create one manually via {@link CreateRelayRequest#builder()}
     * </p>
     *
     * @param createRelayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.CreateRelayRequest.Builder} to create a request.
     * @return Result of the CreateRelay operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws ServiceQuotaExceededException
     *         Occurs when an operation exceeds a predefined service quota or limit.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.CreateRelay
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/CreateRelay" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateRelayResponse createRelay(Consumer<CreateRelayRequest.Builder> createRelayRequest) throws ValidationException,
            ServiceQuotaExceededException, ConflictException, AwsServiceException, SdkClientException, MailManagerException {
        return createRelay(CreateRelayRequest.builder().applyMutation(createRelayRequest).build());
    }

    /**
     * <p>
     * Provision a new rule set.
     * </p>
     *
     * @param createRuleSetRequest
     * @return Result of the CreateRuleSet operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws ServiceQuotaExceededException
     *         Occurs when an operation exceeds a predefined service quota or limit.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.CreateRuleSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/CreateRuleSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateRuleSetResponse createRuleSet(CreateRuleSetRequest createRuleSetRequest) throws ValidationException,
            ServiceQuotaExceededException, ConflictException, AwsServiceException, SdkClientException, MailManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provision a new rule set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRuleSetRequest.Builder} avoiding the need to
     * create one manually via {@link CreateRuleSetRequest#builder()}
     * </p>
     *
     * @param createRuleSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.CreateRuleSetRequest.Builder} to create a
     *        request.
     * @return Result of the CreateRuleSet operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws ServiceQuotaExceededException
     *         Occurs when an operation exceeds a predefined service quota or limit.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.CreateRuleSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/CreateRuleSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateRuleSetResponse createRuleSet(Consumer<CreateRuleSetRequest.Builder> createRuleSetRequest)
            throws ValidationException, ServiceQuotaExceededException, ConflictException, AwsServiceException,
            SdkClientException, MailManagerException {
        return createRuleSet(CreateRuleSetRequest.builder().applyMutation(createRuleSetRequest).build());
    }

    /**
     * <p>
     * Provision a new traffic policy resource.
     * </p>
     *
     * @param createTrafficPolicyRequest
     * @return Result of the CreateTrafficPolicy operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws ServiceQuotaExceededException
     *         Occurs when an operation exceeds a predefined service quota or limit.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.CreateTrafficPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/CreateTrafficPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTrafficPolicyResponse createTrafficPolicy(CreateTrafficPolicyRequest createTrafficPolicyRequest)
            throws ValidationException, ServiceQuotaExceededException, ConflictException, AwsServiceException,
            SdkClientException, MailManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provision a new traffic policy resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTrafficPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link CreateTrafficPolicyRequest#builder()}
     * </p>
     *
     * @param createTrafficPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.CreateTrafficPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the CreateTrafficPolicy operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws ServiceQuotaExceededException
     *         Occurs when an operation exceeds a predefined service quota or limit.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.CreateTrafficPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/CreateTrafficPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTrafficPolicyResponse createTrafficPolicy(
            Consumer<CreateTrafficPolicyRequest.Builder> createTrafficPolicyRequest) throws ValidationException,
            ServiceQuotaExceededException, ConflictException, AwsServiceException, SdkClientException, MailManagerException {
        return createTrafficPolicy(CreateTrafficPolicyRequest.builder().applyMutation(createTrafficPolicyRequest).build());
    }

    /**
     * <p>
     * Deletes an Add On instance.
     * </p>
     *
     * @param deleteAddonInstanceRequest
     * @return Result of the DeleteAddonInstance operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.DeleteAddonInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/DeleteAddonInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAddonInstanceResponse deleteAddonInstance(DeleteAddonInstanceRequest deleteAddonInstanceRequest)
            throws ValidationException, ConflictException, AwsServiceException, SdkClientException, MailManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Add On instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAddonInstanceRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteAddonInstanceRequest#builder()}
     * </p>
     *
     * @param deleteAddonInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.DeleteAddonInstanceRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteAddonInstance operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.DeleteAddonInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/DeleteAddonInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAddonInstanceResponse deleteAddonInstance(
            Consumer<DeleteAddonInstanceRequest.Builder> deleteAddonInstanceRequest) throws ValidationException,
            ConflictException, AwsServiceException, SdkClientException, MailManagerException {
        return deleteAddonInstance(DeleteAddonInstanceRequest.builder().applyMutation(deleteAddonInstanceRequest).build());
    }

    /**
     * <p>
     * Deletes an Add On subscription.
     * </p>
     *
     * @param deleteAddonSubscriptionRequest
     * @return Result of the DeleteAddonSubscription operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.DeleteAddonSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/DeleteAddonSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAddonSubscriptionResponse deleteAddonSubscription(DeleteAddonSubscriptionRequest deleteAddonSubscriptionRequest)
            throws ValidationException, ConflictException, AwsServiceException, SdkClientException, MailManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Add On subscription.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAddonSubscriptionRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteAddonSubscriptionRequest#builder()}
     * </p>
     *
     * @param deleteAddonSubscriptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.DeleteAddonSubscriptionRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteAddonSubscription operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.DeleteAddonSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/DeleteAddonSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAddonSubscriptionResponse deleteAddonSubscription(
            Consumer<DeleteAddonSubscriptionRequest.Builder> deleteAddonSubscriptionRequest) throws ValidationException,
            ConflictException, AwsServiceException, SdkClientException, MailManagerException {
        return deleteAddonSubscription(DeleteAddonSubscriptionRequest.builder().applyMutation(deleteAddonSubscriptionRequest)
                .build());
    }

    /**
     * <p>
     * Deletes an address list.
     * </p>
     *
     * @param deleteAddressListRequest
     * @return Result of the DeleteAddressList operation returned by the service.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.DeleteAddressList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/DeleteAddressList" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteAddressListResponse deleteAddressList(DeleteAddressListRequest deleteAddressListRequest)
            throws AccessDeniedException, ConflictException, ThrottlingException, AwsServiceException, SdkClientException,
            MailManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an address list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAddressListRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteAddressListRequest#builder()}
     * </p>
     *
     * @param deleteAddressListRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.DeleteAddressListRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteAddressList operation returned by the service.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.DeleteAddressList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/DeleteAddressList" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteAddressListResponse deleteAddressList(Consumer<DeleteAddressListRequest.Builder> deleteAddressListRequest)
            throws AccessDeniedException, ConflictException, ThrottlingException, AwsServiceException, SdkClientException,
            MailManagerException {
        return deleteAddressList(DeleteAddressListRequest.builder().applyMutation(deleteAddressListRequest).build());
    }

    /**
     * <p>
     * Initiates deletion of an email archive. This changes the archive state to pending deletion. In this state, no new
     * emails can be added, and existing archived emails become inaccessible (search, export, download). The archive and
     * all of its contents will be permanently deleted 30 days after entering the pending deletion state, regardless of
     * the configured retention period.
     * </p>
     *
     * @param deleteArchiveRequest
     *        The request to initiate deletion of an email archive.
     * @return Result of the DeleteArchive operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.DeleteArchive
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/DeleteArchive" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteArchiveResponse deleteArchive(DeleteArchiveRequest deleteArchiveRequest) throws ValidationException,
            AccessDeniedException, ConflictException, ThrottlingException, AwsServiceException, SdkClientException,
            MailManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Initiates deletion of an email archive. This changes the archive state to pending deletion. In this state, no new
     * emails can be added, and existing archived emails become inaccessible (search, export, download). The archive and
     * all of its contents will be permanently deleted 30 days after entering the pending deletion state, regardless of
     * the configured retention period.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteArchiveRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteArchiveRequest#builder()}
     * </p>
     *
     * @param deleteArchiveRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.DeleteArchiveRequest.Builder} to create a
     *        request. The request to initiate deletion of an email archive.
     * @return Result of the DeleteArchive operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.DeleteArchive
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/DeleteArchive" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteArchiveResponse deleteArchive(Consumer<DeleteArchiveRequest.Builder> deleteArchiveRequest)
            throws ValidationException, AccessDeniedException, ConflictException, ThrottlingException, AwsServiceException,
            SdkClientException, MailManagerException {
        return deleteArchive(DeleteArchiveRequest.builder().applyMutation(deleteArchiveRequest).build());
    }

    /**
     * <p>
     * Delete an ingress endpoint resource.
     * </p>
     *
     * @param deleteIngressPointRequest
     * @return Result of the DeleteIngressPoint operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.DeleteIngressPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/DeleteIngressPoint"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteIngressPointResponse deleteIngressPoint(DeleteIngressPointRequest deleteIngressPointRequest)
            throws ValidationException, ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            MailManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete an ingress endpoint resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIngressPointRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteIngressPointRequest#builder()}
     * </p>
     *
     * @param deleteIngressPointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.DeleteIngressPointRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteIngressPoint operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.DeleteIngressPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/DeleteIngressPoint"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteIngressPointResponse deleteIngressPoint(Consumer<DeleteIngressPointRequest.Builder> deleteIngressPointRequest)
            throws ValidationException, ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            MailManagerException {
        return deleteIngressPoint(DeleteIngressPointRequest.builder().applyMutation(deleteIngressPointRequest).build());
    }

    /**
     * <p>
     * Deletes an existing relay resource.
     * </p>
     *
     * @param deleteRelayRequest
     * @return Result of the DeleteRelay operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.DeleteRelay
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/DeleteRelay" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteRelayResponse deleteRelay(DeleteRelayRequest deleteRelayRequest) throws ValidationException, ConflictException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, MailManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing relay resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRelayRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteRelayRequest#builder()}
     * </p>
     *
     * @param deleteRelayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.DeleteRelayRequest.Builder} to create a request.
     * @return Result of the DeleteRelay operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.DeleteRelay
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/DeleteRelay" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteRelayResponse deleteRelay(Consumer<DeleteRelayRequest.Builder> deleteRelayRequest) throws ValidationException,
            ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException, MailManagerException {
        return deleteRelay(DeleteRelayRequest.builder().applyMutation(deleteRelayRequest).build());
    }

    /**
     * <p>
     * Delete a rule set.
     * </p>
     *
     * @param deleteRuleSetRequest
     * @return Result of the DeleteRuleSet operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.DeleteRuleSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/DeleteRuleSet" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteRuleSetResponse deleteRuleSet(DeleteRuleSetRequest deleteRuleSetRequest) throws ValidationException,
            ConflictException, AwsServiceException, SdkClientException, MailManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a rule set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRuleSetRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteRuleSetRequest#builder()}
     * </p>
     *
     * @param deleteRuleSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.DeleteRuleSetRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteRuleSet operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.DeleteRuleSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/DeleteRuleSet" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteRuleSetResponse deleteRuleSet(Consumer<DeleteRuleSetRequest.Builder> deleteRuleSetRequest)
            throws ValidationException, ConflictException, AwsServiceException, SdkClientException, MailManagerException {
        return deleteRuleSet(DeleteRuleSetRequest.builder().applyMutation(deleteRuleSetRequest).build());
    }

    /**
     * <p>
     * Delete a traffic policy resource.
     * </p>
     *
     * @param deleteTrafficPolicyRequest
     * @return Result of the DeleteTrafficPolicy operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.DeleteTrafficPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/DeleteTrafficPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTrafficPolicyResponse deleteTrafficPolicy(DeleteTrafficPolicyRequest deleteTrafficPolicyRequest)
            throws ValidationException, ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            MailManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a traffic policy resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTrafficPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteTrafficPolicyRequest#builder()}
     * </p>
     *
     * @param deleteTrafficPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.DeleteTrafficPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteTrafficPolicy operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.DeleteTrafficPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/DeleteTrafficPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTrafficPolicyResponse deleteTrafficPolicy(
            Consumer<DeleteTrafficPolicyRequest.Builder> deleteTrafficPolicyRequest) throws ValidationException,
            ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException, MailManagerException {
        return deleteTrafficPolicy(DeleteTrafficPolicyRequest.builder().applyMutation(deleteTrafficPolicyRequest).build());
    }

    /**
     * <p>
     * Removes a member from an address list.
     * </p>
     *
     * @param deregisterMemberFromAddressListRequest
     * @return Result of the DeregisterMemberFromAddressList operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.DeregisterMemberFromAddressList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/DeregisterMemberFromAddressList"
     *      target="_top">AWS API Documentation</a>
     */
    default DeregisterMemberFromAddressListResponse deregisterMemberFromAddressList(
            DeregisterMemberFromAddressListRequest deregisterMemberFromAddressListRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            MailManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a member from an address list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterMemberFromAddressListRequest.Builder}
     * avoiding the need to create one manually via {@link DeregisterMemberFromAddressListRequest#builder()}
     * </p>
     *
     * @param deregisterMemberFromAddressListRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.DeregisterMemberFromAddressListRequest.Builder}
     *        to create a request.
     * @return Result of the DeregisterMemberFromAddressList operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.DeregisterMemberFromAddressList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/DeregisterMemberFromAddressList"
     *      target="_top">AWS API Documentation</a>
     */
    default DeregisterMemberFromAddressListResponse deregisterMemberFromAddressList(
            Consumer<DeregisterMemberFromAddressListRequest.Builder> deregisterMemberFromAddressListRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, MailManagerException {
        return deregisterMemberFromAddressList(DeregisterMemberFromAddressListRequest.builder()
                .applyMutation(deregisterMemberFromAddressListRequest).build());
    }

    /**
     * <p>
     * Gets detailed information about an Add On instance.
     * </p>
     *
     * @param getAddonInstanceRequest
     * @return Result of the GetAddonInstance operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.GetAddonInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetAddonInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default GetAddonInstanceResponse getAddonInstance(GetAddonInstanceRequest getAddonInstanceRequest)
            throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, MailManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets detailed information about an Add On instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAddonInstanceRequest.Builder} avoiding the need
     * to create one manually via {@link GetAddonInstanceRequest#builder()}
     * </p>
     *
     * @param getAddonInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.GetAddonInstanceRequest.Builder} to create a
     *        request.
     * @return Result of the GetAddonInstance operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.GetAddonInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetAddonInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default GetAddonInstanceResponse getAddonInstance(Consumer<GetAddonInstanceRequest.Builder> getAddonInstanceRequest)
            throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, MailManagerException {
        return getAddonInstance(GetAddonInstanceRequest.builder().applyMutation(getAddonInstanceRequest).build());
    }

    /**
     * <p>
     * Gets detailed information about an Add On subscription.
     * </p>
     *
     * @param getAddonSubscriptionRequest
     * @return Result of the GetAddonSubscription operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.GetAddonSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetAddonSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAddonSubscriptionResponse getAddonSubscription(GetAddonSubscriptionRequest getAddonSubscriptionRequest)
            throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, MailManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets detailed information about an Add On subscription.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAddonSubscriptionRequest.Builder} avoiding the
     * need to create one manually via {@link GetAddonSubscriptionRequest#builder()}
     * </p>
     *
     * @param getAddonSubscriptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.GetAddonSubscriptionRequest.Builder} to create a
     *        request.
     * @return Result of the GetAddonSubscription operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.GetAddonSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetAddonSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAddonSubscriptionResponse getAddonSubscription(
            Consumer<GetAddonSubscriptionRequest.Builder> getAddonSubscriptionRequest) throws ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, MailManagerException {
        return getAddonSubscription(GetAddonSubscriptionRequest.builder().applyMutation(getAddonSubscriptionRequest).build());
    }

    /**
     * <p>
     * Fetch attributes of an address list.
     * </p>
     *
     * @param getAddressListRequest
     * @return Result of the GetAddressList operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.GetAddressList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetAddressList" target="_top">AWS
     *      API Documentation</a>
     */
    default GetAddressListResponse getAddressList(GetAddressListRequest getAddressListRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            MailManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Fetch attributes of an address list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAddressListRequest.Builder} avoiding the need to
     * create one manually via {@link GetAddressListRequest#builder()}
     * </p>
     *
     * @param getAddressListRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.GetAddressListRequest.Builder} to create a
     *        request.
     * @return Result of the GetAddressList operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.GetAddressList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetAddressList" target="_top">AWS
     *      API Documentation</a>
     */
    default GetAddressListResponse getAddressList(Consumer<GetAddressListRequest.Builder> getAddressListRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, MailManagerException {
        return getAddressList(GetAddressListRequest.builder().applyMutation(getAddressListRequest).build());
    }

    /**
     * <p>
     * Fetch attributes of an import job.
     * </p>
     *
     * @param getAddressListImportJobRequest
     * @return Result of the GetAddressListImportJob operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.GetAddressListImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetAddressListImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAddressListImportJobResponse getAddressListImportJob(GetAddressListImportJobRequest getAddressListImportJobRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, MailManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Fetch attributes of an import job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAddressListImportJobRequest.Builder} avoiding
     * the need to create one manually via {@link GetAddressListImportJobRequest#builder()}
     * </p>
     *
     * @param getAddressListImportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.GetAddressListImportJobRequest.Builder} to create
     *        a request.
     * @return Result of the GetAddressListImportJob operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.GetAddressListImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetAddressListImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAddressListImportJobResponse getAddressListImportJob(
            Consumer<GetAddressListImportJobRequest.Builder> getAddressListImportJobRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            MailManagerException {
        return getAddressListImportJob(GetAddressListImportJobRequest.builder().applyMutation(getAddressListImportJobRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the full details and current state of a specified email archive.
     * </p>
     *
     * @param getArchiveRequest
     *        The request to retrieve details of an email archive.
     * @return Result of the GetArchive operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.GetArchive
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetArchive" target="_top">AWS API
     *      Documentation</a>
     */
    default GetArchiveResponse getArchive(GetArchiveRequest getArchiveRequest) throws ValidationException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, MailManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the full details and current state of a specified email archive.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetArchiveRequest.Builder} avoiding the need to
     * create one manually via {@link GetArchiveRequest#builder()}
     * </p>
     *
     * @param getArchiveRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.GetArchiveRequest.Builder} to create a request.
     *        The request to retrieve details of an email archive.
     * @return Result of the GetArchive operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.GetArchive
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetArchive" target="_top">AWS API
     *      Documentation</a>
     */
    default GetArchiveResponse getArchive(Consumer<GetArchiveRequest.Builder> getArchiveRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            MailManagerException {
        return getArchive(GetArchiveRequest.builder().applyMutation(getArchiveRequest).build());
    }

    /**
     * <p>
     * Retrieves the details and current status of a specific email archive export job.
     * </p>
     *
     * @param getArchiveExportRequest
     *        The request to retrieve details of a specific archive export job.
     * @return Result of the GetArchiveExport operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.GetArchiveExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetArchiveExport" target="_top">AWS
     *      API Documentation</a>
     */
    default GetArchiveExportResponse getArchiveExport(GetArchiveExportRequest getArchiveExportRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            MailManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the details and current status of a specific email archive export job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetArchiveExportRequest.Builder} avoiding the need
     * to create one manually via {@link GetArchiveExportRequest#builder()}
     * </p>
     *
     * @param getArchiveExportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.GetArchiveExportRequest.Builder} to create a
     *        request. The request to retrieve details of a specific archive export job.
     * @return Result of the GetArchiveExport operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.GetArchiveExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetArchiveExport" target="_top">AWS
     *      API Documentation</a>
     */
    default GetArchiveExportResponse getArchiveExport(Consumer<GetArchiveExportRequest.Builder> getArchiveExportRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            MailManagerException {
        return getArchiveExport(GetArchiveExportRequest.builder().applyMutation(getArchiveExportRequest).build());
    }

    /**
     * <p>
     * Returns a pre-signed URL that provides temporary download access to the specific email message stored in the
     * archive.
     * </p>
     *
     * @param getArchiveMessageRequest
     *        The request to get details of a specific email message stored in an archive.
     * @return Result of the GetArchiveMessage operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.GetArchiveMessage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetArchiveMessage" target="_top">AWS
     *      API Documentation</a>
     */
    default GetArchiveMessageResponse getArchiveMessage(GetArchiveMessageRequest getArchiveMessageRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            MailManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a pre-signed URL that provides temporary download access to the specific email message stored in the
     * archive.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetArchiveMessageRequest.Builder} avoiding the need
     * to create one manually via {@link GetArchiveMessageRequest#builder()}
     * </p>
     *
     * @param getArchiveMessageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.GetArchiveMessageRequest.Builder} to create a
     *        request. The request to get details of a specific email message stored in an archive.
     * @return Result of the GetArchiveMessage operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.GetArchiveMessage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetArchiveMessage" target="_top">AWS
     *      API Documentation</a>
     */
    default GetArchiveMessageResponse getArchiveMessage(Consumer<GetArchiveMessageRequest.Builder> getArchiveMessageRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            MailManagerException {
        return getArchiveMessage(GetArchiveMessageRequest.builder().applyMutation(getArchiveMessageRequest).build());
    }

    /**
     * <p>
     * Returns the textual content of a specific email message stored in the archive. Attachments are not included.
     * </p>
     *
     * @param getArchiveMessageContentRequest
     *        The request to get the textual content of a specific email message stored in an archive.
     * @return Result of the GetArchiveMessageContent operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.GetArchiveMessageContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetArchiveMessageContent"
     *      target="_top">AWS API Documentation</a>
     */
    default GetArchiveMessageContentResponse getArchiveMessageContent(
            GetArchiveMessageContentRequest getArchiveMessageContentRequest) throws ValidationException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, MailManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the textual content of a specific email message stored in the archive. Attachments are not included.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetArchiveMessageContentRequest.Builder} avoiding
     * the need to create one manually via {@link GetArchiveMessageContentRequest#builder()}
     * </p>
     *
     * @param getArchiveMessageContentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.GetArchiveMessageContentRequest.Builder} to
     *        create a request. The request to get the textual content of a specific email message stored in an archive.
     * @return Result of the GetArchiveMessageContent operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.GetArchiveMessageContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetArchiveMessageContent"
     *      target="_top">AWS API Documentation</a>
     */
    default GetArchiveMessageContentResponse getArchiveMessageContent(
            Consumer<GetArchiveMessageContentRequest.Builder> getArchiveMessageContentRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, MailManagerException {
        return getArchiveMessageContent(GetArchiveMessageContentRequest.builder().applyMutation(getArchiveMessageContentRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the details and current status of a specific email archive search job.
     * </p>
     *
     * @param getArchiveSearchRequest
     *        The request to retrieve details of a specific archive search job.
     * @return Result of the GetArchiveSearch operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.GetArchiveSearch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetArchiveSearch" target="_top">AWS
     *      API Documentation</a>
     */
    default GetArchiveSearchResponse getArchiveSearch(GetArchiveSearchRequest getArchiveSearchRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            MailManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the details and current status of a specific email archive search job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetArchiveSearchRequest.Builder} avoiding the need
     * to create one manually via {@link GetArchiveSearchRequest#builder()}
     * </p>
     *
     * @param getArchiveSearchRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.GetArchiveSearchRequest.Builder} to create a
     *        request. The request to retrieve details of a specific archive search job.
     * @return Result of the GetArchiveSearch operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.GetArchiveSearch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetArchiveSearch" target="_top">AWS
     *      API Documentation</a>
     */
    default GetArchiveSearchResponse getArchiveSearch(Consumer<GetArchiveSearchRequest.Builder> getArchiveSearchRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            MailManagerException {
        return getArchiveSearch(GetArchiveSearchRequest.builder().applyMutation(getArchiveSearchRequest).build());
    }

    /**
     * <p>
     * Returns the results of a completed email archive search job.
     * </p>
     *
     * @param getArchiveSearchResultsRequest
     *        The request to retrieve results from a completed archive search job.
     * @return Result of the GetArchiveSearchResults operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.GetArchiveSearchResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetArchiveSearchResults"
     *      target="_top">AWS API Documentation</a>
     */
    default GetArchiveSearchResultsResponse getArchiveSearchResults(GetArchiveSearchResultsRequest getArchiveSearchResultsRequest)
            throws ValidationException, AccessDeniedException, ConflictException, ThrottlingException, AwsServiceException,
            SdkClientException, MailManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the results of a completed email archive search job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetArchiveSearchResultsRequest.Builder} avoiding
     * the need to create one manually via {@link GetArchiveSearchResultsRequest#builder()}
     * </p>
     *
     * @param getArchiveSearchResultsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.GetArchiveSearchResultsRequest.Builder} to create
     *        a request. The request to retrieve results from a completed archive search job.
     * @return Result of the GetArchiveSearchResults operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.GetArchiveSearchResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetArchiveSearchResults"
     *      target="_top">AWS API Documentation</a>
     */
    default GetArchiveSearchResultsResponse getArchiveSearchResults(
            Consumer<GetArchiveSearchResultsRequest.Builder> getArchiveSearchResultsRequest) throws ValidationException,
            AccessDeniedException, ConflictException, ThrottlingException, AwsServiceException, SdkClientException,
            MailManagerException {
        return getArchiveSearchResults(GetArchiveSearchResultsRequest.builder().applyMutation(getArchiveSearchResultsRequest)
                .build());
    }

    /**
     * <p>
     * Fetch ingress endpoint resource attributes.
     * </p>
     *
     * @param getIngressPointRequest
     * @return Result of the GetIngressPoint operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.GetIngressPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetIngressPoint" target="_top">AWS
     *      API Documentation</a>
     */
    default GetIngressPointResponse getIngressPoint(GetIngressPointRequest getIngressPointRequest) throws ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, MailManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Fetch ingress endpoint resource attributes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIngressPointRequest.Builder} avoiding the need
     * to create one manually via {@link GetIngressPointRequest#builder()}
     * </p>
     *
     * @param getIngressPointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.GetIngressPointRequest.Builder} to create a
     *        request.
     * @return Result of the GetIngressPoint operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.GetIngressPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetIngressPoint" target="_top">AWS
     *      API Documentation</a>
     */
    default GetIngressPointResponse getIngressPoint(Consumer<GetIngressPointRequest.Builder> getIngressPointRequest)
            throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, MailManagerException {
        return getIngressPoint(GetIngressPointRequest.builder().applyMutation(getIngressPointRequest).build());
    }

    /**
     * <p>
     * Fetch attributes of a member in an address list.
     * </p>
     *
     * @param getMemberOfAddressListRequest
     * @return Result of the GetMemberOfAddressList operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.GetMemberOfAddressList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetMemberOfAddressList"
     *      target="_top">AWS API Documentation</a>
     */
    default GetMemberOfAddressListResponse getMemberOfAddressList(GetMemberOfAddressListRequest getMemberOfAddressListRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, MailManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Fetch attributes of a member in an address list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMemberOfAddressListRequest.Builder} avoiding the
     * need to create one manually via {@link GetMemberOfAddressListRequest#builder()}
     * </p>
     *
     * @param getMemberOfAddressListRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.GetMemberOfAddressListRequest.Builder} to create
     *        a request.
     * @return Result of the GetMemberOfAddressList operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.GetMemberOfAddressList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetMemberOfAddressList"
     *      target="_top">AWS API Documentation</a>
     */
    default GetMemberOfAddressListResponse getMemberOfAddressList(
            Consumer<GetMemberOfAddressListRequest.Builder> getMemberOfAddressListRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            MailManagerException {
        return getMemberOfAddressList(GetMemberOfAddressListRequest.builder().applyMutation(getMemberOfAddressListRequest)
                .build());
    }

    /**
     * <p>
     * Fetch the relay resource and it's attributes.
     * </p>
     *
     * @param getRelayRequest
     * @return Result of the GetRelay operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.GetRelay
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetRelay" target="_top">AWS API
     *      Documentation</a>
     */
    default GetRelayResponse getRelay(GetRelayRequest getRelayRequest) throws ValidationException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, MailManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Fetch the relay resource and it's attributes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRelayRequest.Builder} avoiding the need to
     * create one manually via {@link GetRelayRequest#builder()}
     * </p>
     *
     * @param getRelayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.GetRelayRequest.Builder} to create a request.
     * @return Result of the GetRelay operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.GetRelay
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetRelay" target="_top">AWS API
     *      Documentation</a>
     */
    default GetRelayResponse getRelay(Consumer<GetRelayRequest.Builder> getRelayRequest) throws ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, MailManagerException {
        return getRelay(GetRelayRequest.builder().applyMutation(getRelayRequest).build());
    }

    /**
     * <p>
     * Fetch attributes of a rule set.
     * </p>
     *
     * @param getRuleSetRequest
     * @return Result of the GetRuleSet operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.GetRuleSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetRuleSet" target="_top">AWS API
     *      Documentation</a>
     */
    default GetRuleSetResponse getRuleSet(GetRuleSetRequest getRuleSetRequest) throws ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, MailManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Fetch attributes of a rule set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRuleSetRequest.Builder} avoiding the need to
     * create one manually via {@link GetRuleSetRequest#builder()}
     * </p>
     *
     * @param getRuleSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.GetRuleSetRequest.Builder} to create a request.
     * @return Result of the GetRuleSet operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.GetRuleSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetRuleSet" target="_top">AWS API
     *      Documentation</a>
     */
    default GetRuleSetResponse getRuleSet(Consumer<GetRuleSetRequest.Builder> getRuleSetRequest) throws ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, MailManagerException {
        return getRuleSet(GetRuleSetRequest.builder().applyMutation(getRuleSetRequest).build());
    }

    /**
     * <p>
     * Fetch attributes of a traffic policy resource.
     * </p>
     *
     * @param getTrafficPolicyRequest
     * @return Result of the GetTrafficPolicy operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.GetTrafficPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetTrafficPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default GetTrafficPolicyResponse getTrafficPolicy(GetTrafficPolicyRequest getTrafficPolicyRequest)
            throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, MailManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Fetch attributes of a traffic policy resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTrafficPolicyRequest.Builder} avoiding the need
     * to create one manually via {@link GetTrafficPolicyRequest#builder()}
     * </p>
     *
     * @param getTrafficPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.GetTrafficPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the GetTrafficPolicy operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.GetTrafficPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/GetTrafficPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default GetTrafficPolicyResponse getTrafficPolicy(Consumer<GetTrafficPolicyRequest.Builder> getTrafficPolicyRequest)
            throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, MailManagerException {
        return getTrafficPolicy(GetTrafficPolicyRequest.builder().applyMutation(getTrafficPolicyRequest).build());
    }

    /**
     * <p>
     * Lists all Add On instances in your account.
     * </p>
     *
     * @param listAddonInstancesRequest
     * @return Result of the ListAddonInstances operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.ListAddonInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListAddonInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAddonInstancesResponse listAddonInstances(ListAddonInstancesRequest listAddonInstancesRequest)
            throws ValidationException, AwsServiceException, SdkClientException, MailManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all Add On instances in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAddonInstancesRequest.Builder} avoiding the
     * need to create one manually via {@link ListAddonInstancesRequest#builder()}
     * </p>
     *
     * @param listAddonInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.ListAddonInstancesRequest.Builder} to create a
     *        request.
     * @return Result of the ListAddonInstances operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.ListAddonInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListAddonInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAddonInstancesResponse listAddonInstances(Consumer<ListAddonInstancesRequest.Builder> listAddonInstancesRequest)
            throws ValidationException, AwsServiceException, SdkClientException, MailManagerException {
        return listAddonInstances(ListAddonInstancesRequest.builder().applyMutation(listAddonInstancesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAddonInstances(software.amazon.awssdk.services.mailmanager.model.ListAddonInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListAddonInstancesIterable responses = client.listAddonInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mailmanager.paginators.ListAddonInstancesIterable responses = client
     *             .listAddonInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.mailmanager.model.ListAddonInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListAddonInstancesIterable responses = client.listAddonInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAddonInstances(software.amazon.awssdk.services.mailmanager.model.ListAddonInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAddonInstancesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.ListAddonInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListAddonInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAddonInstancesIterable listAddonInstancesPaginator(ListAddonInstancesRequest listAddonInstancesRequest)
            throws ValidationException, AwsServiceException, SdkClientException, MailManagerException {
        return new ListAddonInstancesIterable(this, listAddonInstancesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAddonInstances(software.amazon.awssdk.services.mailmanager.model.ListAddonInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListAddonInstancesIterable responses = client.listAddonInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mailmanager.paginators.ListAddonInstancesIterable responses = client
     *             .listAddonInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.mailmanager.model.ListAddonInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListAddonInstancesIterable responses = client.listAddonInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAddonInstances(software.amazon.awssdk.services.mailmanager.model.ListAddonInstancesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAddonInstancesRequest.Builder} avoiding the
     * need to create one manually via {@link ListAddonInstancesRequest#builder()}
     * </p>
     *
     * @param listAddonInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.ListAddonInstancesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.ListAddonInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListAddonInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAddonInstancesIterable listAddonInstancesPaginator(
            Consumer<ListAddonInstancesRequest.Builder> listAddonInstancesRequest) throws ValidationException,
            AwsServiceException, SdkClientException, MailManagerException {
        return listAddonInstancesPaginator(ListAddonInstancesRequest.builder().applyMutation(listAddonInstancesRequest).build());
    }

    /**
     * <p>
     * Lists all Add On subscriptions in your account.
     * </p>
     *
     * @param listAddonSubscriptionsRequest
     * @return Result of the ListAddonSubscriptions operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.ListAddonSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListAddonSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAddonSubscriptionsResponse listAddonSubscriptions(ListAddonSubscriptionsRequest listAddonSubscriptionsRequest)
            throws ValidationException, AwsServiceException, SdkClientException, MailManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all Add On subscriptions in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAddonSubscriptionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAddonSubscriptionsRequest#builder()}
     * </p>
     *
     * @param listAddonSubscriptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.ListAddonSubscriptionsRequest.Builder} to create
     *        a request.
     * @return Result of the ListAddonSubscriptions operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.ListAddonSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListAddonSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAddonSubscriptionsResponse listAddonSubscriptions(
            Consumer<ListAddonSubscriptionsRequest.Builder> listAddonSubscriptionsRequest) throws ValidationException,
            AwsServiceException, SdkClientException, MailManagerException {
        return listAddonSubscriptions(ListAddonSubscriptionsRequest.builder().applyMutation(listAddonSubscriptionsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAddonSubscriptions(software.amazon.awssdk.services.mailmanager.model.ListAddonSubscriptionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListAddonSubscriptionsIterable responses = client.listAddonSubscriptionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mailmanager.paginators.ListAddonSubscriptionsIterable responses = client
     *             .listAddonSubscriptionsPaginator(request);
     *     for (software.amazon.awssdk.services.mailmanager.model.ListAddonSubscriptionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListAddonSubscriptionsIterable responses = client.listAddonSubscriptionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAddonSubscriptions(software.amazon.awssdk.services.mailmanager.model.ListAddonSubscriptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAddonSubscriptionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.ListAddonSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListAddonSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAddonSubscriptionsIterable listAddonSubscriptionsPaginator(
            ListAddonSubscriptionsRequest listAddonSubscriptionsRequest) throws ValidationException, AwsServiceException,
            SdkClientException, MailManagerException {
        return new ListAddonSubscriptionsIterable(this, listAddonSubscriptionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAddonSubscriptions(software.amazon.awssdk.services.mailmanager.model.ListAddonSubscriptionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListAddonSubscriptionsIterable responses = client.listAddonSubscriptionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mailmanager.paginators.ListAddonSubscriptionsIterable responses = client
     *             .listAddonSubscriptionsPaginator(request);
     *     for (software.amazon.awssdk.services.mailmanager.model.ListAddonSubscriptionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListAddonSubscriptionsIterable responses = client.listAddonSubscriptionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAddonSubscriptions(software.amazon.awssdk.services.mailmanager.model.ListAddonSubscriptionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAddonSubscriptionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAddonSubscriptionsRequest#builder()}
     * </p>
     *
     * @param listAddonSubscriptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.ListAddonSubscriptionsRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.ListAddonSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListAddonSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAddonSubscriptionsIterable listAddonSubscriptionsPaginator(
            Consumer<ListAddonSubscriptionsRequest.Builder> listAddonSubscriptionsRequest) throws ValidationException,
            AwsServiceException, SdkClientException, MailManagerException {
        return listAddonSubscriptionsPaginator(ListAddonSubscriptionsRequest.builder()
                .applyMutation(listAddonSubscriptionsRequest).build());
    }

    /**
     * <p>
     * Lists jobs for an address list.
     * </p>
     *
     * @param listAddressListImportJobsRequest
     * @return Result of the ListAddressListImportJobs operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.ListAddressListImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListAddressListImportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAddressListImportJobsResponse listAddressListImportJobs(
            ListAddressListImportJobsRequest listAddressListImportJobsRequest) throws ValidationException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, MailManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists jobs for an address list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAddressListImportJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListAddressListImportJobsRequest#builder()}
     * </p>
     *
     * @param listAddressListImportJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.ListAddressListImportJobsRequest.Builder} to
     *        create a request.
     * @return Result of the ListAddressListImportJobs operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.ListAddressListImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListAddressListImportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAddressListImportJobsResponse listAddressListImportJobs(
            Consumer<ListAddressListImportJobsRequest.Builder> listAddressListImportJobsRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            MailManagerException {
        return listAddressListImportJobs(ListAddressListImportJobsRequest.builder()
                .applyMutation(listAddressListImportJobsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAddressListImportJobs(software.amazon.awssdk.services.mailmanager.model.ListAddressListImportJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListAddressListImportJobsIterable responses = client.listAddressListImportJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mailmanager.paginators.ListAddressListImportJobsIterable responses = client
     *             .listAddressListImportJobsPaginator(request);
     *     for (software.amazon.awssdk.services.mailmanager.model.ListAddressListImportJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListAddressListImportJobsIterable responses = client.listAddressListImportJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAddressListImportJobs(software.amazon.awssdk.services.mailmanager.model.ListAddressListImportJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAddressListImportJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.ListAddressListImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListAddressListImportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAddressListImportJobsIterable listAddressListImportJobsPaginator(
            ListAddressListImportJobsRequest listAddressListImportJobsRequest) throws ValidationException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, MailManagerException {
        return new ListAddressListImportJobsIterable(this, listAddressListImportJobsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAddressListImportJobs(software.amazon.awssdk.services.mailmanager.model.ListAddressListImportJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListAddressListImportJobsIterable responses = client.listAddressListImportJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mailmanager.paginators.ListAddressListImportJobsIterable responses = client
     *             .listAddressListImportJobsPaginator(request);
     *     for (software.amazon.awssdk.services.mailmanager.model.ListAddressListImportJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListAddressListImportJobsIterable responses = client.listAddressListImportJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAddressListImportJobs(software.amazon.awssdk.services.mailmanager.model.ListAddressListImportJobsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAddressListImportJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListAddressListImportJobsRequest#builder()}
     * </p>
     *
     * @param listAddressListImportJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.ListAddressListImportJobsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.ListAddressListImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListAddressListImportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAddressListImportJobsIterable listAddressListImportJobsPaginator(
            Consumer<ListAddressListImportJobsRequest.Builder> listAddressListImportJobsRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            MailManagerException {
        return listAddressListImportJobsPaginator(ListAddressListImportJobsRequest.builder()
                .applyMutation(listAddressListImportJobsRequest).build());
    }

    /**
     * <p>
     * Lists address lists for this account.
     * </p>
     *
     * @param listAddressListsRequest
     * @return Result of the ListAddressLists operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.ListAddressLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListAddressLists" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAddressListsResponse listAddressLists(ListAddressListsRequest listAddressListsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            MailManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists address lists for this account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAddressListsRequest.Builder} avoiding the need
     * to create one manually via {@link ListAddressListsRequest#builder()}
     * </p>
     *
     * @param listAddressListsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.ListAddressListsRequest.Builder} to create a
     *        request.
     * @return Result of the ListAddressLists operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.ListAddressLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListAddressLists" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAddressListsResponse listAddressLists(Consumer<ListAddressListsRequest.Builder> listAddressListsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            MailManagerException {
        return listAddressLists(ListAddressListsRequest.builder().applyMutation(listAddressListsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAddressLists(software.amazon.awssdk.services.mailmanager.model.ListAddressListsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListAddressListsIterable responses = client.listAddressListsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mailmanager.paginators.ListAddressListsIterable responses = client
     *             .listAddressListsPaginator(request);
     *     for (software.amazon.awssdk.services.mailmanager.model.ListAddressListsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListAddressListsIterable responses = client.listAddressListsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAddressLists(software.amazon.awssdk.services.mailmanager.model.ListAddressListsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAddressListsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.ListAddressLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListAddressLists" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAddressListsIterable listAddressListsPaginator(ListAddressListsRequest listAddressListsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            MailManagerException {
        return new ListAddressListsIterable(this, listAddressListsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAddressLists(software.amazon.awssdk.services.mailmanager.model.ListAddressListsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListAddressListsIterable responses = client.listAddressListsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mailmanager.paginators.ListAddressListsIterable responses = client
     *             .listAddressListsPaginator(request);
     *     for (software.amazon.awssdk.services.mailmanager.model.ListAddressListsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListAddressListsIterable responses = client.listAddressListsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAddressLists(software.amazon.awssdk.services.mailmanager.model.ListAddressListsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAddressListsRequest.Builder} avoiding the need
     * to create one manually via {@link ListAddressListsRequest#builder()}
     * </p>
     *
     * @param listAddressListsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.ListAddressListsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.ListAddressLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListAddressLists" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAddressListsIterable listAddressListsPaginator(Consumer<ListAddressListsRequest.Builder> listAddressListsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            MailManagerException {
        return listAddressListsPaginator(ListAddressListsRequest.builder().applyMutation(listAddressListsRequest).build());
    }

    /**
     * <p>
     * Returns a list of email archive export jobs.
     * </p>
     *
     * @param listArchiveExportsRequest
     *        The request to list archive export jobs in your account.
     * @return Result of the ListArchiveExports operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.ListArchiveExports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListArchiveExports"
     *      target="_top">AWS API Documentation</a>
     */
    default ListArchiveExportsResponse listArchiveExports(ListArchiveExportsRequest listArchiveExportsRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, MailManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of email archive export jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListArchiveExportsRequest.Builder} avoiding the
     * need to create one manually via {@link ListArchiveExportsRequest#builder()}
     * </p>
     *
     * @param listArchiveExportsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.ListArchiveExportsRequest.Builder} to create a
     *        request. The request to list archive export jobs in your account.
     * @return Result of the ListArchiveExports operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.ListArchiveExports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListArchiveExports"
     *      target="_top">AWS API Documentation</a>
     */
    default ListArchiveExportsResponse listArchiveExports(Consumer<ListArchiveExportsRequest.Builder> listArchiveExportsRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, MailManagerException {
        return listArchiveExports(ListArchiveExportsRequest.builder().applyMutation(listArchiveExportsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listArchiveExports(software.amazon.awssdk.services.mailmanager.model.ListArchiveExportsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListArchiveExportsIterable responses = client.listArchiveExportsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mailmanager.paginators.ListArchiveExportsIterable responses = client
     *             .listArchiveExportsPaginator(request);
     *     for (software.amazon.awssdk.services.mailmanager.model.ListArchiveExportsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListArchiveExportsIterable responses = client.listArchiveExportsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listArchiveExports(software.amazon.awssdk.services.mailmanager.model.ListArchiveExportsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listArchiveExportsRequest
     *        The request to list archive export jobs in your account.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.ListArchiveExports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListArchiveExports"
     *      target="_top">AWS API Documentation</a>
     */
    default ListArchiveExportsIterable listArchiveExportsPaginator(ListArchiveExportsRequest listArchiveExportsRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, MailManagerException {
        return new ListArchiveExportsIterable(this, listArchiveExportsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listArchiveExports(software.amazon.awssdk.services.mailmanager.model.ListArchiveExportsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListArchiveExportsIterable responses = client.listArchiveExportsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mailmanager.paginators.ListArchiveExportsIterable responses = client
     *             .listArchiveExportsPaginator(request);
     *     for (software.amazon.awssdk.services.mailmanager.model.ListArchiveExportsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListArchiveExportsIterable responses = client.listArchiveExportsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listArchiveExports(software.amazon.awssdk.services.mailmanager.model.ListArchiveExportsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListArchiveExportsRequest.Builder} avoiding the
     * need to create one manually via {@link ListArchiveExportsRequest#builder()}
     * </p>
     *
     * @param listArchiveExportsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.ListArchiveExportsRequest.Builder} to create a
     *        request. The request to list archive export jobs in your account.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.ListArchiveExports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListArchiveExports"
     *      target="_top">AWS API Documentation</a>
     */
    default ListArchiveExportsIterable listArchiveExportsPaginator(
            Consumer<ListArchiveExportsRequest.Builder> listArchiveExportsRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            MailManagerException {
        return listArchiveExportsPaginator(ListArchiveExportsRequest.builder().applyMutation(listArchiveExportsRequest).build());
    }

    /**
     * <p>
     * Returns a list of email archive search jobs.
     * </p>
     *
     * @param listArchiveSearchesRequest
     *        The request to list archive search jobs in your account.
     * @return Result of the ListArchiveSearches operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.ListArchiveSearches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListArchiveSearches"
     *      target="_top">AWS API Documentation</a>
     */
    default ListArchiveSearchesResponse listArchiveSearches(ListArchiveSearchesRequest listArchiveSearchesRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, MailManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of email archive search jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListArchiveSearchesRequest.Builder} avoiding the
     * need to create one manually via {@link ListArchiveSearchesRequest#builder()}
     * </p>
     *
     * @param listArchiveSearchesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.ListArchiveSearchesRequest.Builder} to create a
     *        request. The request to list archive search jobs in your account.
     * @return Result of the ListArchiveSearches operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.ListArchiveSearches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListArchiveSearches"
     *      target="_top">AWS API Documentation</a>
     */
    default ListArchiveSearchesResponse listArchiveSearches(
            Consumer<ListArchiveSearchesRequest.Builder> listArchiveSearchesRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            MailManagerException {
        return listArchiveSearches(ListArchiveSearchesRequest.builder().applyMutation(listArchiveSearchesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listArchiveSearches(software.amazon.awssdk.services.mailmanager.model.ListArchiveSearchesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListArchiveSearchesIterable responses = client.listArchiveSearchesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mailmanager.paginators.ListArchiveSearchesIterable responses = client
     *             .listArchiveSearchesPaginator(request);
     *     for (software.amazon.awssdk.services.mailmanager.model.ListArchiveSearchesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListArchiveSearchesIterable responses = client.listArchiveSearchesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listArchiveSearches(software.amazon.awssdk.services.mailmanager.model.ListArchiveSearchesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listArchiveSearchesRequest
     *        The request to list archive search jobs in your account.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.ListArchiveSearches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListArchiveSearches"
     *      target="_top">AWS API Documentation</a>
     */
    default ListArchiveSearchesIterable listArchiveSearchesPaginator(ListArchiveSearchesRequest listArchiveSearchesRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, MailManagerException {
        return new ListArchiveSearchesIterable(this, listArchiveSearchesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listArchiveSearches(software.amazon.awssdk.services.mailmanager.model.ListArchiveSearchesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListArchiveSearchesIterable responses = client.listArchiveSearchesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mailmanager.paginators.ListArchiveSearchesIterable responses = client
     *             .listArchiveSearchesPaginator(request);
     *     for (software.amazon.awssdk.services.mailmanager.model.ListArchiveSearchesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListArchiveSearchesIterable responses = client.listArchiveSearchesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listArchiveSearches(software.amazon.awssdk.services.mailmanager.model.ListArchiveSearchesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListArchiveSearchesRequest.Builder} avoiding the
     * need to create one manually via {@link ListArchiveSearchesRequest#builder()}
     * </p>
     *
     * @param listArchiveSearchesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.ListArchiveSearchesRequest.Builder} to create a
     *        request. The request to list archive search jobs in your account.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.ListArchiveSearches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListArchiveSearches"
     *      target="_top">AWS API Documentation</a>
     */
    default ListArchiveSearchesIterable listArchiveSearchesPaginator(
            Consumer<ListArchiveSearchesRequest.Builder> listArchiveSearchesRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            MailManagerException {
        return listArchiveSearchesPaginator(ListArchiveSearchesRequest.builder().applyMutation(listArchiveSearchesRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of all email archives in your account.
     * </p>
     *
     * @param listArchivesRequest
     *        The request to list email archives in your account.
     * @return Result of the ListArchives operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.ListArchives
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListArchives" target="_top">AWS API
     *      Documentation</a>
     */
    default ListArchivesResponse listArchives(ListArchivesRequest listArchivesRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, MailManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all email archives in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListArchivesRequest.Builder} avoiding the need to
     * create one manually via {@link ListArchivesRequest#builder()}
     * </p>
     *
     * @param listArchivesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.ListArchivesRequest.Builder} to create a request.
     *        The request to list email archives in your account.
     * @return Result of the ListArchives operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.ListArchives
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListArchives" target="_top">AWS API
     *      Documentation</a>
     */
    default ListArchivesResponse listArchives(Consumer<ListArchivesRequest.Builder> listArchivesRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            MailManagerException {
        return listArchives(ListArchivesRequest.builder().applyMutation(listArchivesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listArchives(software.amazon.awssdk.services.mailmanager.model.ListArchivesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListArchivesIterable responses = client.listArchivesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mailmanager.paginators.ListArchivesIterable responses = client.listArchivesPaginator(request);
     *     for (software.amazon.awssdk.services.mailmanager.model.ListArchivesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListArchivesIterable responses = client.listArchivesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listArchives(software.amazon.awssdk.services.mailmanager.model.ListArchivesRequest)} operation.</b>
     * </p>
     *
     * @param listArchivesRequest
     *        The request to list email archives in your account.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.ListArchives
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListArchives" target="_top">AWS API
     *      Documentation</a>
     */
    default ListArchivesIterable listArchivesPaginator(ListArchivesRequest listArchivesRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, MailManagerException {
        return new ListArchivesIterable(this, listArchivesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listArchives(software.amazon.awssdk.services.mailmanager.model.ListArchivesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListArchivesIterable responses = client.listArchivesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mailmanager.paginators.ListArchivesIterable responses = client.listArchivesPaginator(request);
     *     for (software.amazon.awssdk.services.mailmanager.model.ListArchivesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListArchivesIterable responses = client.listArchivesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listArchives(software.amazon.awssdk.services.mailmanager.model.ListArchivesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListArchivesRequest.Builder} avoiding the need to
     * create one manually via {@link ListArchivesRequest#builder()}
     * </p>
     *
     * @param listArchivesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.ListArchivesRequest.Builder} to create a request.
     *        The request to list email archives in your account.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.ListArchives
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListArchives" target="_top">AWS API
     *      Documentation</a>
     */
    default ListArchivesIterable listArchivesPaginator(Consumer<ListArchivesRequest.Builder> listArchivesRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            MailManagerException {
        return listArchivesPaginator(ListArchivesRequest.builder().applyMutation(listArchivesRequest).build());
    }

    /**
     * <p>
     * List all ingress endpoint resources.
     * </p>
     *
     * @param listIngressPointsRequest
     * @return Result of the ListIngressPoints operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.ListIngressPoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListIngressPoints" target="_top">AWS
     *      API Documentation</a>
     */
    default ListIngressPointsResponse listIngressPoints(ListIngressPointsRequest listIngressPointsRequest)
            throws ValidationException, AwsServiceException, SdkClientException, MailManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all ingress endpoint resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIngressPointsRequest.Builder} avoiding the need
     * to create one manually via {@link ListIngressPointsRequest#builder()}
     * </p>
     *
     * @param listIngressPointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.ListIngressPointsRequest.Builder} to create a
     *        request.
     * @return Result of the ListIngressPoints operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.ListIngressPoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListIngressPoints" target="_top">AWS
     *      API Documentation</a>
     */
    default ListIngressPointsResponse listIngressPoints(Consumer<ListIngressPointsRequest.Builder> listIngressPointsRequest)
            throws ValidationException, AwsServiceException, SdkClientException, MailManagerException {
        return listIngressPoints(ListIngressPointsRequest.builder().applyMutation(listIngressPointsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listIngressPoints(software.amazon.awssdk.services.mailmanager.model.ListIngressPointsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListIngressPointsIterable responses = client.listIngressPointsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mailmanager.paginators.ListIngressPointsIterable responses = client
     *             .listIngressPointsPaginator(request);
     *     for (software.amazon.awssdk.services.mailmanager.model.ListIngressPointsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListIngressPointsIterable responses = client.listIngressPointsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIngressPoints(software.amazon.awssdk.services.mailmanager.model.ListIngressPointsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listIngressPointsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.ListIngressPoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListIngressPoints" target="_top">AWS
     *      API Documentation</a>
     */
    default ListIngressPointsIterable listIngressPointsPaginator(ListIngressPointsRequest listIngressPointsRequest)
            throws ValidationException, AwsServiceException, SdkClientException, MailManagerException {
        return new ListIngressPointsIterable(this, listIngressPointsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listIngressPoints(software.amazon.awssdk.services.mailmanager.model.ListIngressPointsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListIngressPointsIterable responses = client.listIngressPointsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mailmanager.paginators.ListIngressPointsIterable responses = client
     *             .listIngressPointsPaginator(request);
     *     for (software.amazon.awssdk.services.mailmanager.model.ListIngressPointsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListIngressPointsIterable responses = client.listIngressPointsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIngressPoints(software.amazon.awssdk.services.mailmanager.model.ListIngressPointsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIngressPointsRequest.Builder} avoiding the need
     * to create one manually via {@link ListIngressPointsRequest#builder()}
     * </p>
     *
     * @param listIngressPointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.ListIngressPointsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.ListIngressPoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListIngressPoints" target="_top">AWS
     *      API Documentation</a>
     */
    default ListIngressPointsIterable listIngressPointsPaginator(
            Consumer<ListIngressPointsRequest.Builder> listIngressPointsRequest) throws ValidationException, AwsServiceException,
            SdkClientException, MailManagerException {
        return listIngressPointsPaginator(ListIngressPointsRequest.builder().applyMutation(listIngressPointsRequest).build());
    }

    /**
     * <p>
     * Lists members of an address list.
     * </p>
     *
     * @param listMembersOfAddressListRequest
     * @return Result of the ListMembersOfAddressList operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.ListMembersOfAddressList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListMembersOfAddressList"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMembersOfAddressListResponse listMembersOfAddressList(
            ListMembersOfAddressListRequest listMembersOfAddressListRequest) throws ValidationException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, MailManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists members of an address list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMembersOfAddressListRequest.Builder} avoiding
     * the need to create one manually via {@link ListMembersOfAddressListRequest#builder()}
     * </p>
     *
     * @param listMembersOfAddressListRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.ListMembersOfAddressListRequest.Builder} to
     *        create a request.
     * @return Result of the ListMembersOfAddressList operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.ListMembersOfAddressList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListMembersOfAddressList"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMembersOfAddressListResponse listMembersOfAddressList(
            Consumer<ListMembersOfAddressListRequest.Builder> listMembersOfAddressListRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            MailManagerException {
        return listMembersOfAddressList(ListMembersOfAddressListRequest.builder().applyMutation(listMembersOfAddressListRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMembersOfAddressList(software.amazon.awssdk.services.mailmanager.model.ListMembersOfAddressListRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListMembersOfAddressListIterable responses = client.listMembersOfAddressListPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mailmanager.paginators.ListMembersOfAddressListIterable responses = client
     *             .listMembersOfAddressListPaginator(request);
     *     for (software.amazon.awssdk.services.mailmanager.model.ListMembersOfAddressListResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListMembersOfAddressListIterable responses = client.listMembersOfAddressListPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMembersOfAddressList(software.amazon.awssdk.services.mailmanager.model.ListMembersOfAddressListRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMembersOfAddressListRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.ListMembersOfAddressList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListMembersOfAddressList"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMembersOfAddressListIterable listMembersOfAddressListPaginator(
            ListMembersOfAddressListRequest listMembersOfAddressListRequest) throws ValidationException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, MailManagerException {
        return new ListMembersOfAddressListIterable(this, listMembersOfAddressListRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMembersOfAddressList(software.amazon.awssdk.services.mailmanager.model.ListMembersOfAddressListRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListMembersOfAddressListIterable responses = client.listMembersOfAddressListPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mailmanager.paginators.ListMembersOfAddressListIterable responses = client
     *             .listMembersOfAddressListPaginator(request);
     *     for (software.amazon.awssdk.services.mailmanager.model.ListMembersOfAddressListResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListMembersOfAddressListIterable responses = client.listMembersOfAddressListPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMembersOfAddressList(software.amazon.awssdk.services.mailmanager.model.ListMembersOfAddressListRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMembersOfAddressListRequest.Builder} avoiding
     * the need to create one manually via {@link ListMembersOfAddressListRequest#builder()}
     * </p>
     *
     * @param listMembersOfAddressListRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.ListMembersOfAddressListRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.ListMembersOfAddressList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListMembersOfAddressList"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMembersOfAddressListIterable listMembersOfAddressListPaginator(
            Consumer<ListMembersOfAddressListRequest.Builder> listMembersOfAddressListRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            MailManagerException {
        return listMembersOfAddressListPaginator(ListMembersOfAddressListRequest.builder()
                .applyMutation(listMembersOfAddressListRequest).build());
    }

    /**
     * <p>
     * Lists all the existing relay resources.
     * </p>
     *
     * @param listRelaysRequest
     * @return Result of the ListRelays operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.ListRelays
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListRelays" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRelaysResponse listRelays(ListRelaysRequest listRelaysRequest) throws ValidationException, AwsServiceException,
            SdkClientException, MailManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the existing relay resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRelaysRequest.Builder} avoiding the need to
     * create one manually via {@link ListRelaysRequest#builder()}
     * </p>
     *
     * @param listRelaysRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.ListRelaysRequest.Builder} to create a request.
     * @return Result of the ListRelays operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.ListRelays
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListRelays" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRelaysResponse listRelays(Consumer<ListRelaysRequest.Builder> listRelaysRequest) throws ValidationException,
            AwsServiceException, SdkClientException, MailManagerException {
        return listRelays(ListRelaysRequest.builder().applyMutation(listRelaysRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listRelays(software.amazon.awssdk.services.mailmanager.model.ListRelaysRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListRelaysIterable responses = client.listRelaysPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mailmanager.paginators.ListRelaysIterable responses = client.listRelaysPaginator(request);
     *     for (software.amazon.awssdk.services.mailmanager.model.ListRelaysResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListRelaysIterable responses = client.listRelaysPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRelays(software.amazon.awssdk.services.mailmanager.model.ListRelaysRequest)} operation.</b>
     * </p>
     *
     * @param listRelaysRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.ListRelays
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListRelays" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRelaysIterable listRelaysPaginator(ListRelaysRequest listRelaysRequest) throws ValidationException,
            AwsServiceException, SdkClientException, MailManagerException {
        return new ListRelaysIterable(this, listRelaysRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listRelays(software.amazon.awssdk.services.mailmanager.model.ListRelaysRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListRelaysIterable responses = client.listRelaysPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mailmanager.paginators.ListRelaysIterable responses = client.listRelaysPaginator(request);
     *     for (software.amazon.awssdk.services.mailmanager.model.ListRelaysResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListRelaysIterable responses = client.listRelaysPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRelays(software.amazon.awssdk.services.mailmanager.model.ListRelaysRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRelaysRequest.Builder} avoiding the need to
     * create one manually via {@link ListRelaysRequest#builder()}
     * </p>
     *
     * @param listRelaysRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.ListRelaysRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.ListRelays
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListRelays" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRelaysIterable listRelaysPaginator(Consumer<ListRelaysRequest.Builder> listRelaysRequest)
            throws ValidationException, AwsServiceException, SdkClientException, MailManagerException {
        return listRelaysPaginator(ListRelaysRequest.builder().applyMutation(listRelaysRequest).build());
    }

    /**
     * <p>
     * List rule sets for this account.
     * </p>
     *
     * @param listRuleSetsRequest
     * @return Result of the ListRuleSets operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.ListRuleSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListRuleSets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRuleSetsResponse listRuleSets(ListRuleSetsRequest listRuleSetsRequest) throws ValidationException,
            AwsServiceException, SdkClientException, MailManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List rule sets for this account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRuleSetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListRuleSetsRequest#builder()}
     * </p>
     *
     * @param listRuleSetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.ListRuleSetsRequest.Builder} to create a request.
     * @return Result of the ListRuleSets operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.ListRuleSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListRuleSets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRuleSetsResponse listRuleSets(Consumer<ListRuleSetsRequest.Builder> listRuleSetsRequest)
            throws ValidationException, AwsServiceException, SdkClientException, MailManagerException {
        return listRuleSets(ListRuleSetsRequest.builder().applyMutation(listRuleSetsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listRuleSets(software.amazon.awssdk.services.mailmanager.model.ListRuleSetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListRuleSetsIterable responses = client.listRuleSetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mailmanager.paginators.ListRuleSetsIterable responses = client.listRuleSetsPaginator(request);
     *     for (software.amazon.awssdk.services.mailmanager.model.ListRuleSetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListRuleSetsIterable responses = client.listRuleSetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRuleSets(software.amazon.awssdk.services.mailmanager.model.ListRuleSetsRequest)} operation.</b>
     * </p>
     *
     * @param listRuleSetsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.ListRuleSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListRuleSets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRuleSetsIterable listRuleSetsPaginator(ListRuleSetsRequest listRuleSetsRequest) throws ValidationException,
            AwsServiceException, SdkClientException, MailManagerException {
        return new ListRuleSetsIterable(this, listRuleSetsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listRuleSets(software.amazon.awssdk.services.mailmanager.model.ListRuleSetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListRuleSetsIterable responses = client.listRuleSetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mailmanager.paginators.ListRuleSetsIterable responses = client.listRuleSetsPaginator(request);
     *     for (software.amazon.awssdk.services.mailmanager.model.ListRuleSetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListRuleSetsIterable responses = client.listRuleSetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRuleSets(software.amazon.awssdk.services.mailmanager.model.ListRuleSetsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRuleSetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListRuleSetsRequest#builder()}
     * </p>
     *
     * @param listRuleSetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.ListRuleSetsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.ListRuleSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListRuleSets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRuleSetsIterable listRuleSetsPaginator(Consumer<ListRuleSetsRequest.Builder> listRuleSetsRequest)
            throws ValidationException, AwsServiceException, SdkClientException, MailManagerException {
        return listRuleSetsPaginator(ListRuleSetsRequest.builder().applyMutation(listRuleSetsRequest).build());
    }

    /**
     * <p>
     * Retrieves the list of tags (keys and values) assigned to the resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, MailManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the list of tags (keys and values) assigned to the resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, MailManagerException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * List traffic policy resources.
     * </p>
     *
     * @param listTrafficPoliciesRequest
     * @return Result of the ListTrafficPolicies operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.ListTrafficPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListTrafficPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTrafficPoliciesResponse listTrafficPolicies(ListTrafficPoliciesRequest listTrafficPoliciesRequest)
            throws ValidationException, AwsServiceException, SdkClientException, MailManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List traffic policy resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTrafficPoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link ListTrafficPoliciesRequest#builder()}
     * </p>
     *
     * @param listTrafficPoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.ListTrafficPoliciesRequest.Builder} to create a
     *        request.
     * @return Result of the ListTrafficPolicies operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.ListTrafficPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListTrafficPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTrafficPoliciesResponse listTrafficPolicies(
            Consumer<ListTrafficPoliciesRequest.Builder> listTrafficPoliciesRequest) throws ValidationException,
            AwsServiceException, SdkClientException, MailManagerException {
        return listTrafficPolicies(ListTrafficPoliciesRequest.builder().applyMutation(listTrafficPoliciesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTrafficPolicies(software.amazon.awssdk.services.mailmanager.model.ListTrafficPoliciesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListTrafficPoliciesIterable responses = client.listTrafficPoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mailmanager.paginators.ListTrafficPoliciesIterable responses = client
     *             .listTrafficPoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.mailmanager.model.ListTrafficPoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListTrafficPoliciesIterable responses = client.listTrafficPoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTrafficPolicies(software.amazon.awssdk.services.mailmanager.model.ListTrafficPoliciesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTrafficPoliciesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.ListTrafficPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListTrafficPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTrafficPoliciesIterable listTrafficPoliciesPaginator(ListTrafficPoliciesRequest listTrafficPoliciesRequest)
            throws ValidationException, AwsServiceException, SdkClientException, MailManagerException {
        return new ListTrafficPoliciesIterable(this, listTrafficPoliciesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTrafficPolicies(software.amazon.awssdk.services.mailmanager.model.ListTrafficPoliciesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListTrafficPoliciesIterable responses = client.listTrafficPoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mailmanager.paginators.ListTrafficPoliciesIterable responses = client
     *             .listTrafficPoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.mailmanager.model.ListTrafficPoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mailmanager.paginators.ListTrafficPoliciesIterable responses = client.listTrafficPoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTrafficPolicies(software.amazon.awssdk.services.mailmanager.model.ListTrafficPoliciesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTrafficPoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link ListTrafficPoliciesRequest#builder()}
     * </p>
     *
     * @param listTrafficPoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.ListTrafficPoliciesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.ListTrafficPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ListTrafficPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTrafficPoliciesIterable listTrafficPoliciesPaginator(
            Consumer<ListTrafficPoliciesRequest.Builder> listTrafficPoliciesRequest) throws ValidationException,
            AwsServiceException, SdkClientException, MailManagerException {
        return listTrafficPoliciesPaginator(ListTrafficPoliciesRequest.builder().applyMutation(listTrafficPoliciesRequest)
                .build());
    }

    /**
     * <p>
     * Adds a member to an address list.
     * </p>
     *
     * @param registerMemberToAddressListRequest
     * @return Result of the RegisterMemberToAddressList operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ServiceQuotaExceededException
     *         Occurs when an operation exceeds a predefined service quota or limit.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.RegisterMemberToAddressList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/RegisterMemberToAddressList"
     *      target="_top">AWS API Documentation</a>
     */
    default RegisterMemberToAddressListResponse registerMemberToAddressList(
            RegisterMemberToAddressListRequest registerMemberToAddressListRequest) throws ValidationException,
            AccessDeniedException, ServiceQuotaExceededException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, MailManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a member to an address list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterMemberToAddressListRequest.Builder}
     * avoiding the need to create one manually via {@link RegisterMemberToAddressListRequest#builder()}
     * </p>
     *
     * @param registerMemberToAddressListRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.RegisterMemberToAddressListRequest.Builder} to
     *        create a request.
     * @return Result of the RegisterMemberToAddressList operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ServiceQuotaExceededException
     *         Occurs when an operation exceeds a predefined service quota or limit.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.RegisterMemberToAddressList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/RegisterMemberToAddressList"
     *      target="_top">AWS API Documentation</a>
     */
    default RegisterMemberToAddressListResponse registerMemberToAddressList(
            Consumer<RegisterMemberToAddressListRequest.Builder> registerMemberToAddressListRequest) throws ValidationException,
            AccessDeniedException, ServiceQuotaExceededException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, MailManagerException {
        return registerMemberToAddressList(RegisterMemberToAddressListRequest.builder()
                .applyMutation(registerMemberToAddressListRequest).build());
    }

    /**
     * <p>
     * Starts an import job for an address list.
     * </p>
     *
     * @param startAddressListImportJobRequest
     * @return Result of the StartAddressListImportJob operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ServiceQuotaExceededException
     *         Occurs when an operation exceeds a predefined service quota or limit.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.StartAddressListImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/StartAddressListImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartAddressListImportJobResponse startAddressListImportJob(
            StartAddressListImportJobRequest startAddressListImportJobRequest) throws ValidationException, AccessDeniedException,
            ServiceQuotaExceededException, ConflictException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, MailManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an import job for an address list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartAddressListImportJobRequest.Builder} avoiding
     * the need to create one manually via {@link StartAddressListImportJobRequest#builder()}
     * </p>
     *
     * @param startAddressListImportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.StartAddressListImportJobRequest.Builder} to
     *        create a request.
     * @return Result of the StartAddressListImportJob operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ServiceQuotaExceededException
     *         Occurs when an operation exceeds a predefined service quota or limit.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.StartAddressListImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/StartAddressListImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartAddressListImportJobResponse startAddressListImportJob(
            Consumer<StartAddressListImportJobRequest.Builder> startAddressListImportJobRequest) throws ValidationException,
            AccessDeniedException, ServiceQuotaExceededException, ConflictException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, MailManagerException {
        return startAddressListImportJob(StartAddressListImportJobRequest.builder()
                .applyMutation(startAddressListImportJobRequest).build());
    }

    /**
     * <p>
     * Initiates an export of emails from the specified archive.
     * </p>
     *
     * @param startArchiveExportRequest
     *        The request to initiate an export of emails from an archive.
     * @return Result of the StartArchiveExport operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ServiceQuotaExceededException
     *         Occurs when an operation exceeds a predefined service quota or limit.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.StartArchiveExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/StartArchiveExport"
     *      target="_top">AWS API Documentation</a>
     */
    default StartArchiveExportResponse startArchiveExport(StartArchiveExportRequest startArchiveExportRequest)
            throws ValidationException, AccessDeniedException, ServiceQuotaExceededException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, MailManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Initiates an export of emails from the specified archive.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartArchiveExportRequest.Builder} avoiding the
     * need to create one manually via {@link StartArchiveExportRequest#builder()}
     * </p>
     *
     * @param startArchiveExportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.StartArchiveExportRequest.Builder} to create a
     *        request. The request to initiate an export of emails from an archive.
     * @return Result of the StartArchiveExport operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ServiceQuotaExceededException
     *         Occurs when an operation exceeds a predefined service quota or limit.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.StartArchiveExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/StartArchiveExport"
     *      target="_top">AWS API Documentation</a>
     */
    default StartArchiveExportResponse startArchiveExport(Consumer<StartArchiveExportRequest.Builder> startArchiveExportRequest)
            throws ValidationException, AccessDeniedException, ServiceQuotaExceededException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, MailManagerException {
        return startArchiveExport(StartArchiveExportRequest.builder().applyMutation(startArchiveExportRequest).build());
    }

    /**
     * <p>
     * Initiates a search across emails in the specified archive.
     * </p>
     *
     * @param startArchiveSearchRequest
     *        The request to initiate a search across emails in an archive.
     * @return Result of the StartArchiveSearch operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ServiceQuotaExceededException
     *         Occurs when an operation exceeds a predefined service quota or limit.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.StartArchiveSearch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/StartArchiveSearch"
     *      target="_top">AWS API Documentation</a>
     */
    default StartArchiveSearchResponse startArchiveSearch(StartArchiveSearchRequest startArchiveSearchRequest)
            throws ValidationException, AccessDeniedException, ServiceQuotaExceededException, ConflictException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, MailManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Initiates a search across emails in the specified archive.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartArchiveSearchRequest.Builder} avoiding the
     * need to create one manually via {@link StartArchiveSearchRequest#builder()}
     * </p>
     *
     * @param startArchiveSearchRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.StartArchiveSearchRequest.Builder} to create a
     *        request. The request to initiate a search across emails in an archive.
     * @return Result of the StartArchiveSearch operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ServiceQuotaExceededException
     *         Occurs when an operation exceeds a predefined service quota or limit.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.StartArchiveSearch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/StartArchiveSearch"
     *      target="_top">AWS API Documentation</a>
     */
    default StartArchiveSearchResponse startArchiveSearch(Consumer<StartArchiveSearchRequest.Builder> startArchiveSearchRequest)
            throws ValidationException, AccessDeniedException, ServiceQuotaExceededException, ConflictException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, MailManagerException {
        return startArchiveSearch(StartArchiveSearchRequest.builder().applyMutation(startArchiveSearchRequest).build());
    }

    /**
     * <p>
     * Stops an ongoing import job for an address list.
     * </p>
     *
     * @param stopAddressListImportJobRequest
     * @return Result of the StopAddressListImportJob operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.StopAddressListImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/StopAddressListImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StopAddressListImportJobResponse stopAddressListImportJob(
            StopAddressListImportJobRequest stopAddressListImportJobRequest) throws ValidationException, AccessDeniedException,
            ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            MailManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops an ongoing import job for an address list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopAddressListImportJobRequest.Builder} avoiding
     * the need to create one manually via {@link StopAddressListImportJobRequest#builder()}
     * </p>
     *
     * @param stopAddressListImportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.StopAddressListImportJobRequest.Builder} to
     *        create a request.
     * @return Result of the StopAddressListImportJob operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.StopAddressListImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/StopAddressListImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StopAddressListImportJobResponse stopAddressListImportJob(
            Consumer<StopAddressListImportJobRequest.Builder> stopAddressListImportJobRequest) throws ValidationException,
            AccessDeniedException, ConflictException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, MailManagerException {
        return stopAddressListImportJob(StopAddressListImportJobRequest.builder().applyMutation(stopAddressListImportJobRequest)
                .build());
    }

    /**
     * <p>
     * Stops an in-progress export of emails from an archive.
     * </p>
     *
     * @param stopArchiveExportRequest
     *        The request to stop an in-progress archive export job.
     * @return Result of the StopArchiveExport operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.StopArchiveExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/StopArchiveExport" target="_top">AWS
     *      API Documentation</a>
     */
    default StopArchiveExportResponse stopArchiveExport(StopArchiveExportRequest stopArchiveExportRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            MailManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops an in-progress export of emails from an archive.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopArchiveExportRequest.Builder} avoiding the need
     * to create one manually via {@link StopArchiveExportRequest#builder()}
     * </p>
     *
     * @param stopArchiveExportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.StopArchiveExportRequest.Builder} to create a
     *        request. The request to stop an in-progress archive export job.
     * @return Result of the StopArchiveExport operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.StopArchiveExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/StopArchiveExport" target="_top">AWS
     *      API Documentation</a>
     */
    default StopArchiveExportResponse stopArchiveExport(Consumer<StopArchiveExportRequest.Builder> stopArchiveExportRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            MailManagerException {
        return stopArchiveExport(StopArchiveExportRequest.builder().applyMutation(stopArchiveExportRequest).build());
    }

    /**
     * <p>
     * Stops an in-progress archive search job.
     * </p>
     *
     * @param stopArchiveSearchRequest
     *        The request to stop an in-progress archive search job.
     * @return Result of the StopArchiveSearch operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.StopArchiveSearch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/StopArchiveSearch" target="_top">AWS
     *      API Documentation</a>
     */
    default StopArchiveSearchResponse stopArchiveSearch(StopArchiveSearchRequest stopArchiveSearchRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            MailManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops an in-progress archive search job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopArchiveSearchRequest.Builder} avoiding the need
     * to create one manually via {@link StopArchiveSearchRequest#builder()}
     * </p>
     *
     * @param stopArchiveSearchRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.StopArchiveSearchRequest.Builder} to create a
     *        request. The request to stop an in-progress archive search job.
     * @return Result of the StopArchiveSearch operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.StopArchiveSearch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/StopArchiveSearch" target="_top">AWS
     *      API Documentation</a>
     */
    default StopArchiveSearchResponse stopArchiveSearch(Consumer<StopArchiveSearchRequest.Builder> stopArchiveSearchRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            MailManagerException {
        return stopArchiveSearch(StopArchiveSearchRequest.builder().applyMutation(stopArchiveSearchRequest).build());
    }

    /**
     * <p>
     * Adds one or more tags (keys and values) to a specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws ServiceQuotaExceededException
     *         Occurs when an operation exceeds a predefined service quota or limit.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ValidationException,
            ServiceQuotaExceededException, ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            MailManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds one or more tags (keys and values) to a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws ServiceQuotaExceededException
     *         Occurs when an operation exceeds a predefined service quota or limit.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws ValidationException,
            ServiceQuotaExceededException, ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            MailManagerException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Remove one or more tags (keys and values) from a specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException,
            ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException, MailManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Remove one or more tags (keys and values) from a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ValidationException, ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            MailManagerException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the attributes of an existing email archive.
     * </p>
     *
     * @param updateArchiveRequest
     *        The request to update properties of an existing email archive.
     * @return Result of the UpdateArchive operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ServiceQuotaExceededException
     *         Occurs when an operation exceeds a predefined service quota or limit.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.UpdateArchive
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/UpdateArchive" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateArchiveResponse updateArchive(UpdateArchiveRequest updateArchiveRequest) throws ValidationException,
            AccessDeniedException, ServiceQuotaExceededException, ConflictException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, MailManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the attributes of an existing email archive.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateArchiveRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateArchiveRequest#builder()}
     * </p>
     *
     * @param updateArchiveRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.UpdateArchiveRequest.Builder} to create a
     *        request. The request to update properties of an existing email archive.
     * @return Result of the UpdateArchive operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws AccessDeniedException
     *         Occurs when a user is denied access to a specific resource or action.
     * @throws ServiceQuotaExceededException
     *         Occurs when an operation exceeds a predefined service quota or limit.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws ThrottlingException
     *         Occurs when a service's request rate limit is exceeded, resulting in throttling of further requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.UpdateArchive
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/UpdateArchive" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateArchiveResponse updateArchive(Consumer<UpdateArchiveRequest.Builder> updateArchiveRequest)
            throws ValidationException, AccessDeniedException, ServiceQuotaExceededException, ConflictException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, MailManagerException {
        return updateArchive(UpdateArchiveRequest.builder().applyMutation(updateArchiveRequest).build());
    }

    /**
     * <p>
     * Update attributes of a provisioned ingress endpoint resource.
     * </p>
     *
     * @param updateIngressPointRequest
     * @return Result of the UpdateIngressPoint operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.UpdateIngressPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/UpdateIngressPoint"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateIngressPointResponse updateIngressPoint(UpdateIngressPointRequest updateIngressPointRequest)
            throws ValidationException, ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            MailManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update attributes of a provisioned ingress endpoint resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateIngressPointRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateIngressPointRequest#builder()}
     * </p>
     *
     * @param updateIngressPointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.UpdateIngressPointRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateIngressPoint operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.UpdateIngressPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/UpdateIngressPoint"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateIngressPointResponse updateIngressPoint(Consumer<UpdateIngressPointRequest.Builder> updateIngressPointRequest)
            throws ValidationException, ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            MailManagerException {
        return updateIngressPoint(UpdateIngressPointRequest.builder().applyMutation(updateIngressPointRequest).build());
    }

    /**
     * <p>
     * Updates the attributes of an existing relay resource.
     * </p>
     *
     * @param updateRelayRequest
     * @return Result of the UpdateRelay operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.UpdateRelay
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/UpdateRelay" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateRelayResponse updateRelay(UpdateRelayRequest updateRelayRequest) throws ValidationException, ConflictException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, MailManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the attributes of an existing relay resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRelayRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateRelayRequest#builder()}
     * </p>
     *
     * @param updateRelayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.UpdateRelayRequest.Builder} to create a request.
     * @return Result of the UpdateRelay operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.UpdateRelay
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/UpdateRelay" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateRelayResponse updateRelay(Consumer<UpdateRelayRequest.Builder> updateRelayRequest) throws ValidationException,
            ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException, MailManagerException {
        return updateRelay(UpdateRelayRequest.builder().applyMutation(updateRelayRequest).build());
    }

    /**
     * <p>
     * Update attributes of an already provisioned rule set.
     * </p>
     *
     * @param updateRuleSetRequest
     * @return Result of the UpdateRuleSet operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.UpdateRuleSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/UpdateRuleSet" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateRuleSetResponse updateRuleSet(UpdateRuleSetRequest updateRuleSetRequest) throws ValidationException,
            ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException, MailManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update attributes of an already provisioned rule set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRuleSetRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateRuleSetRequest#builder()}
     * </p>
     *
     * @param updateRuleSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.UpdateRuleSetRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateRuleSet operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.UpdateRuleSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/UpdateRuleSet" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateRuleSetResponse updateRuleSet(Consumer<UpdateRuleSetRequest.Builder> updateRuleSetRequest)
            throws ValidationException, ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            MailManagerException {
        return updateRuleSet(UpdateRuleSetRequest.builder().applyMutation(updateRuleSetRequest).build());
    }

    /**
     * <p>
     * Update attributes of an already provisioned traffic policy resource.
     * </p>
     *
     * @param updateTrafficPolicyRequest
     * @return Result of the UpdateTrafficPolicy operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.UpdateTrafficPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/UpdateTrafficPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateTrafficPolicyResponse updateTrafficPolicy(UpdateTrafficPolicyRequest updateTrafficPolicyRequest)
            throws ValidationException, ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            MailManagerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update attributes of an already provisioned traffic policy resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTrafficPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateTrafficPolicyRequest#builder()}
     * </p>
     *
     * @param updateTrafficPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mailmanager.model.UpdateTrafficPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateTrafficPolicy operation returned by the service.
     * @throws ValidationException
     *         The request validation has failed. For details, see the accompanying error message.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws ResourceNotFoundException
     *         Occurs when a requested resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MailManagerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MailManagerClient.UpdateTrafficPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/UpdateTrafficPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateTrafficPolicyResponse updateTrafficPolicy(
            Consumer<UpdateTrafficPolicyRequest.Builder> updateTrafficPolicyRequest) throws ValidationException,
            ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException, MailManagerException {
        return updateTrafficPolicy(UpdateTrafficPolicyRequest.builder().applyMutation(updateTrafficPolicyRequest).build());
    }

    /**
     * Create a {@link MailManagerClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static MailManagerClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link MailManagerClient}.
     */
    static MailManagerClientBuilder builder() {
        return new DefaultMailManagerClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default MailManagerServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
