/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAddressListImportJobRequest extends MailManagerRequest implements
        ToCopyableBuilder<CreateAddressListImportJobRequest.Builder, CreateAddressListImportJobRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateAddressListImportJobRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> ADDRESS_LIST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AddressListId").getter(getter(CreateAddressListImportJobRequest::addressListId))
            .setter(setter(Builder::addressListId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressListId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateAddressListImportJobRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<ImportDataFormat> IMPORT_DATA_FORMAT_FIELD = SdkField
            .<ImportDataFormat> builder(MarshallingType.SDK_POJO).memberName("ImportDataFormat")
            .getter(getter(CreateAddressListImportJobRequest::importDataFormat)).setter(setter(Builder::importDataFormat))
            .constructor(ImportDataFormat::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportDataFormat").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            ADDRESS_LIST_ID_FIELD, NAME_FIELD, IMPORT_DATA_FORMAT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final String addressListId;

    private final String name;

    private final ImportDataFormat importDataFormat;

    private CreateAddressListImportJobRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.addressListId = builder.addressListId;
        this.name = builder.name;
        this.importDataFormat = builder.importDataFormat;
    }

    /**
     * <p>
     * A unique token that Amazon SES uses to recognize subsequent retries of the same request.
     * </p>
     * 
     * @return A unique token that Amazon SES uses to recognize subsequent retries of the same request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The unique identifier of the address list for importing addresses to.
     * </p>
     * 
     * @return The unique identifier of the address list for importing addresses to.
     */
    public final String addressListId() {
        return addressListId;
    }

    /**
     * <p>
     * A user-friendly name for the import job.
     * </p>
     * 
     * @return A user-friendly name for the import job.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The format of the input for an import job.
     * </p>
     * 
     * @return The format of the input for an import job.
     */
    public final ImportDataFormat importDataFormat() {
        return importDataFormat;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(addressListId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(importDataFormat());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAddressListImportJobRequest)) {
            return false;
        }
        CreateAddressListImportJobRequest other = (CreateAddressListImportJobRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(addressListId(), other.addressListId())
                && Objects.equals(name(), other.name()) && Objects.equals(importDataFormat(), other.importDataFormat());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAddressListImportJobRequest").add("ClientToken", clientToken())
                .add("AddressListId", addressListId()).add("Name", name()).add("ImportDataFormat", importDataFormat()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "AddressListId":
            return Optional.ofNullable(clazz.cast(addressListId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ImportDataFormat":
            return Optional.ofNullable(clazz.cast(importDataFormat()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("AddressListId", ADDRESS_LIST_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("ImportDataFormat", IMPORT_DATA_FORMAT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAddressListImportJobRequest, T> g) {
        return obj -> g.apply((CreateAddressListImportJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MailManagerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateAddressListImportJobRequest> {
        /**
         * <p>
         * A unique token that Amazon SES uses to recognize subsequent retries of the same request.
         * </p>
         * 
         * @param clientToken
         *        A unique token that Amazon SES uses to recognize subsequent retries of the same request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The unique identifier of the address list for importing addresses to.
         * </p>
         * 
         * @param addressListId
         *        The unique identifier of the address list for importing addresses to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressListId(String addressListId);

        /**
         * <p>
         * A user-friendly name for the import job.
         * </p>
         * 
         * @param name
         *        A user-friendly name for the import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The format of the input for an import job.
         * </p>
         * 
         * @param importDataFormat
         *        The format of the input for an import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importDataFormat(ImportDataFormat importDataFormat);

        /**
         * <p>
         * The format of the input for an import job.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImportDataFormat.Builder} avoiding the
         * need to create one manually via {@link ImportDataFormat#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImportDataFormat.Builder#build()} is called immediately and its
         * result is passed to {@link #importDataFormat(ImportDataFormat)}.
         * 
         * @param importDataFormat
         *        a consumer that will call methods on {@link ImportDataFormat.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #importDataFormat(ImportDataFormat)
         */
        default Builder importDataFormat(Consumer<ImportDataFormat.Builder> importDataFormat) {
            return importDataFormat(ImportDataFormat.builder().applyMutation(importDataFormat).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MailManagerRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String addressListId;

        private String name;

        private ImportDataFormat importDataFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAddressListImportJobRequest model) {
            super(model);
            clientToken(model.clientToken);
            addressListId(model.addressListId);
            name(model.name);
            importDataFormat(model.importDataFormat);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getAddressListId() {
            return addressListId;
        }

        public final void setAddressListId(String addressListId) {
            this.addressListId = addressListId;
        }

        @Override
        public final Builder addressListId(String addressListId) {
            this.addressListId = addressListId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ImportDataFormat.Builder getImportDataFormat() {
            return importDataFormat != null ? importDataFormat.toBuilder() : null;
        }

        public final void setImportDataFormat(ImportDataFormat.BuilderImpl importDataFormat) {
            this.importDataFormat = importDataFormat != null ? importDataFormat.build() : null;
        }

        @Override
        public final Builder importDataFormat(ImportDataFormat importDataFormat) {
            this.importDataFormat = importDataFormat;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAddressListImportJobRequest build() {
            return new CreateAddressListImportJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
