/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTrafficPolicyRequest extends MailManagerRequest implements
        ToCopyableBuilder<CreateTrafficPolicyRequest.Builder, CreateTrafficPolicyRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateTrafficPolicyRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> TRAFFIC_POLICY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrafficPolicyName").getter(getter(CreateTrafficPolicyRequest::trafficPolicyName))
            .setter(setter(Builder::trafficPolicyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficPolicyName").build()).build();

    private static final SdkField<List<PolicyStatement>> POLICY_STATEMENTS_FIELD = SdkField
            .<List<PolicyStatement>> builder(MarshallingType.LIST)
            .memberName("PolicyStatements")
            .getter(getter(CreateTrafficPolicyRequest::policyStatements))
            .setter(setter(Builder::policyStatements))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyStatements").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PolicyStatement> builder(MarshallingType.SDK_POJO)
                                            .constructor(PolicyStatement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DEFAULT_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultAction").getter(getter(CreateTrafficPolicyRequest::defaultActionAsString))
            .setter(setter(Builder::defaultAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultAction").build()).build();

    private static final SdkField<Integer> MAX_MESSAGE_SIZE_BYTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxMessageSizeBytes").getter(getter(CreateTrafficPolicyRequest::maxMessageSizeBytes))
            .setter(setter(Builder::maxMessageSizeBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxMessageSizeBytes").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateTrafficPolicyRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            TRAFFIC_POLICY_NAME_FIELD, POLICY_STATEMENTS_FIELD, DEFAULT_ACTION_FIELD, MAX_MESSAGE_SIZE_BYTES_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final String trafficPolicyName;

    private final List<PolicyStatement> policyStatements;

    private final String defaultAction;

    private final Integer maxMessageSizeBytes;

    private final List<Tag> tags;

    private CreateTrafficPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.trafficPolicyName = builder.trafficPolicyName;
        this.policyStatements = builder.policyStatements;
        this.defaultAction = builder.defaultAction;
        this.maxMessageSizeBytes = builder.maxMessageSizeBytes;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A unique token that Amazon SES uses to recognize subsequent retries of the same request.
     * </p>
     * 
     * @return A unique token that Amazon SES uses to recognize subsequent retries of the same request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * A user-friendly name for the traffic policy resource.
     * </p>
     * 
     * @return A user-friendly name for the traffic policy resource.
     */
    public final String trafficPolicyName() {
        return trafficPolicyName;
    }

    /**
     * For responses, this returns true if the service returned a value for the PolicyStatements property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPolicyStatements() {
        return policyStatements != null && !(policyStatements instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Conditional statements for filtering email traffic.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPolicyStatements} method.
     * </p>
     * 
     * @return Conditional statements for filtering email traffic.
     */
    public final List<PolicyStatement> policyStatements() {
        return policyStatements;
    }

    /**
     * <p>
     * Default action instructs the traﬃc policy to either Allow or Deny (block) messages that fall outside of (or not
     * addressed by) the conditions of your policy statements
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #defaultAction}
     * will return {@link AcceptAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #defaultActionAsString}.
     * </p>
     * 
     * @return Default action instructs the traﬃc policy to either Allow or Deny (block) messages that fall outside of
     *         (or not addressed by) the conditions of your policy statements
     * @see AcceptAction
     */
    public final AcceptAction defaultAction() {
        return AcceptAction.fromValue(defaultAction);
    }

    /**
     * <p>
     * Default action instructs the traﬃc policy to either Allow or Deny (block) messages that fall outside of (or not
     * addressed by) the conditions of your policy statements
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #defaultAction}
     * will return {@link AcceptAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #defaultActionAsString}.
     * </p>
     * 
     * @return Default action instructs the traﬃc policy to either Allow or Deny (block) messages that fall outside of
     *         (or not addressed by) the conditions of your policy statements
     * @see AcceptAction
     */
    public final String defaultActionAsString() {
        return defaultAction;
    }

    /**
     * <p>
     * The maximum message size in bytes of email which is allowed in by this traffic policy—anything larger will be
     * blocked.
     * </p>
     * 
     * @return The maximum message size in bytes of email which is allowed in by this traffic policy—anything larger
     *         will be blocked.
     */
    public final Integer maxMessageSizeBytes() {
        return maxMessageSizeBytes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for the resource. For example, { "tags": {"key1":"value1",
     * "key2":"value2"} }.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for the resource. For example, { "tags":
     *         {"key1":"value1", "key2":"value2"} }.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(trafficPolicyName());
        hashCode = 31 * hashCode + Objects.hashCode(hasPolicyStatements() ? policyStatements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(defaultActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxMessageSizeBytes());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrafficPolicyRequest)) {
            return false;
        }
        CreateTrafficPolicyRequest other = (CreateTrafficPolicyRequest) obj;
        return Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(trafficPolicyName(), other.trafficPolicyName())
                && hasPolicyStatements() == other.hasPolicyStatements()
                && Objects.equals(policyStatements(), other.policyStatements())
                && Objects.equals(defaultActionAsString(), other.defaultActionAsString())
                && Objects.equals(maxMessageSizeBytes(), other.maxMessageSizeBytes()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTrafficPolicyRequest").add("ClientToken", clientToken())
                .add("TrafficPolicyName", trafficPolicyName())
                .add("PolicyStatements", hasPolicyStatements() ? policyStatements() : null)
                .add("DefaultAction", defaultActionAsString()).add("MaxMessageSizeBytes", maxMessageSizeBytes())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "TrafficPolicyName":
            return Optional.ofNullable(clazz.cast(trafficPolicyName()));
        case "PolicyStatements":
            return Optional.ofNullable(clazz.cast(policyStatements()));
        case "DefaultAction":
            return Optional.ofNullable(clazz.cast(defaultActionAsString()));
        case "MaxMessageSizeBytes":
            return Optional.ofNullable(clazz.cast(maxMessageSizeBytes()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("TrafficPolicyName", TRAFFIC_POLICY_NAME_FIELD);
        map.put("PolicyStatements", POLICY_STATEMENTS_FIELD);
        map.put("DefaultAction", DEFAULT_ACTION_FIELD);
        map.put("MaxMessageSizeBytes", MAX_MESSAGE_SIZE_BYTES_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTrafficPolicyRequest, T> g) {
        return obj -> g.apply((CreateTrafficPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MailManagerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateTrafficPolicyRequest> {
        /**
         * <p>
         * A unique token that Amazon SES uses to recognize subsequent retries of the same request.
         * </p>
         * 
         * @param clientToken
         *        A unique token that Amazon SES uses to recognize subsequent retries of the same request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * A user-friendly name for the traffic policy resource.
         * </p>
         * 
         * @param trafficPolicyName
         *        A user-friendly name for the traffic policy resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicyName(String trafficPolicyName);

        /**
         * <p>
         * Conditional statements for filtering email traffic.
         * </p>
         * 
         * @param policyStatements
         *        Conditional statements for filtering email traffic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyStatements(Collection<PolicyStatement> policyStatements);

        /**
         * <p>
         * Conditional statements for filtering email traffic.
         * </p>
         * 
         * @param policyStatements
         *        Conditional statements for filtering email traffic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyStatements(PolicyStatement... policyStatements);

        /**
         * <p>
         * Conditional statements for filtering email traffic.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mailmanager.model.PolicyStatement.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.mailmanager.model.PolicyStatement#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mailmanager.model.PolicyStatement.Builder#build()} is called
         * immediately and its result is passed to {@link #policyStatements(List<PolicyStatement>)}.
         * 
         * @param policyStatements
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mailmanager.model.PolicyStatement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policyStatements(java.util.Collection<PolicyStatement>)
         */
        Builder policyStatements(Consumer<PolicyStatement.Builder>... policyStatements);

        /**
         * <p>
         * Default action instructs the traﬃc policy to either Allow or Deny (block) messages that fall outside of (or
         * not addressed by) the conditions of your policy statements
         * </p>
         * 
         * @param defaultAction
         *        Default action instructs the traﬃc policy to either Allow or Deny (block) messages that fall outside
         *        of (or not addressed by) the conditions of your policy statements
         * @see AcceptAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AcceptAction
         */
        Builder defaultAction(String defaultAction);

        /**
         * <p>
         * Default action instructs the traﬃc policy to either Allow or Deny (block) messages that fall outside of (or
         * not addressed by) the conditions of your policy statements
         * </p>
         * 
         * @param defaultAction
         *        Default action instructs the traﬃc policy to either Allow or Deny (block) messages that fall outside
         *        of (or not addressed by) the conditions of your policy statements
         * @see AcceptAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AcceptAction
         */
        Builder defaultAction(AcceptAction defaultAction);

        /**
         * <p>
         * The maximum message size in bytes of email which is allowed in by this traffic policy—anything larger will be
         * blocked.
         * </p>
         * 
         * @param maxMessageSizeBytes
         *        The maximum message size in bytes of email which is allowed in by this traffic policy—anything larger
         *        will be blocked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxMessageSizeBytes(Integer maxMessageSizeBytes);

        /**
         * <p>
         * The tags used to organize, track, or control access for the resource. For example, { "tags":
         * {"key1":"value1", "key2":"value2"} }.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for the resource. For example, { "tags":
         *        {"key1":"value1", "key2":"value2"} }.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags used to organize, track, or control access for the resource. For example, { "tags":
         * {"key1":"value1", "key2":"value2"} }.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for the resource. For example, { "tags":
         *        {"key1":"value1", "key2":"value2"} }.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags used to organize, track, or control access for the resource. For example, { "tags":
         * {"key1":"value1", "key2":"value2"} }.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mailmanager.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.mailmanager.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mailmanager.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mailmanager.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MailManagerRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String trafficPolicyName;

        private List<PolicyStatement> policyStatements = DefaultSdkAutoConstructList.getInstance();

        private String defaultAction;

        private Integer maxMessageSizeBytes;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTrafficPolicyRequest model) {
            super(model);
            clientToken(model.clientToken);
            trafficPolicyName(model.trafficPolicyName);
            policyStatements(model.policyStatements);
            defaultAction(model.defaultAction);
            maxMessageSizeBytes(model.maxMessageSizeBytes);
            tags(model.tags);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getTrafficPolicyName() {
            return trafficPolicyName;
        }

        public final void setTrafficPolicyName(String trafficPolicyName) {
            this.trafficPolicyName = trafficPolicyName;
        }

        @Override
        public final Builder trafficPolicyName(String trafficPolicyName) {
            this.trafficPolicyName = trafficPolicyName;
            return this;
        }

        public final List<PolicyStatement.Builder> getPolicyStatements() {
            List<PolicyStatement.Builder> result = PolicyStatementListCopier.copyToBuilder(this.policyStatements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPolicyStatements(Collection<PolicyStatement.BuilderImpl> policyStatements) {
            this.policyStatements = PolicyStatementListCopier.copyFromBuilder(policyStatements);
        }

        @Override
        public final Builder policyStatements(Collection<PolicyStatement> policyStatements) {
            this.policyStatements = PolicyStatementListCopier.copy(policyStatements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyStatements(PolicyStatement... policyStatements) {
            policyStatements(Arrays.asList(policyStatements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyStatements(Consumer<PolicyStatement.Builder>... policyStatements) {
            policyStatements(Stream.of(policyStatements).map(c -> PolicyStatement.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getDefaultAction() {
            return defaultAction;
        }

        public final void setDefaultAction(String defaultAction) {
            this.defaultAction = defaultAction;
        }

        @Override
        public final Builder defaultAction(String defaultAction) {
            this.defaultAction = defaultAction;
            return this;
        }

        @Override
        public final Builder defaultAction(AcceptAction defaultAction) {
            this.defaultAction(defaultAction == null ? null : defaultAction.toString());
            return this;
        }

        public final Integer getMaxMessageSizeBytes() {
            return maxMessageSizeBytes;
        }

        public final void setMaxMessageSizeBytes(Integer maxMessageSizeBytes) {
            this.maxMessageSizeBytes = maxMessageSizeBytes;
        }

        @Override
        public final Builder maxMessageSizeBytes(Integer maxMessageSizeBytes) {
            this.maxMessageSizeBytes = maxMessageSizeBytes;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTrafficPolicyRequest build() {
            return new CreateTrafficPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
