/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The password configuration of the ingress endpoint resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IngressPointPasswordConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<IngressPointPasswordConfiguration.Builder, IngressPointPasswordConfiguration> {
    private static final SdkField<String> SMTP_PASSWORD_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SmtpPasswordVersion").getter(getter(IngressPointPasswordConfiguration::smtpPasswordVersion))
            .setter(setter(Builder::smtpPasswordVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SmtpPasswordVersion").build())
            .build();

    private static final SdkField<String> PREVIOUS_SMTP_PASSWORD_VERSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PreviousSmtpPasswordVersion")
            .getter(getter(IngressPointPasswordConfiguration::previousSmtpPasswordVersion))
            .setter(setter(Builder::previousSmtpPasswordVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviousSmtpPasswordVersion")
                    .build()).build();

    private static final SdkField<Instant> PREVIOUS_SMTP_PASSWORD_EXPIRY_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("PreviousSmtpPasswordExpiryTimestamp")
            .getter(getter(IngressPointPasswordConfiguration::previousSmtpPasswordExpiryTimestamp))
            .setter(setter(Builder::previousSmtpPasswordExpiryTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("PreviousSmtpPasswordExpiryTimestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SMTP_PASSWORD_VERSION_FIELD,
            PREVIOUS_SMTP_PASSWORD_VERSION_FIELD, PREVIOUS_SMTP_PASSWORD_EXPIRY_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String smtpPasswordVersion;

    private final String previousSmtpPasswordVersion;

    private final Instant previousSmtpPasswordExpiryTimestamp;

    private IngressPointPasswordConfiguration(BuilderImpl builder) {
        this.smtpPasswordVersion = builder.smtpPasswordVersion;
        this.previousSmtpPasswordVersion = builder.previousSmtpPasswordVersion;
        this.previousSmtpPasswordExpiryTimestamp = builder.previousSmtpPasswordExpiryTimestamp;
    }

    /**
     * <p>
     * The current password expiry timestamp of the ingress endpoint resource.
     * </p>
     * 
     * @return The current password expiry timestamp of the ingress endpoint resource.
     */
    public final String smtpPasswordVersion() {
        return smtpPasswordVersion;
    }

    /**
     * <p>
     * The previous password version of the ingress endpoint resource.
     * </p>
     * 
     * @return The previous password version of the ingress endpoint resource.
     */
    public final String previousSmtpPasswordVersion() {
        return previousSmtpPasswordVersion;
    }

    /**
     * <p>
     * The previous password expiry timestamp of the ingress endpoint resource.
     * </p>
     * 
     * @return The previous password expiry timestamp of the ingress endpoint resource.
     */
    public final Instant previousSmtpPasswordExpiryTimestamp() {
        return previousSmtpPasswordExpiryTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(smtpPasswordVersion());
        hashCode = 31 * hashCode + Objects.hashCode(previousSmtpPasswordVersion());
        hashCode = 31 * hashCode + Objects.hashCode(previousSmtpPasswordExpiryTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IngressPointPasswordConfiguration)) {
            return false;
        }
        IngressPointPasswordConfiguration other = (IngressPointPasswordConfiguration) obj;
        return Objects.equals(smtpPasswordVersion(), other.smtpPasswordVersion())
                && Objects.equals(previousSmtpPasswordVersion(), other.previousSmtpPasswordVersion())
                && Objects.equals(previousSmtpPasswordExpiryTimestamp(), other.previousSmtpPasswordExpiryTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IngressPointPasswordConfiguration").add("SmtpPasswordVersion", smtpPasswordVersion())
                .add("PreviousSmtpPasswordVersion", previousSmtpPasswordVersion())
                .add("PreviousSmtpPasswordExpiryTimestamp", previousSmtpPasswordExpiryTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SmtpPasswordVersion":
            return Optional.ofNullable(clazz.cast(smtpPasswordVersion()));
        case "PreviousSmtpPasswordVersion":
            return Optional.ofNullable(clazz.cast(previousSmtpPasswordVersion()));
        case "PreviousSmtpPasswordExpiryTimestamp":
            return Optional.ofNullable(clazz.cast(previousSmtpPasswordExpiryTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SmtpPasswordVersion", SMTP_PASSWORD_VERSION_FIELD);
        map.put("PreviousSmtpPasswordVersion", PREVIOUS_SMTP_PASSWORD_VERSION_FIELD);
        map.put("PreviousSmtpPasswordExpiryTimestamp", PREVIOUS_SMTP_PASSWORD_EXPIRY_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IngressPointPasswordConfiguration, T> g) {
        return obj -> g.apply((IngressPointPasswordConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IngressPointPasswordConfiguration> {
        /**
         * <p>
         * The current password expiry timestamp of the ingress endpoint resource.
         * </p>
         * 
         * @param smtpPasswordVersion
         *        The current password expiry timestamp of the ingress endpoint resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smtpPasswordVersion(String smtpPasswordVersion);

        /**
         * <p>
         * The previous password version of the ingress endpoint resource.
         * </p>
         * 
         * @param previousSmtpPasswordVersion
         *        The previous password version of the ingress endpoint resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previousSmtpPasswordVersion(String previousSmtpPasswordVersion);

        /**
         * <p>
         * The previous password expiry timestamp of the ingress endpoint resource.
         * </p>
         * 
         * @param previousSmtpPasswordExpiryTimestamp
         *        The previous password expiry timestamp of the ingress endpoint resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previousSmtpPasswordExpiryTimestamp(Instant previousSmtpPasswordExpiryTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String smtpPasswordVersion;

        private String previousSmtpPasswordVersion;

        private Instant previousSmtpPasswordExpiryTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(IngressPointPasswordConfiguration model) {
            smtpPasswordVersion(model.smtpPasswordVersion);
            previousSmtpPasswordVersion(model.previousSmtpPasswordVersion);
            previousSmtpPasswordExpiryTimestamp(model.previousSmtpPasswordExpiryTimestamp);
        }

        public final String getSmtpPasswordVersion() {
            return smtpPasswordVersion;
        }

        public final void setSmtpPasswordVersion(String smtpPasswordVersion) {
            this.smtpPasswordVersion = smtpPasswordVersion;
        }

        @Override
        public final Builder smtpPasswordVersion(String smtpPasswordVersion) {
            this.smtpPasswordVersion = smtpPasswordVersion;
            return this;
        }

        public final String getPreviousSmtpPasswordVersion() {
            return previousSmtpPasswordVersion;
        }

        public final void setPreviousSmtpPasswordVersion(String previousSmtpPasswordVersion) {
            this.previousSmtpPasswordVersion = previousSmtpPasswordVersion;
        }

        @Override
        public final Builder previousSmtpPasswordVersion(String previousSmtpPasswordVersion) {
            this.previousSmtpPasswordVersion = previousSmtpPasswordVersion;
            return this;
        }

        public final Instant getPreviousSmtpPasswordExpiryTimestamp() {
            return previousSmtpPasswordExpiryTimestamp;
        }

        public final void setPreviousSmtpPasswordExpiryTimestamp(Instant previousSmtpPasswordExpiryTimestamp) {
            this.previousSmtpPasswordExpiryTimestamp = previousSmtpPasswordExpiryTimestamp;
        }

        @Override
        public final Builder previousSmtpPasswordExpiryTimestamp(Instant previousSmtpPasswordExpiryTimestamp) {
            this.previousSmtpPasswordExpiryTimestamp = previousSmtpPasswordExpiryTimestamp;
            return this;
        }

        @Override
        public IngressPointPasswordConfiguration build() {
            return new IngressPointPasswordConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
