/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response containing a list of archive export jobs and their statuses.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListArchiveExportsResponse extends MailManagerResponse implements
        ToCopyableBuilder<ListArchiveExportsResponse.Builder, ListArchiveExportsResponse> {
    private static final SdkField<List<ExportSummary>> EXPORTS_FIELD = SdkField
            .<List<ExportSummary>> builder(MarshallingType.LIST)
            .memberName("Exports")
            .getter(getter(ListArchiveExportsResponse::exports))
            .setter(setter(Builder::exports))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Exports").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExportSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExportSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListArchiveExportsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORTS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ExportSummary> exports;

    private final String nextToken;

    private ListArchiveExportsResponse(BuilderImpl builder) {
        super(builder);
        this.exports = builder.exports;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Exports property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasExports() {
        return exports != null && !(exports instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of export job identifiers and statuses.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExports} method.
     * </p>
     * 
     * @return The list of export job identifiers and statuses.
     */
    public final List<ExportSummary> exports() {
        return exports;
    }

    /**
     * <p>
     * If present, use to retrieve the next page of results.
     * </p>
     * 
     * @return If present, use to retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasExports() ? exports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListArchiveExportsResponse)) {
            return false;
        }
        ListArchiveExportsResponse other = (ListArchiveExportsResponse) obj;
        return hasExports() == other.hasExports() && Objects.equals(exports(), other.exports())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListArchiveExportsResponse").add("Exports", hasExports() ? exports() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Exports":
            return Optional.ofNullable(clazz.cast(exports()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Exports", EXPORTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListArchiveExportsResponse, T> g) {
        return obj -> g.apply((ListArchiveExportsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MailManagerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListArchiveExportsResponse> {
        /**
         * <p>
         * The list of export job identifiers and statuses.
         * </p>
         * 
         * @param exports
         *        The list of export job identifiers and statuses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exports(Collection<ExportSummary> exports);

        /**
         * <p>
         * The list of export job identifiers and statuses.
         * </p>
         * 
         * @param exports
         *        The list of export job identifiers and statuses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exports(ExportSummary... exports);

        /**
         * <p>
         * The list of export job identifiers and statuses.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mailmanager.model.ExportSummary.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.mailmanager.model.ExportSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mailmanager.model.ExportSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #exports(List<ExportSummary>)}.
         * 
         * @param exports
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mailmanager.model.ExportSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exports(java.util.Collection<ExportSummary>)
         */
        Builder exports(Consumer<ExportSummary.Builder>... exports);

        /**
         * <p>
         * If present, use to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        If present, use to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends MailManagerResponse.BuilderImpl implements Builder {
        private List<ExportSummary> exports = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListArchiveExportsResponse model) {
            super(model);
            exports(model.exports);
            nextToken(model.nextToken);
        }

        public final List<ExportSummary.Builder> getExports() {
            List<ExportSummary.Builder> result = ExportSummaryListCopier.copyToBuilder(this.exports);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExports(Collection<ExportSummary.BuilderImpl> exports) {
            this.exports = ExportSummaryListCopier.copyFromBuilder(exports);
        }

        @Override
        public final Builder exports(Collection<ExportSummary> exports) {
            this.exports = ExportSummaryListCopier.copy(exports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exports(ExportSummary... exports) {
            exports(Arrays.asList(exports));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exports(Consumer<ExportSummary.Builder>... exports) {
            exports(Stream.of(exports).map(c -> ExportSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListArchiveExportsResponse build() {
            return new ListArchiveExportsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
