/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response containing a list of archive search jobs and their statuses.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListArchiveSearchesResponse extends MailManagerResponse implements
        ToCopyableBuilder<ListArchiveSearchesResponse.Builder, ListArchiveSearchesResponse> {
    private static final SdkField<List<SearchSummary>> SEARCHES_FIELD = SdkField
            .<List<SearchSummary>> builder(MarshallingType.LIST)
            .memberName("Searches")
            .getter(getter(ListArchiveSearchesResponse::searches))
            .setter(setter(Builder::searches))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Searches").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SearchSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(SearchSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListArchiveSearchesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEARCHES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<SearchSummary> searches;

    private final String nextToken;

    private ListArchiveSearchesResponse(BuilderImpl builder) {
        super(builder);
        this.searches = builder.searches;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Searches property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSearches() {
        return searches != null && !(searches instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of search job identifiers and statuses.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSearches} method.
     * </p>
     * 
     * @return The list of search job identifiers and statuses.
     */
    public final List<SearchSummary> searches() {
        return searches;
    }

    /**
     * <p>
     * If present, use to retrieve the next page of results.
     * </p>
     * 
     * @return If present, use to retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSearches() ? searches() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListArchiveSearchesResponse)) {
            return false;
        }
        ListArchiveSearchesResponse other = (ListArchiveSearchesResponse) obj;
        return hasSearches() == other.hasSearches() && Objects.equals(searches(), other.searches())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListArchiveSearchesResponse").add("Searches", hasSearches() ? searches() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Searches":
            return Optional.ofNullable(clazz.cast(searches()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Searches", SEARCHES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListArchiveSearchesResponse, T> g) {
        return obj -> g.apply((ListArchiveSearchesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MailManagerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListArchiveSearchesResponse> {
        /**
         * <p>
         * The list of search job identifiers and statuses.
         * </p>
         * 
         * @param searches
         *        The list of search job identifiers and statuses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searches(Collection<SearchSummary> searches);

        /**
         * <p>
         * The list of search job identifiers and statuses.
         * </p>
         * 
         * @param searches
         *        The list of search job identifiers and statuses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searches(SearchSummary... searches);

        /**
         * <p>
         * The list of search job identifiers and statuses.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mailmanager.model.SearchSummary.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.mailmanager.model.SearchSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mailmanager.model.SearchSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #searches(List<SearchSummary>)}.
         * 
         * @param searches
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mailmanager.model.SearchSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #searches(java.util.Collection<SearchSummary>)
         */
        Builder searches(Consumer<SearchSummary.Builder>... searches);

        /**
         * <p>
         * If present, use to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        If present, use to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends MailManagerResponse.BuilderImpl implements Builder {
        private List<SearchSummary> searches = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListArchiveSearchesResponse model) {
            super(model);
            searches(model.searches);
            nextToken(model.nextToken);
        }

        public final List<SearchSummary.Builder> getSearches() {
            List<SearchSummary.Builder> result = SearchSummaryListCopier.copyToBuilder(this.searches);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSearches(Collection<SearchSummary.BuilderImpl> searches) {
            this.searches = SearchSummaryListCopier.copyFromBuilder(searches);
        }

        @Override
        public final Builder searches(Collection<SearchSummary> searches) {
            this.searches = SearchSummaryListCopier.copy(searches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder searches(SearchSummary... searches) {
            searches(Arrays.asList(searches));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder searches(Consumer<SearchSummary.Builder>... searches) {
            searches(Stream.of(searches).map(c -> SearchSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListArchiveSearchesResponse build() {
            return new ListArchiveSearchesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
