/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Authentication for the relay destination server—specify the secretARN where the SMTP credentials are stored, or
 * specify an empty NoAuthentication structure if the relay destination server does not require SMTP credential
 * authentication.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RelayAuthentication implements SdkPojo, Serializable,
        ToCopyableBuilder<RelayAuthentication.Builder, RelayAuthentication> {
    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretArn").getter(getter(RelayAuthentication::secretArn)).setter(setter(Builder::secretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()).build();

    private static final SdkField<NoAuthentication> NO_AUTHENTICATION_FIELD = SdkField
            .<NoAuthentication> builder(MarshallingType.SDK_POJO).memberName("NoAuthentication")
            .getter(getter(RelayAuthentication::noAuthentication)).setter(setter(Builder::noAuthentication))
            .constructor(NoAuthentication::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NoAuthentication").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECRET_ARN_FIELD,
            NO_AUTHENTICATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String secretArn;

    private final NoAuthentication noAuthentication;

    private final Type type;

    private RelayAuthentication(BuilderImpl builder) {
        this.secretArn = builder.secretArn;
        this.noAuthentication = builder.noAuthentication;
        this.type = builder.type;
    }

    /**
     * <p>
     * The ARN of the secret created in secrets manager where the relay server's SMTP credentials are stored.
     * </p>
     * 
     * @return The ARN of the secret created in secrets manager where the relay server's SMTP credentials are stored.
     */
    public final String secretArn() {
        return secretArn;
    }

    /**
     * <p>
     * Keep an empty structure if the relay destination server does not require SMTP credential authentication.
     * </p>
     * 
     * @return Keep an empty structure if the relay destination server does not require SMTP credential authentication.
     */
    public final NoAuthentication noAuthentication() {
        return noAuthentication;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(noAuthentication());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelayAuthentication)) {
            return false;
        }
        RelayAuthentication other = (RelayAuthentication) obj;
        return Objects.equals(secretArn(), other.secretArn()) && Objects.equals(noAuthentication(), other.noAuthentication());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RelayAuthentication").add("SecretArn", secretArn()).add("NoAuthentication", noAuthentication())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecretArn":
            return Optional.ofNullable(clazz.cast(secretArn()));
        case "NoAuthentication":
            return Optional.ofNullable(clazz.cast(noAuthentication()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #secretArn()} initialized to the given value.
     *
     * <p>
     * The ARN of the secret created in secrets manager where the relay server's SMTP credentials are stored.
     * </p>
     * 
     * @param secretArn
     *        The ARN of the secret created in secrets manager where the relay server's SMTP credentials are stored.
     */
    public static RelayAuthentication fromSecretArn(String secretArn) {
        return builder().secretArn(secretArn).build();
    }

    /**
     * Create an instance of this class with {@link #noAuthentication()} initialized to the given value.
     *
     * <p>
     * Keep an empty structure if the relay destination server does not require SMTP credential authentication.
     * </p>
     * 
     * @param noAuthentication
     *        Keep an empty structure if the relay destination server does not require SMTP credential authentication.
     */
    public static RelayAuthentication fromNoAuthentication(NoAuthentication noAuthentication) {
        return builder().noAuthentication(noAuthentication).build();
    }

    /**
     * Create an instance of this class with {@link #noAuthentication()} initialized to the given value.
     *
     * <p>
     * Keep an empty structure if the relay destination server does not require SMTP credential authentication.
     * </p>
     * 
     * @param noAuthentication
     *        Keep an empty structure if the relay destination server does not require SMTP credential authentication.
     */
    public static RelayAuthentication fromNoAuthentication(Consumer<NoAuthentication.Builder> noAuthentication) {
        NoAuthentication.Builder builder = NoAuthentication.builder();
        noAuthentication.accept(builder);
        return fromNoAuthentication(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SecretArn", SECRET_ARN_FIELD);
        map.put("NoAuthentication", NO_AUTHENTICATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RelayAuthentication, T> g) {
        return obj -> g.apply((RelayAuthentication) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RelayAuthentication> {
        /**
         * <p>
         * The ARN of the secret created in secrets manager where the relay server's SMTP credentials are stored.
         * </p>
         * 
         * @param secretArn
         *        The ARN of the secret created in secrets manager where the relay server's SMTP credentials are stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretArn(String secretArn);

        /**
         * <p>
         * Keep an empty structure if the relay destination server does not require SMTP credential authentication.
         * </p>
         * 
         * @param noAuthentication
         *        Keep an empty structure if the relay destination server does not require SMTP credential
         *        authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noAuthentication(NoAuthentication noAuthentication);

        /**
         * <p>
         * Keep an empty structure if the relay destination server does not require SMTP credential authentication.
         * </p>
         * This is a convenience method that creates an instance of the {@link NoAuthentication.Builder} avoiding the
         * need to create one manually via {@link NoAuthentication#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NoAuthentication.Builder#build()} is called immediately and its
         * result is passed to {@link #noAuthentication(NoAuthentication)}.
         * 
         * @param noAuthentication
         *        a consumer that will call methods on {@link NoAuthentication.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #noAuthentication(NoAuthentication)
         */
        default Builder noAuthentication(Consumer<NoAuthentication.Builder> noAuthentication) {
            return noAuthentication(NoAuthentication.builder().applyMutation(noAuthentication).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String secretArn;

        private NoAuthentication noAuthentication;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RelayAuthentication model) {
            secretArn(model.secretArn);
            noAuthentication(model.noAuthentication);
        }

        public final String getSecretArn() {
            return secretArn;
        }

        public final void setSecretArn(String secretArn) {
            Object oldValue = this.secretArn;
            this.secretArn = secretArn;
            handleUnionValueChange(Type.SECRET_ARN, oldValue, this.secretArn);
        }

        @Override
        public final Builder secretArn(String secretArn) {
            Object oldValue = this.secretArn;
            this.secretArn = secretArn;
            handleUnionValueChange(Type.SECRET_ARN, oldValue, this.secretArn);
            return this;
        }

        public final NoAuthentication.Builder getNoAuthentication() {
            return noAuthentication != null ? noAuthentication.toBuilder() : null;
        }

        public final void setNoAuthentication(NoAuthentication.BuilderImpl noAuthentication) {
            Object oldValue = this.noAuthentication;
            this.noAuthentication = noAuthentication != null ? noAuthentication.build() : null;
            handleUnionValueChange(Type.NO_AUTHENTICATION, oldValue, this.noAuthentication);
        }

        @Override
        public final Builder noAuthentication(NoAuthentication noAuthentication) {
            Object oldValue = this.noAuthentication;
            this.noAuthentication = noAuthentication;
            handleUnionValueChange(Type.NO_AUTHENTICATION, oldValue, this.noAuthentication);
            return this;
        }

        @Override
        public RelayAuthentication build() {
            return new RelayAuthentication(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see RelayAuthentication#type()
     */
    public enum Type {
        SECRET_ARN,

        NO_AUTHENTICATION,

        UNKNOWN_TO_SDK_VERSION
    }
}
