/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The verdict to evaluate in a verdict condition expression.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleVerdictToEvaluate implements SdkPojo, Serializable,
        ToCopyableBuilder<RuleVerdictToEvaluate.Builder, RuleVerdictToEvaluate> {
    private static final SdkField<String> ATTRIBUTE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Attribute").getter(getter(RuleVerdictToEvaluate::attributeAsString)).setter(setter(Builder::attribute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attribute").build()).build();

    private static final SdkField<Analysis> ANALYSIS_FIELD = SdkField.<Analysis> builder(MarshallingType.SDK_POJO)
            .memberName("Analysis").getter(getter(RuleVerdictToEvaluate::analysis)).setter(setter(Builder::analysis))
            .constructor(Analysis::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Analysis").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_FIELD,
            ANALYSIS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String attribute;

    private final Analysis analysis;

    private final Type type;

    private RuleVerdictToEvaluate(BuilderImpl builder) {
        this.attribute = builder.attribute;
        this.analysis = builder.analysis;
        this.type = builder.type;
    }

    /**
     * <p>
     * The email verdict attribute to evaluate in a string verdict expression.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attribute} will
     * return {@link RuleVerdictAttribute#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #attributeAsString}.
     * </p>
     * 
     * @return The email verdict attribute to evaluate in a string verdict expression.
     * @see RuleVerdictAttribute
     */
    public final RuleVerdictAttribute attribute() {
        return RuleVerdictAttribute.fromValue(attribute);
    }

    /**
     * <p>
     * The email verdict attribute to evaluate in a string verdict expression.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attribute} will
     * return {@link RuleVerdictAttribute#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #attributeAsString}.
     * </p>
     * 
     * @return The email verdict attribute to evaluate in a string verdict expression.
     * @see RuleVerdictAttribute
     */
    public final String attributeAsString() {
        return attribute;
    }

    /**
     * <p>
     * The Add On ARN and its returned value to evaluate in a verdict condition expression.
     * </p>
     * 
     * @return The Add On ARN and its returned value to evaluate in a verdict condition expression.
     */
    public final Analysis analysis() {
        return analysis;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(analysis());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleVerdictToEvaluate)) {
            return false;
        }
        RuleVerdictToEvaluate other = (RuleVerdictToEvaluate) obj;
        return Objects.equals(attributeAsString(), other.attributeAsString()) && Objects.equals(analysis(), other.analysis());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleVerdictToEvaluate").add("Attribute", attributeAsString()).add("Analysis", analysis())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attribute":
            return Optional.ofNullable(clazz.cast(attributeAsString()));
        case "Analysis":
            return Optional.ofNullable(clazz.cast(analysis()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #attributeAsString()} initialized to the given value.
     *
     * <p>
     * The email verdict attribute to evaluate in a string verdict expression.
     * </p>
     * 
     * @param attribute
     *        The email verdict attribute to evaluate in a string verdict expression.
     * @see RuleVerdictAttribute
     */
    public static RuleVerdictToEvaluate fromAttribute(String attribute) {
        return builder().attribute(attribute).build();
    }

    /**
     * Create an instance of this class with {@link #attributeAsString()} initialized to the given value.
     *
     * <p>
     * The email verdict attribute to evaluate in a string verdict expression.
     * </p>
     * 
     * @param attribute
     *        The email verdict attribute to evaluate in a string verdict expression.
     * @see RuleVerdictAttribute
     */
    public static RuleVerdictToEvaluate fromAttribute(RuleVerdictAttribute attribute) {
        return builder().attribute(attribute).build();
    }

    /**
     * Create an instance of this class with {@link #analysis()} initialized to the given value.
     *
     * <p>
     * The Add On ARN and its returned value to evaluate in a verdict condition expression.
     * </p>
     * 
     * @param analysis
     *        The Add On ARN and its returned value to evaluate in a verdict condition expression.
     */
    public static RuleVerdictToEvaluate fromAnalysis(Analysis analysis) {
        return builder().analysis(analysis).build();
    }

    /**
     * Create an instance of this class with {@link #analysis()} initialized to the given value.
     *
     * <p>
     * The Add On ARN and its returned value to evaluate in a verdict condition expression.
     * </p>
     * 
     * @param analysis
     *        The Add On ARN and its returned value to evaluate in a verdict condition expression.
     */
    public static RuleVerdictToEvaluate fromAnalysis(Consumer<Analysis.Builder> analysis) {
        Analysis.Builder builder = Analysis.builder();
        analysis.accept(builder);
        return fromAnalysis(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Attribute", ATTRIBUTE_FIELD);
        map.put("Analysis", ANALYSIS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuleVerdictToEvaluate, T> g) {
        return obj -> g.apply((RuleVerdictToEvaluate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleVerdictToEvaluate> {
        /**
         * <p>
         * The email verdict attribute to evaluate in a string verdict expression.
         * </p>
         * 
         * @param attribute
         *        The email verdict attribute to evaluate in a string verdict expression.
         * @see RuleVerdictAttribute
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleVerdictAttribute
         */
        Builder attribute(String attribute);

        /**
         * <p>
         * The email verdict attribute to evaluate in a string verdict expression.
         * </p>
         * 
         * @param attribute
         *        The email verdict attribute to evaluate in a string verdict expression.
         * @see RuleVerdictAttribute
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleVerdictAttribute
         */
        Builder attribute(RuleVerdictAttribute attribute);

        /**
         * <p>
         * The Add On ARN and its returned value to evaluate in a verdict condition expression.
         * </p>
         * 
         * @param analysis
         *        The Add On ARN and its returned value to evaluate in a verdict condition expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysis(Analysis analysis);

        /**
         * <p>
         * The Add On ARN and its returned value to evaluate in a verdict condition expression.
         * </p>
         * This is a convenience method that creates an instance of the {@link Analysis.Builder} avoiding the need to
         * create one manually via {@link Analysis#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Analysis.Builder#build()} is called immediately and its result is
         * passed to {@link #analysis(Analysis)}.
         * 
         * @param analysis
         *        a consumer that will call methods on {@link Analysis.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #analysis(Analysis)
         */
        default Builder analysis(Consumer<Analysis.Builder> analysis) {
            return analysis(Analysis.builder().applyMutation(analysis).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String attribute;

        private Analysis analysis;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RuleVerdictToEvaluate model) {
            attribute(model.attribute);
            analysis(model.analysis);
        }

        public final String getAttribute() {
            return attribute;
        }

        public final void setAttribute(String attribute) {
            Object oldValue = this.attribute;
            this.attribute = attribute;
            handleUnionValueChange(Type.ATTRIBUTE, oldValue, this.attribute);
        }

        @Override
        public final Builder attribute(String attribute) {
            Object oldValue = this.attribute;
            this.attribute = attribute;
            handleUnionValueChange(Type.ATTRIBUTE, oldValue, this.attribute);
            return this;
        }

        @Override
        public final Builder attribute(RuleVerdictAttribute attribute) {
            this.attribute(attribute == null ? null : attribute.toString());
            return this;
        }

        public final Analysis.Builder getAnalysis() {
            return analysis != null ? analysis.toBuilder() : null;
        }

        public final void setAnalysis(Analysis.BuilderImpl analysis) {
            Object oldValue = this.analysis;
            this.analysis = analysis != null ? analysis.build() : null;
            handleUnionValueChange(Type.ANALYSIS, oldValue, this.analysis);
        }

        @Override
        public final Builder analysis(Analysis analysis) {
            Object oldValue = this.analysis;
            this.analysis = analysis;
            handleUnionValueChange(Type.ANALYSIS, oldValue, this.analysis);
            return this;
        }

        @Override
        public RuleVerdictToEvaluate build() {
            return new RuleVerdictToEvaluate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see RuleVerdictToEvaluate#type()
     */
    public enum Type {
        ATTRIBUTE,

        ANALYSIS,

        UNKNOWN_TO_SDK_VERSION
    }
}
