/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The action to publish the email content to an Amazon SNS topic. When executed, this action will send the email as a
 * notification to the specified SNS topic.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SnsAction implements SdkPojo, Serializable, ToCopyableBuilder<SnsAction.Builder, SnsAction> {
    private static final SdkField<String> ACTION_FAILURE_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActionFailurePolicy").getter(getter(SnsAction::actionFailurePolicyAsString))
            .setter(setter(Builder::actionFailurePolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionFailurePolicy").build())
            .build();

    private static final SdkField<String> TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TopicArn").getter(getter(SnsAction::topicArn)).setter(setter(Builder::topicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicArn").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(SnsAction::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> ENCODING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Encoding").getter(getter(SnsAction::encodingAsString)).setter(setter(Builder::encoding))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encoding").build()).build();

    private static final SdkField<String> PAYLOAD_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PayloadType").getter(getter(SnsAction::payloadTypeAsString)).setter(setter(Builder::payloadType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PayloadType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FAILURE_POLICY_FIELD,
            TOPIC_ARN_FIELD, ROLE_ARN_FIELD, ENCODING_FIELD, PAYLOAD_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String actionFailurePolicy;

    private final String topicArn;

    private final String roleArn;

    private final String encoding;

    private final String payloadType;

    private SnsAction(BuilderImpl builder) {
        this.actionFailurePolicy = builder.actionFailurePolicy;
        this.topicArn = builder.topicArn;
        this.roleArn = builder.roleArn;
        this.encoding = builder.encoding;
        this.payloadType = builder.payloadType;
    }

    /**
     * <p>
     * A policy that states what to do in the case of failure. The action will fail if there are configuration errors.
     * For example, specified SNS topic has been deleted or the role lacks necessary permissions to call the
     * <code>sns:Publish</code> API.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #actionFailurePolicy} will return {@link ActionFailurePolicy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #actionFailurePolicyAsString}.
     * </p>
     * 
     * @return A policy that states what to do in the case of failure. The action will fail if there are configuration
     *         errors. For example, specified SNS topic has been deleted or the role lacks necessary permissions to call
     *         the <code>sns:Publish</code> API.
     * @see ActionFailurePolicy
     */
    public final ActionFailurePolicy actionFailurePolicy() {
        return ActionFailurePolicy.fromValue(actionFailurePolicy);
    }

    /**
     * <p>
     * A policy that states what to do in the case of failure. The action will fail if there are configuration errors.
     * For example, specified SNS topic has been deleted or the role lacks necessary permissions to call the
     * <code>sns:Publish</code> API.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #actionFailurePolicy} will return {@link ActionFailurePolicy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #actionFailurePolicyAsString}.
     * </p>
     * 
     * @return A policy that states what to do in the case of failure. The action will fail if there are configuration
     *         errors. For example, specified SNS topic has been deleted or the role lacks necessary permissions to call
     *         the <code>sns:Publish</code> API.
     * @see ActionFailurePolicy
     */
    public final String actionFailurePolicyAsString() {
        return actionFailurePolicy;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon SNS Topic to which notification for the email received will be
     * published.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon SNS Topic to which notification for the email received will
     *         be published.
     */
    public final String topicArn() {
        return topicArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM Role to use while writing to Amazon SNS. This role must have access to
     * the <code>sns:Publish</code> API for the given topic.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM Role to use while writing to Amazon SNS. This role must have
     *         access to the <code>sns:Publish</code> API for the given topic.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The encoding to use for the email within the Amazon SNS notification. The default value is <code>UTF-8</code>.
     * Use <code>BASE64</code> if you need to preserve all special characters, especially when the original message uses
     * a different encoding format.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encoding} will
     * return {@link SnsNotificationEncoding#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #encodingAsString}.
     * </p>
     * 
     * @return The encoding to use for the email within the Amazon SNS notification. The default value is
     *         <code>UTF-8</code>. Use <code>BASE64</code> if you need to preserve all special characters, especially
     *         when the original message uses a different encoding format.
     * @see SnsNotificationEncoding
     */
    public final SnsNotificationEncoding encoding() {
        return SnsNotificationEncoding.fromValue(encoding);
    }

    /**
     * <p>
     * The encoding to use for the email within the Amazon SNS notification. The default value is <code>UTF-8</code>.
     * Use <code>BASE64</code> if you need to preserve all special characters, especially when the original message uses
     * a different encoding format.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encoding} will
     * return {@link SnsNotificationEncoding#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #encodingAsString}.
     * </p>
     * 
     * @return The encoding to use for the email within the Amazon SNS notification. The default value is
     *         <code>UTF-8</code>. Use <code>BASE64</code> if you need to preserve all special characters, especially
     *         when the original message uses a different encoding format.
     * @see SnsNotificationEncoding
     */
    public final String encodingAsString() {
        return encoding;
    }

    /**
     * <p>
     * The expected payload type within the Amazon SNS notification. <code>CONTENT</code> attempts to publish the full
     * email content with 20KB of headers content. <code>HEADERS</code> extracts up to 100KB of header content to
     * include in the notification, email content will not be included to the notification. The default value is
     * <code>CONTENT</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #payloadType} will
     * return {@link SnsNotificationPayloadType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #payloadTypeAsString}.
     * </p>
     * 
     * @return The expected payload type within the Amazon SNS notification. <code>CONTENT</code> attempts to publish
     *         the full email content with 20KB of headers content. <code>HEADERS</code> extracts up to 100KB of header
     *         content to include in the notification, email content will not be included to the notification. The
     *         default value is <code>CONTENT</code>.
     * @see SnsNotificationPayloadType
     */
    public final SnsNotificationPayloadType payloadType() {
        return SnsNotificationPayloadType.fromValue(payloadType);
    }

    /**
     * <p>
     * The expected payload type within the Amazon SNS notification. <code>CONTENT</code> attempts to publish the full
     * email content with 20KB of headers content. <code>HEADERS</code> extracts up to 100KB of header content to
     * include in the notification, email content will not be included to the notification. The default value is
     * <code>CONTENT</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #payloadType} will
     * return {@link SnsNotificationPayloadType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #payloadTypeAsString}.
     * </p>
     * 
     * @return The expected payload type within the Amazon SNS notification. <code>CONTENT</code> attempts to publish
     *         the full email content with 20KB of headers content. <code>HEADERS</code> extracts up to 100KB of header
     *         content to include in the notification, email content will not be included to the notification. The
     *         default value is <code>CONTENT</code>.
     * @see SnsNotificationPayloadType
     */
    public final String payloadTypeAsString() {
        return payloadType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionFailurePolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(topicArn());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(encodingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(payloadTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnsAction)) {
            return false;
        }
        SnsAction other = (SnsAction) obj;
        return Objects.equals(actionFailurePolicyAsString(), other.actionFailurePolicyAsString())
                && Objects.equals(topicArn(), other.topicArn()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(encodingAsString(), other.encodingAsString())
                && Objects.equals(payloadTypeAsString(), other.payloadTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SnsAction").add("ActionFailurePolicy", actionFailurePolicyAsString())
                .add("TopicArn", topicArn()).add("RoleArn", roleArn()).add("Encoding", encodingAsString())
                .add("PayloadType", payloadTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActionFailurePolicy":
            return Optional.ofNullable(clazz.cast(actionFailurePolicyAsString()));
        case "TopicArn":
            return Optional.ofNullable(clazz.cast(topicArn()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "Encoding":
            return Optional.ofNullable(clazz.cast(encodingAsString()));
        case "PayloadType":
            return Optional.ofNullable(clazz.cast(payloadTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ActionFailurePolicy", ACTION_FAILURE_POLICY_FIELD);
        map.put("TopicArn", TOPIC_ARN_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("Encoding", ENCODING_FIELD);
        map.put("PayloadType", PAYLOAD_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SnsAction, T> g) {
        return obj -> g.apply((SnsAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SnsAction> {
        /**
         * <p>
         * A policy that states what to do in the case of failure. The action will fail if there are configuration
         * errors. For example, specified SNS topic has been deleted or the role lacks necessary permissions to call the
         * <code>sns:Publish</code> API.
         * </p>
         * 
         * @param actionFailurePolicy
         *        A policy that states what to do in the case of failure. The action will fail if there are
         *        configuration errors. For example, specified SNS topic has been deleted or the role lacks necessary
         *        permissions to call the <code>sns:Publish</code> API.
         * @see ActionFailurePolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionFailurePolicy
         */
        Builder actionFailurePolicy(String actionFailurePolicy);

        /**
         * <p>
         * A policy that states what to do in the case of failure. The action will fail if there are configuration
         * errors. For example, specified SNS topic has been deleted or the role lacks necessary permissions to call the
         * <code>sns:Publish</code> API.
         * </p>
         * 
         * @param actionFailurePolicy
         *        A policy that states what to do in the case of failure. The action will fail if there are
         *        configuration errors. For example, specified SNS topic has been deleted or the role lacks necessary
         *        permissions to call the <code>sns:Publish</code> API.
         * @see ActionFailurePolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionFailurePolicy
         */
        Builder actionFailurePolicy(ActionFailurePolicy actionFailurePolicy);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon SNS Topic to which notification for the email received will be
         * published.
         * </p>
         * 
         * @param topicArn
         *        The Amazon Resource Name (ARN) of the Amazon SNS Topic to which notification for the email received
         *        will be published.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicArn(String topicArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM Role to use while writing to Amazon SNS. This role must have access
         * to the <code>sns:Publish</code> API for the given topic.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM Role to use while writing to Amazon SNS. This role must have
         *        access to the <code>sns:Publish</code> API for the given topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The encoding to use for the email within the Amazon SNS notification. The default value is <code>UTF-8</code>
         * . Use <code>BASE64</code> if you need to preserve all special characters, especially when the original
         * message uses a different encoding format.
         * </p>
         * 
         * @param encoding
         *        The encoding to use for the email within the Amazon SNS notification. The default value is
         *        <code>UTF-8</code>. Use <code>BASE64</code> if you need to preserve all special characters, especially
         *        when the original message uses a different encoding format.
         * @see SnsNotificationEncoding
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnsNotificationEncoding
         */
        Builder encoding(String encoding);

        /**
         * <p>
         * The encoding to use for the email within the Amazon SNS notification. The default value is <code>UTF-8</code>
         * . Use <code>BASE64</code> if you need to preserve all special characters, especially when the original
         * message uses a different encoding format.
         * </p>
         * 
         * @param encoding
         *        The encoding to use for the email within the Amazon SNS notification. The default value is
         *        <code>UTF-8</code>. Use <code>BASE64</code> if you need to preserve all special characters, especially
         *        when the original message uses a different encoding format.
         * @see SnsNotificationEncoding
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnsNotificationEncoding
         */
        Builder encoding(SnsNotificationEncoding encoding);

        /**
         * <p>
         * The expected payload type within the Amazon SNS notification. <code>CONTENT</code> attempts to publish the
         * full email content with 20KB of headers content. <code>HEADERS</code> extracts up to 100KB of header content
         * to include in the notification, email content will not be included to the notification. The default value is
         * <code>CONTENT</code>.
         * </p>
         * 
         * @param payloadType
         *        The expected payload type within the Amazon SNS notification. <code>CONTENT</code> attempts to publish
         *        the full email content with 20KB of headers content. <code>HEADERS</code> extracts up to 100KB of
         *        header content to include in the notification, email content will not be included to the notification.
         *        The default value is <code>CONTENT</code>.
         * @see SnsNotificationPayloadType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnsNotificationPayloadType
         */
        Builder payloadType(String payloadType);

        /**
         * <p>
         * The expected payload type within the Amazon SNS notification. <code>CONTENT</code> attempts to publish the
         * full email content with 20KB of headers content. <code>HEADERS</code> extracts up to 100KB of header content
         * to include in the notification, email content will not be included to the notification. The default value is
         * <code>CONTENT</code>.
         * </p>
         * 
         * @param payloadType
         *        The expected payload type within the Amazon SNS notification. <code>CONTENT</code> attempts to publish
         *        the full email content with 20KB of headers content. <code>HEADERS</code> extracts up to 100KB of
         *        header content to include in the notification, email content will not be included to the notification.
         *        The default value is <code>CONTENT</code>.
         * @see SnsNotificationPayloadType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnsNotificationPayloadType
         */
        Builder payloadType(SnsNotificationPayloadType payloadType);
    }

    static final class BuilderImpl implements Builder {
        private String actionFailurePolicy;

        private String topicArn;

        private String roleArn;

        private String encoding;

        private String payloadType;

        private BuilderImpl() {
        }

        private BuilderImpl(SnsAction model) {
            actionFailurePolicy(model.actionFailurePolicy);
            topicArn(model.topicArn);
            roleArn(model.roleArn);
            encoding(model.encoding);
            payloadType(model.payloadType);
        }

        public final String getActionFailurePolicy() {
            return actionFailurePolicy;
        }

        public final void setActionFailurePolicy(String actionFailurePolicy) {
            this.actionFailurePolicy = actionFailurePolicy;
        }

        @Override
        public final Builder actionFailurePolicy(String actionFailurePolicy) {
            this.actionFailurePolicy = actionFailurePolicy;
            return this;
        }

        @Override
        public final Builder actionFailurePolicy(ActionFailurePolicy actionFailurePolicy) {
            this.actionFailurePolicy(actionFailurePolicy == null ? null : actionFailurePolicy.toString());
            return this;
        }

        public final String getTopicArn() {
            return topicArn;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getEncoding() {
            return encoding;
        }

        public final void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        @Override
        public final Builder encoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        @Override
        public final Builder encoding(SnsNotificationEncoding encoding) {
            this.encoding(encoding == null ? null : encoding.toString());
            return this;
        }

        public final String getPayloadType() {
            return payloadType;
        }

        public final void setPayloadType(String payloadType) {
            this.payloadType = payloadType;
        }

        @Override
        public final Builder payloadType(String payloadType) {
            this.payloadType = payloadType;
            return this;
        }

        @Override
        public final Builder payloadType(SnsNotificationPayloadType payloadType) {
            this.payloadType(payloadType == null ? null : payloadType.toString());
            return this;
        }

        @Override
        public SnsAction build() {
            return new SnsAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
