/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An archive resource for storing and retaining emails.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Archive implements SdkPojo, Serializable, ToCopyableBuilder<Archive.Builder, Archive> {
    private static final SdkField<String> ARCHIVE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ArchiveId").getter(getter(Archive::archiveId)).setter(setter(Builder::archiveId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchiveId").build()).build();

    private static final SdkField<String> ARCHIVE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ArchiveName").getter(getter(Archive::archiveName)).setter(setter(Builder::archiveName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchiveName").build()).build();

    private static final SdkField<String> ARCHIVE_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ArchiveState").getter(getter(Archive::archiveStateAsString)).setter(setter(Builder::archiveState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchiveState").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTimestamp").getter(getter(Archive::lastUpdatedTimestamp))
            .setter(setter(Builder::lastUpdatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTimestamp").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARCHIVE_ID_FIELD,
            ARCHIVE_NAME_FIELD, ARCHIVE_STATE_FIELD, LAST_UPDATED_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String archiveId;

    private final String archiveName;

    private final String archiveState;

    private final Instant lastUpdatedTimestamp;

    private Archive(BuilderImpl builder) {
        this.archiveId = builder.archiveId;
        this.archiveName = builder.archiveName;
        this.archiveState = builder.archiveState;
        this.lastUpdatedTimestamp = builder.lastUpdatedTimestamp;
    }

    /**
     * <p>
     * The unique identifier of the archive.
     * </p>
     * 
     * @return The unique identifier of the archive.
     */
    public final String archiveId() {
        return archiveId;
    }

    /**
     * <p>
     * The unique name assigned to the archive.
     * </p>
     * 
     * @return The unique name assigned to the archive.
     */
    public final String archiveName() {
        return archiveName;
    }

    /**
     * <p>
     * The current state of the archive:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code> – The archive is ready and available for use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING_DELETION</code> – The archive has been marked for deletion and will be permanently deleted in 30
     * days. No further modifications can be made in this state.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #archiveState} will
     * return {@link ArchiveState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #archiveStateAsString}.
     * </p>
     * 
     * @return The current state of the archive:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> – The archive is ready and available for use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PENDING_DELETION</code> – The archive has been marked for deletion and will be permanently deleted
     *         in 30 days. No further modifications can be made in this state.
     *         </p>
     *         </li>
     * @see ArchiveState
     */
    public final ArchiveState archiveState() {
        return ArchiveState.fromValue(archiveState);
    }

    /**
     * <p>
     * The current state of the archive:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code> – The archive is ready and available for use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING_DELETION</code> – The archive has been marked for deletion and will be permanently deleted in 30
     * days. No further modifications can be made in this state.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #archiveState} will
     * return {@link ArchiveState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #archiveStateAsString}.
     * </p>
     * 
     * @return The current state of the archive:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> – The archive is ready and available for use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PENDING_DELETION</code> – The archive has been marked for deletion and will be permanently deleted
     *         in 30 days. No further modifications can be made in this state.
     *         </p>
     *         </li>
     * @see ArchiveState
     */
    public final String archiveStateAsString() {
        return archiveState;
    }

    /**
     * <p>
     * The timestamp of when the archive was last updated.
     * </p>
     * 
     * @return The timestamp of when the archive was last updated.
     */
    public final Instant lastUpdatedTimestamp() {
        return lastUpdatedTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(archiveId());
        hashCode = 31 * hashCode + Objects.hashCode(archiveName());
        hashCode = 31 * hashCode + Objects.hashCode(archiveStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Archive)) {
            return false;
        }
        Archive other = (Archive) obj;
        return Objects.equals(archiveId(), other.archiveId()) && Objects.equals(archiveName(), other.archiveName())
                && Objects.equals(archiveStateAsString(), other.archiveStateAsString())
                && Objects.equals(lastUpdatedTimestamp(), other.lastUpdatedTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Archive").add("ArchiveId", archiveId()).add("ArchiveName", archiveName())
                .add("ArchiveState", archiveStateAsString()).add("LastUpdatedTimestamp", lastUpdatedTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ArchiveId":
            return Optional.ofNullable(clazz.cast(archiveId()));
        case "ArchiveName":
            return Optional.ofNullable(clazz.cast(archiveName()));
        case "ArchiveState":
            return Optional.ofNullable(clazz.cast(archiveStateAsString()));
        case "LastUpdatedTimestamp":
            return Optional.ofNullable(clazz.cast(lastUpdatedTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ArchiveId", ARCHIVE_ID_FIELD);
        map.put("ArchiveName", ARCHIVE_NAME_FIELD);
        map.put("ArchiveState", ARCHIVE_STATE_FIELD);
        map.put("LastUpdatedTimestamp", LAST_UPDATED_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Archive, T> g) {
        return obj -> g.apply((Archive) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Archive> {
        /**
         * <p>
         * The unique identifier of the archive.
         * </p>
         * 
         * @param archiveId
         *        The unique identifier of the archive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder archiveId(String archiveId);

        /**
         * <p>
         * The unique name assigned to the archive.
         * </p>
         * 
         * @param archiveName
         *        The unique name assigned to the archive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder archiveName(String archiveName);

        /**
         * <p>
         * The current state of the archive:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code> – The archive is ready and available for use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PENDING_DELETION</code> – The archive has been marked for deletion and will be permanently deleted in
         * 30 days. No further modifications can be made in this state.
         * </p>
         * </li>
         * </ul>
         * 
         * @param archiveState
         *        The current state of the archive:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> – The archive is ready and available for use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PENDING_DELETION</code> – The archive has been marked for deletion and will be permanently
         *        deleted in 30 days. No further modifications can be made in this state.
         *        </p>
         *        </li>
         * @see ArchiveState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArchiveState
         */
        Builder archiveState(String archiveState);

        /**
         * <p>
         * The current state of the archive:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code> – The archive is ready and available for use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PENDING_DELETION</code> – The archive has been marked for deletion and will be permanently deleted in
         * 30 days. No further modifications can be made in this state.
         * </p>
         * </li>
         * </ul>
         * 
         * @param archiveState
         *        The current state of the archive:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> – The archive is ready and available for use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PENDING_DELETION</code> – The archive has been marked for deletion and will be permanently
         *        deleted in 30 days. No further modifications can be made in this state.
         *        </p>
         *        </li>
         * @see ArchiveState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArchiveState
         */
        Builder archiveState(ArchiveState archiveState);

        /**
         * <p>
         * The timestamp of when the archive was last updated.
         * </p>
         * 
         * @param lastUpdatedTimestamp
         *        The timestamp of when the archive was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String archiveId;

        private String archiveName;

        private String archiveState;

        private Instant lastUpdatedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(Archive model) {
            archiveId(model.archiveId);
            archiveName(model.archiveName);
            archiveState(model.archiveState);
            lastUpdatedTimestamp(model.lastUpdatedTimestamp);
        }

        public final String getArchiveId() {
            return archiveId;
        }

        public final void setArchiveId(String archiveId) {
            this.archiveId = archiveId;
        }

        @Override
        public final Builder archiveId(String archiveId) {
            this.archiveId = archiveId;
            return this;
        }

        public final String getArchiveName() {
            return archiveName;
        }

        public final void setArchiveName(String archiveName) {
            this.archiveName = archiveName;
        }

        @Override
        public final Builder archiveName(String archiveName) {
            this.archiveName = archiveName;
            return this;
        }

        public final String getArchiveState() {
            return archiveState;
        }

        public final void setArchiveState(String archiveState) {
            this.archiveState = archiveState;
        }

        @Override
        public final Builder archiveState(String archiveState) {
            this.archiveState = archiveState;
            return this;
        }

        @Override
        public final Builder archiveState(ArchiveState archiveState) {
            this.archiveState(archiveState == null ? null : archiveState.toString());
            return this;
        }

        public final Instant getLastUpdatedTimestamp() {
            return lastUpdatedTimestamp;
        }

        public final void setLastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        }

        @Override
        public final Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
            return this;
        }

        @Override
        public Archive build() {
            return new Archive(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
