/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The current status of an archive export job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportStatus implements SdkPojo, Serializable, ToCopyableBuilder<ExportStatus.Builder, ExportStatus> {
    private static final SdkField<Instant> SUBMISSION_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("SubmissionTimestamp").getter(getter(ExportStatus::submissionTimestamp))
            .setter(setter(Builder::submissionTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubmissionTimestamp").build())
            .build();

    private static final SdkField<Instant> COMPLETION_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CompletionTimestamp").getter(getter(ExportStatus::completionTimestamp))
            .setter(setter(Builder::completionTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionTimestamp").build())
            .build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(ExportStatus::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorMessage").getter(getter(ExportStatus::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBMISSION_TIMESTAMP_FIELD,
            COMPLETION_TIMESTAMP_FIELD, STATE_FIELD, ERROR_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant submissionTimestamp;

    private final Instant completionTimestamp;

    private final String state;

    private final String errorMessage;

    private ExportStatus(BuilderImpl builder) {
        this.submissionTimestamp = builder.submissionTimestamp;
        this.completionTimestamp = builder.completionTimestamp;
        this.state = builder.state;
        this.errorMessage = builder.errorMessage;
    }

    /**
     * <p>
     * The timestamp of when the export job was submitted.
     * </p>
     * 
     * @return The timestamp of when the export job was submitted.
     */
    public final Instant submissionTimestamp() {
        return submissionTimestamp;
    }

    /**
     * <p>
     * The timestamp of when the export job completed (if finished).
     * </p>
     * 
     * @return The timestamp of when the export job completed (if finished).
     */
    public final Instant completionTimestamp() {
        return completionTimestamp;
    }

    /**
     * <p>
     * The current state of the export job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ExportState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the export job.
     * @see ExportState
     */
    public final ExportState state() {
        return ExportState.fromValue(state);
    }

    /**
     * <p>
     * The current state of the export job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ExportState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the export job.
     * @see ExportState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * An error message if the export job failed.
     * </p>
     * 
     * @return An error message if the export job failed.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(submissionTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(completionTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportStatus)) {
            return false;
        }
        ExportStatus other = (ExportStatus) obj;
        return Objects.equals(submissionTimestamp(), other.submissionTimestamp())
                && Objects.equals(completionTimestamp(), other.completionTimestamp())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(errorMessage(), other.errorMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExportStatus").add("SubmissionTimestamp", submissionTimestamp())
                .add("CompletionTimestamp", completionTimestamp()).add("State", stateAsString())
                .add("ErrorMessage", errorMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SubmissionTimestamp":
            return Optional.ofNullable(clazz.cast(submissionTimestamp()));
        case "CompletionTimestamp":
            return Optional.ofNullable(clazz.cast(completionTimestamp()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SubmissionTimestamp", SUBMISSION_TIMESTAMP_FIELD);
        map.put("CompletionTimestamp", COMPLETION_TIMESTAMP_FIELD);
        map.put("State", STATE_FIELD);
        map.put("ErrorMessage", ERROR_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExportStatus, T> g) {
        return obj -> g.apply((ExportStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExportStatus> {
        /**
         * <p>
         * The timestamp of when the export job was submitted.
         * </p>
         * 
         * @param submissionTimestamp
         *        The timestamp of when the export job was submitted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder submissionTimestamp(Instant submissionTimestamp);

        /**
         * <p>
         * The timestamp of when the export job completed (if finished).
         * </p>
         * 
         * @param completionTimestamp
         *        The timestamp of when the export job completed (if finished).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completionTimestamp(Instant completionTimestamp);

        /**
         * <p>
         * The current state of the export job.
         * </p>
         * 
         * @param state
         *        The current state of the export job.
         * @see ExportState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of the export job.
         * </p>
         * 
         * @param state
         *        The current state of the export job.
         * @see ExportState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportState
         */
        Builder state(ExportState state);

        /**
         * <p>
         * An error message if the export job failed.
         * </p>
         * 
         * @param errorMessage
         *        An error message if the export job failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);
    }

    static final class BuilderImpl implements Builder {
        private Instant submissionTimestamp;

        private Instant completionTimestamp;

        private String state;

        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportStatus model) {
            submissionTimestamp(model.submissionTimestamp);
            completionTimestamp(model.completionTimestamp);
            state(model.state);
            errorMessage(model.errorMessage);
        }

        public final Instant getSubmissionTimestamp() {
            return submissionTimestamp;
        }

        public final void setSubmissionTimestamp(Instant submissionTimestamp) {
            this.submissionTimestamp = submissionTimestamp;
        }

        @Override
        public final Builder submissionTimestamp(Instant submissionTimestamp) {
            this.submissionTimestamp = submissionTimestamp;
            return this;
        }

        public final Instant getCompletionTimestamp() {
            return completionTimestamp;
        }

        public final void setCompletionTimestamp(Instant completionTimestamp) {
            this.completionTimestamp = completionTimestamp;
        }

        @Override
        public final Builder completionTimestamp(Instant completionTimestamp) {
            this.completionTimestamp = completionTimestamp;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ExportState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        @Override
        public ExportStatus build() {
            return new ExportStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
