/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAddonInstanceResponse extends MailManagerResponse implements
        ToCopyableBuilder<GetAddonInstanceResponse.Builder, GetAddonInstanceResponse> {
    private static final SdkField<String> ADDON_SUBSCRIPTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AddonSubscriptionId").getter(getter(GetAddonInstanceResponse::addonSubscriptionId))
            .setter(setter(Builder::addonSubscriptionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddonSubscriptionId").build())
            .build();

    private static final SdkField<String> ADDON_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AddonName").getter(getter(GetAddonInstanceResponse::addonName)).setter(setter(Builder::addonName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddonName").build()).build();

    private static final SdkField<String> ADDON_INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AddonInstanceArn").getter(getter(GetAddonInstanceResponse::addonInstanceArn))
            .setter(setter(Builder::addonInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddonInstanceArn").build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp").getter(getter(GetAddonInstanceResponse::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDON_SUBSCRIPTION_ID_FIELD,
            ADDON_NAME_FIELD, ADDON_INSTANCE_ARN_FIELD, CREATED_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String addonSubscriptionId;

    private final String addonName;

    private final String addonInstanceArn;

    private final Instant createdTimestamp;

    private GetAddonInstanceResponse(BuilderImpl builder) {
        super(builder);
        this.addonSubscriptionId = builder.addonSubscriptionId;
        this.addonName = builder.addonName;
        this.addonInstanceArn = builder.addonInstanceArn;
        this.createdTimestamp = builder.createdTimestamp;
    }

    /**
     * <p>
     * The subscription ID associated to the instance.
     * </p>
     * 
     * @return The subscription ID associated to the instance.
     */
    public final String addonSubscriptionId() {
        return addonSubscriptionId;
    }

    /**
     * <p>
     * The name of the Add On provider associated to the subscription of the instance.
     * </p>
     * 
     * @return The name of the Add On provider associated to the subscription of the instance.
     */
    public final String addonName() {
        return addonName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Add On instance.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Add On instance.
     */
    public final String addonInstanceArn() {
        return addonInstanceArn;
    }

    /**
     * <p>
     * The timestamp of when the Add On instance was created.
     * </p>
     * 
     * @return The timestamp of when the Add On instance was created.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(addonSubscriptionId());
        hashCode = 31 * hashCode + Objects.hashCode(addonName());
        hashCode = 31 * hashCode + Objects.hashCode(addonInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAddonInstanceResponse)) {
            return false;
        }
        GetAddonInstanceResponse other = (GetAddonInstanceResponse) obj;
        return Objects.equals(addonSubscriptionId(), other.addonSubscriptionId())
                && Objects.equals(addonName(), other.addonName()) && Objects.equals(addonInstanceArn(), other.addonInstanceArn())
                && Objects.equals(createdTimestamp(), other.createdTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAddonInstanceResponse").add("AddonSubscriptionId", addonSubscriptionId())
                .add("AddonName", addonName()).add("AddonInstanceArn", addonInstanceArn())
                .add("CreatedTimestamp", createdTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AddonSubscriptionId":
            return Optional.ofNullable(clazz.cast(addonSubscriptionId()));
        case "AddonName":
            return Optional.ofNullable(clazz.cast(addonName()));
        case "AddonInstanceArn":
            return Optional.ofNullable(clazz.cast(addonInstanceArn()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AddonSubscriptionId", ADDON_SUBSCRIPTION_ID_FIELD);
        map.put("AddonName", ADDON_NAME_FIELD);
        map.put("AddonInstanceArn", ADDON_INSTANCE_ARN_FIELD);
        map.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAddonInstanceResponse, T> g) {
        return obj -> g.apply((GetAddonInstanceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MailManagerResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetAddonInstanceResponse> {
        /**
         * <p>
         * The subscription ID associated to the instance.
         * </p>
         * 
         * @param addonSubscriptionId
         *        The subscription ID associated to the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addonSubscriptionId(String addonSubscriptionId);

        /**
         * <p>
         * The name of the Add On provider associated to the subscription of the instance.
         * </p>
         * 
         * @param addonName
         *        The name of the Add On provider associated to the subscription of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addonName(String addonName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Add On instance.
         * </p>
         * 
         * @param addonInstanceArn
         *        The Amazon Resource Name (ARN) of the Add On instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addonInstanceArn(String addonInstanceArn);

        /**
         * <p>
         * The timestamp of when the Add On instance was created.
         * </p>
         * 
         * @param createdTimestamp
         *        The timestamp of when the Add On instance was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);
    }

    static final class BuilderImpl extends MailManagerResponse.BuilderImpl implements Builder {
        private String addonSubscriptionId;

        private String addonName;

        private String addonInstanceArn;

        private Instant createdTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAddonInstanceResponse model) {
            super(model);
            addonSubscriptionId(model.addonSubscriptionId);
            addonName(model.addonName);
            addonInstanceArn(model.addonInstanceArn);
            createdTimestamp(model.createdTimestamp);
        }

        public final String getAddonSubscriptionId() {
            return addonSubscriptionId;
        }

        public final void setAddonSubscriptionId(String addonSubscriptionId) {
            this.addonSubscriptionId = addonSubscriptionId;
        }

        @Override
        public final Builder addonSubscriptionId(String addonSubscriptionId) {
            this.addonSubscriptionId = addonSubscriptionId;
            return this;
        }

        public final String getAddonName() {
            return addonName;
        }

        public final void setAddonName(String addonName) {
            this.addonName = addonName;
        }

        @Override
        public final Builder addonName(String addonName) {
            this.addonName = addonName;
            return this;
        }

        public final String getAddonInstanceArn() {
            return addonInstanceArn;
        }

        public final void setAddonInstanceArn(String addonInstanceArn) {
            this.addonInstanceArn = addonInstanceArn;
        }

        @Override
        public final Builder addonInstanceArn(String addonInstanceArn) {
            this.addonInstanceArn = addonInstanceArn;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        @Override
        public GetAddonInstanceResponse build() {
            return new GetAddonInstanceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
