/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAddressListImportJobResponse extends MailManagerResponse implements
        ToCopyableBuilder<GetAddressListImportJobResponse.Builder, GetAddressListImportJobResponse> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("JobId")
            .getter(getter(GetAddressListImportJobResponse::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GetAddressListImportJobResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GetAddressListImportJobResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> PRE_SIGNED_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PreSignedUrl").getter(getter(GetAddressListImportJobResponse::preSignedUrl))
            .setter(setter(Builder::preSignedUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreSignedUrl").build()).build();

    private static final SdkField<Integer> IMPORTED_ITEMS_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ImportedItemsCount").getter(getter(GetAddressListImportJobResponse::importedItemsCount))
            .setter(setter(Builder::importedItemsCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportedItemsCount").build())
            .build();

    private static final SdkField<Integer> FAILED_ITEMS_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FailedItemsCount").getter(getter(GetAddressListImportJobResponse::failedItemsCount))
            .setter(setter(Builder::failedItemsCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedItemsCount").build()).build();

    private static final SdkField<ImportDataFormat> IMPORT_DATA_FORMAT_FIELD = SdkField
            .<ImportDataFormat> builder(MarshallingType.SDK_POJO).memberName("ImportDataFormat")
            .getter(getter(GetAddressListImportJobResponse::importDataFormat)).setter(setter(Builder::importDataFormat))
            .constructor(ImportDataFormat::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportDataFormat").build()).build();

    private static final SdkField<String> ADDRESS_LIST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AddressListId").getter(getter(GetAddressListImportJobResponse::addressListId))
            .setter(setter(Builder::addressListId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressListId").build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp").getter(getter(GetAddressListImportJobResponse::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()).build();

    private static final SdkField<Instant> START_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTimestamp").getter(getter(GetAddressListImportJobResponse::startTimestamp))
            .setter(setter(Builder::startTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTimestamp").build()).build();

    private static final SdkField<Instant> COMPLETED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CompletedTimestamp").getter(getter(GetAddressListImportJobResponse::completedTimestamp))
            .setter(setter(Builder::completedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletedTimestamp").build())
            .build();

    private static final SdkField<String> ERROR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Error")
            .getter(getter(GetAddressListImportJobResponse::error)).setter(setter(Builder::error))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, NAME_FIELD,
            STATUS_FIELD, PRE_SIGNED_URL_FIELD, IMPORTED_ITEMS_COUNT_FIELD, FAILED_ITEMS_COUNT_FIELD, IMPORT_DATA_FORMAT_FIELD,
            ADDRESS_LIST_ID_FIELD, CREATED_TIMESTAMP_FIELD, START_TIMESTAMP_FIELD, COMPLETED_TIMESTAMP_FIELD, ERROR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String jobId;

    private final String name;

    private final String status;

    private final String preSignedUrl;

    private final Integer importedItemsCount;

    private final Integer failedItemsCount;

    private final ImportDataFormat importDataFormat;

    private final String addressListId;

    private final Instant createdTimestamp;

    private final Instant startTimestamp;

    private final Instant completedTimestamp;

    private final String error;

    private GetAddressListImportJobResponse(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.name = builder.name;
        this.status = builder.status;
        this.preSignedUrl = builder.preSignedUrl;
        this.importedItemsCount = builder.importedItemsCount;
        this.failedItemsCount = builder.failedItemsCount;
        this.importDataFormat = builder.importDataFormat;
        this.addressListId = builder.addressListId;
        this.createdTimestamp = builder.createdTimestamp;
        this.startTimestamp = builder.startTimestamp;
        this.completedTimestamp = builder.completedTimestamp;
        this.error = builder.error;
    }

    /**
     * <p>
     * The identifier of the import job.
     * </p>
     * 
     * @return The identifier of the import job.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * A user-friendly name for the import job.
     * </p>
     * 
     * @return A user-friendly name for the import job.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The status of the import job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ImportJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the import job.
     * @see ImportJobStatus
     */
    public final ImportJobStatus status() {
        return ImportJobStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the import job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ImportJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the import job.
     * @see ImportJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The pre-signed URL target for uploading the input file.
     * </p>
     * 
     * @return The pre-signed URL target for uploading the input file.
     */
    public final String preSignedUrl() {
        return preSignedUrl;
    }

    /**
     * <p>
     * The number of input addresses successfully imported into the address list.
     * </p>
     * 
     * @return The number of input addresses successfully imported into the address list.
     */
    public final Integer importedItemsCount() {
        return importedItemsCount;
    }

    /**
     * <p>
     * The number of input addresses that failed to be imported into the address list.
     * </p>
     * 
     * @return The number of input addresses that failed to be imported into the address list.
     */
    public final Integer failedItemsCount() {
        return failedItemsCount;
    }

    /**
     * <p>
     * The format of the input for an import job.
     * </p>
     * 
     * @return The format of the input for an import job.
     */
    public final ImportDataFormat importDataFormat() {
        return importDataFormat;
    }

    /**
     * <p>
     * The unique identifier of the address list the import job was created for.
     * </p>
     * 
     * @return The unique identifier of the address list the import job was created for.
     */
    public final String addressListId() {
        return addressListId;
    }

    /**
     * <p>
     * The timestamp of when the import job was created.
     * </p>
     * 
     * @return The timestamp of when the import job was created.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * The timestamp of when the import job was started.
     * </p>
     * 
     * @return The timestamp of when the import job was started.
     */
    public final Instant startTimestamp() {
        return startTimestamp;
    }

    /**
     * <p>
     * The timestamp of when the import job was completed.
     * </p>
     * 
     * @return The timestamp of when the import job was completed.
     */
    public final Instant completedTimestamp() {
        return completedTimestamp;
    }

    /**
     * <p>
     * The reason for failure of an import job.
     * </p>
     * 
     * @return The reason for failure of an import job.
     */
    public final String error() {
        return error;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(preSignedUrl());
        hashCode = 31 * hashCode + Objects.hashCode(importedItemsCount());
        hashCode = 31 * hashCode + Objects.hashCode(failedItemsCount());
        hashCode = 31 * hashCode + Objects.hashCode(importDataFormat());
        hashCode = 31 * hashCode + Objects.hashCode(addressListId());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(startTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(completedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAddressListImportJobResponse)) {
            return false;
        }
        GetAddressListImportJobResponse other = (GetAddressListImportJobResponse) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(name(), other.name())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(preSignedUrl(), other.preSignedUrl())
                && Objects.equals(importedItemsCount(), other.importedItemsCount())
                && Objects.equals(failedItemsCount(), other.failedItemsCount())
                && Objects.equals(importDataFormat(), other.importDataFormat())
                && Objects.equals(addressListId(), other.addressListId())
                && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(startTimestamp(), other.startTimestamp())
                && Objects.equals(completedTimestamp(), other.completedTimestamp()) && Objects.equals(error(), other.error());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAddressListImportJobResponse").add("JobId", jobId()).add("Name", name())
                .add("Status", statusAsString())
                .add("PreSignedUrl", preSignedUrl() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ImportedItemsCount", importedItemsCount()).add("FailedItemsCount", failedItemsCount())
                .add("ImportDataFormat", importDataFormat()).add("AddressListId", addressListId())
                .add("CreatedTimestamp", createdTimestamp()).add("StartTimestamp", startTimestamp())
                .add("CompletedTimestamp", completedTimestamp()).add("Error", error()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "PreSignedUrl":
            return Optional.ofNullable(clazz.cast(preSignedUrl()));
        case "ImportedItemsCount":
            return Optional.ofNullable(clazz.cast(importedItemsCount()));
        case "FailedItemsCount":
            return Optional.ofNullable(clazz.cast(failedItemsCount()));
        case "ImportDataFormat":
            return Optional.ofNullable(clazz.cast(importDataFormat()));
        case "AddressListId":
            return Optional.ofNullable(clazz.cast(addressListId()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "StartTimestamp":
            return Optional.ofNullable(clazz.cast(startTimestamp()));
        case "CompletedTimestamp":
            return Optional.ofNullable(clazz.cast(completedTimestamp()));
        case "Error":
            return Optional.ofNullable(clazz.cast(error()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("JobId", JOB_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("PreSignedUrl", PRE_SIGNED_URL_FIELD);
        map.put("ImportedItemsCount", IMPORTED_ITEMS_COUNT_FIELD);
        map.put("FailedItemsCount", FAILED_ITEMS_COUNT_FIELD);
        map.put("ImportDataFormat", IMPORT_DATA_FORMAT_FIELD);
        map.put("AddressListId", ADDRESS_LIST_ID_FIELD);
        map.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
        map.put("StartTimestamp", START_TIMESTAMP_FIELD);
        map.put("CompletedTimestamp", COMPLETED_TIMESTAMP_FIELD);
        map.put("Error", ERROR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAddressListImportJobResponse, T> g) {
        return obj -> g.apply((GetAddressListImportJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MailManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetAddressListImportJobResponse> {
        /**
         * <p>
         * The identifier of the import job.
         * </p>
         * 
         * @param jobId
         *        The identifier of the import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * A user-friendly name for the import job.
         * </p>
         * 
         * @param name
         *        A user-friendly name for the import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The status of the import job.
         * </p>
         * 
         * @param status
         *        The status of the import job.
         * @see ImportJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImportJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the import job.
         * </p>
         * 
         * @param status
         *        The status of the import job.
         * @see ImportJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImportJobStatus
         */
        Builder status(ImportJobStatus status);

        /**
         * <p>
         * The pre-signed URL target for uploading the input file.
         * </p>
         * 
         * @param preSignedUrl
         *        The pre-signed URL target for uploading the input file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preSignedUrl(String preSignedUrl);

        /**
         * <p>
         * The number of input addresses successfully imported into the address list.
         * </p>
         * 
         * @param importedItemsCount
         *        The number of input addresses successfully imported into the address list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importedItemsCount(Integer importedItemsCount);

        /**
         * <p>
         * The number of input addresses that failed to be imported into the address list.
         * </p>
         * 
         * @param failedItemsCount
         *        The number of input addresses that failed to be imported into the address list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedItemsCount(Integer failedItemsCount);

        /**
         * <p>
         * The format of the input for an import job.
         * </p>
         * 
         * @param importDataFormat
         *        The format of the input for an import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importDataFormat(ImportDataFormat importDataFormat);

        /**
         * <p>
         * The format of the input for an import job.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImportDataFormat.Builder} avoiding the
         * need to create one manually via {@link ImportDataFormat#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImportDataFormat.Builder#build()} is called immediately and its
         * result is passed to {@link #importDataFormat(ImportDataFormat)}.
         * 
         * @param importDataFormat
         *        a consumer that will call methods on {@link ImportDataFormat.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #importDataFormat(ImportDataFormat)
         */
        default Builder importDataFormat(Consumer<ImportDataFormat.Builder> importDataFormat) {
            return importDataFormat(ImportDataFormat.builder().applyMutation(importDataFormat).build());
        }

        /**
         * <p>
         * The unique identifier of the address list the import job was created for.
         * </p>
         * 
         * @param addressListId
         *        The unique identifier of the address list the import job was created for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressListId(String addressListId);

        /**
         * <p>
         * The timestamp of when the import job was created.
         * </p>
         * 
         * @param createdTimestamp
         *        The timestamp of when the import job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * The timestamp of when the import job was started.
         * </p>
         * 
         * @param startTimestamp
         *        The timestamp of when the import job was started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimestamp(Instant startTimestamp);

        /**
         * <p>
         * The timestamp of when the import job was completed.
         * </p>
         * 
         * @param completedTimestamp
         *        The timestamp of when the import job was completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completedTimestamp(Instant completedTimestamp);

        /**
         * <p>
         * The reason for failure of an import job.
         * </p>
         * 
         * @param error
         *        The reason for failure of an import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(String error);
    }

    static final class BuilderImpl extends MailManagerResponse.BuilderImpl implements Builder {
        private String jobId;

        private String name;

        private String status;

        private String preSignedUrl;

        private Integer importedItemsCount;

        private Integer failedItemsCount;

        private ImportDataFormat importDataFormat;

        private String addressListId;

        private Instant createdTimestamp;

        private Instant startTimestamp;

        private Instant completedTimestamp;

        private String error;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAddressListImportJobResponse model) {
            super(model);
            jobId(model.jobId);
            name(model.name);
            status(model.status);
            preSignedUrl(model.preSignedUrl);
            importedItemsCount(model.importedItemsCount);
            failedItemsCount(model.failedItemsCount);
            importDataFormat(model.importDataFormat);
            addressListId(model.addressListId);
            createdTimestamp(model.createdTimestamp);
            startTimestamp(model.startTimestamp);
            completedTimestamp(model.completedTimestamp);
            error(model.error);
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ImportJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getPreSignedUrl() {
            return preSignedUrl;
        }

        public final void setPreSignedUrl(String preSignedUrl) {
            this.preSignedUrl = preSignedUrl;
        }

        @Override
        public final Builder preSignedUrl(String preSignedUrl) {
            this.preSignedUrl = preSignedUrl;
            return this;
        }

        public final Integer getImportedItemsCount() {
            return importedItemsCount;
        }

        public final void setImportedItemsCount(Integer importedItemsCount) {
            this.importedItemsCount = importedItemsCount;
        }

        @Override
        public final Builder importedItemsCount(Integer importedItemsCount) {
            this.importedItemsCount = importedItemsCount;
            return this;
        }

        public final Integer getFailedItemsCount() {
            return failedItemsCount;
        }

        public final void setFailedItemsCount(Integer failedItemsCount) {
            this.failedItemsCount = failedItemsCount;
        }

        @Override
        public final Builder failedItemsCount(Integer failedItemsCount) {
            this.failedItemsCount = failedItemsCount;
            return this;
        }

        public final ImportDataFormat.Builder getImportDataFormat() {
            return importDataFormat != null ? importDataFormat.toBuilder() : null;
        }

        public final void setImportDataFormat(ImportDataFormat.BuilderImpl importDataFormat) {
            this.importDataFormat = importDataFormat != null ? importDataFormat.build() : null;
        }

        @Override
        public final Builder importDataFormat(ImportDataFormat importDataFormat) {
            this.importDataFormat = importDataFormat;
            return this;
        }

        public final String getAddressListId() {
            return addressListId;
        }

        public final void setAddressListId(String addressListId) {
            this.addressListId = addressListId;
        }

        @Override
        public final Builder addressListId(String addressListId) {
            this.addressListId = addressListId;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getStartTimestamp() {
            return startTimestamp;
        }

        public final void setStartTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
        }

        @Override
        public final Builder startTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
            return this;
        }

        public final Instant getCompletedTimestamp() {
            return completedTimestamp;
        }

        public final void setCompletedTimestamp(Instant completedTimestamp) {
            this.completedTimestamp = completedTimestamp;
        }

        @Override
        public final Builder completedTimestamp(Instant completedTimestamp) {
            this.completedTimestamp = completedTimestamp;
            return this;
        }

        public final String getError() {
            return error;
        }

        public final void setError(String error) {
            this.error = error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        @Override
        public GetAddressListImportJobResponse build() {
            return new GetAddressListImportJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
