/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response containing search results from a completed archive search.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetArchiveSearchResultsResponse extends MailManagerResponse implements
        ToCopyableBuilder<GetArchiveSearchResultsResponse.Builder, GetArchiveSearchResultsResponse> {
    private static final SdkField<List<Row>> ROWS_FIELD = SdkField
            .<List<Row>> builder(MarshallingType.LIST)
            .memberName("Rows")
            .getter(getter(GetArchiveSearchResultsResponse::rows))
            .setter(setter(Builder::rows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rows").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Row> builder(MarshallingType.SDK_POJO)
                                            .constructor(Row::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROWS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<Row> rows;

    private GetArchiveSearchResultsResponse(BuilderImpl builder) {
        super(builder);
        this.rows = builder.rows;
    }

    /**
     * For responses, this returns true if the service returned a value for the Rows property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasRows() {
        return rows != null && !(rows instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of email result objects matching the search criteria.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRows} method.
     * </p>
     * 
     * @return The list of email result objects matching the search criteria.
     */
    public final List<Row> rows() {
        return rows;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRows() ? rows() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetArchiveSearchResultsResponse)) {
            return false;
        }
        GetArchiveSearchResultsResponse other = (GetArchiveSearchResultsResponse) obj;
        return hasRows() == other.hasRows() && Objects.equals(rows(), other.rows());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetArchiveSearchResultsResponse").add("Rows", hasRows() ? rows() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Rows":
            return Optional.ofNullable(clazz.cast(rows()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Rows", ROWS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetArchiveSearchResultsResponse, T> g) {
        return obj -> g.apply((GetArchiveSearchResultsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MailManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetArchiveSearchResultsResponse> {
        /**
         * <p>
         * The list of email result objects matching the search criteria.
         * </p>
         * 
         * @param rows
         *        The list of email result objects matching the search criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rows(Collection<Row> rows);

        /**
         * <p>
         * The list of email result objects matching the search criteria.
         * </p>
         * 
         * @param rows
         *        The list of email result objects matching the search criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rows(Row... rows);

        /**
         * <p>
         * The list of email result objects matching the search criteria.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mailmanager.model.Row.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.mailmanager.model.Row#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mailmanager.model.Row.Builder#build()} is called immediately and its
         * result is passed to {@link #rows(List<Row>)}.
         * 
         * @param rows
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mailmanager.model.Row.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rows(java.util.Collection<Row>)
         */
        Builder rows(Consumer<Row.Builder>... rows);
    }

    static final class BuilderImpl extends MailManagerResponse.BuilderImpl implements Builder {
        private List<Row> rows = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetArchiveSearchResultsResponse model) {
            super(model);
            rows(model.rows);
        }

        public final List<Row.Builder> getRows() {
            List<Row.Builder> result = RowsListCopier.copyToBuilder(this.rows);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRows(Collection<Row.BuilderImpl> rows) {
            this.rows = RowsListCopier.copyFromBuilder(rows);
        }

        @Override
        public final Builder rows(Collection<Row> rows) {
            this.rows = RowsListCopier.copy(rows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rows(Row... rows) {
            rows(Arrays.asList(rows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rows(Consumer<Row.Builder>... rows) {
            rows(Stream.of(rows).map(c -> Row.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetArchiveSearchResultsResponse build() {
            return new GetArchiveSearchResultsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
