/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMembersOfAddressListResponse extends MailManagerResponse implements
        ToCopyableBuilder<ListMembersOfAddressListResponse.Builder, ListMembersOfAddressListResponse> {
    private static final SdkField<List<SavedAddress>> ADDRESSES_FIELD = SdkField
            .<List<SavedAddress>> builder(MarshallingType.LIST)
            .memberName("Addresses")
            .getter(getter(ListMembersOfAddressListResponse::addresses))
            .setter(setter(Builder::addresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Addresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SavedAddress> builder(MarshallingType.SDK_POJO)
                                            .constructor(SavedAddress::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListMembersOfAddressListResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDRESSES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<SavedAddress> addresses;

    private final String nextToken;

    private ListMembersOfAddressListResponse(BuilderImpl builder) {
        super(builder);
        this.addresses = builder.addresses;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Addresses property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAddresses() {
        return addresses != null && !(addresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of addresses.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddresses} method.
     * </p>
     * 
     * @return The list of addresses.
     */
    public final List<SavedAddress> addresses() {
        return addresses;
    }

    /**
     * <p>
     * If NextToken is returned, there are more results available. The value of NextToken is a unique pagination token
     * for each page. Make the call again using the returned token to retrieve the next page.
     * </p>
     * 
     * @return If NextToken is returned, there are more results available. The value of NextToken is a unique pagination
     *         token for each page. Make the call again using the returned token to retrieve the next page.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAddresses() ? addresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMembersOfAddressListResponse)) {
            return false;
        }
        ListMembersOfAddressListResponse other = (ListMembersOfAddressListResponse) obj;
        return hasAddresses() == other.hasAddresses() && Objects.equals(addresses(), other.addresses())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListMembersOfAddressListResponse").add("Addresses", hasAddresses() ? addresses() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Addresses":
            return Optional.ofNullable(clazz.cast(addresses()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Addresses", ADDRESSES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListMembersOfAddressListResponse, T> g) {
        return obj -> g.apply((ListMembersOfAddressListResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MailManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListMembersOfAddressListResponse> {
        /**
         * <p>
         * The list of addresses.
         * </p>
         * 
         * @param addresses
         *        The list of addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addresses(Collection<SavedAddress> addresses);

        /**
         * <p>
         * The list of addresses.
         * </p>
         * 
         * @param addresses
         *        The list of addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addresses(SavedAddress... addresses);

        /**
         * <p>
         * The list of addresses.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mailmanager.model.SavedAddress.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.mailmanager.model.SavedAddress#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mailmanager.model.SavedAddress.Builder#build()} is called immediately
         * and its result is passed to {@link #addresses(List<SavedAddress>)}.
         * 
         * @param addresses
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mailmanager.model.SavedAddress.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addresses(java.util.Collection<SavedAddress>)
         */
        Builder addresses(Consumer<SavedAddress.Builder>... addresses);

        /**
         * <p>
         * If NextToken is returned, there are more results available. The value of NextToken is a unique pagination
         * token for each page. Make the call again using the returned token to retrieve the next page.
         * </p>
         * 
         * @param nextToken
         *        If NextToken is returned, there are more results available. The value of NextToken is a unique
         *        pagination token for each page. Make the call again using the returned token to retrieve the next
         *        page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends MailManagerResponse.BuilderImpl implements Builder {
        private List<SavedAddress> addresses = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMembersOfAddressListResponse model) {
            super(model);
            addresses(model.addresses);
            nextToken(model.nextToken);
        }

        public final List<SavedAddress.Builder> getAddresses() {
            List<SavedAddress.Builder> result = SavedAddressesCopier.copyToBuilder(this.addresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddresses(Collection<SavedAddress.BuilderImpl> addresses) {
            this.addresses = SavedAddressesCopier.copyFromBuilder(addresses);
        }

        @Override
        public final Builder addresses(Collection<SavedAddress> addresses) {
            this.addresses = SavedAddressesCopier.copy(addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addresses(SavedAddress... addresses) {
            addresses(Arrays.asList(addresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addresses(Consumer<SavedAddress.Builder>... addresses) {
            addresses(Stream.of(addresses).map(c -> SavedAddress.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListMembersOfAddressListResponse build() {
            return new ListMembersOfAddressListResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
