/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The metadata about the email.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Metadata implements SdkPojo, Serializable, ToCopyableBuilder<Metadata.Builder, Metadata> {
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("Timestamp").getter(getter(Metadata::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()).build();

    private static final SdkField<String> INGRESS_POINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IngressPointId").getter(getter(Metadata::ingressPointId)).setter(setter(Builder::ingressPointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngressPointId").build()).build();

    private static final SdkField<String> TRAFFIC_POLICY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrafficPolicyId").getter(getter(Metadata::trafficPolicyId)).setter(setter(Builder::trafficPolicyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficPolicyId").build()).build();

    private static final SdkField<String> RULE_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleSetId").getter(getter(Metadata::ruleSetId)).setter(setter(Builder::ruleSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleSetId").build()).build();

    private static final SdkField<String> SENDER_HOSTNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SenderHostname").getter(getter(Metadata::senderHostname)).setter(setter(Builder::senderHostname))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SenderHostname").build()).build();

    private static final SdkField<String> SENDER_IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SenderIpAddress").getter(getter(Metadata::senderIpAddress)).setter(setter(Builder::senderIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SenderIpAddress").build()).build();

    private static final SdkField<String> TLS_CIPHER_SUITE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TlsCipherSuite").getter(getter(Metadata::tlsCipherSuite)).setter(setter(Builder::tlsCipherSuite))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TlsCipherSuite").build()).build();

    private static final SdkField<String> TLS_PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TlsProtocol").getter(getter(Metadata::tlsProtocol)).setter(setter(Builder::tlsProtocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TlsProtocol").build()).build();

    private static final SdkField<String> SENDING_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SendingMethod").getter(getter(Metadata::sendingMethod)).setter(setter(Builder::sendingMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SendingMethod").build()).build();

    private static final SdkField<String> SOURCE_IDENTITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceIdentity").getter(getter(Metadata::sourceIdentity)).setter(setter(Builder::sourceIdentity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceIdentity").build()).build();

    private static final SdkField<String> SENDING_POOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SendingPool").getter(getter(Metadata::sendingPool)).setter(setter(Builder::sendingPool))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SendingPool").build()).build();

    private static final SdkField<String> CONFIGURATION_SET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationSet").getter(getter(Metadata::configurationSet)).setter(setter(Builder::configurationSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSet").build()).build();

    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceArn").getter(getter(Metadata::sourceArn)).setter(setter(Builder::sourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMESTAMP_FIELD,
            INGRESS_POINT_ID_FIELD, TRAFFIC_POLICY_ID_FIELD, RULE_SET_ID_FIELD, SENDER_HOSTNAME_FIELD, SENDER_IP_ADDRESS_FIELD,
            TLS_CIPHER_SUITE_FIELD, TLS_PROTOCOL_FIELD, SENDING_METHOD_FIELD, SOURCE_IDENTITY_FIELD, SENDING_POOL_FIELD,
            CONFIGURATION_SET_FIELD, SOURCE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant timestamp;

    private final String ingressPointId;

    private final String trafficPolicyId;

    private final String ruleSetId;

    private final String senderHostname;

    private final String senderIpAddress;

    private final String tlsCipherSuite;

    private final String tlsProtocol;

    private final String sendingMethod;

    private final String sourceIdentity;

    private final String sendingPool;

    private final String configurationSet;

    private final String sourceArn;

    private Metadata(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.ingressPointId = builder.ingressPointId;
        this.trafficPolicyId = builder.trafficPolicyId;
        this.ruleSetId = builder.ruleSetId;
        this.senderHostname = builder.senderHostname;
        this.senderIpAddress = builder.senderIpAddress;
        this.tlsCipherSuite = builder.tlsCipherSuite;
        this.tlsProtocol = builder.tlsProtocol;
        this.sendingMethod = builder.sendingMethod;
        this.sourceIdentity = builder.sourceIdentity;
        this.sendingPool = builder.sendingPool;
        this.configurationSet = builder.configurationSet;
        this.sourceArn = builder.sourceArn;
    }

    /**
     * <p>
     * The timestamp of when the email was received.
     * </p>
     * 
     * @return The timestamp of when the email was received.
     */
    public final Instant timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * The ID of the ingress endpoint through which the email was received.
     * </p>
     * 
     * @return The ID of the ingress endpoint through which the email was received.
     */
    public final String ingressPointId() {
        return ingressPointId;
    }

    /**
     * <p>
     * The ID of the traffic policy that was in effect when the email was received.
     * </p>
     * 
     * @return The ID of the traffic policy that was in effect when the email was received.
     */
    public final String trafficPolicyId() {
        return trafficPolicyId;
    }

    /**
     * <p>
     * The ID of the rule set that processed the email.
     * </p>
     * 
     * @return The ID of the rule set that processed the email.
     */
    public final String ruleSetId() {
        return ruleSetId;
    }

    /**
     * <p>
     * The name of the host from which the email was received.
     * </p>
     * 
     * @return The name of the host from which the email was received.
     */
    public final String senderHostname() {
        return senderHostname;
    }

    /**
     * <p>
     * The IP address of the host from which the email was received.
     * </p>
     * 
     * @return The IP address of the host from which the email was received.
     */
    public final String senderIpAddress() {
        return senderIpAddress;
    }

    /**
     * <p>
     * The TLS cipher suite used to communicate with the host from which the email was received.
     * </p>
     * 
     * @return The TLS cipher suite used to communicate with the host from which the email was received.
     */
    public final String tlsCipherSuite() {
        return tlsCipherSuite;
    }

    /**
     * <p>
     * The TLS protocol used to communicate with the host from which the email was received.
     * </p>
     * 
     * @return The TLS protocol used to communicate with the host from which the email was received.
     */
    public final String tlsProtocol() {
        return tlsProtocol;
    }

    /**
     * <p>
     * The name of the API call used when sent through a configuration set with archiving enabled.
     * </p>
     * 
     * @return The name of the API call used when sent through a configuration set with archiving enabled.
     */
    public final String sendingMethod() {
        return sendingMethod;
    }

    /**
     * <p>
     * The identity name used to authorize the sending action when sent through a configuration set with archiving
     * enabled.
     * </p>
     * 
     * @return The identity name used to authorize the sending action when sent through a configuration set with
     *         archiving enabled.
     */
    public final String sourceIdentity() {
        return sourceIdentity;
    }

    /**
     * <p>
     * The name of the dedicated IP pool used when sent through a configuration set with archiving enabled.
     * </p>
     * 
     * @return The name of the dedicated IP pool used when sent through a configuration set with archiving enabled.
     */
    public final String sendingPool() {
        return sendingPool;
    }

    /**
     * <p>
     * The name of the configuration set used when sent through a configuration set with archiving enabled.
     * </p>
     * 
     * @return The name of the configuration set used when sent through a configuration set with archiving enabled.
     */
    public final String configurationSet() {
        return configurationSet;
    }

    /**
     * <p>
     * Specifies the archived email source, identified by either a Rule Set's ARN with an Archive action, or a
     * Configuration Set's Archive ARN.
     * </p>
     * 
     * @return Specifies the archived email source, identified by either a Rule Set's ARN with an Archive action, or a
     *         Configuration Set's Archive ARN.
     */
    public final String sourceArn() {
        return sourceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(ingressPointId());
        hashCode = 31 * hashCode + Objects.hashCode(trafficPolicyId());
        hashCode = 31 * hashCode + Objects.hashCode(ruleSetId());
        hashCode = 31 * hashCode + Objects.hashCode(senderHostname());
        hashCode = 31 * hashCode + Objects.hashCode(senderIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(tlsCipherSuite());
        hashCode = 31 * hashCode + Objects.hashCode(tlsProtocol());
        hashCode = 31 * hashCode + Objects.hashCode(sendingMethod());
        hashCode = 31 * hashCode + Objects.hashCode(sourceIdentity());
        hashCode = 31 * hashCode + Objects.hashCode(sendingPool());
        hashCode = 31 * hashCode + Objects.hashCode(configurationSet());
        hashCode = 31 * hashCode + Objects.hashCode(sourceArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Metadata)) {
            return false;
        }
        Metadata other = (Metadata) obj;
        return Objects.equals(timestamp(), other.timestamp()) && Objects.equals(ingressPointId(), other.ingressPointId())
                && Objects.equals(trafficPolicyId(), other.trafficPolicyId()) && Objects.equals(ruleSetId(), other.ruleSetId())
                && Objects.equals(senderHostname(), other.senderHostname())
                && Objects.equals(senderIpAddress(), other.senderIpAddress())
                && Objects.equals(tlsCipherSuite(), other.tlsCipherSuite()) && Objects.equals(tlsProtocol(), other.tlsProtocol())
                && Objects.equals(sendingMethod(), other.sendingMethod())
                && Objects.equals(sourceIdentity(), other.sourceIdentity()) && Objects.equals(sendingPool(), other.sendingPool())
                && Objects.equals(configurationSet(), other.configurationSet()) && Objects.equals(sourceArn(), other.sourceArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Metadata").add("Timestamp", timestamp()).add("IngressPointId", ingressPointId())
                .add("TrafficPolicyId", trafficPolicyId()).add("RuleSetId", ruleSetId()).add("SenderHostname", senderHostname())
                .add("SenderIpAddress", senderIpAddress() == null ? null : "*** Sensitive Data Redacted ***")
                .add("TlsCipherSuite", tlsCipherSuite()).add("TlsProtocol", tlsProtocol()).add("SendingMethod", sendingMethod())
                .add("SourceIdentity", sourceIdentity()).add("SendingPool", sendingPool())
                .add("ConfigurationSet", configurationSet()).add("SourceArn", sourceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "IngressPointId":
            return Optional.ofNullable(clazz.cast(ingressPointId()));
        case "TrafficPolicyId":
            return Optional.ofNullable(clazz.cast(trafficPolicyId()));
        case "RuleSetId":
            return Optional.ofNullable(clazz.cast(ruleSetId()));
        case "SenderHostname":
            return Optional.ofNullable(clazz.cast(senderHostname()));
        case "SenderIpAddress":
            return Optional.ofNullable(clazz.cast(senderIpAddress()));
        case "TlsCipherSuite":
            return Optional.ofNullable(clazz.cast(tlsCipherSuite()));
        case "TlsProtocol":
            return Optional.ofNullable(clazz.cast(tlsProtocol()));
        case "SendingMethod":
            return Optional.ofNullable(clazz.cast(sendingMethod()));
        case "SourceIdentity":
            return Optional.ofNullable(clazz.cast(sourceIdentity()));
        case "SendingPool":
            return Optional.ofNullable(clazz.cast(sendingPool()));
        case "ConfigurationSet":
            return Optional.ofNullable(clazz.cast(configurationSet()));
        case "SourceArn":
            return Optional.ofNullable(clazz.cast(sourceArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Timestamp", TIMESTAMP_FIELD);
        map.put("IngressPointId", INGRESS_POINT_ID_FIELD);
        map.put("TrafficPolicyId", TRAFFIC_POLICY_ID_FIELD);
        map.put("RuleSetId", RULE_SET_ID_FIELD);
        map.put("SenderHostname", SENDER_HOSTNAME_FIELD);
        map.put("SenderIpAddress", SENDER_IP_ADDRESS_FIELD);
        map.put("TlsCipherSuite", TLS_CIPHER_SUITE_FIELD);
        map.put("TlsProtocol", TLS_PROTOCOL_FIELD);
        map.put("SendingMethod", SENDING_METHOD_FIELD);
        map.put("SourceIdentity", SOURCE_IDENTITY_FIELD);
        map.put("SendingPool", SENDING_POOL_FIELD);
        map.put("ConfigurationSet", CONFIGURATION_SET_FIELD);
        map.put("SourceArn", SOURCE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Metadata, T> g) {
        return obj -> g.apply((Metadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Metadata> {
        /**
         * <p>
         * The timestamp of when the email was received.
         * </p>
         * 
         * @param timestamp
         *        The timestamp of when the email was received.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);

        /**
         * <p>
         * The ID of the ingress endpoint through which the email was received.
         * </p>
         * 
         * @param ingressPointId
         *        The ID of the ingress endpoint through which the email was received.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingressPointId(String ingressPointId);

        /**
         * <p>
         * The ID of the traffic policy that was in effect when the email was received.
         * </p>
         * 
         * @param trafficPolicyId
         *        The ID of the traffic policy that was in effect when the email was received.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicyId(String trafficPolicyId);

        /**
         * <p>
         * The ID of the rule set that processed the email.
         * </p>
         * 
         * @param ruleSetId
         *        The ID of the rule set that processed the email.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleSetId(String ruleSetId);

        /**
         * <p>
         * The name of the host from which the email was received.
         * </p>
         * 
         * @param senderHostname
         *        The name of the host from which the email was received.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder senderHostname(String senderHostname);

        /**
         * <p>
         * The IP address of the host from which the email was received.
         * </p>
         * 
         * @param senderIpAddress
         *        The IP address of the host from which the email was received.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder senderIpAddress(String senderIpAddress);

        /**
         * <p>
         * The TLS cipher suite used to communicate with the host from which the email was received.
         * </p>
         * 
         * @param tlsCipherSuite
         *        The TLS cipher suite used to communicate with the host from which the email was received.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tlsCipherSuite(String tlsCipherSuite);

        /**
         * <p>
         * The TLS protocol used to communicate with the host from which the email was received.
         * </p>
         * 
         * @param tlsProtocol
         *        The TLS protocol used to communicate with the host from which the email was received.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tlsProtocol(String tlsProtocol);

        /**
         * <p>
         * The name of the API call used when sent through a configuration set with archiving enabled.
         * </p>
         * 
         * @param sendingMethod
         *        The name of the API call used when sent through a configuration set with archiving enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sendingMethod(String sendingMethod);

        /**
         * <p>
         * The identity name used to authorize the sending action when sent through a configuration set with archiving
         * enabled.
         * </p>
         * 
         * @param sourceIdentity
         *        The identity name used to authorize the sending action when sent through a configuration set with
         *        archiving enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceIdentity(String sourceIdentity);

        /**
         * <p>
         * The name of the dedicated IP pool used when sent through a configuration set with archiving enabled.
         * </p>
         * 
         * @param sendingPool
         *        The name of the dedicated IP pool used when sent through a configuration set with archiving enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sendingPool(String sendingPool);

        /**
         * <p>
         * The name of the configuration set used when sent through a configuration set with archiving enabled.
         * </p>
         * 
         * @param configurationSet
         *        The name of the configuration set used when sent through a configuration set with archiving enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSet(String configurationSet);

        /**
         * <p>
         * Specifies the archived email source, identified by either a Rule Set's ARN with an Archive action, or a
         * Configuration Set's Archive ARN.
         * </p>
         * 
         * @param sourceArn
         *        Specifies the archived email source, identified by either a Rule Set's ARN with an Archive action, or
         *        a Configuration Set's Archive ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceArn(String sourceArn);
    }

    static final class BuilderImpl implements Builder {
        private Instant timestamp;

        private String ingressPointId;

        private String trafficPolicyId;

        private String ruleSetId;

        private String senderHostname;

        private String senderIpAddress;

        private String tlsCipherSuite;

        private String tlsProtocol;

        private String sendingMethod;

        private String sourceIdentity;

        private String sendingPool;

        private String configurationSet;

        private String sourceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Metadata model) {
            timestamp(model.timestamp);
            ingressPointId(model.ingressPointId);
            trafficPolicyId(model.trafficPolicyId);
            ruleSetId(model.ruleSetId);
            senderHostname(model.senderHostname);
            senderIpAddress(model.senderIpAddress);
            tlsCipherSuite(model.tlsCipherSuite);
            tlsProtocol(model.tlsProtocol);
            sendingMethod(model.sendingMethod);
            sourceIdentity(model.sourceIdentity);
            sendingPool(model.sendingPool);
            configurationSet(model.configurationSet);
            sourceArn(model.sourceArn);
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final String getIngressPointId() {
            return ingressPointId;
        }

        public final void setIngressPointId(String ingressPointId) {
            this.ingressPointId = ingressPointId;
        }

        @Override
        public final Builder ingressPointId(String ingressPointId) {
            this.ingressPointId = ingressPointId;
            return this;
        }

        public final String getTrafficPolicyId() {
            return trafficPolicyId;
        }

        public final void setTrafficPolicyId(String trafficPolicyId) {
            this.trafficPolicyId = trafficPolicyId;
        }

        @Override
        public final Builder trafficPolicyId(String trafficPolicyId) {
            this.trafficPolicyId = trafficPolicyId;
            return this;
        }

        public final String getRuleSetId() {
            return ruleSetId;
        }

        public final void setRuleSetId(String ruleSetId) {
            this.ruleSetId = ruleSetId;
        }

        @Override
        public final Builder ruleSetId(String ruleSetId) {
            this.ruleSetId = ruleSetId;
            return this;
        }

        public final String getSenderHostname() {
            return senderHostname;
        }

        public final void setSenderHostname(String senderHostname) {
            this.senderHostname = senderHostname;
        }

        @Override
        public final Builder senderHostname(String senderHostname) {
            this.senderHostname = senderHostname;
            return this;
        }

        public final String getSenderIpAddress() {
            return senderIpAddress;
        }

        public final void setSenderIpAddress(String senderIpAddress) {
            this.senderIpAddress = senderIpAddress;
        }

        @Override
        public final Builder senderIpAddress(String senderIpAddress) {
            this.senderIpAddress = senderIpAddress;
            return this;
        }

        public final String getTlsCipherSuite() {
            return tlsCipherSuite;
        }

        public final void setTlsCipherSuite(String tlsCipherSuite) {
            this.tlsCipherSuite = tlsCipherSuite;
        }

        @Override
        public final Builder tlsCipherSuite(String tlsCipherSuite) {
            this.tlsCipherSuite = tlsCipherSuite;
            return this;
        }

        public final String getTlsProtocol() {
            return tlsProtocol;
        }

        public final void setTlsProtocol(String tlsProtocol) {
            this.tlsProtocol = tlsProtocol;
        }

        @Override
        public final Builder tlsProtocol(String tlsProtocol) {
            this.tlsProtocol = tlsProtocol;
            return this;
        }

        public final String getSendingMethod() {
            return sendingMethod;
        }

        public final void setSendingMethod(String sendingMethod) {
            this.sendingMethod = sendingMethod;
        }

        @Override
        public final Builder sendingMethod(String sendingMethod) {
            this.sendingMethod = sendingMethod;
            return this;
        }

        public final String getSourceIdentity() {
            return sourceIdentity;
        }

        public final void setSourceIdentity(String sourceIdentity) {
            this.sourceIdentity = sourceIdentity;
        }

        @Override
        public final Builder sourceIdentity(String sourceIdentity) {
            this.sourceIdentity = sourceIdentity;
            return this;
        }

        public final String getSendingPool() {
            return sendingPool;
        }

        public final void setSendingPool(String sendingPool) {
            this.sendingPool = sendingPool;
        }

        @Override
        public final Builder sendingPool(String sendingPool) {
            this.sendingPool = sendingPool;
            return this;
        }

        public final String getConfigurationSet() {
            return configurationSet;
        }

        public final void setConfigurationSet(String configurationSet) {
            this.configurationSet = configurationSet;
        }

        @Override
        public final Builder configurationSet(String configurationSet) {
            this.configurationSet = configurationSet;
            return this;
        }

        public final String getSourceArn() {
            return sourceArn;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        @Override
        public Metadata build() {
            return new Metadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
