/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The network type (IPv4-only, Dual-Stack, PrivateLink) of the ingress endpoint resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<NetworkConfiguration.Builder, NetworkConfiguration> {
    private static final SdkField<PublicNetworkConfiguration> PUBLIC_NETWORK_CONFIGURATION_FIELD = SdkField
            .<PublicNetworkConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("PublicNetworkConfiguration")
            .getter(getter(NetworkConfiguration::publicNetworkConfiguration))
            .setter(setter(Builder::publicNetworkConfiguration))
            .constructor(PublicNetworkConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicNetworkConfiguration").build())
            .build();

    private static final SdkField<PrivateNetworkConfiguration> PRIVATE_NETWORK_CONFIGURATION_FIELD = SdkField
            .<PrivateNetworkConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("PrivateNetworkConfiguration")
            .getter(getter(NetworkConfiguration::privateNetworkConfiguration))
            .setter(setter(Builder::privateNetworkConfiguration))
            .constructor(PrivateNetworkConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateNetworkConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PUBLIC_NETWORK_CONFIGURATION_FIELD, PRIVATE_NETWORK_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final PublicNetworkConfiguration publicNetworkConfiguration;

    private final PrivateNetworkConfiguration privateNetworkConfiguration;

    private final Type type;

    private NetworkConfiguration(BuilderImpl builder) {
        this.publicNetworkConfiguration = builder.publicNetworkConfiguration;
        this.privateNetworkConfiguration = builder.privateNetworkConfiguration;
        this.type = builder.type;
    }

    /**
     * <p>
     * Specifies the network configuration for the public ingress point.
     * </p>
     * 
     * @return Specifies the network configuration for the public ingress point.
     */
    public final PublicNetworkConfiguration publicNetworkConfiguration() {
        return publicNetworkConfiguration;
    }

    /**
     * <p>
     * Specifies the network configuration for the private ingress point.
     * </p>
     * 
     * @return Specifies the network configuration for the private ingress point.
     */
    public final PrivateNetworkConfiguration privateNetworkConfiguration() {
        return privateNetworkConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(publicNetworkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(privateNetworkConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkConfiguration)) {
            return false;
        }
        NetworkConfiguration other = (NetworkConfiguration) obj;
        return Objects.equals(publicNetworkConfiguration(), other.publicNetworkConfiguration())
                && Objects.equals(privateNetworkConfiguration(), other.privateNetworkConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkConfiguration").add("PublicNetworkConfiguration", publicNetworkConfiguration())
                .add("PrivateNetworkConfiguration", privateNetworkConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PublicNetworkConfiguration":
            return Optional.ofNullable(clazz.cast(publicNetworkConfiguration()));
        case "PrivateNetworkConfiguration":
            return Optional.ofNullable(clazz.cast(privateNetworkConfiguration()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #publicNetworkConfiguration()} initialized to the given value.
     *
     * <p>
     * Specifies the network configuration for the public ingress point.
     * </p>
     * 
     * @param publicNetworkConfiguration
     *        Specifies the network configuration for the public ingress point.
     */
    public static NetworkConfiguration fromPublicNetworkConfiguration(PublicNetworkConfiguration publicNetworkConfiguration) {
        return builder().publicNetworkConfiguration(publicNetworkConfiguration).build();
    }

    /**
     * Create an instance of this class with {@link #publicNetworkConfiguration()} initialized to the given value.
     *
     * <p>
     * Specifies the network configuration for the public ingress point.
     * </p>
     * 
     * @param publicNetworkConfiguration
     *        Specifies the network configuration for the public ingress point.
     */
    public static NetworkConfiguration fromPublicNetworkConfiguration(
            Consumer<PublicNetworkConfiguration.Builder> publicNetworkConfiguration) {
        PublicNetworkConfiguration.Builder builder = PublicNetworkConfiguration.builder();
        publicNetworkConfiguration.accept(builder);
        return fromPublicNetworkConfiguration(builder.build());
    }

    /**
     * Create an instance of this class with {@link #privateNetworkConfiguration()} initialized to the given value.
     *
     * <p>
     * Specifies the network configuration for the private ingress point.
     * </p>
     * 
     * @param privateNetworkConfiguration
     *        Specifies the network configuration for the private ingress point.
     */
    public static NetworkConfiguration fromPrivateNetworkConfiguration(PrivateNetworkConfiguration privateNetworkConfiguration) {
        return builder().privateNetworkConfiguration(privateNetworkConfiguration).build();
    }

    /**
     * Create an instance of this class with {@link #privateNetworkConfiguration()} initialized to the given value.
     *
     * <p>
     * Specifies the network configuration for the private ingress point.
     * </p>
     * 
     * @param privateNetworkConfiguration
     *        Specifies the network configuration for the private ingress point.
     */
    public static NetworkConfiguration fromPrivateNetworkConfiguration(
            Consumer<PrivateNetworkConfiguration.Builder> privateNetworkConfiguration) {
        PrivateNetworkConfiguration.Builder builder = PrivateNetworkConfiguration.builder();
        privateNetworkConfiguration.accept(builder);
        return fromPrivateNetworkConfiguration(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PublicNetworkConfiguration", PUBLIC_NETWORK_CONFIGURATION_FIELD);
        map.put("PrivateNetworkConfiguration", PRIVATE_NETWORK_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NetworkConfiguration, T> g) {
        return obj -> g.apply((NetworkConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkConfiguration> {
        /**
         * <p>
         * Specifies the network configuration for the public ingress point.
         * </p>
         * 
         * @param publicNetworkConfiguration
         *        Specifies the network configuration for the public ingress point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicNetworkConfiguration(PublicNetworkConfiguration publicNetworkConfiguration);

        /**
         * <p>
         * Specifies the network configuration for the public ingress point.
         * </p>
         * This is a convenience method that creates an instance of the {@link PublicNetworkConfiguration.Builder}
         * avoiding the need to create one manually via {@link PublicNetworkConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PublicNetworkConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #publicNetworkConfiguration(PublicNetworkConfiguration)}.
         * 
         * @param publicNetworkConfiguration
         *        a consumer that will call methods on {@link PublicNetworkConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #publicNetworkConfiguration(PublicNetworkConfiguration)
         */
        default Builder publicNetworkConfiguration(Consumer<PublicNetworkConfiguration.Builder> publicNetworkConfiguration) {
            return publicNetworkConfiguration(PublicNetworkConfiguration.builder().applyMutation(publicNetworkConfiguration)
                    .build());
        }

        /**
         * <p>
         * Specifies the network configuration for the private ingress point.
         * </p>
         * 
         * @param privateNetworkConfiguration
         *        Specifies the network configuration for the private ingress point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateNetworkConfiguration(PrivateNetworkConfiguration privateNetworkConfiguration);

        /**
         * <p>
         * Specifies the network configuration for the private ingress point.
         * </p>
         * This is a convenience method that creates an instance of the {@link PrivateNetworkConfiguration.Builder}
         * avoiding the need to create one manually via {@link PrivateNetworkConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PrivateNetworkConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #privateNetworkConfiguration(PrivateNetworkConfiguration)}.
         * 
         * @param privateNetworkConfiguration
         *        a consumer that will call methods on {@link PrivateNetworkConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #privateNetworkConfiguration(PrivateNetworkConfiguration)
         */
        default Builder privateNetworkConfiguration(Consumer<PrivateNetworkConfiguration.Builder> privateNetworkConfiguration) {
            return privateNetworkConfiguration(PrivateNetworkConfiguration.builder().applyMutation(privateNetworkConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private PublicNetworkConfiguration publicNetworkConfiguration;

        private PrivateNetworkConfiguration privateNetworkConfiguration;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkConfiguration model) {
            publicNetworkConfiguration(model.publicNetworkConfiguration);
            privateNetworkConfiguration(model.privateNetworkConfiguration);
        }

        public final PublicNetworkConfiguration.Builder getPublicNetworkConfiguration() {
            return publicNetworkConfiguration != null ? publicNetworkConfiguration.toBuilder() : null;
        }

        public final void setPublicNetworkConfiguration(PublicNetworkConfiguration.BuilderImpl publicNetworkConfiguration) {
            Object oldValue = this.publicNetworkConfiguration;
            this.publicNetworkConfiguration = publicNetworkConfiguration != null ? publicNetworkConfiguration.build() : null;
            handleUnionValueChange(Type.PUBLIC_NETWORK_CONFIGURATION, oldValue, this.publicNetworkConfiguration);
        }

        @Override
        public final Builder publicNetworkConfiguration(PublicNetworkConfiguration publicNetworkConfiguration) {
            Object oldValue = this.publicNetworkConfiguration;
            this.publicNetworkConfiguration = publicNetworkConfiguration;
            handleUnionValueChange(Type.PUBLIC_NETWORK_CONFIGURATION, oldValue, this.publicNetworkConfiguration);
            return this;
        }

        public final PrivateNetworkConfiguration.Builder getPrivateNetworkConfiguration() {
            return privateNetworkConfiguration != null ? privateNetworkConfiguration.toBuilder() : null;
        }

        public final void setPrivateNetworkConfiguration(PrivateNetworkConfiguration.BuilderImpl privateNetworkConfiguration) {
            Object oldValue = this.privateNetworkConfiguration;
            this.privateNetworkConfiguration = privateNetworkConfiguration != null ? privateNetworkConfiguration.build() : null;
            handleUnionValueChange(Type.PRIVATE_NETWORK_CONFIGURATION, oldValue, this.privateNetworkConfiguration);
        }

        @Override
        public final Builder privateNetworkConfiguration(PrivateNetworkConfiguration privateNetworkConfiguration) {
            Object oldValue = this.privateNetworkConfiguration;
            this.privateNetworkConfiguration = privateNetworkConfiguration;
            handleUnionValueChange(Type.PRIVATE_NETWORK_CONFIGURATION, oldValue, this.privateNetworkConfiguration);
            return this;
        }

        @Override
        public NetworkConfiguration build() {
            return new NetworkConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see NetworkConfiguration#type()
     */
    public enum Type {
        PUBLIC_NETWORK_CONFIGURATION,

        PRIVATE_NETWORK_CONFIGURATION,

        UNKNOWN_TO_SDK_VERSION
    }
}
