/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the network configuration for the public ingress point.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PublicNetworkConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<PublicNetworkConfiguration.Builder, PublicNetworkConfiguration> {
    private static final SdkField<String> IP_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("IpType")
            .getter(getter(PublicNetworkConfiguration::ipTypeAsString)).setter(setter(Builder::ipType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String ipType;

    private PublicNetworkConfiguration(BuilderImpl builder) {
        this.ipType = builder.ipType;
    }

    /**
     * <p>
     * The IP address type for the public ingress point. Valid values are IPV4 and DUAL_STACK.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipType} will
     * return {@link IpType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipTypeAsString}.
     * </p>
     * 
     * @return The IP address type for the public ingress point. Valid values are IPV4 and DUAL_STACK.
     * @see IpType
     */
    public final IpType ipType() {
        return IpType.fromValue(ipType);
    }

    /**
     * <p>
     * The IP address type for the public ingress point. Valid values are IPV4 and DUAL_STACK.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipType} will
     * return {@link IpType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipTypeAsString}.
     * </p>
     * 
     * @return The IP address type for the public ingress point. Valid values are IPV4 and DUAL_STACK.
     * @see IpType
     */
    public final String ipTypeAsString() {
        return ipType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ipTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublicNetworkConfiguration)) {
            return false;
        }
        PublicNetworkConfiguration other = (PublicNetworkConfiguration) obj;
        return Objects.equals(ipTypeAsString(), other.ipTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PublicNetworkConfiguration").add("IpType", ipTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IpType":
            return Optional.ofNullable(clazz.cast(ipTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IpType", IP_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PublicNetworkConfiguration, T> g) {
        return obj -> g.apply((PublicNetworkConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PublicNetworkConfiguration> {
        /**
         * <p>
         * The IP address type for the public ingress point. Valid values are IPV4 and DUAL_STACK.
         * </p>
         * 
         * @param ipType
         *        The IP address type for the public ingress point. Valid values are IPV4 and DUAL_STACK.
         * @see IpType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpType
         */
        Builder ipType(String ipType);

        /**
         * <p>
         * The IP address type for the public ingress point. Valid values are IPV4 and DUAL_STACK.
         * </p>
         * 
         * @param ipType
         *        The IP address type for the public ingress point. Valid values are IPV4 and DUAL_STACK.
         * @see IpType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpType
         */
        Builder ipType(IpType ipType);
    }

    static final class BuilderImpl implements Builder {
        private String ipType;

        private BuilderImpl() {
        }

        private BuilderImpl(PublicNetworkConfiguration model) {
            ipType(model.ipType);
        }

        public final String getIpType() {
            return ipType;
        }

        public final void setIpType(String ipType) {
            this.ipType = ipType;
        }

        @Override
        public final Builder ipType(String ipType) {
            this.ipType = ipType;
            return this;
        }

        @Override
        public final Builder ipType(IpType ipType) {
            this.ipType(ipType == null ? null : ipType.toString());
            return this;
        }

        @Override
        public PublicNetworkConfiguration build() {
            return new PublicNetworkConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
