/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterMemberToAddressListRequest extends MailManagerRequest implements
        ToCopyableBuilder<RegisterMemberToAddressListRequest.Builder, RegisterMemberToAddressListRequest> {
    private static final SdkField<String> ADDRESS_LIST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AddressListId").getter(getter(RegisterMemberToAddressListRequest::addressListId))
            .setter(setter(Builder::addressListId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressListId").build()).build();

    private static final SdkField<String> ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Address")
            .getter(getter(RegisterMemberToAddressListRequest::address)).setter(setter(Builder::address))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDRESS_LIST_ID_FIELD,
            ADDRESS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String addressListId;

    private final String address;

    private RegisterMemberToAddressListRequest(BuilderImpl builder) {
        super(builder);
        this.addressListId = builder.addressListId;
        this.address = builder.address;
    }

    /**
     * <p>
     * The unique identifier of the address list where the address should be added.
     * </p>
     * 
     * @return The unique identifier of the address list where the address should be added.
     */
    public final String addressListId() {
        return addressListId;
    }

    /**
     * <p>
     * The address to be added to the address list.
     * </p>
     * 
     * @return The address to be added to the address list.
     */
    public final String address() {
        return address;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(addressListId());
        hashCode = 31 * hashCode + Objects.hashCode(address());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterMemberToAddressListRequest)) {
            return false;
        }
        RegisterMemberToAddressListRequest other = (RegisterMemberToAddressListRequest) obj;
        return Objects.equals(addressListId(), other.addressListId()) && Objects.equals(address(), other.address());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterMemberToAddressListRequest").add("AddressListId", addressListId())
                .add("Address", address() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AddressListId":
            return Optional.ofNullable(clazz.cast(addressListId()));
        case "Address":
            return Optional.ofNullable(clazz.cast(address()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AddressListId", ADDRESS_LIST_ID_FIELD);
        map.put("Address", ADDRESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegisterMemberToAddressListRequest, T> g) {
        return obj -> g.apply((RegisterMemberToAddressListRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MailManagerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, RegisterMemberToAddressListRequest> {
        /**
         * <p>
         * The unique identifier of the address list where the address should be added.
         * </p>
         * 
         * @param addressListId
         *        The unique identifier of the address list where the address should be added.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressListId(String addressListId);

        /**
         * <p>
         * The address to be added to the address list.
         * </p>
         * 
         * @param address
         *        The address to be added to the address list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder address(String address);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MailManagerRequest.BuilderImpl implements Builder {
        private String addressListId;

        private String address;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterMemberToAddressListRequest model) {
            super(model);
            addressListId(model.addressListId);
            address(model.address);
        }

        public final String getAddressListId() {
            return addressListId;
        }

        public final void setAddressListId(String addressListId) {
            this.addressListId = addressListId;
        }

        @Override
        public final Builder addressListId(String addressListId) {
            this.addressListId = addressListId;
            return this;
        }

        public final String getAddress() {
            return address;
        }

        public final void setAddress(String address) {
            this.address = address;
        }

        @Override
        public final Builder address(String address) {
            this.address = address;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterMemberToAddressListRequest build() {
            return new RegisterMemberToAddressListRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
