/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The action relays the email via SMTP to another specific SMTP server.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RelayAction implements SdkPojo, Serializable, ToCopyableBuilder<RelayAction.Builder, RelayAction> {
    private static final SdkField<String> ACTION_FAILURE_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActionFailurePolicy").getter(getter(RelayAction::actionFailurePolicyAsString))
            .setter(setter(Builder::actionFailurePolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionFailurePolicy").build())
            .build();

    private static final SdkField<String> RELAY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Relay")
            .getter(getter(RelayAction::relay)).setter(setter(Builder::relay))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Relay").build()).build();

    private static final SdkField<String> MAIL_FROM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MailFrom").getter(getter(RelayAction::mailFromAsString)).setter(setter(Builder::mailFrom))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MailFrom").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FAILURE_POLICY_FIELD,
            RELAY_FIELD, MAIL_FROM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String actionFailurePolicy;

    private final String relay;

    private final String mailFrom;

    private RelayAction(BuilderImpl builder) {
        this.actionFailurePolicy = builder.actionFailurePolicy;
        this.relay = builder.relay;
        this.mailFrom = builder.mailFrom;
    }

    /**
     * <p>
     * A policy that states what to do in the case of failure. The action will fail if there are configuration errors.
     * For example, the specified relay has been deleted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #actionFailurePolicy} will return {@link ActionFailurePolicy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #actionFailurePolicyAsString}.
     * </p>
     * 
     * @return A policy that states what to do in the case of failure. The action will fail if there are configuration
     *         errors. For example, the specified relay has been deleted.
     * @see ActionFailurePolicy
     */
    public final ActionFailurePolicy actionFailurePolicy() {
        return ActionFailurePolicy.fromValue(actionFailurePolicy);
    }

    /**
     * <p>
     * A policy that states what to do in the case of failure. The action will fail if there are configuration errors.
     * For example, the specified relay has been deleted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #actionFailurePolicy} will return {@link ActionFailurePolicy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #actionFailurePolicyAsString}.
     * </p>
     * 
     * @return A policy that states what to do in the case of failure. The action will fail if there are configuration
     *         errors. For example, the specified relay has been deleted.
     * @see ActionFailurePolicy
     */
    public final String actionFailurePolicyAsString() {
        return actionFailurePolicy;
    }

    /**
     * <p>
     * The identifier of the relay resource to be used when relaying an email.
     * </p>
     * 
     * @return The identifier of the relay resource to be used when relaying an email.
     */
    public final String relay() {
        return relay;
    }

    /**
     * <p>
     * This action specifies whether to preserve or replace original mail from address while relaying received emails to
     * a destination server.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mailFrom} will
     * return {@link MailFrom#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mailFromAsString}.
     * </p>
     * 
     * @return This action specifies whether to preserve or replace original mail from address while relaying received
     *         emails to a destination server.
     * @see MailFrom
     */
    public final MailFrom mailFrom() {
        return MailFrom.fromValue(mailFrom);
    }

    /**
     * <p>
     * This action specifies whether to preserve or replace original mail from address while relaying received emails to
     * a destination server.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mailFrom} will
     * return {@link MailFrom#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mailFromAsString}.
     * </p>
     * 
     * @return This action specifies whether to preserve or replace original mail from address while relaying received
     *         emails to a destination server.
     * @see MailFrom
     */
    public final String mailFromAsString() {
        return mailFrom;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionFailurePolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(relay());
        hashCode = 31 * hashCode + Objects.hashCode(mailFromAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelayAction)) {
            return false;
        }
        RelayAction other = (RelayAction) obj;
        return Objects.equals(actionFailurePolicyAsString(), other.actionFailurePolicyAsString())
                && Objects.equals(relay(), other.relay()) && Objects.equals(mailFromAsString(), other.mailFromAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RelayAction").add("ActionFailurePolicy", actionFailurePolicyAsString()).add("Relay", relay())
                .add("MailFrom", mailFromAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActionFailurePolicy":
            return Optional.ofNullable(clazz.cast(actionFailurePolicyAsString()));
        case "Relay":
            return Optional.ofNullable(clazz.cast(relay()));
        case "MailFrom":
            return Optional.ofNullable(clazz.cast(mailFromAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ActionFailurePolicy", ACTION_FAILURE_POLICY_FIELD);
        map.put("Relay", RELAY_FIELD);
        map.put("MailFrom", MAIL_FROM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RelayAction, T> g) {
        return obj -> g.apply((RelayAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RelayAction> {
        /**
         * <p>
         * A policy that states what to do in the case of failure. The action will fail if there are configuration
         * errors. For example, the specified relay has been deleted.
         * </p>
         * 
         * @param actionFailurePolicy
         *        A policy that states what to do in the case of failure. The action will fail if there are
         *        configuration errors. For example, the specified relay has been deleted.
         * @see ActionFailurePolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionFailurePolicy
         */
        Builder actionFailurePolicy(String actionFailurePolicy);

        /**
         * <p>
         * A policy that states what to do in the case of failure. The action will fail if there are configuration
         * errors. For example, the specified relay has been deleted.
         * </p>
         * 
         * @param actionFailurePolicy
         *        A policy that states what to do in the case of failure. The action will fail if there are
         *        configuration errors. For example, the specified relay has been deleted.
         * @see ActionFailurePolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionFailurePolicy
         */
        Builder actionFailurePolicy(ActionFailurePolicy actionFailurePolicy);

        /**
         * <p>
         * The identifier of the relay resource to be used when relaying an email.
         * </p>
         * 
         * @param relay
         *        The identifier of the relay resource to be used when relaying an email.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relay(String relay);

        /**
         * <p>
         * This action specifies whether to preserve or replace original mail from address while relaying received
         * emails to a destination server.
         * </p>
         * 
         * @param mailFrom
         *        This action specifies whether to preserve or replace original mail from address while relaying
         *        received emails to a destination server.
         * @see MailFrom
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MailFrom
         */
        Builder mailFrom(String mailFrom);

        /**
         * <p>
         * This action specifies whether to preserve or replace original mail from address while relaying received
         * emails to a destination server.
         * </p>
         * 
         * @param mailFrom
         *        This action specifies whether to preserve or replace original mail from address while relaying
         *        received emails to a destination server.
         * @see MailFrom
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MailFrom
         */
        Builder mailFrom(MailFrom mailFrom);
    }

    static final class BuilderImpl implements Builder {
        private String actionFailurePolicy;

        private String relay;

        private String mailFrom;

        private BuilderImpl() {
        }

        private BuilderImpl(RelayAction model) {
            actionFailurePolicy(model.actionFailurePolicy);
            relay(model.relay);
            mailFrom(model.mailFrom);
        }

        public final String getActionFailurePolicy() {
            return actionFailurePolicy;
        }

        public final void setActionFailurePolicy(String actionFailurePolicy) {
            this.actionFailurePolicy = actionFailurePolicy;
        }

        @Override
        public final Builder actionFailurePolicy(String actionFailurePolicy) {
            this.actionFailurePolicy = actionFailurePolicy;
            return this;
        }

        @Override
        public final Builder actionFailurePolicy(ActionFailurePolicy actionFailurePolicy) {
            this.actionFailurePolicy(actionFailurePolicy == null ? null : actionFailurePolicy.toString());
            return this;
        }

        public final String getRelay() {
            return relay;
        }

        public final void setRelay(String relay) {
            this.relay = relay;
        }

        @Override
        public final Builder relay(String relay) {
            this.relay = relay;
            return this;
        }

        public final String getMailFrom() {
            return mailFrom;
        }

        public final void setMailFrom(String mailFrom) {
            this.mailFrom = mailFrom;
        }

        @Override
        public final Builder mailFrom(String mailFrom) {
            this.mailFrom = mailFrom;
            return this;
        }

        @Override
        public final Builder mailFrom(MailFrom mailFrom) {
            this.mailFrom(mailFrom == null ? null : mailFrom.toString());
            return this;
        }

        @Override
        public RelayAction build() {
            return new RelayAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
