/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum RetentionPeriod {
    THREE_MONTHS("THREE_MONTHS"),

    SIX_MONTHS("SIX_MONTHS"),

    NINE_MONTHS("NINE_MONTHS"),

    ONE_YEAR("ONE_YEAR"),

    EIGHTEEN_MONTHS("EIGHTEEN_MONTHS"),

    TWO_YEARS("TWO_YEARS"),

    THIRTY_MONTHS("THIRTY_MONTHS"),

    THREE_YEARS("THREE_YEARS"),

    FOUR_YEARS("FOUR_YEARS"),

    FIVE_YEARS("FIVE_YEARS"),

    SIX_YEARS("SIX_YEARS"),

    SEVEN_YEARS("SEVEN_YEARS"),

    EIGHT_YEARS("EIGHT_YEARS"),

    NINE_YEARS("NINE_YEARS"),

    TEN_YEARS("TEN_YEARS"),

    PERMANENT("PERMANENT"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RetentionPeriod> VALUE_MAP = EnumUtils.uniqueIndex(RetentionPeriod.class,
            RetentionPeriod::toString);

    private final String value;

    private RetentionPeriod(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return RetentionPeriod corresponding to the value
     */
    public static RetentionPeriod fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link RetentionPeriod}s
     */
    public static Set<RetentionPeriod> knownValues() {
        Set<RetentionPeriod> knownValues = EnumSet.allOf(RetentionPeriod.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
